/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tydic.dyc.oc.service.domainservice.UocRefundCallbackService;
import com.tydic.dyc.oc.service.domainservice.bo.UocRefundCallbackBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocRefundCallbackReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocRefundCallbackRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscCreateRefundAbilityService;
import com.tydic.fsc.pay.ability.bo.FscCreateRefundAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscCreateRefundAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscCreateRefundBusiService;
import com.tydic.fsc.pay.busi.api.FscDealRefundBusiService;
import com.tydic.fsc.pay.busi.bo.FscCreateRefundBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscCreateRefundBusiRspBO;
import com.tydic.fsc.pay.busi.bo.FscDealRefundBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscDealRefundBusiRspBO;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscCreateRefundAbilityService"})
public class FscCreateRefundAbilityServiceImpl
implements FscCreateRefundAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscCreateRefundAbilityServiceImpl.class);
    @Autowired
    private FscCreateRefundBusiService fscCreateRefundBusiService;
    @Autowired
    private FscDealRefundBusiService fscDealRefundBusiService;
    @Autowired
    private UocRefundCallbackService uocRefundCallbackService;
    private static final ExecutorService EXECUTORSERVICE = new ThreadPoolExecutor(2, 5, 2L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(3), new ThreadFactoryBuilder().setNameFormat("\u63a8\u9001\u8ba2\u5355\u9000\u6b3e\u6d88\u606f").build(), new ThreadPoolExecutor.AbortPolicy());

    @PostMapping(value={"createRefund"})
    public FscCreateRefundAbilityRspBO createRefund(@RequestBody FscCreateRefundAbilityReqBO abilityReqBO) {
        this.check(abilityReqBO);
        FscCreateRefundBusiReqBO fscCreateRefundBusiReqBO = (FscCreateRefundBusiReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)abilityReqBO), FscCreateRefundBusiReqBO.class));
        FscCreateRefundBusiRspBO fscCreateRefundBusiRspBO = this.fscCreateRefundBusiService.createRefund(fscCreateRefundBusiReqBO);
        if (!"0000".equals(fscCreateRefundBusiRspBO.getRespCode())) {
            throw new BusinessException(fscCreateRefundBusiRspBO.getRespCode(), fscCreateRefundBusiRspBO.getRespDesc());
        }
        try {
            FscDealRefundBusiReqBO fscDealRefundBusiReqBo = (FscDealRefundBusiReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)abilityReqBO), FscDealRefundBusiReqBO.class));
            fscDealRefundBusiReqBo.setRefundId(fscCreateRefundBusiRspBO.getRefundId());
            FscDealRefundBusiRspBO fscDealRefundBusiRspBo = this.fscDealRefundBusiService.dealRefund(fscDealRefundBusiReqBo);
            if (!"0000".equals(fscDealRefundBusiRspBo.getRespCode())) {
                log.debug("\u9000\u6b3e\u8fd4\u56de\u51fa\u53c2{}", (Object)fscDealRefundBusiRspBo);
            }
            if ("0000".equals(fscDealRefundBusiRspBo.getRespCode())) {
                this.refundCallBack(abilityReqBO);
            }
        }
        catch (BusinessException e) {
            e.printStackTrace();
        }
        return (FscCreateRefundAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)fscCreateRefundBusiRspBO)), FscCreateRefundAbilityRspBO.class);
    }

    private void refundCallBack(FscCreateRefundAbilityReqBO abilityReqBO) {
        EXECUTORSERVICE.execute(() -> {
            log.debug("\u5f00\u542f\u591a\u7ebf\u7a0b\u901a\u77e5\u8ba2\u5355\u4fee\u6539\u9000\u6b3e\u72b6\u6001\u5f00\u59cb");
            UocRefundCallbackReqBO uocRefundCallbackReqBo = new UocRefundCallbackReqBO();
            ArrayList<UocRefundCallbackBO> uocRefundCallbackBoS = new ArrayList<UocRefundCallbackBO>();
            UocRefundCallbackBO uocRefundCallbackBo = new UocRefundCallbackBO();
            uocRefundCallbackBo.setOrderId(abilityReqBO.getOrderId());
            uocRefundCallbackBo.setSaleOrderId(abilityReqBO.getSaleOrderId());
            uocRefundCallbackBo.setRefundMoney(abilityReqBO.getRefundAmount());
            uocRefundCallbackBoS.add(uocRefundCallbackBo);
            uocRefundCallbackReqBo.setUocRefundCallbackBOS(uocRefundCallbackBoS);
            log.debug("\u5f00\u542f\u591a\u7ebf\u7a0b\u901a\u77e5\u8ba2\u5355\u4fee\u6539\u9000\u6b3e\u72b6\u6001\u5165\u53c2{}", (Object)uocRefundCallbackReqBo);
            try {
                UocRefundCallbackRspBO uocRefundCallbackRspBo = this.uocRefundCallbackService.dealCallback(uocRefundCallbackReqBo);
                log.debug("\u5f00\u542f\u591a\u7ebf\u7a0b\u901a\u77e5\u8ba2\u5355\u4fee\u6539\u9000\u6b3e\u72b6\u6001\u51fa\u53c2{}", (Object)uocRefundCallbackRspBo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void check(FscCreateRefundAbilityReqBO abilityReqBO) {
        if (StringUtils.isEmpty((Object)abilityReqBO.getOrderNo())) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)abilityReqBO.getSaleOrderNo())) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u9500\u552e\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)abilityReqBO.getCreateOperName())) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u4e0b\u5355\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)abilityReqBO.getSupplierName())) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)abilityReqBO.getPurchaserName())) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u91c7\u8d2d\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getCreateType() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u7533\u8bf7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getCreateType().equals(FscConstants.RefundType.ORDER_REFUND) && StringUtils.isEmpty((Object)abilityReqBO.getAfterOrderNo())) {
            throw new FscBusinessException("190000", "\u9000\u8d27\u9000\u6b3e\u65f6\u5165\u53c2\u552e\u540e\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getCreateType().equals(FscConstants.RefundType.ORDER_REFUND) && abilityReqBO.getAfterOrderId() == null) {
            throw new FscBusinessException("190000", "\u9000\u8d27\u9000\u6b3e\u65f6\u5165\u53c2\u552e\u540e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getOrderId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getSaleOrderId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u9500\u552e\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getCreateOperId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u4e0b\u5355\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getSupplierId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getPurchaserId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u91c7\u8d2d\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getCreateTime() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u7533\u8bf7\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getOrderAmount() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getRefundAmount() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

