/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.dao.FscPayAttachmentMapper;
import com.tydic.fsc.dao.FscPayInfoMapper;
import com.tydic.fsc.dao.FscPayOrderInfoItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.FscDealCashierDownPayItemBusiService;
import com.tydic.fsc.pay.busi.bo.FscDealCashierDownPayItemBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscDealCashierDownPayItemBusiRspBO;
import com.tydic.fsc.po.FscPayAttachmentPO;
import com.tydic.fsc.po.FscPayInfoPO;
import com.tydic.fsc.po.FscPayOrderInfoItemPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscDealCashierDownPayItemBusiServiceImpl
implements FscDealCashierDownPayItemBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscDealCashierDownPayItemBusiServiceImpl.class);
    @Autowired
    private FscPayInfoMapper fscPayInfoMapper;
    @Autowired
    private FscPayOrderInfoItemMapper fscPayOrderInfoItemMapper;
    @Autowired
    private FscPayAttachmentMapper fscPayAttachmentMapper;

    @Override
    public FscDealCashierDownPayItemBusiRspBO dealCashierDownPayItem(FscDealCashierDownPayItemBusiReqBO busiReqBO) {
        this.checkFscPayInfo(busiReqBO);
        List<FscPayOrderInfoItemPO> list = this.checkFscPayOrderInfoItemPOS(busiReqBO);
        this.checkNum(busiReqBO, list);
        this.addAllAttachment(busiReqBO);
        FscDealCashierDownPayItemBusiRspBO fscDealCashierDownPayItemBusiRspBO = new FscDealCashierDownPayItemBusiRspBO();
        fscDealCashierDownPayItemBusiRspBO.setPayOrderId(busiReqBO.getPayOrderId());
        fscDealCashierDownPayItemBusiRspBO.setRespCode("0000");
        fscDealCashierDownPayItemBusiRspBO.setRespDesc("\u6210\u529f");
        return fscDealCashierDownPayItemBusiRspBO;
    }

    private void checkNum(FscDealCashierDownPayItemBusiReqBO busiReqBO, List<FscPayOrderInfoItemPO> list) {
        if (list.size() != busiReqBO.getFscDealCashierDownPayItemList().size()) {
            throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5355\u4ed8\u6b3e\u660e\u7ec6\u6570\u91cf\u4e0e\u4ed8\u6b3e\u5355\u660e\u7ec6\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
    }

    private void checkFscPayInfo(FscDealCashierDownPayItemBusiReqBO busiReqBO) {
        FscPayInfoPO fscPayInfoPo = new FscPayInfoPO();
        fscPayInfoPo.setPayOrderId(busiReqBO.getPayOrderId());
        FscPayInfoPO modelBy = this.fscPayInfoMapper.getModelBy(fscPayInfoPo);
        if (modelBy == null) {
            throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
    }

    private List<FscPayOrderInfoItemPO> checkFscPayOrderInfoItemPOS(FscDealCashierDownPayItemBusiReqBO busiReqBO) {
        FscPayOrderInfoItemPO fscPayOrderInfoItemPo = new FscPayOrderInfoItemPO();
        fscPayOrderInfoItemPo.setPayOrderId(busiReqBO.getPayOrderId());
        List list = this.fscPayOrderInfoItemMapper.getList(fscPayOrderInfoItemPo);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5355\u660e\u7ec6\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return list;
    }

    private void addAllAttachment(FscDealCashierDownPayItemBusiReqBO busiReqBO) {
        log.debug("\u5f00\u59cb\u751f\u6210\u4ed8\u6b3e\u9644\u4ef6\u4fe1\u606f");
        ArrayList fscPayAttachmentPoS = new ArrayList();
        busiReqBO.getFscDealCashierDownPayItemList().forEach(fscDealCashierDownPayItemBo -> fscDealCashierDownPayItemBo.getAttachmentList().forEach(attachmentBo -> {
            Long attachmentId = Sequence.getInstance().nextId();
            FscPayAttachmentPO fscPayAttachmentPo = new FscPayAttachmentPO();
            BeanUtils.copyProperties((Object)attachmentBo, (Object)fscPayAttachmentPo);
            fscPayAttachmentPo.setAttachmentId(attachmentId);
            fscPayAttachmentPo.setPayOrderId(busiReqBO.getPayOrderId());
            fscPayAttachmentPo.setPayOrderItemId(fscDealCashierDownPayItemBo.getPayOrderItemId());
            fscPayAttachmentPoS.add(fscPayAttachmentPo);
        }));
        log.debug("\u751f\u6210\u4ed8\u6b3e\u9644\u4ef6\u4fe1\u606f\u5165\u53c2{}", fscPayAttachmentPoS);
        this.fscPayAttachmentMapper.insertBatch(fscPayAttachmentPoS);
    }
}

