/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscLedgerInfoItemMapper;
import com.tydic.fsc.dao.FscLedgerInfoMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscPayInfoMapper;
import com.tydic.fsc.dao.FscPayOrderInfoItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.FscDealApplyLedgerBusiService;
import com.tydic.fsc.pay.busi.bo.FscDealApplyLedgerBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscDealApplyLedgerBusiRspBO;
import com.tydic.fsc.po.FscLedgerInfoItemPO;
import com.tydic.fsc.po.FscLedgerInfoPO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscPayInfoPO;
import com.tydic.fsc.po.FscPayOrderInfoItemPO;
import com.tydic.payment.pay.ability.bo.DivideDetailDataBO;
import com.tydic.payment.pay.ability.bo.PayDivideReqBO;
import com.tydic.payment.pay.ability.bo.PayDivideRspBO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscDealApplyLedgerBusiServiceImpl
implements FscDealApplyLedgerBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscDealApplyLedgerBusiServiceImpl.class);
    @Autowired
    private FscLedgerInfoMapper fscLedgerInfoMapper;
    @Autowired
    private FscPayInfoMapper fscPayInfoMapper;
    @Autowired
    private FscPayOrderInfoItemMapper fscPayOrderInfoItemMapper;
    @Autowired
    private FscLedgerInfoItemMapper fscLedgerInfoItemMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Value(value="${isTruePay:false}")
    private Boolean isTruePay;
    @Value(value="${MERCHANT_ORG_ID:759903388549152768}")
    private Long merchantOrgId;
    @Value(value="${pay.center.busi.code:D500}")
    private String payBusiCode;
    @Value(value="${divideRefundUrl:www.baidu.com}")
    private String divideRefundUrl;

    @Override
    public FscDealApplyLedgerBusiRspBO dealApplyLedger(FscDealApplyLedgerBusiReqBO busiReqBO) {
        log.debug("\u7533\u8bf7\u5206\u8d26\u5f00\u59cb{}", (Object)busiReqBO);
        List<FscPayInfoPO> fscPayInfoPoList = this.getFscPayInfoPoList(busiReqBO);
        FscPayOrderInfoItemPO fscPayOrderInfoItemMapperModelBy = this.getFscPayOrderInfoItemPo(busiReqBO, fscPayInfoPoList);
        List<FscLedgerInfoItemPO> fscLedgerInfoItemMapperList = this.getFscLedgerInfoItemPoList(fscPayOrderInfoItemMapperModelBy);
        List<FscLedgerInfoPO> fscLedgerInfoMapperList = this.getFscLedgerInfoPoList(fscLedgerInfoItemMapperList);
        FscLedgerInfoPO fscLedgerInfoMapperModelBy = this.getFscLedgerInfoPo(fscPayInfoPoList, fscLedgerInfoItemMapperList);
        HashMap<Long, List<FscLedgerInfoPO>> fscLedgerInfoPoMap = new HashMap<Long, List<FscLedgerInfoPO>>(fscLedgerInfoItemMapperList.size());
        HashMap<Long, BigDecimal> serviceAmountMap = new HashMap<Long, BigDecimal>(1);
        serviceAmountMap.put(this.merchantOrgId, BigDecimal.ZERO);
        HashMap<Long, BigDecimal> merchantAmountMap = new HashMap<Long, BigDecimal>(1);
        merchantAmountMap.put(fscLedgerInfoItemMapperList.get(0).getPayeeMerchantId(), BigDecimal.ZERO);
        HashMap<Long, BigDecimal> serviceAmountRefundMap = new HashMap<Long, BigDecimal>(1);
        serviceAmountRefundMap.put(this.merchantOrgId, BigDecimal.ZERO);
        HashMap<Long, BigDecimal> merchantAmountRefundMap = new HashMap<Long, BigDecimal>(1);
        merchantAmountRefundMap.put(fscLedgerInfoItemMapperList.get(0).getPayeeMerchantId(), BigDecimal.ZERO);
        this.forEachLedgerInfo(fscLedgerInfoMapperList, fscLedgerInfoPoMap);
        this.forEachLedgerItem(fscLedgerInfoItemMapperList, fscLedgerInfoPoMap, serviceAmountMap, merchantAmountMap, serviceAmountRefundMap, merchantAmountRefundMap);
        log.debug("\u670d\u52a1\u8d39\u66ff\u6362\u540emap\u6700\u7ec8\u503c{}", serviceAmountMap);
        log.debug("\u5546\u6237\u5206\u8d26\u66ff\u6362\u540emap{}", merchantAmountMap);
        log.debug("\u670d\u52a1\u8d39\u9000\u6b3e\u66ff\u6362\u540emap{}", serviceAmountRefundMap);
        log.debug("\u5546\u6237\u5206\u8d26\u9000\u6b3e\u66ff\u6362\u540emap{}", merchantAmountRefundMap);
        PayDivideRspBO payDivideRspBO = this.getPayDivideRspBo(busiReqBO, fscPayInfoPoList, fscLedgerInfoItemMapperList, fscLedgerInfoMapperModelBy, serviceAmountMap, merchantAmountMap, serviceAmountRefundMap, merchantAmountRefundMap, fscPayOrderInfoItemMapperModelBy);
        FscDealApplyLedgerBusiRspBO fscDealApplyLedgerBusiRspBo = new FscDealApplyLedgerBusiRspBO();
        fscDealApplyLedgerBusiRspBo.setState(payDivideRspBO.getStatus());
        fscDealApplyLedgerBusiRspBo.setRespCode("0000");
        fscDealApplyLedgerBusiRspBo.setRespDesc("\u6210\u529f");
        return fscDealApplyLedgerBusiRspBo;
    }

    private PayDivideRspBO getPayDivideRspBo(FscDealApplyLedgerBusiReqBO busiReqBO, List<FscPayInfoPO> fscPayInfoPoList, List<FscLedgerInfoItemPO> fscLedgerInfoItemMapperList, FscLedgerInfoPO fscLedgerInfoMapperModelBy, Map<Long, BigDecimal> serviceAmountMap, Map<Long, BigDecimal> merchantAmountMap, Map<Long, BigDecimal> serviceAmountRefundMap, Map<Long, BigDecimal> merchantAmountRefundMap, FscPayOrderInfoItemPO fscPayOrderInfoItemMapperModelBy) {
        PayDivideRspBO payDivideRspBo;
        log.debug("\u652f\u4ed8\u4e2d\u5fc3\u4f20\u503c\u8bbe\u7f6e\u5e76\u8c03\u7528\u63a5\u53e3\u5206\u8d26\u5f00\u59cb");
        BigDecimal serviceLedgerAmount = serviceAmountMap.get(this.merchantOrgId).subtract(serviceAmountRefundMap.get(this.merchantOrgId));
        log.debug("\u652f\u4ed8\u4e2d\u5fc3\u670d\u52a1\u8d39\u5206\u8d26\u91d1\u989d{}", (Object)serviceLedgerAmount);
        BigDecimal merchantLedgerAmount = merchantAmountMap.get(fscLedgerInfoItemMapperList.get(0).getPayeeMerchantId()).subtract(merchantAmountRefundMap.get(fscLedgerInfoItemMapperList.get(0).getPayeeMerchantId()));
        log.debug("\u652f\u4ed8\u4e2d\u5fc3\u5546\u6237\u5206\u8d26\u91d1\u989d{}", (Object)merchantLedgerAmount);
        ArrayList<Long> merchantIds = new ArrayList<Long>();
        merchantIds.add(this.merchantOrgId);
        merchantIds.add(fscLedgerInfoItemMapperList.get(0).getPayeeMerchantId());
        log.debug("\u7ed3\u7b97\u4e2d\u5fc3\u5546\u6237id\u96c6\u5408{}", merchantIds);
        List<FscMerchantPO> fscMerchantListPay = this.getFscMerchantListPay(merchantIds);
        HashMap<Long, String> fscMerchantAndPayMerchantMap = new HashMap<Long, String>(2);
        Map<Long, String> fscMerchantAndPayMerchantMapPay = fscMerchantListPay.stream().collect(Collectors.toMap(FscMerchantPO::getMerchantId, FscMerchantPO::getPayMerchantId));
        log.debug("\u4ed8\u6b3e\u4f9b\u5e94\u5546\u7684\u7ed3\u7b97\u5546\u6237\u548c\u652f\u4ed8\u4e2d\u5fc3\u5546\u6237\u5bf9\u5e94\u5173\u7cfb\u4e34\u65f6map{}", fscMerchantAndPayMerchantMapPay);
        fscMerchantAndPayMerchantMap.putAll(fscMerchantAndPayMerchantMapPay);
        log.debug("\u4ed8\u6b3e\u4f9b\u5e94\u5546\u7684\u7ed3\u7b97\u5546\u6237\u548c\u652f\u4ed8\u4e2d\u5fc3\u5546\u6237\u5bf9\u5e94\u5173\u7cfbmap{}", fscMerchantAndPayMerchantMap);
        PayDivideReqBO payDivideReqBo = (PayDivideReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiReqBO)), PayDivideReqBO.class);
        payDivideReqBo.setOutOrderId(fscPayInfoPoList.get(0).getPayOrderId().toString());
        payDivideReqBo.setSubOrderId(fscLedgerInfoMapperModelBy.getPayLedgerId().toString());
        payDivideReqBo.setBusiCode(this.payBusiCode);
        ArrayList<DivideDetailDataBO> divideDetailDataList = new ArrayList<DivideDetailDataBO>();
        DivideDetailDataBO divideDetailDataBoService = new DivideDetailDataBO();
        DivideDetailDataBO divideDetailDataBoMerchant = new DivideDetailDataBO();
        divideDetailDataBoService.setMerchantId((String)fscMerchantAndPayMerchantMap.get(this.merchantOrgId));
        divideDetailDataBoMerchant.setMerchantId((String)fscMerchantAndPayMerchantMap.get(fscLedgerInfoItemMapperList.get(0).getPayeeMerchantId()));
        if (this.isTruePay.booleanValue()) {
            divideDetailDataBoMerchant.setAmount(Long.valueOf(MoneyUtils.yuanToFenToLong((BigDecimal)merchantLedgerAmount)));
            divideDetailDataBoService.setAmount(Long.valueOf(MoneyUtils.yuanToFenToLong((BigDecimal)serviceLedgerAmount)));
        } else {
            divideDetailDataBoMerchant.setAmount(Long.valueOf(MoneyUtils.yuanToFenToLong((BigDecimal)new BigDecimal("0.01"))));
            divideDetailDataBoService.setAmount(Long.valueOf(MoneyUtils.yuanToFenToLong((BigDecimal)new BigDecimal("0.01"))));
        }
        divideDetailDataList.add(divideDetailDataBoService);
        divideDetailDataList.add(divideDetailDataBoMerchant);
        payDivideReqBo.setDivideDetailList(divideDetailDataList);
        log.debug("\u63a8\u9001\u652f\u4ed8\u4e2d\u5fc3\u5206\u8d26\u5165\u53c2{}", (Object)(this.divideRefundUrl + JSONObject.toJSONString((Object)payDivideReqBo)));
        String resultData = HttpUtil.post((String)this.divideRefundUrl, (String)JSONObject.toJSONString((Object)payDivideReqBo));
        log.debug("\u63a8\u9001\u652f\u4ed8\u4e2d\u5fc3\u5206\u8d26\u51fa\u53c2{}", (Object)resultData);
        if (!StringUtils.isEmpty((Object)resultData)) {
            payDivideRspBo = (PayDivideRspBO)JSONObject.parseObject((String)resultData, PayDivideRspBO.class);
            if (!"0000".equals(payDivideRspBo.getRspCode())) {
                throw new FscBusinessException(payDivideRspBo.getRspCode(), payDivideRspBo.getRspName());
            }
            try {
                FscPayOrderInfoItemPO fscPayOrderInfoItemPoWhere = new FscPayOrderInfoItemPO();
                fscPayOrderInfoItemPoWhere.setPayOrderItemId(fscPayOrderInfoItemMapperModelBy.getPayOrderItemId());
                FscPayOrderInfoItemPO fscPayOrderInfoItemPoSet = new FscPayOrderInfoItemPO();
                fscPayOrderInfoItemPoSet.setPayLedgerState(FscConstants.LedgerState.SUCCESS);
                int update = this.fscPayOrderInfoItemMapper.updateBy(fscPayOrderInfoItemPoSet, fscPayOrderInfoItemPoWhere);
                if (update < 1) {
                    log.debug("\u4fee\u6539\u4ed8\u6b3e\u660e\u7ec6\u5206\u8d26\u72b6\u6001\u5931\u8d25");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new FscBusinessException("190000", "\u7533\u8bf7\u5206\u8d26\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return payDivideRspBo;
    }

    private void forEachLedgerItem(List<FscLedgerInfoItemPO> fscLedgerInfoItemMapperList, Map<Long, List<FscLedgerInfoPO>> fscLedgerInfoPoMap, Map<Long, BigDecimal> serviceAmountMap, Map<Long, BigDecimal> merchantAmountMap, Map<Long, BigDecimal> serviceAmountRefundMap, Map<Long, BigDecimal> merchantAmountRefundMap) {
        log.debug("\u5f00\u59cb\u5faa\u73af\u5206\u8d26\u660e\u7ec6\u4fe1\u606f\u8ba1\u7b97\u5206\u8d26\u91d1\u989d");
        fscLedgerInfoItemMapperList.forEach(fscLedgerInfoItemPoModel -> {
            List<FscLedgerInfoPO> fscLedgerInfoPoList = this.dealFscLedgerInfoSame(fscLedgerInfoPoMap, serviceAmountMap, merchantAmountMap, (FscLedgerInfoItemPO)fscLedgerInfoItemPoModel);
            if (CollectionUtils.isEmpty(fscLedgerInfoPoList)) {
                log.debug("\u4e0d\u9700\u8981\u6263\u51cf\u91d1\u989d");
            } else {
                log.debug("\u9700\u8981\u6263\u51cf\u91d1\u989d");
                this.needSubServiceAndMerchant(serviceAmountRefundMap, merchantAmountRefundMap, (FscLedgerInfoItemPO)fscLedgerInfoItemPoModel, fscLedgerInfoPoList);
            }
        });
    }

    private void needSubServiceAndMerchant(Map<Long, BigDecimal> serviceAmountRefundMap, Map<Long, BigDecimal> merchantAmountRefundMap, FscLedgerInfoItemPO fscLedgerInfoItemPoModel, List<FscLedgerInfoPO> fscLedgerInfoPoList) {
        log.debug("\u9700\u8981\u6263\u51cf\u91d1\u989d\u5f00\u59cb");
        fscLedgerInfoPoList.forEach(fscLedgerInfoPoModel -> {
            BigDecimal serviceAmountRefundBefore = (BigDecimal)serviceAmountRefundMap.get(this.merchantOrgId);
            log.debug("\u670d\u52a1\u8d39\u7d2f\u52a0\u4e4b\u524d\u9000\u6b3e\u670d\u52a1\u8d39\u91d1\u989d{}", (Object)serviceAmountRefundBefore);
            BigDecimal serviceAmountRefundAfter = serviceAmountRefundBefore.add(fscLedgerInfoPoModel.getPayLedgerItemRefundAmount());
            log.debug("\u670d\u52a1\u8d39\u7d2f\u52a0\u4e4b\u540e\u9000\u6b3e\u670d\u52a1\u8d39\u91d1\u989d{}", (Object)serviceAmountRefundAfter);
            serviceAmountRefundMap.replace(this.merchantOrgId, serviceAmountRefundAfter);
            log.debug("\u670d\u52a1\u8d39\u9000\u6b3e\u66ff\u6362\u540emap{}", (Object)serviceAmountRefundMap);
            BigDecimal merchantRefundBefore = (BigDecimal)merchantAmountRefundMap.get(fscLedgerInfoItemPoModel.getPayeeMerchantId());
            log.debug("\u5546\u6237\u5206\u8d26\u9000\u6b3e\u7d2f\u52a0\u4e4b\u524d\u91d1\u989d{}", (Object)merchantRefundBefore);
            BigDecimal merchantRefundAfter = merchantRefundBefore.add(fscLedgerInfoPoModel.getPayItemRefundAmount());
            log.debug("\u5546\u6237\u5206\u8d26\u9000\u6b3e\u7d2f\u52a0\u4e4b\u540e\u91d1\u989d{}", (Object)merchantRefundAfter);
            merchantAmountRefundMap.replace(fscLedgerInfoItemPoModel.getPayeeMerchantId(), merchantRefundAfter);
            log.debug("\u5546\u6237\u5206\u8d26\u9000\u6b3e\u66ff\u6362\u540emap{}", (Object)merchantAmountRefundMap);
        });
    }

    private List<FscLedgerInfoPO> dealFscLedgerInfoSame(Map<Long, List<FscLedgerInfoPO>> fscLedgerInfoPoMap, Map<Long, BigDecimal> serviceAmountMap, Map<Long, BigDecimal> merchantAmountMap, FscLedgerInfoItemPO fscLedgerInfoItemPoModel) {
        log.debug("\u8bbe\u7f6e\u5e76\u8ba1\u7b97\u5206\u8d26\u660e\u7ec6\u4fe1\u606f\u7edf\u4e00\u503c\u5f00\u59cb");
        BigDecimal skuAmount = fscLedgerInfoItemPoModel.getSkuAmount();
        log.debug("\u5f53\u524d\u5546\u54c1\u4ed8\u6b3e\u603b\u91d1\u989d{}", (Object)skuAmount);
        BigDecimal ledgerAmount = fscLedgerInfoItemPoModel.getLedgerAmount();
        log.debug("\u5f53\u524d\u5546\u54c1\u5206\u8d26\u603b\u91d1\u989d{}", (Object)ledgerAmount);
        List<FscLedgerInfoPO> fscLedgerInfoPoList = fscLedgerInfoPoMap.get(fscLedgerInfoItemPoModel.getPayOrderItemLedgerId());
        log.debug("\u83b7\u53d6\u5f53\u524d\u5206\u8d26\u9000\u6b3e\u96c6\u5408\u4e3a{}", fscLedgerInfoPoList);
        BigDecimal serviceBefore = serviceAmountMap.get(this.merchantOrgId);
        log.debug("\u670d\u52a1\u8d39\u7d2f\u52a0\u4e4b\u524d\u91d1\u989d{}", (Object)serviceBefore);
        BigDecimal serviceAfter = serviceBefore.add(fscLedgerInfoItemPoModel.getLedgerAmount());
        log.debug("\u670d\u52a1\u8d39\u7d2f\u52a0\u4e4b\u540e\u91d1\u989d{}", (Object)serviceAfter);
        serviceAmountMap.replace(this.merchantOrgId, serviceAfter);
        log.debug("\u670d\u52a1\u8d39\u66ff\u6362\u540emap{}", serviceAmountMap);
        BigDecimal merchantBefore = merchantAmountMap.get(fscLedgerInfoItemPoModel.getPayeeMerchantId());
        log.debug("\u5546\u6237\u5206\u8d26\u7d2f\u52a0\u4e4b\u524d\u91d1\u989d{}", (Object)serviceBefore);
        BigDecimal merchantAfter = merchantBefore.add(fscLedgerInfoItemPoModel.getRelAmount());
        log.debug("\u5546\u6237\u5206\u8d26\u7d2f\u52a0\u4e4b\u540e\u91d1\u989d{}", (Object)serviceAfter);
        merchantAmountMap.replace(fscLedgerInfoItemPoModel.getPayeeMerchantId(), merchantAfter);
        log.debug("\u5546\u6237\u5206\u8d26\u66ff\u6362\u540emap{}", merchantAmountMap);
        return fscLedgerInfoPoList;
    }

    private void forEachLedgerInfo(List<FscLedgerInfoPO> fscLedgerInfoMapperList, Map<Long, List<FscLedgerInfoPO>> fscLedgerInfoPoMap) {
        if (!CollectionUtils.isEmpty(fscLedgerInfoMapperList)) {
            log.debug("\u5f00\u59cb\u5faa\u73af\u62fc\u63a5\u5206\u8d26\u4e3b\u5355\u4fe1\u606fMap{}", fscLedgerInfoMapperList);
            fscLedgerInfoMapperList.forEach(fscLedgerInfoPoModel -> {
                if (fscLedgerInfoPoMap.containsKey(fscLedgerInfoPoModel.getPayLedgerItemId())) {
                    this.haveKey(fscLedgerInfoPoMap, (FscLedgerInfoPO)fscLedgerInfoPoModel);
                } else {
                    this.notHaveKey(fscLedgerInfoPoMap, (FscLedgerInfoPO)fscLedgerInfoPoModel);
                }
            });
            log.debug("\u5faa\u73af\u62fc\u63a5\u5206\u8d26\u4e3b\u5355\u4fe1\u606fMap\u7ed3\u679c{}", fscLedgerInfoPoMap);
        }
    }

    private void notHaveKey(Map<Long, List<FscLedgerInfoPO>> fscLedgerInfoPoMap, FscLedgerInfoPO fscLedgerInfoPoModel) {
        log.debug("\u5df2\u7ecf\u672a\u542b\u6709\u5f53\u524dkey\u7684value\u503c");
        ArrayList<FscLedgerInfoPO> fscLedgerInfoPoList = new ArrayList<FscLedgerInfoPO>();
        fscLedgerInfoPoList.add(fscLedgerInfoPoModel);
        fscLedgerInfoPoMap.put(fscLedgerInfoPoModel.getPayLedgerItemId(), fscLedgerInfoPoList);
        log.debug("\u5df2\u7ecf\u672a\u542b\u6709\u5f53\u524dkey\u7684value\u503cput\u540e{}", fscLedgerInfoPoMap);
    }

    private void haveKey(Map<Long, List<FscLedgerInfoPO>> fscLedgerInfoPoMap, FscLedgerInfoPO fscLedgerInfoPoModel) {
        List<FscLedgerInfoPO> fscLedgerInfoList = fscLedgerInfoPoMap.get(fscLedgerInfoPoModel.getPayLedgerItemId());
        log.debug("\u5df2\u7ecf\u542b\u6709\u5f53\u524dkey\u7684value\u503c{}", fscLedgerInfoList);
        fscLedgerInfoList.add(fscLedgerInfoPoModel);
        log.debug("\u5df2\u7ecf\u542b\u6709\u5f53\u524dkey\u7684value\u503c\u66ff\u6362\u524d{}", fscLedgerInfoPoMap);
        fscLedgerInfoPoMap.replace(fscLedgerInfoPoModel.getPayLedgerItemId(), fscLedgerInfoList);
        log.debug("\u5df2\u7ecf\u542b\u6709\u5f53\u524dkey\u7684value\u503c\u66ff\u6362\u540e{}", fscLedgerInfoPoMap);
    }

    private List<FscLedgerInfoPO> getFscLedgerInfoPoList(List<FscLedgerInfoItemPO> fscLedgerInfoItemMapperList) {
        log.debug("\u7533\u8bf7\u5206\u8d26\u67e5\u8be2\u5206\u8d26\u9000\u6b3e\u4e3b\u5355\u4fe1\u606f\u5f00\u59cb");
        List payLedgerItemIds = fscLedgerInfoItemMapperList.stream().map(FscLedgerInfoItemPO::getPayOrderItemLedgerId).collect(Collectors.toList());
        FscLedgerInfoPO fscLedgerInfoPo = new FscLedgerInfoPO();
        fscLedgerInfoPo.setPayLedgerItemIds(payLedgerItemIds);
        fscLedgerInfoPo.setPayOrRefund(FscConstants.PayOrRefund.REFUND);
        log.debug("\u7533\u8bf7\u5206\u8d26\u67e5\u8be2\u5206\u8d26\u9000\u6b3e\u4e3b\u5355\u4fe1\u606f\u5165\u53c2{}", (Object)fscLedgerInfoPo);
        List fscLedgerInfoMapperList = this.fscLedgerInfoMapper.getList(fscLedgerInfoPo);
        log.debug("\u7533\u8bf7\u5206\u8d26\u67e5\u8be2\u5206\u8d26\u9000\u6b3e\u4e3b\u5355\u4fe1\u606f\u51fa\u53c2{}", (Object)fscLedgerInfoMapperList);
        return fscLedgerInfoMapperList;
    }

    private FscLedgerInfoPO getFscLedgerInfoPo(List<FscPayInfoPO> fscPayInfoPoList, List<FscLedgerInfoItemPO> fscLedgerInfoItemMapperList) {
        log.debug("\u7533\u8bf7\u5206\u8d26\u67e5\u8be2\u5206\u8d26\u4ed8\u6b3e\u4e3b\u5355\u4fe1\u606f\u5f00\u59cb");
        FscLedgerInfoPO fscLedgerInfoPoPay = new FscLedgerInfoPO();
        fscLedgerInfoPoPay.setPayOrRefund(FscConstants.PayOrRefund.PAY);
        fscLedgerInfoPoPay.setPayOrderId(fscPayInfoPoList.get(0).getPayOrderId());
        fscLedgerInfoPoPay.setMerchantId(fscLedgerInfoItemMapperList.get(0).getPayeeMerchantId());
        log.debug("\u7533\u8bf7\u5206\u8d26\u67e5\u8be2\u5206\u8d26\u4ed8\u6b3e\u4e3b\u5355\u4fe1\u606f\u5165\u53c2{}", (Object)fscLedgerInfoPoPay);
        FscLedgerInfoPO fscLedgerInfoMapperModelBy = this.fscLedgerInfoMapper.getModelBy(fscLedgerInfoPoPay);
        log.debug("\u7533\u8bf7\u5206\u8d26\u67e5\u8be2\u5206\u8d26\u4ed8\u6b3e\u4e3b\u5355\u4fe1\u606f\u51fa\u53c2{}", (Object)fscLedgerInfoMapperModelBy);
        return fscLedgerInfoMapperModelBy;
    }

    private List<FscLedgerInfoItemPO> getFscLedgerInfoItemPoList(FscPayOrderInfoItemPO fscPayOrderInfoItemMapperModelBy) {
        log.debug("\u7533\u8bf7\u5206\u8d26\u67e5\u8be2\u5206\u8d26\u660e\u7ec6\u4fe1\u606f\u5f00\u59cb");
        FscLedgerInfoItemPO fscLedgerInfoItemPo = new FscLedgerInfoItemPO();
        fscLedgerInfoItemPo.setPayOrderItemId(fscPayOrderInfoItemMapperModelBy.getPayOrderItemId());
        log.debug("\u7533\u8bf7\u5206\u8d26\u67e5\u8be2\u5206\u8d26\u660e\u7ec6\u4fe1\u606f\u5165\u53c2{}", (Object)fscLedgerInfoItemPo);
        List fscLedgerInfoItemMapperList = this.fscLedgerInfoItemMapper.getList(fscLedgerInfoItemPo);
        log.debug("\u7533\u8bf7\u5206\u8d26\u67e5\u8be2\u5206\u8d26\u660e\u7ec6\u4fe1\u606f\u51fa\u53c2{}", (Object)fscLedgerInfoItemMapperList);
        if (CollectionUtils.isEmpty((Collection)fscLedgerInfoItemMapperList)) {
            throw new FscBusinessException("190000", "\u7533\u8bf7\u5206\u8d26\u67e5\u8be2\u5206\u8d26\u660e\u7ec6\u4fe1\u606f\u51fa\u53c2\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return fscLedgerInfoItemMapperList;
    }

    private FscPayOrderInfoItemPO getFscPayOrderInfoItemPo(FscDealApplyLedgerBusiReqBO busiReqBO, List<FscPayInfoPO> fscPayInfoPoList) {
        log.debug("\u7533\u8bf7\u5206\u8d26\u67e5\u8be2\u65b0\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5f00\u59cb");
        FscPayOrderInfoItemPO fscPayOrderInfoItemPo = new FscPayOrderInfoItemPO();
        fscPayOrderInfoItemPo.setPayOrderId(fscPayInfoPoList.get(0).getPayOrderId());
        fscPayOrderInfoItemPo.setPayObjectId(busiReqBO.getSaleOrderId());
        log.debug("\u7533\u8bf7\u5206\u8d26\u67e5\u8be2\u65b0\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5165\u53c2{}", (Object)fscPayOrderInfoItemPo);
        FscPayOrderInfoItemPO fscPayOrderInfoItemMapperModelBy = this.fscPayOrderInfoItemMapper.getModelBy(fscPayOrderInfoItemPo);
        log.debug("\u7533\u8bf7\u5206\u8d26\u67e5\u8be2\u65b0\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u51fa\u53c2{}", (Object)fscPayOrderInfoItemMapperModelBy);
        if (fscPayOrderInfoItemMapperModelBy == null) {
            throw new FscBusinessException("190000", "\u7533\u8bf7\u5206\u8d26\u67e5\u8be2\u4ed8\u6b3e\u5355\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (fscPayOrderInfoItemMapperModelBy.getPayLedgerState() != null && fscPayOrderInfoItemMapperModelBy.getPayLedgerState().equals(FscConstants.LedgerState.SUCCESS)) {
            throw new FscBusinessException("190000", "\u8be5\u660e\u7ec6\u5df2\u7ecf\u5206\u8d26\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u8bd5");
        }
        return fscPayOrderInfoItemMapperModelBy;
    }

    private List<FscPayInfoPO> getFscPayInfoPoList(FscDealApplyLedgerBusiReqBO busiReqBO) {
        log.debug("\u7533\u8bf7\u5206\u8d26\u67e5\u8be2\u65b0\u4ed8\u6b3e\u5355\u4fe1\u606f\u5f00\u59cb");
        FscPayInfoPO fscPayInfoPo = new FscPayInfoPO();
        fscPayInfoPo.setPayObjectIds(Collections.singletonList(busiReqBO.getSaleOrderId()));
        log.debug("\u7533\u8bf7\u5206\u8d26\u67e5\u8be2\u65b0\u4ed8\u6b3e\u5355\u4fe1\u606f\u5165\u53c2{}", (Object)fscPayInfoPo);
        List fscPayInfoPoList = this.fscPayInfoMapper.getListByPayObjectIds(fscPayInfoPo);
        log.debug("\u7533\u8bf7\u5206\u8d26\u67e5\u8be2\u65b0\u4ed8\u6b3e\u5355\u4fe1\u606f\u51fa\u53c2{}", (Object)fscPayInfoPoList);
        if (CollectionUtils.isEmpty((Collection)fscPayInfoPoList)) {
            throw new FscBusinessException("190000", "\u7533\u8bf7\u5206\u8d26\u67e5\u8be2\u4ed8\u6b3e\u5355\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return fscPayInfoPoList;
    }

    private List<FscMerchantPO> getFscMerchantListPay(List<Long> merchantIds) {
        FscMerchantPO reqPo = new FscMerchantPO();
        reqPo.setDelFlag(Integer.valueOf(0));
        reqPo.setExceptionFlag(Integer.valueOf(0));
        reqPo.setStatus(Integer.valueOf(3));
        reqPo.setMerchantIds(merchantIds);
        return this.fscMerchantMapper.getList(reqPo);
    }
}

