/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscLedgerInfoMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscPayInfoMapper;
import com.tydic.fsc.dao.FscRefundInfoMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.FscDealRefundBusiService;
import com.tydic.fsc.pay.busi.bo.FscDealRefundBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscDealRefundBusiRspBO;
import com.tydic.fsc.po.FscLedgerInfoPO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscPayInfoPO;
import com.tydic.fsc.po.FscRefundInfoPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.payment.pay.ability.PayProRefundAbilityService;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.PorderMapper;
import com.tydic.payment.pay.dao.PorderRefundTransMapper;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.dao.po.PorderRefundTransPo;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscDealRefundBusiServiceImpl
implements FscDealRefundBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscDealRefundBusiServiceImpl.class);
    @Autowired
    private FscRefundInfoMapper fscRefundInfoMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private PayProRefundAbilityService payProRefundAbilityService;
    @Autowired
    private FscPayInfoMapper fscPayInfoMapper;
    @Autowired
    private FscLedgerInfoMapper fscLedgerInfoMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private PorderMapper porderMapper;
    @Autowired
    private PorderRefundTransMapper porderRefundTransMapper;
    @Value(value="${isTruePay:false}")
    private Boolean isTruePay;
    @Value(value="${pay.center.busi.code:D500}")
    private String payBusiCode;
    @Value(value="${orderRefundNotifyUrl:http://www.baidu.com}")
    private String orderRefundNotifyUrl;
    @Value(value="${woPayRefundUrl:http://www.baidu.com}")
    private String woPayRefundUrl;
    @Value(value="${yeePayRefundUrl:http://www.baidu.com}")
    private String yeePayRefundUrl;

    @Override
    public FscDealRefundBusiRspBO dealRefund(FscDealRefundBusiReqBO busiReqBO) {
        PayProRefundAbilityReqBo payProRefundAbilityReqBo = new PayProRefundAbilityReqBo();
        String refundOutId = String.valueOf(Sequence.getInstance().nextId());
        FscDealRefundBusiRspBO fscDealRefundBusiRspBo = new FscDealRefundBusiRspBO();
        FscRefundInfoPO modelBy = this.getFscRefundInfoPO(busiReqBO);
        fscDealRefundBusiRspBo.setOrderId(modelBy.getOrderId());
        if (modelBy.getAfterOrderId() != null && FscConstants.RefundType.ORDER_REFUND.equals(modelBy.getCreateType())) {
            fscDealRefundBusiRspBo.setSaleOrderId(modelBy.getAfterOrderId());
        } else if (modelBy.getAfterOrderId() == null && FscConstants.RefundType.ORDER_REFUND.equals(modelBy.getCreateType())) {
            fscDealRefundBusiRspBo.setSaleOrderId(null);
        } else if (FscConstants.RefundType.ORDER_CHANNEL.equals(modelBy.getCreateType())) {
            fscDealRefundBusiRspBo.setSaleOrderId(modelBy.getSaleOrderId());
        } else if (FscConstants.RefundType.TWICE_PAY.equals(modelBy.getCreateType())) {
            fscDealRefundBusiRspBo.setSaleOrderId(modelBy.getSaleOrderId());
        }
        fscDealRefundBusiRspBo.setRefundAmount(modelBy.getRefundAmount());
        this.checkRefund(modelBy);
        Long payOrderId = this.oldPay(modelBy);
        this.IsOldOrNew(payProRefundAbilityReqBo, modelBy, payOrderId, busiReqBO, fscDealRefundBusiRspBo, refundOutId);
        this.updateRefundExtend(busiReqBO, refundOutId);
        return fscDealRefundBusiRspBo;
    }

    private void checkRefund(FscRefundInfoPO modelBy) {
        PorderRefundTransPo porderRefundTransPo;
        PorderPo porderPo = this.porderMapper.selectPorderByOutOrderIdSnyGoods(modelBy.getExtend1());
        if (porderPo != null && "B10".equals((porderRefundTransPo = this.porderRefundTransMapper.queryLastRecordByOrderId(porderPo.getOrderId())).getOrderStatus())) {
            throw new FscBusinessException("190000", "\u8be5\u9000\u6b3e\u5355\u5df2\u7ecf\u9000\u6b3e\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u8bd5");
        }
    }

    private void IsOldOrNew(PayProRefundAbilityReqBo payProRefundAbilityReqBo, FscRefundInfoPO modelBy, Long payOrderId, FscDealRefundBusiReqBO busiReqBO, FscDealRefundBusiRspBO fscDealRefundBusiRspBo, String refundOutId) {
        payProRefundAbilityReqBo.setBusiCode(this.payBusiCode);
        payProRefundAbilityReqBo.setOrderType("06");
        payProRefundAbilityReqBo.setRefundOutOrderId(refundOutId);
        payProRefundAbilityReqBo.setNotifyUrl(this.orderRefundNotifyUrl);
        String resultData = null;
        if (payOrderId == null) {
            FscPayInfoPO fscPayInfoPo = this.newPaySet(payProRefundAbilityReqBo, modelBy, busiReqBO);
            log.debug("\u652f\u4ed8\u4e2d\u5fc3\u9000\u6b3e\u524d\u4ed8\u6b3e\u4fe1\u606f\u4e3a{}", (Object)fscPayInfoPo);
            if (FscConstants.MerchantPayChannelPay.WO.equals(fscPayInfoPo.getPayChannel()) || FscConstants.MerchantPayChannel.WO.equals(fscPayInfoPo.getPayChannel())) {
                log.debug("\u6c83\u652f\u4ed8\u9000\u6b3e");
                log.debug("\u6c83\u652f\u4ed8\u9000\u6b3e\u5165\u53c2{}", (Object)(this.woPayRefundUrl + JSONObject.toJSONString((Object)payProRefundAbilityReqBo)));
                resultData = HttpUtil.post((String)this.woPayRefundUrl, (String)JSONObject.toJSONString((Object)payProRefundAbilityReqBo));
                log.debug("\u6c83\u652f\u4ed8\u9000\u6b3e\u51fa\u53c2{}", (Object)resultData);
            } else if (FscConstants.MerchantPayChannelPay.YEE.equals(fscPayInfoPo.getPayChannel())) {
                log.debug("\u6613\u5b9d\u4ed8\u9000\u6b3e");
                log.debug("\u6613\u5b9d\u4ed8\u9000\u6b3e\u5165\u53c2{}", (Object)(this.yeePayRefundUrl + JSONObject.toJSONString((Object)payProRefundAbilityReqBo)));
                resultData = HttpUtil.post((String)this.yeePayRefundUrl, (String)JSONObject.toJSONString((Object)payProRefundAbilityReqBo));
                log.debug("\u6613\u5b9d\u4ed8\u9000\u6b3e\u51fa\u53c2{}", (Object)resultData);
            }
        } else {
            this.oldPaySet(payProRefundAbilityReqBo, modelBy, payOrderId);
            log.debug("\u6c83\u652f\u4ed8\u8001\u4ed8\u6b3e\u9000\u6b3e");
            log.debug("\u6c83\u652f\u4ed8\u8001\u4ed8\u6b3e\u9000\u6b3e\u5165\u53c2{}", (Object)(this.woPayRefundUrl + JSONObject.toJSONString((Object)payProRefundAbilityReqBo)));
            resultData = HttpUtil.post((String)this.woPayRefundUrl, (String)JSONObject.toJSONString((Object)payProRefundAbilityReqBo));
            log.debug("\u6c83\u652f\u4ed8\u8001\u4ed8\u6b3e\u9000\u6b3e\u51fa\u53c2{}", (Object)resultData);
        }
        this.dealRefundPay(busiReqBO, fscDealRefundBusiRspBo, resultData);
    }

    private void dealRefundPay(FscDealRefundBusiReqBO busiReqBO, FscDealRefundBusiRspBO fscDealRefundBusiRspBo, String resultData) {
        try {
            if (!StringUtils.isEmpty((Object)resultData)) {
                PayProRefundAbilityRspBo payProRefundAbilityRspBo = (PayProRefundAbilityRspBo)JSONObject.parseObject((String)resultData, PayProRefundAbilityRspBo.class);
                if ("0000".equals(payProRefundAbilityRspBo.getRespCode())) {
                    fscDealRefundBusiRspBo.setMessage("\u9000\u6b3e\u5df2\u7ecf\u7533\u8bf7\u6210\u529f\uff0c\u8bf7\u67e5\u8be2\u67e5\u8be2\u60a8\u7684\u9000\u6b3e\u60c5\u51b5\uff0c\u5982\u679c\u662f\u94f6\u884c\u5361\u9700\u8981\u4e00\u6bb5\u65f6\u95f4\u540e\u624d\u80fd\u6536\u5230\u9000\u6b3e\u3002\n\n\u5982\u6709\u95ee\u9898\u8bf7\u4e0e\u5e73\u53f0\u8054\u7cfb\u3002");
                    if ("SUCCESS".equals(payProRefundAbilityRspBo.getResultCode())) {
                        this.updateRefundSuccess(busiReqBO);
                    }
                    fscDealRefundBusiRspBo.setRespCode("0000");
                    fscDealRefundBusiRspBo.setRespDesc("\u6210\u529f");
                } else {
                    fscDealRefundBusiRspBo.setMessage("\u9000\u6b3e\u7533\u8bf7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u91cd\u65b0\u53d1\u8d77\u7533\u8bf7\u3002");
                    fscDealRefundBusiRspBo.setRespCode("190000");
                    fscDealRefundBusiRspBo.setRespDesc("\u9000\u6b3e\u7533\u8bf7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u91cd\u65b0\u53d1\u8d77\u7533\u8bf7\u3002");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            fscDealRefundBusiRspBo.setMessage("\u9000\u6b3e\u7533\u8bf7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u91cd\u65b0\u53d1\u8d77\u7533\u8bf7\u3002");
            fscDealRefundBusiRspBo.setRespCode("190000");
            fscDealRefundBusiRspBo.setRespDesc("\u9000\u6b3e\u7533\u8bf7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u91cd\u65b0\u53d1\u8d77\u7533\u8bf7\u3002");
        }
    }

    private void oldPaySet(PayProRefundAbilityReqBo payProRefundAbilityReqBo, FscRefundInfoPO modelBy, Long payOrderId) {
        log.debug("\u8fdb\u5165\u8001\u4ed8\u6b3e\u9000\u6b3e");
        payProRefundAbilityReqBo.setOriOutOrderId(String.valueOf(payOrderId));
        if (this.isTruePay.booleanValue()) {
            payProRefundAbilityReqBo.setRefundFee(String.valueOf(MoneyUtils.yuanToFenToLong((BigDecimal)modelBy.getRefundAmount())));
        } else {
            payProRefundAbilityReqBo.setRefundFee(MoneyUtils.yuanToFenToLong((BigDecimal)new BigDecimal("0.01")) + "");
        }
    }

    private FscPayInfoPO newPaySet(PayProRefundAbilityReqBo payProRefundAbilityReqBo, FscRefundInfoPO modelBy, FscDealRefundBusiReqBO busiReqBO) {
        log.debug("\u8fdb\u5165\u65b0\u4ed8\u6b3e\u9000\u6b3e");
        if (busiReqBO.getPayOrderId() == null) {
            log.debug("\u8fdb\u5165\u6b63\u5e38\u9000\u6b3e");
            FscPayInfoPO fscPayInfoPo = this.newPay(modelBy);
            payProRefundAbilityReqBo.setOriOutOrderId(String.valueOf(fscPayInfoPo.getPayOrderId()));
            this.IsLedger(payProRefundAbilityReqBo, modelBy, fscPayInfoPo);
            return fscPayInfoPo;
        }
        log.debug("\u8fdb\u5165\u652f\u4ed8\u56de\u8c03\u9000\u6b3e");
        payProRefundAbilityReqBo.setOriOutOrderId(String.valueOf(busiReqBO.getPayOrderId()));
        FscPayInfoPO fscPayInfoMapperModelBy = this.getFscPayInfoPO(busiReqBO);
        this.IsLedger(payProRefundAbilityReqBo, modelBy, fscPayInfoMapperModelBy);
        return fscPayInfoMapperModelBy;
    }

    private FscPayInfoPO getFscPayInfoPO(FscDealRefundBusiReqBO busiReqBO) {
        FscPayInfoPO fscPayInfoPo = new FscPayInfoPO();
        fscPayInfoPo.setPayOrderId(busiReqBO.getPayOrderId());
        FscPayInfoPO fscPayInfoMapperModelBy = this.fscPayInfoMapper.getModelBy(fscPayInfoPo);
        if (fscPayInfoMapperModelBy == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u4ed8\u6b3e\u5355\u5931\u8d25");
        }
        return fscPayInfoMapperModelBy;
    }

    private void IsLedger(PayProRefundAbilityReqBo payProRefundAbilityReqBo, FscRefundInfoPO modelBy, FscPayInfoPO fscPayInfoPo) {
        if (FscConstants.IsLedger.YES.equals(fscPayInfoPo.getIsLedger())) {
            this.isLedger(payProRefundAbilityReqBo, modelBy);
        } else {
            this.newPayBefor(payProRefundAbilityReqBo, modelBy);
        }
    }

    private void newPayBefor(PayProRefundAbilityReqBo payProRefundAbilityReqBo, FscRefundInfoPO modelBy) {
        log.debug("\u8fdb\u5165\u65b0\u4ed8\u6b3e\u9000\u6b3e\u5206\u8d26\u672a\u4e0a\u7ebf\u524d");
        if (this.isTruePay.booleanValue()) {
            payProRefundAbilityReqBo.setRefundFee(String.valueOf(MoneyUtils.yuanToFenToLong((BigDecimal)modelBy.getRefundAmount())));
        } else {
            payProRefundAbilityReqBo.setRefundFee(MoneyUtils.yuanToFenToLong((BigDecimal)new BigDecimal("0.01")) + "");
        }
    }

    private void isLedger(PayProRefundAbilityReqBo payProRefundAbilityReqBo, FscRefundInfoPO modelBy) {
        log.debug("\u8fdb\u5165\u65b0\u4ed8\u6b3e\u9000\u6b3e\u5206\u8d26\u4e0a\u7ebf\u540e");
        List<FscLedgerInfoPO> fscLedgerInfoMapperList = this.getFscLedgerInfoPOS(modelBy);
        HashMap<Long, BigDecimal> dealRefundMerchantRelAmountMap = new HashMap<Long, BigDecimal>(1);
        dealRefundMerchantRelAmountMap.put(fscLedgerInfoMapperList.get(0).getMerchantId(), BigDecimal.ZERO);
        HashMap<Long, BigDecimal> dealRefundTotalAmountMap = new HashMap<Long, BigDecimal>(1);
        dealRefundTotalAmountMap.put(fscLedgerInfoMapperList.get(0).getMerchantId(), BigDecimal.ZERO);
        this.getAmount(fscLedgerInfoMapperList, dealRefundMerchantRelAmountMap, dealRefundTotalAmountMap);
        BigDecimal dealRefundMerchantRelAmountMapFinish = this.checkAmount(modelBy, fscLedgerInfoMapperList, dealRefundMerchantRelAmountMap, dealRefundTotalAmountMap);
        this.setPayRefundInfo(payProRefundAbilityReqBo, modelBy, fscLedgerInfoMapperList, dealRefundMerchantRelAmountMapFinish);
    }

    private BigDecimal checkAmount(FscRefundInfoPO modelBy, List<FscLedgerInfoPO> fscLedgerInfoMapperList, HashMap<Long, BigDecimal> dealRefundMerchantRelAmountMap, HashMap<Long, BigDecimal> dealRefundTotalAmountMap) {
        BigDecimal dealRefundTotalAmountMapFinish = dealRefundTotalAmountMap.get(fscLedgerInfoMapperList.get(0).getMerchantId());
        log.debug("\u9000\u6b3e\u91d1\u989d\u6700\u7ec8\u503c{}", (Object)dealRefundTotalAmountMapFinish);
        if (dealRefundTotalAmountMapFinish.compareTo(modelBy.getRefundAmount()) != 0) {
            throw new FscBusinessException("190000", "\u8ba2\u5355\u9000\u6b3e\u91d1\u989d\u4e0e\u7ed3\u7b97\u8ba1\u7b97\u51fa\u91d1\u989d\u4e0d\u4e00\u81f4");
        }
        BigDecimal dealRefundMerchantRelAmountMapFinish = dealRefundMerchantRelAmountMap.get(fscLedgerInfoMapperList.get(0).getMerchantId());
        log.debug("\u5f52\u8fd8\u91d1\u989d\u6700\u7ec8\u503c{}", (Object)dealRefundMerchantRelAmountMapFinish);
        return dealRefundMerchantRelAmountMapFinish;
    }

    private void setPayRefundInfo(PayProRefundAbilityReqBo payProRefundAbilityReqBo, FscRefundInfoPO modelBy, List<FscLedgerInfoPO> fscLedgerInfoMapperList, BigDecimal dealRefundMerchantRelAmountMapFinish) {
        Long merchantId = fscLedgerInfoMapperList.get(0).getMerchantId();
        FscMerchantPO rspPo = this.getFscMerchantPo(merchantId);
        payProRefundAbilityReqBo.setRefundExtendValue5(rspPo.getPayMerchantId());
        if (this.isTruePay.booleanValue()) {
            payProRefundAbilityReqBo.setRefundFee(String.valueOf(MoneyUtils.yuanToFenToLong((BigDecimal)modelBy.getRefundAmount())));
            payProRefundAbilityReqBo.setRefundExtendValue4(String.valueOf(MoneyUtils.yuanToFenToLong((BigDecimal)dealRefundMerchantRelAmountMapFinish)));
        } else {
            payProRefundAbilityReqBo.setRefundFee(MoneyUtils.yuanToFenToLong((BigDecimal)new BigDecimal("0.01")) + "");
            payProRefundAbilityReqBo.setRefundExtendValue4(MoneyUtils.yuanToFenToLong((BigDecimal)new BigDecimal("0.01")) + "");
        }
    }

    private FscMerchantPO getFscMerchantPo(Long merchantId) {
        FscMerchantPO fscMerchantPo = new FscMerchantPO();
        fscMerchantPo.setMerchantId(merchantId);
        fscMerchantPo.setDelFlag(Integer.valueOf(0));
        fscMerchantPo.setExceptionFlag(Integer.valueOf(0));
        fscMerchantPo.setStatus(Integer.valueOf(3));
        log.debug("\u83b7\u53d6\u652f\u4ed8\u4fa7\u5546\u6237id\u5165\u53c2{}", (Object)fscMerchantPo);
        FscMerchantPO rspPo = this.fscMerchantMapper.getModelBy(fscMerchantPo);
        log.debug("\u83b7\u53d6\u652f\u4ed8\u4fa7\u5546\u6237id\u51fa\u53c2{}", (Object)rspPo);
        if (null == rspPo) {
            log.debug("\u5546\u6237\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a");
            throw new FscBusinessException("194202", "\u6536\u6b3e\u65b9\u5546\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        return rspPo;
    }

    private void getAmount(List<FscLedgerInfoPO> fscLedgerInfoMapperList, HashMap<Long, BigDecimal> dealRefundMerchantRelAmountMap, HashMap<Long, BigDecimal> dealRefundTotalAmountMap) {
        fscLedgerInfoMapperList.forEach(fscLedgerInfoPoModel -> {
            BigDecimal dealRefundMerchantRelAmountMapAmount = (BigDecimal)dealRefundMerchantRelAmountMap.get(((FscLedgerInfoPO)fscLedgerInfoMapperList.get(0)).getMerchantId());
            log.debug("\u83b7\u53d6\u5f52\u8fd8\u91d1\u989d\u66ff\u6362\u4e4b\u524d\u503c{}", (Object)dealRefundMerchantRelAmountMapAmount);
            BigDecimal dealRefundMerchantRelAmountMapAmountAfter = dealRefundMerchantRelAmountMapAmount.add(fscLedgerInfoPoModel.getPayLedgerItemRefundAmount());
            log.debug("\u83b7\u53d6\u5f52\u8fd8\u91d1\u989d\u66ff\u6362\u4e4b\u540e\u503c{}", (Object)dealRefundMerchantRelAmountMapAmountAfter);
            dealRefundMerchantRelAmountMap.replace(((FscLedgerInfoPO)fscLedgerInfoMapperList.get(0)).getMerchantId(), dealRefundMerchantRelAmountMapAmountAfter);
            log.debug("\u83b7\u53d6\u5f52\u8fd8\u91d1\u989d\u66ff\u6362\u540emap{}", (Object)dealRefundMerchantRelAmountMap);
            BigDecimal dealRefundTotalAmountMapAmount = (BigDecimal)dealRefundTotalAmountMap.get(((FscLedgerInfoPO)fscLedgerInfoMapperList.get(0)).getMerchantId());
            log.debug("\u83b7\u53d6\u9000\u6b3e\u91d1\u989d\u66ff\u6362\u4e4b\u524d\u503c{}", (Object)dealRefundTotalAmountMapAmount);
            BigDecimal dealRefundTotalAmountMapAmountAfter = dealRefundTotalAmountMapAmount.add(fscLedgerInfoPoModel.getPayItemRefundAmount());
            log.debug("\u83b7\u53d6\u9000\u6b3e\u91d1\u989d\u66ff\u6362\u4e4b\u540e\u503c{}", (Object)dealRefundTotalAmountMapAmountAfter);
            dealRefundTotalAmountMap.replace(((FscLedgerInfoPO)fscLedgerInfoMapperList.get(0)).getMerchantId(), dealRefundTotalAmountMapAmountAfter);
            log.debug("\u83b7\u53d6\u9000\u6b3e\u91d1\u989d\u66ff\u6362\u540emap{}", (Object)dealRefundTotalAmountMap);
        });
    }

    private List<FscLedgerInfoPO> getFscLedgerInfoPOS(FscRefundInfoPO modelBy) {
        FscLedgerInfoPO fscLedgerInfoPo = new FscLedgerInfoPO();
        fscLedgerInfoPo.setRefundId(modelBy.getRefundId());
        log.debug("\u67e5\u8be2\u5206\u8d26\u9000\u6b3e\u4fe1\u606f\u5165\u53c2{}", (Object)fscLedgerInfoPo);
        List fscLedgerInfoMapperList = this.fscLedgerInfoMapper.getList(fscLedgerInfoPo);
        log.debug("\u67e5\u8be2\u5206\u8d26\u9000\u6b3e\u4fe1\u606f\u51fa\u53c2{}", (Object)fscLedgerInfoMapperList);
        if (CollectionUtils.isEmpty((Collection)fscLedgerInfoMapperList)) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5206\u8d26\u9000\u6b3e\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return fscLedgerInfoMapperList;
    }

    private Long oldPay(FscRefundInfoPO modelBy) {
        log.debug("\u8001\u652f\u4ed8\u9000\u6b3e\u6821\u9a8c");
        FscShouldPayPO fscShouldPayPoOrder = new FscShouldPayPO();
        fscShouldPayPoOrder.setObjectId(modelBy.getSaleOrderId());
        Long payOrderId = this.fscShouldPayMapper.getFscPayOrderIdByShouldPayId(fscShouldPayPoOrder);
        log.debug("\u5224\u65ad\u662f\u5426\u662f\u8001\u4ed8\u6b3e\u51fa\u53c2{}", (Object)payOrderId);
        return payOrderId;
    }

    private FscPayInfoPO newPay(FscRefundInfoPO modelBy) {
        FscPayInfoPO fscPayOrder = this.getFscPayOrderId(modelBy);
        if (fscPayOrder == null) {
            throw new FscBusinessException("190000", "\u5916\u90e8\u8ba2\u5355\u6d41\u6c34\u4e3a\u7a7a");
        }
        return fscPayOrder;
    }

    private FscRefundInfoPO getFscRefundInfoPO(FscDealRefundBusiReqBO busiReqBO) {
        FscRefundInfoPO fscRefundInfoPo = new FscRefundInfoPO();
        fscRefundInfoPo.setRefundId(busiReqBO.getRefundId());
        FscRefundInfoPO modelBy = this.fscRefundInfoMapper.getModelBy(fscRefundInfoPo);
        if (modelBy == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u9000\u6b3e\u5355\u4e3a\u7a7a");
        }
        return modelBy;
    }

    private void updateRefundSuccess(FscDealRefundBusiReqBO busiReqBO) {
        FscRefundInfoPO fscRefundInfoPoSet = new FscRefundInfoPO();
        fscRefundInfoPoSet.setRefundState(FscConstants.RefundState.REFUND);
        FscRefundInfoPO fscRefundInfoPoWhere = new FscRefundInfoPO();
        fscRefundInfoPoWhere.setRefundId(busiReqBO.getRefundId());
        this.fscRefundInfoMapper.updateBy(fscRefundInfoPoSet, fscRefundInfoPoWhere);
    }

    private void updateRefundExtend(FscDealRefundBusiReqBO busiReqBO, String refundOutId) {
        FscRefundInfoPO fscRefundInfoPoSet = new FscRefundInfoPO();
        fscRefundInfoPoSet.setExtend1(refundOutId);
        FscRefundInfoPO fscRefundInfoPoWhere = new FscRefundInfoPO();
        fscRefundInfoPoWhere.setRefundId(busiReqBO.getRefundId());
        int update = this.fscRefundInfoMapper.updateBy(fscRefundInfoPoSet, fscRefundInfoPoWhere);
        if (update < 1) {
            throw new FscBusinessException("190000", "\u66f4\u65b0\u9000\u6b3e\u5355\u5931\u8d25");
        }
    }

    private FscPayInfoPO getFscPayOrderId(FscRefundInfoPO modelBy) {
        log.debug("\u67e5\u8be2\u652f\u4ed8\u6210\u529f\u7684\u4ed8\u6b3e\u5355\uff0c\u5e76\u9000\u6b3e\uff08\u53ea\u4f1a\u6709\u4e00\u6761\u652f\u4ed8\u6210\u529f\u7684\uff0c\u6240\u4ee5\u4e0d\u7528\u62c5\u5fc3\uff09{}", (Object)modelBy);
        FscPayInfoPO fscPayInfoPo = new FscPayInfoPO();
        fscPayInfoPo.setPayObjectId(modelBy.getSaleOrderId());
        fscPayInfoPo.setPayOrderType(Integer.valueOf(modelBy.getExtend2()));
        log.debug("\u67e5\u8be2\u652f\u4ed8\u6210\u529f\u7684\u4ed8\u6b3e\u5355\uff0c\u5e76\u9000\u6b3e\uff0c\u5165\u53c2{}", (Object)fscPayInfoPo);
        FscPayInfoPO fscPayInfoPoModel = this.fscPayInfoMapper.getPayOrderIdByPayObjectId(fscPayInfoPo);
        log.debug("\u67e5\u8be2\u652f\u4ed8\u6210\u529f\u7684\u4ed8\u6b3e\u5355\uff0c\u5e76\u9000\u6b3e\uff0c\u51fa\u53c2{}", (Object)fscPayInfoPoModel);
        return fscPayInfoPoModel;
    }
}

