/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscPayInfoMapper;
import com.tydic.fsc.dao.FscPayOrderInfoItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.FscNoticeOderBusiService;
import com.tydic.fsc.pay.busi.bo.FscNoticeOderBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscNoticeOderBusiRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscPayInfoPO;
import com.tydic.fsc.po.FscPayOrderInfoItemPO;
import com.tydic.payment.pay.busi.DataEncryptionService;
import com.tydic.payment.pay.busi.bo.DataEncryptionReqBo;
import com.tydic.payment.pay.busi.bo.DataEncryptionRspBo;
import com.tydic.payment.pay.common.util.HttpUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscNoticeOderBusiServiceImpl
implements FscNoticeOderBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscNoticeOderBusiServiceImpl.class);
    @Autowired
    private FscPayInfoMapper fscPayInfoMapper;
    @Autowired
    private FscPayOrderInfoItemMapper fscPayOrderInfoItemMapper;
    @Autowired
    private DataEncryptionService dataEncryptionService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Value(value="${sleepTime:3000}")
    private String sleepTime;
    @Value(value="${fscPayNotifyUrl:http://10.0.11.61:10210/dyc/saas/self/order/noauth/dealPayCallback}")
    private String notifyUrl;
    @Value(value="${pay.center.busi.code:D500}")
    private String payBusiCode;
    @Value(value="${pay.center.busi.id:10000001}")
    private String payBusiId;

    @Override
    public FscNoticeOderBusiRspBO dealNoticeOder(FscNoticeOderBusiReqBO busiReqBO) {
        FscNoticeOderBusiRspBO fscNoticeOderBusiRspBo = new FscNoticeOderBusiRspBO();
        log.debug("\u4ed8\u6b3e\u56de\u8c03\u4fee\u6539\u72b6\u6001\u63a5\u53e3\u5b9e\u73b0\u7c7b\u5f00\u59cb{}", (Object)busiReqBO);
        this.sleep();
        log.debug("\u7ed3\u675f\u7761\u7720{}", (Object)System.currentTimeMillis());
        Date date = new Date();
        Long payOrderId = busiReqBO.getPayOrderId();
        FscPayInfoPO fscPayInfoModelBy = this.getFscPayInfoPO(payOrderId);
        List<FscPayOrderInfoItemPO> fscPayOrderInfoItemList = this.getFscPayOrderInfoItemPOS(payOrderId);
        Map<Long, List<FscPayOrderInfoItemPO>> fscPayOrderInfoItemPoMap = fscPayOrderInfoItemList.stream().collect(Collectors.groupingBy(FscPayOrderInfoItemPO::getPayObjectId));
        if (FscConstants.PayObjectType.ORDER.equals(fscPayOrderInfoItemList.get(0).getPayObjectType())) {
            log.debug("\u8ba2\u5355\u4ed8\u6b3e\u56de\u8c03\u5f00\u59cb");
            this.sendPay(busiReqBO, fscPayInfoModelBy);
        } else if (FscConstants.PayObjectType.FSC.equals(fscPayOrderInfoItemList.get(0).getPayObjectType())) {
            log.debug("\u5bf9\u8d26\u5355\u4ed8\u6b3e\u56de\u8c03\u5f00\u59cb");
            this.updatePayInfo(payOrderId, date, FscConstants.NewPayState.PAYED);
            this.updatePayInfoItem(payOrderId, date, FscConstants.NewPayState.PAYED);
            HashMap paramMap = new HashMap();
            Map<Integer, List<FscOrderPO>> collect = this.getIntegerListMap(fscPayOrderInfoItemList);
            List<FscOrderPO> fscOrderPayingPoS = collect.get(FscConstants.FscServiceOrderState.PAYING);
            log.debug("\u4ed8\u6b3e\u5904\u7406\u4e2d\u7684\u6570\u636e" + fscOrderPayingPoS);
            List<FscOrderPO> fscOrderNotPayPoS = collect.get(FscConstants.FscServiceOrderState.NOT_PAYING);
            log.debug("\u5f85\u4ed8\u6b3e\u7684\u6570\u636e" + fscOrderNotPayPoS);
            if (CollectionUtils.isEmpty(fscOrderPayingPoS) ? fscOrderNotPayPoS.size() != fscPayOrderInfoItemList.size() : (CollectionUtils.isEmpty(fscOrderNotPayPoS) ? fscOrderPayingPoS.size() != fscPayOrderInfoItemList.size() : fscOrderPayingPoS.size() + fscOrderNotPayPoS.size() != fscPayOrderInfoItemList.size())) {
                throw new FscBusinessException("190000", "\u4ed8\u6b3e\u6570\u91cf\u4e8e\u5f53\u524d\u4ed8\u6b3e\u72b6\u6001\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u8bd5");
            }
            ArrayList<FscPayOrderInfoItemPO> fscPayOrderInfoItemPoS = new ArrayList<FscPayOrderInfoItemPO>();
            if (!CollectionUtils.isEmpty(fscOrderPayingPoS)) {
                fscOrderPayingPoS.forEach(fscOrderPoPaying -> fscPayOrderInfoItemPoS.add((FscPayOrderInfoItemPO)((List)fscPayOrderInfoItemPoMap.get(fscOrderPoPaying.getFscOrderId())).get(0)));
            }
            if (!CollectionUtils.isEmpty(fscOrderNotPayPoS)) {
                fscOrderNotPayPoS.forEach(fscOrderNotPay -> {
                    this.invokeFscOrderStatusFlow(fscPayOrderInfoItemList, paramMap);
                    fscPayOrderInfoItemPoS.add((FscPayOrderInfoItemPO)((List)fscPayOrderInfoItemPoMap.get(fscOrderNotPay.getFscOrderId())).get(0));
                });
            }
            fscNoticeOderBusiRspBo.setFscPayOrderInfoItemList(fscPayOrderInfoItemPoS);
            this.sleep();
        } else if (FscConstants.PayObjectType.SERVICE.equals(fscPayOrderInfoItemList.get(0).getPayObjectType()) || FscConstants.PayObjectType.PLATFORM.equals(fscPayOrderInfoItemList.get(0).getPayObjectType())) {
            log.debug("\u670d\u52a1\u8d39\u4ed8\u6b3e\u56de\u8c03\u5f00\u59cb");
            this.updatePayInfo(payOrderId, date, FscConstants.NewPayState.PAYED);
            this.updatePayInfoItem(payOrderId, date, FscConstants.NewPayState.PAYED);
            Map<Integer, List<FscOrderPO>> collectMap = this.getIntegerListMap(fscPayOrderInfoItemList);
            List<FscOrderPO> fscOrderPayingPoS = collectMap.get(FscConstants.FscServiceOrderState.PAYING);
            log.debug("\u4ed8\u6b3e\u5904\u7406\u4e2d\u7684\u6570\u636e" + fscOrderPayingPoS);
            List<FscOrderPO> fscOrderNotPayPoS = collectMap.get(FscConstants.FscServiceOrderState.NOT_SERVICE_PAYING);
            log.debug("\u5f85\u4ed8\u6b3e\u7684\u6570\u636e" + fscOrderNotPayPoS);
            if (CollectionUtils.isEmpty(fscOrderPayingPoS) ? fscOrderNotPayPoS.size() != fscPayOrderInfoItemList.size() : (CollectionUtils.isEmpty(fscOrderNotPayPoS) ? fscOrderPayingPoS.size() != fscPayOrderInfoItemList.size() : fscOrderPayingPoS.size() + fscOrderNotPayPoS.size() != fscPayOrderInfoItemList.size())) {
                throw new FscBusinessException("190000", "\u4ed8\u6b3e\u6570\u91cf\u4e8e\u5f53\u524d\u4ed8\u6b3e\u72b6\u6001\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u8bd5");
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            if (busiReqBO.getPayConfirmFlag().booleanValue()) {
                paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag1);
            } else {
                paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag0);
            }
            this.invokeFscOrderStatusFlow(fscPayOrderInfoItemList, paramMap);
            List<Long> collect = fscPayOrderInfoItemList.stream().map(FscPayOrderInfoItemPO::getPayObjectId).collect(Collectors.toList());
            fscNoticeOderBusiRspBo.setServiceFeeFscOrderIdList(collect);
        }
        fscNoticeOderBusiRspBo.setRespCode("0000");
        fscNoticeOderBusiRspBo.setRespDesc("\u6210\u529f");
        return fscNoticeOderBusiRspBo;
    }

    private Map<Integer, List<FscOrderPO>> getIntegerListMap(List<FscPayOrderInfoItemPO> fscPayOrderInfoItemList) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderIds(fscPayOrderInfoItemList.stream().map(FscPayOrderInfoItemPO::getPayObjectId).collect(Collectors.toList()));
        List fscOrderPoList = this.fscOrderMapper.getList(fscOrderPo);
        return fscOrderPoList.stream().collect(Collectors.groupingBy(FscOrderPO::getOrderState));
    }

    private List<FscPayOrderInfoItemPO> getFscPayOrderInfoItemPOS(Long payOrderId) {
        log.debug("\u67e5\u8be2\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5f00\u59cb");
        FscPayOrderInfoItemPO fscPayOrderInfoItemPo = new FscPayOrderInfoItemPO();
        fscPayOrderInfoItemPo.setPayOrderId(payOrderId);
        log.debug("\u67e5\u8be2\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5165\u53c2{}", (Object)fscPayOrderInfoItemPo);
        List fscPayOrderInfoItemList = this.fscPayOrderInfoItemMapper.getList(fscPayOrderInfoItemPo);
        log.debug("\u67e5\u8be2\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u51fa\u53c2{}", (Object)fscPayOrderInfoItemList);
        if (CollectionUtils.isEmpty((Collection)fscPayOrderInfoItemList)) {
            log.debug("\u67e5\u8be2\u4ed8\u6b3e\u660e\u7ec6\u4e3a\u7a7a");
            throw new FscBusinessException("190000", "\u67e5\u8be2\u4ed8\u6b3e\u660e\u7ec6\u4e3a\u7a7a");
        }
        return fscPayOrderInfoItemList;
    }

    private FscPayInfoPO getFscPayInfoPO(Long payOrderId) {
        log.debug("\u67e5\u8be2\u4ed8\u6b3e\u4e3b\u5355\u8be6\u60c5\u5f00\u59cb");
        FscPayInfoPO fscPayInfoPo = new FscPayInfoPO();
        fscPayInfoPo.setPayOrderId(payOrderId);
        log.debug("\u67e5\u8be2\u4ed8\u6b3e\u4e3b\u5355\u8be6\u60c5\u5165\u53c2{}", (Object)fscPayInfoPo);
        FscPayInfoPO fscPayInfoModelBy = this.fscPayInfoMapper.getModelBy(fscPayInfoPo);
        log.debug("\u67e5\u8be2\u4ed8\u6b3e\u4e3b\u5355\u8be6\u60c5\u51fa\u53c2{}", (Object)fscPayInfoModelBy);
        if (fscPayInfoModelBy == null) {
            log.debug("\u67e5\u8be2\u4ed8\u6b3e\u4e3b\u5355\u8be6\u60c5\u67e5\u8be2\u4e3a\u7a7a");
            throw new FscBusinessException("190000", "\u67e5\u8be2\u4ed8\u6b3e\u4e3b\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        return fscPayInfoModelBy;
    }

    private void updatePayInfo(Long payOrderId, Date date, Integer payState) {
        log.debug("\u4fee\u6539\u4ed8\u6b3e\u5355\u72b6\u6001\u60c5\u5f00\u59cb");
        FscPayInfoPO fscPayInfoWherePo = new FscPayInfoPO();
        fscPayInfoWherePo.setPayOrderId(payOrderId);
        FscPayInfoPO fscPayInfoSetPo = new FscPayInfoPO();
        fscPayInfoSetPo.setPayUpdateTime(date);
        fscPayInfoSetPo.setPayState(payState);
        log.debug("\u4fee\u6539\u4ed8\u6b3e\u5355\u72b6\u6001\u5165\u53c2where{}", (Object)fscPayInfoWherePo);
        log.debug("\u4fee\u6539\u4ed8\u6b3e\u5355\u72b6\u6001\u5165\u53c2Set{}", (Object)fscPayInfoSetPo);
        int update = this.fscPayInfoMapper.updateBy(fscPayInfoSetPo, fscPayInfoWherePo);
        if (update < 1) {
            throw new FscBusinessException("190000", "\u4fee\u6539\u4ed8\u6b3e\u72b6\u6001\u5931\u8d25");
        }
    }

    private void updatePayInfoItem(Long payOrderId, Date date, Integer payItemState) {
        log.debug("\u4fee\u6539\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5f00\u59cb");
        FscPayOrderInfoItemPO fscPayOrderInfoItemWherePo = new FscPayOrderInfoItemPO();
        fscPayOrderInfoItemWherePo.setPayOrderId(payOrderId);
        FscPayOrderInfoItemPO fscPayOrderInfoItemSetPo = new FscPayOrderInfoItemPO();
        fscPayOrderInfoItemSetPo.setPayItemUpdateTime(date);
        fscPayOrderInfoItemSetPo.setPayItemState(payItemState);
        log.debug("\u4fee\u6539\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5165\u53c2where{}", (Object)fscPayOrderInfoItemWherePo);
        log.debug("\u4fee\u6539\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5165\u53c2Set{}", (Object)fscPayOrderInfoItemSetPo);
        int update = this.fscPayOrderInfoItemMapper.updateBy(fscPayOrderInfoItemSetPo, fscPayOrderInfoItemWherePo);
        if (update < 1) {
            throw new FscBusinessException("190000", "\u4fee\u6539\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void sendPay(FscNoticeOderBusiReqBO busiReqBO, FscPayInfoPO fscPayInfoModelBy) {
        HashMap<String, String> content = new HashMap<String, String>(16);
        content.put("busiId", this.payBusiId);
        content.put("busiCode", this.payBusiCode);
        content.put("notifyUrl", this.notifyUrl);
        if (busiReqBO.getUserId() != null) {
            content.put("createOperId", busiReqBO.getUserId().toString());
        }
        content.put("creatOperName", busiReqBO.getUserName());
        content.put("TradeTime", new Date().toString());
        content.put("payNotifyTransId", fscPayInfoModelBy.getPayOrderId().toString());
        content.put("outOrderId", fscPayInfoModelBy.getPayOrderId().toString());
        content.put("paymentInsId", "3");
        content.put("PayMethod", "30");
        content.put("resultCode", "SUCCESS");
        String contentSend = JSONObject.toJSONString(content);
        DataEncryptionReqBo dataEncryptionReqBo = new DataEncryptionReqBo();
        dataEncryptionReqBo.setBusiId(this.payBusiId);
        dataEncryptionReqBo.setContent(contentSend);
        DataEncryptionRspBo dataEncryptionRspBo = this.dataEncryptionService.dataEncryption(dataEncryptionReqBo);
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("busiId", this.payBusiId);
        postParams.put("busiCode", this.payBusiCode);
        postParams.put("content", dataEncryptionRspBo.getEncrypData());
        String resultData = null;
        try {
            log.debug("\u56de\u8c03\u8ba2\u5355\u5f00\u59cb{}{}", postParams, (Object)this.notifyUrl);
            resultData = HttpUtil.sendPost((String)this.notifyUrl, postParams);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.info("\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a" + resultData);
    }

    private void invokeFscOrderStatusFlow(List<FscPayOrderInfoItemPO> fscPayOrderInfoItemList, Map<String, Object> paramMap) {
        log.debug("\u6d41\u8f6c\u72b6\u6001\u5f00\u59cb");
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBo = new FscOrderStatusFlowAtomReqBO();
        fscPayOrderInfoItemList.forEach(fscPayOrderInfoItemPo -> {
            fscOrderStatusFlowAtomReqBo.setOrderId(fscPayOrderInfoItemPo.getPayObjectId());
            fscOrderStatusFlowAtomReqBo.setParamMap(paramMap);
            log.debug("\u6d41\u8f6c\u72b6\u6001\u5165\u53c2{}", (Object)fscOrderStatusFlowAtomReqBo);
            FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBo);
            log.debug("\u6d41\u8f6c\u72b6\u6001\u51fa\u53c2{}", (Object)atomRspBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                log.debug("\u6d41\u8f6c\u72b6\u6001\u5931\u8d25");
                throw new FscBusinessException("194202", atomRspBO.getRespDesc());
            }
        });
    }

    private void sleep() {
        log.debug("\u5f00\u59cb\u7761\u7720{}", (Object)System.currentTimeMillis());
        try {
            Thread.sleep(Long.parseLong(this.sleepTime));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        log.debug("\u7ed3\u675f\u7761\u7720{}", (Object)System.currentTimeMillis());
    }
}

