/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCostLogMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.pay.busi.api.FscOrderBusiService;
import com.tydic.fsc.pay.busi.bo.FscOrderBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscOrderBusiRspBO;
import com.tydic.fsc.pay.busi.bo.FscOrderItemBusiBO;
import com.tydic.fsc.po.FscCostLogPO;
import com.tydic.fsc.po.FscCostOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.LdHttpUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscOrderBusiServiceImpl
implements FscOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderBusiServiceImpl.class);
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscCostLogMapper fscCostLogMapper;
    @Value(value="${ESB_ACCESS_IP}")
    private String ESB_ACCESS_IP;
    @Value(value="${PUSH_COST_FSC_ORDER}")
    private String PUSH_COST_FSC_ORDER;
    @Autowired
    private LdHttpUtils ldHttpUtils;

    @Override
    public FscOrderBusiRspBO getFscOrder(FscOrderBusiReqBO reqBO) {
        FscOrderBusiRspBO rspBO = new FscOrderBusiRspBO();
        FscCostLogPO fscCostLogPO = new FscCostLogPO();
        fscCostLogPO.setMethod(this.getClass().toString());
        fscCostLogPO.setObjId(reqBO.getFscOrderId().toString());
        fscCostLogPO.setObjType(FscConstants.CostObjType.FSC_ORDER_ID);
        try {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
            FscOrderPO orderPO = this.fscOrderMapper.getOrderInvoiceInfoByFscOrderId(fscOrderPO);
            rspBO.setFscOrderId(reqBO.getFscOrderId());
            rspBO.setFscOrderNo(orderPO.getOrderNo());
            rspBO.setRelationNo(orderPO.getContractNo());
            rspBO.setTotalPay(orderPO.getInspTotalBillMoney());
            FscCostOrderItemPO fscCostOrderItemPO = new FscCostOrderItemPO();
            fscCostOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
            List costList = this.fscOrderItemMapper.getCostList(fscCostOrderItemPO);
            if (!CollectionUtils.isEmpty((Collection)costList)) {
                BigDecimal totalPay = BigDecimal.ZERO;
                ArrayList<FscOrderItemBusiBO> fscOrderItem = new ArrayList<FscOrderItemBusiBO>();
                for (FscCostOrderItemPO costOrderItemPO : costList) {
                    FscOrderItemBusiBO fscOrderItemBusiBO = (FscOrderItemBusiBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)costOrderItemPO), FscOrderItemBusiBO.class);
                    fscOrderItemBusiBO.setReceivingReportAmount(fscOrderItemBusiBO.getSalePrice().multiply(fscOrderItemBusiBO.getOrderNum()));
                    totalPay = totalPay.add(fscOrderItemBusiBO.getSalePrice().multiply(fscOrderItemBusiBO.getOrderNum()));
                    fscOrderItem.add(fscOrderItemBusiBO);
                }
                if (orderPO.getTotalCharge().compareTo(totalPay) != 0) {
                    fscCostLogPO.setIsError(FscConstants.CostIsError.YES);
                    rspBO.setRespCode("1");
                    rspBO.setRespDesc("\u5bf9\u8d26\u603b\u91d1\u989d\u4e0e\u660e\u7ec6\u4e4b\u548c\u4e0d\u76f8\u7b49");
                } else {
                    fscCostLogPO.setIsError(FscConstants.CostIsError.NO);
                    rspBO.setFscOrderItem(fscOrderItem);
                }
            } else {
                fscCostLogPO.setIsError(FscConstants.CostIsError.YES);
                rspBO.setRespCode("1");
                rspBO.setRespDesc("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5bf9\u8d26\u5355\u660e\u7ec6");
            }
        }
        catch (Exception e) {
            fscCostLogPO.setIsError(FscConstants.CostIsError.YES);
            rspBO.setRespCode("1");
            rspBO.setRespDesc("\u7cfb\u7edf\u9519\u8bef");
        }
        if (!FscConstants.CostIsError.YES.equals(fscCostLogPO.getIsError())) {
            rspBO.setUrl(reqBO.getUrl());
            String body = JSON.toJSONString((Object)((Object)rspBO));
            log.debug("\u63a8\u9001\u6210\u672c\u7cfb\u7edfURL{}", (Object)reqBO.getUrl());
            log.debug("\u63a8\u9001\u6210\u672c\u7cfb\u7edfBODY{}", (Object)body);
            String post = this.ldHttpUtils.doPost(this.PUSH_COST_FSC_ORDER, body, null);
            rspBO.setRespDesc(post);
            log.error("\u8c03\u7528\u6210\u672c\u7cfb\u7edf\u63a5\u53e3\u65e5\u5fd7\u5165\u53c2\uff1a{}\uff1b\u51fa\u53c2\uff1a{}", (Object)body, (Object)post);
        }
        fscCostLogPO.setReq(JSONObject.toJSONString((Object)((Object)reqBO)));
        fscCostLogPO.setRsp(JSONObject.toJSONString((Object)((Object)rspBO)));
        fscCostLogPO.setCreateTime(new Date());
        fscCostLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        this.fscCostLogMapper.insert(fscCostLogPO);
        return rspBO;
    }
}

