/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscPayInfoMapper;
import com.tydic.fsc.dao.FscPayOrderInfoItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.FscPaySuccessCallBackOrderBO;
import com.tydic.fsc.pay.atom.api.FscDealPaySuccessAtomService;
import com.tydic.fsc.pay.atom.bo.FscDealPaySuccessAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscDealPaySuccessAtomRspBO;
import com.tydic.fsc.pay.busi.api.FscPayConfirmBusiService;
import com.tydic.fsc.pay.busi.api.FscUpdateCashierDownPayItemStateBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayConfirmBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayConfirmBusiRspBO;
import com.tydic.fsc.pay.busi.bo.FscUpdateCashierDownPayItemStateBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscUpdateCashierDownPayItemStateBusiRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscPayInfoPO;
import com.tydic.fsc.po.FscPayOrderInfoItemPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayConfirmBusiServiceImpl
implements FscPayConfirmBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPayConfirmBusiServiceImpl.class);
    @Autowired
    private FscDealPaySuccessAtomService fscDealPaySuccessAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscPayInfoMapper fscPayInfoMapper;
    @Autowired
    private FscPayOrderInfoItemMapper fscPayOrderInfoItemMapper;
    @Autowired
    private FscUpdateCashierDownPayItemStateBusiService fscUpdateCashierDownPayItemStateBusiService;
    @Value(value="${isNewPay:false}")
    private Boolean isNewPay;

    @Override
    public FscPayConfirmBusiRspBO dealPayConfirm(FscPayConfirmBusiReqBO busiReqBO) {
        if (this.isNewPay.booleanValue()) {
            Date date = new Date();
            ArrayList fscPaySuccessCallBackOrderBOList = new ArrayList();
            FscOrderPO set = new FscOrderPO();
            set.setPayConfirmId(busiReqBO.getUserName());
            set.setPayConfirmName(busiReqBO.getName());
            set.setPayConfirmTime(date);
            FscOrderPO where = new FscOrderPO();
            where.setFscOrderIds(busiReqBO.getFscOrderIds());
            this.fscOrderMapper.updateBy(set, where);
            List<FscPayInfoPO> paying = this.getFscPayInfoPoS(busiReqBO);
            if (org.apache.commons.collections.CollectionUtils.isEmpty(paying)) {
                log.debug("\u67e5\u8be2\u786e\u8ba4\u652f\u4ed8\u5bf9\u8d26\u5355\u5bf9\u5e94\u7684\u4ed8\u6b3e\u5355\u636e\u51fa\u53c2\u4e3a\u7a7a{}", paying);
                throw new FscBusinessException("190000", "\u652f\u4ed8\u786e\u8ba4\u5931\u8d25");
            }
            log.debug("\u67e5\u8be2\u786e\u8ba4\u652f\u4ed8\u5bf9\u8d26\u5355\u5bf9\u5e94\u7684\u4ed8\u6b3e\u5355\u636e\u51fa\u53c2\u4e0d\u4e3a\u7a7a{}", paying);
            List<Long> payOrderIds = paying.stream().map(FscPayInfoPO::getPayOrderId).collect(Collectors.toList());
            if (busiReqBO.getPayFlag().booleanValue()) {
                log.debug("\u652f\u4ed8\u786e\u8ba4\u4e3a\u5df2\u4ed8\u6b3e\u5f00\u59cb");
                this.updatePayInfo(payOrderIds, date, FscConstants.NewPayState.PAYED);
            } else {
                log.debug("\u652f\u4ed8\u786e\u8ba4\u4e3a\u672a\u4ed8\u6b3e\u5f00\u59cb");
                this.updatePayInfo(payOrderIds, date, FscConstants.NewPayState.PAY_FAIL);
                FscUpdateCashierDownPayItemStateBusiReqBO fscUpdateCashierDownPayItemStateBusiReqBo = new FscUpdateCashierDownPayItemStateBusiReqBO();
                fscUpdateCashierDownPayItemStateBusiReqBo.setPayObjectIds(busiReqBO.getFscOrderIds());
                log.debug("\u66f4\u65b0\u4ed8\u6b3e\u5355\u660e\u7ec6\u72b6\u6001\u5165\u53c2{}", (Object)fscUpdateCashierDownPayItemStateBusiReqBo);
                FscUpdateCashierDownPayItemStateBusiRspBO fscUpdateCashierDownPayItemStateBusiRspBO = this.fscUpdateCashierDownPayItemStateBusiService.updateCashierDownPayItemState(fscUpdateCashierDownPayItemStateBusiReqBo);
                log.debug("\u66f4\u65b0\u4ed8\u6b3e\u5355\u660e\u7ec6\u72b6\u6001\u51fa\u53c2{}", (Object)fscUpdateCashierDownPayItemStateBusiRspBO);
                if (!"0000".equals(fscUpdateCashierDownPayItemStateBusiRspBO.getRespCode())) {
                    throw new FscBusinessException(fscUpdateCashierDownPayItemStateBusiRspBO.getRespCode(), fscUpdateCashierDownPayItemStateBusiRspBO.getRespDesc());
                }
            }
            this.updatePayItem(date, payOrderIds);
            this.invokeFscOrderStatusFlow(busiReqBO);
            ArrayList<Long> resultFscOrderIds = new ArrayList<Long>(busiReqBO.getFscOrderIds());
            FscPayConfirmBusiRspBO busiRspBO = new FscPayConfirmBusiRspBO();
            busiRspBO.setResultFscOrderIds(resultFscOrderIds);
            return busiRspBO;
        }
        ArrayList<Long> resultFscOrderIds = new ArrayList<Long>();
        ArrayList<FscPaySuccessCallBackOrderBO> fscPaySuccessCallBackOrderBOList = new ArrayList<FscPaySuccessCallBackOrderBO>();
        FscOrderPO set = new FscOrderPO();
        set.setPayConfirmId(busiReqBO.getUserName());
        set.setPayConfirmName(busiReqBO.getName());
        set.setPayConfirmTime(new Date());
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderIds(busiReqBO.getFscOrderIds());
        this.fscOrderMapper.updateBy(set, where);
        Map<String, Object> paramMap = this.invokeFscOrderStatusFlow(busiReqBO);
        if (busiReqBO.getPayFlag().booleanValue()) {
            FscDealPaySuccessAtomReqBO fscDealPaySuccessAtomReqBO = new FscDealPaySuccessAtomReqBO();
            fscDealPaySuccessAtomReqBO.setPayFscOrderId(busiReqBO.getFscOrderIds());
            fscDealPaySuccessAtomReqBO.setParamMap(paramMap);
            fscDealPaySuccessAtomReqBO.setUserId(busiReqBO.getUserId());
            fscDealPaySuccessAtomReqBO.setUserName(busiReqBO.getUserName());
            FscDealPaySuccessAtomRspBO atomRspBO = this.fscDealPaySuccessAtomService.dealPaySuccess(fscDealPaySuccessAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException("193205", atomRspBO.getRespDesc());
            }
            if (!CollectionUtils.isEmpty(atomRspBO.getResultFscOrderIds())) {
                resultFscOrderIds.addAll(atomRspBO.getResultFscOrderIds());
            }
            if (!CollectionUtils.isEmpty(atomRspBO.getFscPaySuccessCallBackOrderBOList())) {
                fscPaySuccessCallBackOrderBOList.addAll(atomRspBO.getFscPaySuccessCallBackOrderBOList());
            }
        }
        resultFscOrderIds.addAll(busiReqBO.getFscOrderIds());
        FscPayConfirmBusiRspBO busiRspBO = new FscPayConfirmBusiRspBO();
        busiRspBO.setResultFscOrderIds(resultFscOrderIds);
        busiRspBO.setFscPaySuccessCallBackOrderBOList(fscPaySuccessCallBackOrderBOList);
        return busiRspBO;
    }

    private List<FscPayInfoPO> getFscPayInfoPoS(FscPayConfirmBusiReqBO busiReqBO) {
        FscPayInfoPO fscPayInfoPo = new FscPayInfoPO();
        fscPayInfoPo.setPayObjectIds(busiReqBO.getFscOrderIds());
        fscPayInfoPo.setPayState(FscConstants.NewPayState.PAYED);
        log.debug("\u67e5\u8be2\u786e\u8ba4\u652f\u4ed8\u5bf9\u8d26\u5355\u5bf9\u5e94\u7684\u4ed8\u6b3e\u5355\u636e\u5165\u53c2{}", (Object)fscPayInfoPo);
        List paying = this.fscPayInfoMapper.getListByPayObjectIdsPaying(fscPayInfoPo);
        log.debug("\u67e5\u8be2\u786e\u8ba4\u652f\u4ed8\u5bf9\u8d26\u5355\u5bf9\u5e94\u7684\u4ed8\u6b3e\u5355\u636e\u51fa\u53c2{}", (Object)paying);
        return paying;
    }

    private void updatePayItem(Date date, List<Long> payOrderIds) {
        log.debug("\u66f4\u65b0\u652f\u4ed8\u660e\u7ec6\u8868\u5f00\u59cb");
        FscPayOrderInfoItemPO fscPayOrderInfoItemPoWhere = new FscPayOrderInfoItemPO();
        fscPayOrderInfoItemPoWhere.setPayOrderIds(payOrderIds);
        FscPayOrderInfoItemPO fscPayOrderInfoItemPoSet = new FscPayOrderInfoItemPO();
        fscPayOrderInfoItemPoSet.setPayItemUpdateTime(date);
        log.debug("\u66f4\u65b0\u652f\u4ed8\u660e\u7ec6\u8868\u5f00\u59cb\u5165\u53c2where{}", (Object)fscPayOrderInfoItemPoWhere);
        log.debug("\u66f4\u65b0\u652f\u4ed8\u660e\u7ec6\u8868\u5f00\u59cb\u5165\u53c2Set{}", (Object)fscPayOrderInfoItemPoSet);
        this.fscPayOrderInfoItemMapper.updateBy(fscPayOrderInfoItemPoSet, fscPayOrderInfoItemPoWhere);
    }

    private Map<String, Object> invokeFscOrderStatusFlow(FscPayConfirmBusiReqBO busiReqBO) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = (FscOrderStatusFlowAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscOrderStatusFlowAtomReqBO.class);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (busiReqBO.getPayFlag().booleanValue()) {
            paramMap.put("payFlag", FscConstants.ProcessParam.payFlag1);
        } else {
            paramMap.put("payFlag", FscConstants.ProcessParam.payFlag0);
        }
        busiReqBO.getFscOrderIds().forEach(fscOrderId -> {
            fscOrderStatusFlowAtomReqBO.setCurStatus(FscConstants.FscPayOrderState.PAIED_TO_COMFIR);
            fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderId);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException("193205", atomRspBO.getRespDesc());
            }
        });
        return paramMap;
    }

    private void updatePayInfo(List<Long> payOrderIds, Date date, Integer payState) {
        log.debug("\u4fee\u6539\u4ed8\u6b3e\u5355\u72b6\u6001\u60c5\u5f00\u59cb");
        FscPayInfoPO fscPayInfoWherePo = new FscPayInfoPO();
        fscPayInfoWherePo.setPayOrderIds(payOrderIds);
        FscPayInfoPO fscPayInfoSetPo = new FscPayInfoPO();
        fscPayInfoSetPo.setPayUpdateTime(date);
        fscPayInfoSetPo.setPayState(payState);
        log.debug("\u4fee\u6539\u4ed8\u6b3e\u5355\u72b6\u6001\u5165\u53c2where{}", (Object)fscPayInfoWherePo);
        log.debug("\u4fee\u6539\u4ed8\u6b3e\u5355\u72b6\u6001\u5165\u53c2Set{}", (Object)fscPayInfoSetPo);
        int update = this.fscPayInfoMapper.updateBy(fscPayInfoSetPo, fscPayInfoWherePo);
        if (update < 1) {
            throw new FscBusinessException("190000", "\u4fee\u6539\u4ed8\u6b3e\u72b6\u6001\u5931\u8d25");
        }
    }
}

