/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.atom.api.FscCostLogAtomService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscDelOrderAbilityService;
import com.tydic.fsc.pay.ability.bo.FscDelOrderAbilityBO;
import com.tydic.fsc.pay.ability.bo.FscDelOrderAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscDelOrderAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscDelOrderBusiService;
import com.tydic.fsc.pay.busi.bo.FscDelOrderBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscDelOrderBusiRspBO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscDelOrderAbilityService"})
public class FscDelOrderAbilityServiceImpl
implements FscDelOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscDelOrderAbilityServiceImpl.class);
    @Autowired
    FscDelOrderBusiService fscDelOrderBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscCostLogAtomService fscCostLogAtomService;

    @PostMapping(value={"delOrder"})
    public FscDelOrderAbilityRspBO delOrder(@RequestBody FscDelOrderAbilityReqBO reqBO) {
        log.debug("\u4e0b\u6e38\u6210\u672c\u7cfb\u7edf\u56de\u8c03\u5f00\u59cb\u4e86\u5165\u53c2{}", (Object)reqBO);
        Long logId = null;
        try {
            logId = this.logAddCallMoneyBack(reqBO + "", reqBO.getFscOrderList().get(0) + "");
        }
        catch (Exception e) {
            log.debug("\u4e0b\u6e38\u6210\u672c\u7cfb\u7edf\u56de\u8c03\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25");
            e.printStackTrace();
        }
        this.var(reqBO);
        FscDelOrderBusiReqBO fscDelOrderBusiReqBO = (FscDelOrderBusiReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscDelOrderBusiReqBO.class));
        FscDelOrderBusiRspBO busiRspBo = this.fscDelOrderBusiService.delOrder(fscDelOrderBusiReqBO);
        if (!"0000".equals(busiRspBo.getRespCode())) {
            try {
                if (logId != null) {
                    this.logUpdate(logId, busiRspBo.getRespDesc());
                }
            }
            catch (Exception ek) {
                log.debug("\u4e0b\u6e38\u6210\u672c\u7cfb\u7edf\u56de\u8c03\u65e5\u5fd7\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25");
                ek.printStackTrace();
            }
        }
        if ("0000".equals(busiRspBo.getRespCode()) && !CollectionUtils.isEmpty((Collection)reqBO.getFscOrderList())) {
            this.sendMq(reqBO.getFscOrderList().stream().map(FscDelOrderAbilityBO::getFscOrderId).collect(Collectors.toList()));
        }
        return (FscDelOrderAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBo)), FscDelOrderAbilityRspBO.class);
    }

    private void logUpdate(Long id, String rspStr) {
        this.fscCostLogAtomService.logUpdate(id, rspStr, FscConstants.CostIsError.NO);
    }

    private void sendMq(List<Long> fscOrderIds) {
        fscOrderIds.forEach(fscOrderId -> {
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        });
    }

    private Long logAddCallMoneyBack(String reqStr, String fscOrderId) {
        return this.fscCostLogAtomService.logInsert(fscOrderId, reqStr, null, FscConstants.CostIsError.YES, FscConstants.CostObjType.FSC_DOWN_CALL_MONEY_BACK, this.getClass().toString());
    }

    private void var(FscDelOrderAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("190000", "\u4e0b\u6e38\u6210\u672c\u7cfb\u7edf\u56de\u4f20\u63a5\u53e3\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getPayTime() == null) {
            throw new FscBusinessException("190000", "\u4e0b\u6e38\u6210\u672c\u7cfb\u7edf\u56de\u4f20\u63a5\u53e3\u5165\u53c2\u4ed8\u6b3e\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getThisPay() == null) {
            throw new FscBusinessException("190000", "\u4e0b\u6e38\u6210\u672c\u7cfb\u7edf\u56de\u4f20\u63a5\u53e3\u5165\u53c2\u672c\u6b21\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getTotalPay() == null) {
            throw new FscBusinessException("190000", "\u4e0b\u6e38\u6210\u672c\u7cfb\u7edf\u56de\u4f20\u63a5\u53e3\u5165\u53c2\u603b\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

