/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.atom.api.FscCostLogAtomService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscOrderAbilityService;
import com.tydic.fsc.pay.ability.bo.FscOrderAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscOrderAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscOrderBusiService;
import com.tydic.fsc.pay.busi.bo.FscOrderBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscOrderBusiRspBO;
import com.tydic.fsc.po.FscOrderPO;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscOrderAbilityService"})
public class FscOrderAbilityServiceImpl
implements FscOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderAbilityServiceImpl.class);
    @Autowired
    private FscOrderBusiService fscOrderBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Value(value="${agreeOrderDownDetailUrl:http://test1-lsugu.liando.cn:9191/#/index/agrTradeStatementDetails?fscOrderId=}")
    private String agreeOrderDownDetailUrl;
    @Value(value="${eleOrderDownDetailUrl:http://test1-lsugu.liando.cn:9191/#/index/ecTradeStatementDetails?fscOrderId=}")
    private String eleOrderDownDetailUrl;
    @Value(value="${tradOrderDownDetailUrl:http://test1-lsugu.liando.cn:9191/#/index/agrTradeStatementDetails?fscOrderId=}")
    private String tradOrderDownDetailUrl;
    @Autowired
    private FscCostLogAtomService fscCostLogAtomService;
    @Value(value="${settlementDay:7}")
    private int settlementDay;

    @PostMapping(value={"dealFscOrder"})
    public FscOrderAbilityRspBO dealFscOrder(@RequestBody FscOrderAbilityReqBO reqBO) {
        log.debug("\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u6570\u636e\u5f00\u59cb\u4e86{}", (Object)reqBO);
        this.getFscOrderPo(reqBO);
        FscOrderBusiReqBO fscOrderBusiReqBo = (FscOrderBusiReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscOrderBusiReqBO.class));
        log.debug("\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u6570\u636e\u5f00\u59cb\u4e86Busi\u5165\u53c2{}", (Object)fscOrderBusiReqBo);
        FscOrderBusiRspBO busiRspBO = this.fscOrderBusiService.dealFscOrder(fscOrderBusiReqBo);
        log.debug("\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u6570\u636e\u5f00\u59cb\u4e86Busi\u51fa\u53c2{}", (Object)busiRspBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("190000", busiRspBO.getRespDesc());
        }
        if ("0000".equals(busiRspBO.getRespCode())) {
            this.sendMq(reqBO.getFscOrderId());
        }
        return (FscOrderAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscOrderAbilityRspBO.class);
    }

    private void setInfo(FscOrderAbilityReqBO reqBO, FscOrderPO fscOrderPoModel) {
        if ("3".equals(fscOrderPoModel.getOrderSource().toString()) && FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPoModel.getMakeType()) && "4".equals(fscOrderPoModel.getUserType().toString()) && fscOrderPoModel.getTotalCombinedPaymentCredit().compareTo(BigDecimal.ZERO) > 0) {
            log.debug("\u8d38\u6613\u534f\u8bae\u4e0b\u6e38\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u5f00\u59cb");
            reqBO.setUrl(this.agreeOrderDownDetailUrl + fscOrderPoModel.getFscOrderId());
        } else if ("3".equals(fscOrderPoModel.getOrderSource().toString()) && FscConstants.FscOrderMakeType.SUPPLIER.equals(fscOrderPoModel.getMakeType()) && "4".equals(fscOrderPoModel.getUserType().toString()) && fscOrderPoModel.getTotalCombinedPaymentCredit().compareTo(BigDecimal.ZERO) > 0) {
            log.debug("\u4e09\u65b9\u4ea4\u6613\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u5f00\u59cb");
            reqBO.setUrl(this.tradOrderDownDetailUrl + fscOrderPoModel.getFscOrderId());
        } else if ("2".equals(fscOrderPoModel.getOrderSource().toString()) && FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPoModel.getMakeType()) && "4".equals(fscOrderPoModel.getUserType().toString()) && fscOrderPoModel.getTotalCombinedPaymentCredit().compareTo(BigDecimal.ZERO) > 0) {
            log.debug("\u7535\u5546\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u5f00\u59cb");
            reqBO.setUrl(this.tradOrderDownDetailUrl + fscOrderPoModel.getFscOrderId());
        }
        reqBO.setFscOrderId(fscOrderPoModel.getFscOrderId());
    }

    private FscOrderPO getFscOrderPo(FscOrderAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("190000", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u7ed3\u7b97\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPo.setReceiveType(FscConstants.FscOrderReceiveType.PURCHASE);
        FscOrderPO fscOrderPoModel = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (fscOrderPoModel == null) {
            throw new FscBusinessException("190000", "\u5bf9\u8d26\u5355\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a");
        }
        if (!FscConstants.IsCallCost.NO.equals(fscOrderPo.getIsCallCost())) {
            throw new FscBusinessException("190000", "\u5df2\u7ecf\u63a8\u9001\u7684\u8d26\u5355\u4e0d\u5141\u8bb8\u518d\u6b21\u63a8\u9001");
        }
        return fscOrderPoModel;
    }

    private void sendMq(Long fscOrderId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private Long logAddCallMoney(String reqStr, String fscOrderId) {
        return this.fscCostLogAtomService.logInsert(fscOrderId, reqStr, null, FscConstants.CostIsError.YES, FscConstants.CostObjType.FSC_DOWN_CALL_MONEY, this.getClass().toString());
    }

    private void logUpdate(Long id, String rspStr) {
        this.fscCostLogAtomService.logUpdate(id, rspStr, FscConstants.CostIsError.NO);
    }

    @PostMapping(value={"dealFscOrderAutoTime"})
    public FscOrderAbilityRspBO dealFscOrderAutoTime(@RequestBody FscOrderAbilityReqBO reqBO) {
        List<FscOrderPO> fscOrderPoList = this.getFscOrderPoList();
        if (CollectionUtils.isEmpty(fscOrderPoList)) {
            return new FscOrderAbilityRspBO();
        }
        fscOrderPoList.forEach(fscOrderPoModel -> {
            FscOrderBusiReqBO fscOrderAbilityReqBo = new FscOrderBusiReqBO();
            Date date = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(6, this.settlementDay);
            Date resultDate = calendar.getTime();
            if (fscOrderPoModel.getPlanPayTime() != null && fscOrderPoModel.getPlanPayTime().compareTo(resultDate) <= 0) {
                if ("3".equals(fscOrderPoModel.getOrderSource().toString()) && FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPoModel.getMakeType()) && "4".equals(fscOrderPoModel.getUserType().toString()) && fscOrderPoModel.getTotalCombinedPaymentCredit().compareTo(BigDecimal.ZERO) > 0) {
                    log.debug("\u8d38\u6613\u534f\u8bae\u4e0b\u6e38\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u5f00\u59cb");
                    fscOrderAbilityReqBo.setUrl(this.agreeOrderDownDetailUrl + fscOrderPoModel.getFscOrderId());
                } else if ("3".equals(fscOrderPoModel.getOrderSource().toString()) && FscConstants.FscOrderMakeType.SUPPLIER.equals(fscOrderPoModel.getMakeType()) && "4".equals(fscOrderPoModel.getUserType().toString()) && fscOrderPoModel.getTotalCombinedPaymentCredit().compareTo(BigDecimal.ZERO) > 0) {
                    log.debug("\u4e09\u65b9\u4ea4\u6613\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u5f00\u59cb");
                    fscOrderAbilityReqBo.setUrl(this.tradOrderDownDetailUrl + fscOrderPoModel.getFscOrderId());
                } else if ("2".equals(fscOrderPoModel.getOrderSource().toString()) && FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPoModel.getMakeType()) && "4".equals(fscOrderPoModel.getUserType().toString()) && fscOrderPoModel.getTotalCombinedPaymentCredit().compareTo(BigDecimal.ZERO) > 0) {
                    log.debug("\u7535\u5546\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u5f00\u59cb");
                    fscOrderAbilityReqBo.setUrl(this.eleOrderDownDetailUrl + fscOrderPoModel.getFscOrderId());
                }
                fscOrderAbilityReqBo.setFscOrderId(fscOrderPoModel.getFscOrderId());
                Long logId = null;
                try {
                    logId = this.logAddCallMoney((Object)((Object)fscOrderAbilityReqBo) + "", fscOrderPoModel.getFscOrderId() + "");
                }
                catch (Exception e) {
                    log.debug("\u4e0b\u6e38\u6210\u672c\u7cfb\u7edf\u521b\u5efa\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25");
                    e.printStackTrace();
                }
                try {
                    fscOrderAbilityReqBo.setLogId(logId);
                    log.debug("\u4e0b\u6e38\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u5165\u53c2{}", (Object)fscOrderAbilityReqBo);
                    this.fscOrderBusiService.dealFscOrder(fscOrderAbilityReqBo);
                    log.debug("\u4e0b\u6e38\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u51fa\u53c2{}", (Object)fscOrderAbilityReqBo);
                }
                catch (Exception e) {
                    try {
                        if (logId != null) {
                            this.logUpdate(logId, e.getMessage());
                        }
                    }
                    catch (Exception ek) {
                        log.debug("\u4e0b\u6e38\u6210\u672c\u7cfb\u7edf\u56de\u8c03\u65e5\u5fd7\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25");
                        ek.printStackTrace();
                    }
                    e.printStackTrace();
                }
            }
        });
        return new FscOrderAbilityRspBO();
    }

    private List<FscOrderPO> getFscOrderPoList() {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setIsCallCost(FscConstants.IsCallCost.NO);
        fscOrderPo.setAgreementLdType(FscConstants.AgreementLdType.INTERNAL_DATA_COLLECTION);
        return this.fscOrderMapper.getListNotChannl(fscOrderPo);
    }

    @PostMapping(value={"dealFscOrderBySelf"})
    public FscOrderAbilityRspBO dealFscOrderBySelf(@RequestBody FscOrderAbilityReqBO reqBO) {
        log.debug("\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u6570\u636e\u5f00\u59cb\u4e86{}", (Object)reqBO);
        FscOrderPO fscOrderPoModel = this.getFscOrderPo(reqBO);
        if (!FscConstants.AgreementLdType.INTERNAL_DATA_COLLECTION.equals(fscOrderPoModel.getAgreementLdType())) {
            throw new FscBusinessException("190000", "\u975e\u81ea\u91c7\u96c6\u91c7\u7c7b\u8d26\u5355\u4e0d\u5141\u8bb8\u624b\u52a8\u63a8\u9001");
        }
        this.setInfo(reqBO, fscOrderPoModel);
        FscOrderBusiReqBO fscOrderBusiReqBo = (FscOrderBusiReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscOrderBusiReqBO.class));
        fscOrderBusiReqBo.setIsDeal(true);
        log.debug("\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u6570\u636e\u5f00\u59cb\u4e86Busi\u5165\u53c2{}", (Object)fscOrderBusiReqBo);
        FscOrderBusiRspBO busiRspBO = this.fscOrderBusiService.dealFscOrder(fscOrderBusiReqBo);
        log.debug("\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u6570\u636e\u5f00\u59cb\u4e86Busi\u51fa\u53c2{}", (Object)busiRspBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("190000", busiRspBO.getRespDesc());
        }
        if ("0000".equals(busiRspBO.getRespCode())) {
            this.sendMq(reqBO.getFscOrderId());
        }
        return (FscOrderAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscOrderAbilityRspBO.class);
    }
}

