/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.atom.api.FscCostLogAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.FscOrderBusiService;
import com.tydic.fsc.pay.busi.bo.FscCallMoneyBo;
import com.tydic.fsc.pay.busi.bo.FscOrderBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscOrderBusiRspBO;
import com.tydic.fsc.pay.busi.bo.FscOrderItemBusiBO;
import com.tydic.fsc.po.FscCostOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscOrderBusiServiceImpl
implements FscOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderBusiServiceImpl.class);
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscCostLogAtomService fscCostLogAtomService;
    @Value(value="${PUSH_COST_FSC_ORDER:http://test1-lsugu.liando.cn}")
    private String PUSH_COST_FSC_ORDER;
    @Value(value="${SUPPLIER_NAME_CALL_MONEY:\u5317\u4eac\u94fe\u4e0a\u4f18\u8c37\u79d1\u6280\u6709\u9650\u516c\u53f8}")
    private String supplierNameCallMoney;

    @Override
    public FscOrderBusiRspBO dealFscOrder(FscOrderBusiReqBO reqBO) {
        FscOrderBusiRspBO rspBO = new FscOrderBusiRspBO();
        FscCallMoneyBo fscCallMoneyBo = new FscCallMoneyBo();
        FscOrderPO orderPo = this.getFscOrderPo(reqBO);
        List<FscCostOrderItemPO> costList = this.getFscCostOrderItemPoList(reqBO);
        this.setCallMoneyBo(reqBO, fscCallMoneyBo, orderPo, costList);
        this.doPost(reqBO, fscCallMoneyBo);
        this.updateFscOrder(reqBO);
        return rspBO;
    }

    private void updateFscOrder(FscOrderBusiReqBO reqBO) {
        log.debug("\u6210\u672c\u7cfb\u7edf\u63a8\u9001\u7ed9\u72b6\u6001\u53ca\u91d1\u989d\u9ed8\u8ba4\u503c\u5f00\u59cb");
        FscOrderPO fscOrderPoSet = new FscOrderPO();
        fscOrderPoSet.setPayMoney(BigDecimal.ZERO);
        fscOrderPoSet.setCostPayState(FscConstants.CostPayState.TO_PAY);
        FscOrderPO fscOrderPoWhere = new FscOrderPO();
        fscOrderPoWhere.setFscOrderId(reqBO.getFscOrderId());
        log.debug("\u6210\u672c\u7cfb\u7edf\u63a8\u9001\u7ed9\u72b6\u6001\u53ca\u91d1\u989d\u9ed8\u8ba4\u503cSet{}", (Object)fscOrderPoSet);
        log.debug("\u6210\u672c\u7cfb\u7edf\u63a8\u9001\u7ed9\u72b6\u6001\u53ca\u91d1\u989d\u9ed8\u8ba4\u503c\u5f00\u59cbWhere{}", (Object)fscOrderPoWhere);
        int update = this.fscOrderMapper.updateBy(fscOrderPoSet, fscOrderPoWhere);
        if (update < 1) {
            log.debug("\u6210\u672c\u7cfb\u7edf\u63a8\u9001\u7ed9\u72b6\u6001\u53ca\u91d1\u989d\u9ed8\u8ba4\u503c\u5931\u8d25");
            throw new FscBusinessException("190000", "\u6210\u672c\u7cfb\u7edf\u66f4\u65b0\u5931\u8d25");
        }
    }

    private void logUpdate(Long id, String rspStr) {
        this.fscCostLogAtomService.logUpdate(id, rspStr, FscConstants.CostIsError.NO);
    }

    private void doPost(FscOrderBusiReqBO reqBO, FscCallMoneyBo fscCallMoneyBo) {
        block6: {
            if (!reqBO.getIsDeal().booleanValue()) {
                try {
                    log.debug("\u4e0b\u6e38\u63a8\u9001\u6210\u672c\u7cfb\u7edfURL{}", (Object)fscCallMoneyBo);
                    log.debug("\u4e0b\u6e38\u63a8\u9001\u6210\u672c\u7cfb\u7edfBODY{}", (Object)this.PUSH_COST_FSC_ORDER);
                    String result = HttpUtil.post((String)this.PUSH_COST_FSC_ORDER, (String)JSONObject.toJSONString((Object)fscCallMoneyBo));
                    log.debug("\u4e0b\u6e38\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u51fa\u53c2-{}", (Object)result);
                    JSONObject resultObj = JSONObject.parseObject((String)result);
                    if (Integer.parseInt((String)resultObj.get((Object)"code")) != 0) {
                        log.debug("\u4e0b\u6e38\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u5f02\u5e38");
                        this.logUpdate(reqBO.getLogId(), result);
                        break block6;
                    }
                    this.setSucessPost(reqBO);
                }
                catch (Exception e) {
                    log.debug("\u4e0b\u6e38\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u5f02\u5e38");
                    this.logUpdate(reqBO.getLogId(), e.getMessage());
                    e.printStackTrace();
                }
            } else {
                log.debug("\u4e0b\u6e38\u63a8\u9001\u6210\u672c\u7cfb\u7edfURL{}", (Object)fscCallMoneyBo);
                log.debug("\u4e0b\u6e38\u63a8\u9001\u6210\u672c\u7cfb\u7edfBODY{}", (Object)this.PUSH_COST_FSC_ORDER);
                String result = HttpUtil.post((String)this.PUSH_COST_FSC_ORDER, (String)JSONObject.toJSONString((Object)fscCallMoneyBo));
                log.debug("\u4e0b\u6e38\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u51fa\u53c2-{}", (Object)result);
                JSONObject resultObj = JSONObject.parseObject((String)result);
                if (Integer.parseInt((String)resultObj.get((Object)"code")) != 0) {
                    throw new FscBusinessException("190000", "\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u5f02\u5e38");
                }
                this.setSucessPost(reqBO);
            }
        }
    }

    private void setSucessPost(FscOrderBusiReqBO reqBO) {
        try {
            FscOrderPO fscOrderPoWhere = new FscOrderPO();
            fscOrderPoWhere.setFscOrderId(reqBO.getFscOrderId());
            FscOrderPO fscOrderPoSet = new FscOrderPO();
            fscOrderPoSet.setIsCallCost(FscConstants.IsCallCost.YES);
            this.fscOrderMapper.updateBy(fscOrderPoSet, fscOrderPoWhere);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setCallMoneyBo(FscOrderBusiReqBO reqBO, FscCallMoneyBo fscCallMoneyBo, FscOrderPO orderPo, List<FscCostOrderItemPO> costList) {
        fscCallMoneyBo.setFscOrderId(reqBO.getFscOrderId());
        fscCallMoneyBo.setFscOrderNo(orderPo.getOrderNo());
        fscCallMoneyBo.setTotalPay(orderPo.getTotalCombinedPaymentCredit());
        fscCallMoneyBo.setUrl(reqBO.getUrl());
        fscCallMoneyBo.setRelationNo(orderPo.getContractNo());
        fscCallMoneyBo.setFscOrderSupplierName(this.supplierNameCallMoney);
        BigDecimal totalPay = BigDecimal.ZERO;
        ArrayList<FscOrderItemBusiBO> fscOrderItem = new ArrayList<FscOrderItemBusiBO>();
        for (FscCostOrderItemPO costOrderItemPo : costList) {
            FscOrderItemBusiBO fscOrderItemBusiBO = (FscOrderItemBusiBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)costOrderItemPo), FscOrderItemBusiBO.class);
            fscOrderItemBusiBO.setReceivingReportAmount(fscOrderItemBusiBO.getSalePrice().multiply(fscOrderItemBusiBO.getOrderNum()));
            totalPay = totalPay.add(fscOrderItemBusiBO.getSalePrice().multiply(fscOrderItemBusiBO.getOrderNum()));
            fscOrderItem.add(fscOrderItemBusiBO);
        }
        fscCallMoneyBo.setFscOrderItem(fscOrderItem);
    }

    private List<FscCostOrderItemPO> getFscCostOrderItemPoList(FscOrderBusiReqBO reqBO) {
        FscCostOrderItemPO fscCostOrderItemPo = new FscCostOrderItemPO();
        fscCostOrderItemPo.setFscOrderId(reqBO.getFscOrderId());
        List costList = this.fscOrderItemMapper.getCostList(fscCostOrderItemPo);
        if (CollectionUtils.isEmpty((Collection)costList)) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5bf9\u8d26\u5355\u660e\u7ec6\u4e3a\u7a7a");
        }
        return costList;
    }

    private FscOrderPO getFscOrderPo(FscOrderBusiReqBO reqBO) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getFscOrderId());
        FscOrderPO orderPo = this.fscOrderMapper.getOrderInvoiceInfoByFscOrderId(fscOrderPo);
        if (orderPo == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5bf9\u8d26\u5355\u4e3a\u7a7a");
        }
        return orderPo;
    }
}

