/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.tydic.dyc.oc.service.saleorder.UocQrySaleOrderExtFiledService;
import com.tydic.dyc.oc.service.saleorder.bo.UocQrySaleOrderMapReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocQrySaleOrderMapRspBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderMapExt;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscMerchantPayeeMapper;
import com.tydic.fsc.dao.FscPayAttachmentMapper;
import com.tydic.fsc.dao.FscPayInfoMapper;
import com.tydic.fsc.dao.FscPayOrderInfoItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscQryCashierDownPayItemAbilityService;
import com.tydic.fsc.pay.ability.bo.FscQryCashierDownPayItemAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscQryCashierDownPayItemAbilityRspBO;
import com.tydic.fsc.pay.ability.bo.FscQryCashierDownPayItemBO;
import com.tydic.fsc.pay.ability.bo.PayBo;
import com.tydic.fsc.pay.ability.bo.PayInfoItemBO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscMerchantPayeePO;
import com.tydic.fsc.po.FscPayAttachmentPO;
import com.tydic.fsc.po.FscPayInfoPO;
import com.tydic.fsc.po.FscPayOrderInfoItemPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscQryCashierDownPayItemAbilityService"})
public class FscQryCashierDownPayItemAbilityServiceImpl
implements FscQryCashierDownPayItemAbilityService {
    @Autowired
    private FscPayInfoMapper fscPayInfoMapper;
    @Autowired
    private FscPayOrderInfoItemMapper fscPayOrderInfoItemMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscMerchantPayeeMapper fscMerchantPayeeMapper;
    @Autowired
    private FscPayAttachmentMapper fscPayAttachmentMapper;
    @Autowired
    private UocQrySaleOrderExtFiledService uocQrySaleOrderExtFiledService;
    @Value(value="${payeeId:305775845729763327}")
    private Long payeeId;

    @PostMapping(value={"qryCashierDownPayItem"})
    public FscQryCashierDownPayItemAbilityRspBO qryCashierDownPayItem(@RequestBody FscQryCashierDownPayItemAbilityReqBO abilityReqBO) {
        this.check(abilityReqBO);
        this.checkFscPayInfo(abilityReqBO);
        List<FscPayOrderInfoItemPO> list = this.checkfscpayorderinfoitempos(abilityReqBO);
        List<FscMerchantPO> fscMerchantMapperList = this.checkfscmerchantpos(list);
        List<FscMerchantPayeePO> fscMerchantPayeePoList = this.getFscMerchantPayeePOS(fscMerchantMapperList);
        Map<Long, FscMerchantPayeePO> fscMerchantPayeePoMap = fscMerchantPayeePoList.stream().collect(Collectors.toMap(FscMerchantPayeePO::getMerchantId, o -> o));
        Map<Long, Long> fscMerchantMap = fscMerchantMapperList.stream().collect(Collectors.toMap(FscMerchantPO::getOrgId, FscMerchantPO::getMerchantId));
        ArrayList fscQryCashierDownPayItemBoS = new ArrayList();
        list.forEach(fscPayOrderInfoItemPoModel -> {
            FscQryCashierDownPayItemBO fscQryCashierDownPayItemBo = new FscQryCashierDownPayItemBO();
            fscQryCashierDownPayItemBo.setPayOrderItemId(fscPayOrderInfoItemPoModel.getPayOrderItemId());
            fscQryCashierDownPayItemBo.setPayObjectNo(fscPayOrderInfoItemPoModel.getPayObjectNo());
            fscQryCashierDownPayItemBo.setPayOrderItemAmount(fscPayOrderInfoItemPoModel.getPayOrderItemAmount());
            fscQryCashierDownPayItemBo.setPayBankName(((FscMerchantPayeePO)fscMerchantPayeePoMap.get(fscMerchantMap.get(fscPayOrderInfoItemPoModel.getPayeeId()))).getPayeeBankName());
            fscQryCashierDownPayItemBo.setPayBankAccount(((FscMerchantPayeePO)fscMerchantPayeePoMap.get(fscMerchantMap.get(fscPayOrderInfoItemPoModel.getPayeeId()))).getPayeeBankAccount());
            fscQryCashierDownPayItemBo.setPayeeAccountName(((FscMerchantPayeePO)fscMerchantPayeePoMap.get(fscMerchantMap.get(fscPayOrderInfoItemPoModel.getPayeeId()))).getPayeeAccountName());
            fscQryCashierDownPayItemBoS.add(fscQryCashierDownPayItemBo);
        });
        FscQryCashierDownPayItemAbilityRspBO lianDongFscQryCashierDownPayItemAbilityRspBo = new FscQryCashierDownPayItemAbilityRspBO();
        lianDongFscQryCashierDownPayItemAbilityRspBo.setRespCode("0000");
        lianDongFscQryCashierDownPayItemAbilityRspBo.setRespDesc("\u6210\u529f");
        lianDongFscQryCashierDownPayItemAbilityRspBo.setFscQryCashierDownPayItemList(fscQryCashierDownPayItemBoS);
        return lianDongFscQryCashierDownPayItemAbilityRspBo;
    }

    private List<FscMerchantPayeePO> getFscMerchantPayeePOS(List<FscMerchantPO> fscMerchantMapperList) {
        List merchantIds = fscMerchantMapperList.stream().map(FscMerchantPO::getMerchantId).collect(Collectors.toList());
        FscMerchantPayeePO fscMerchantPayeePo = new FscMerchantPayeePO();
        fscMerchantPayeePo.setMerchantIds(merchantIds);
        return this.fscMerchantPayeeMapper.getList(fscMerchantPayeePo);
    }

    private List<FscMerchantPO> checkfscmerchantpos(List<FscPayOrderInfoItemPO> list) {
        List collect = list.stream().map(FscPayOrderInfoItemPO::getPayeeId).distinct().collect(Collectors.toList());
        FscMerchantPO fscMerchantPo = new FscMerchantPO();
        fscMerchantPo.setOrgIds(collect);
        fscMerchantPo.setDelFlag(Integer.valueOf(0));
        fscMerchantPo.setExceptionFlag(Integer.valueOf(0));
        fscMerchantPo.setStatus(Integer.valueOf(3));
        List fscMerchantMapperList = this.fscMerchantMapper.getList(fscMerchantPo);
        if (CollectionUtils.isEmpty((Collection)fscMerchantMapperList) || fscMerchantMapperList.size() != collect.size()) {
            throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5355\u660e\u7ec6\u4e2d\u6709\u5546\u6237\u672a\u914d\u7f6e\u6536\u6b3e\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return fscMerchantMapperList;
    }

    private List<FscPayOrderInfoItemPO> checkfscpayorderinfoitempos(FscQryCashierDownPayItemAbilityReqBO abilityReqBO) {
        FscPayOrderInfoItemPO fscPayOrderInfoItemPo = new FscPayOrderInfoItemPO();
        fscPayOrderInfoItemPo.setPayOrderId(abilityReqBO.getPayOrderId());
        List list = this.fscPayOrderInfoItemMapper.getList(fscPayOrderInfoItemPo);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5355\u660e\u7ec6\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return list;
    }

    private void checkFscPayInfo(FscQryCashierDownPayItemAbilityReqBO abilityReqBO) {
        FscPayInfoPO fscPayInfoPo = new FscPayInfoPO();
        fscPayInfoPo.setPayOrderId(abilityReqBO.getPayOrderId());
        FscPayInfoPO modelBy = this.fscPayInfoMapper.getModelBy(fscPayInfoPo);
        if (modelBy == null) {
            throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
    }

    private void check(FscQryCashierDownPayItemAbilityReqBO abilityReqBO) {
        if (abilityReqBO.getPayOrderId() == null) {
            throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5355id\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
    }

    @PostMapping(value={"qryOrderListCashierDownPayItem"})
    public FscQryCashierDownPayItemAbilityRspBO qryOrderListCashierDownPayItem(@RequestBody FscQryCashierDownPayItemAbilityReqBO abilityReqBO) {
        if (abilityReqBO.getPayOrderType() == null) {
            ArrayList<Integer> payOrderTypeList = new ArrayList<Integer>();
            payOrderTypeList.add(FscConstants.PayOrderTypeInfo.ALL);
            payOrderTypeList.add(FscConstants.PayOrderTypeInfo.FIRST);
            abilityReqBO.setPayOrderTypeList(payOrderTypeList);
        }
        FscQryCashierDownPayItemAbilityRspBO fscQryCashierDownPayItemAbilityRspBo = new FscQryCashierDownPayItemAbilityRspBO();
        List<FscPayOrderInfoItemPO> fscPayOrderInfoItemMapperList = this.getfscpayorderinfoitempos(abilityReqBO);
        if (CollectionUtils.isEmpty(fscPayOrderInfoItemMapperList)) {
            fscPayOrderInfoItemMapperList = this.getfscpayorderinfoitemposByOrderId(abilityReqBO);
        }
        if (CollectionUtils.isEmpty(fscPayOrderInfoItemMapperList)) {
            fscPayOrderInfoItemMapperList = this.getfscpayorderinfoitemposByOrderIdFail(abilityReqBO);
        }
        if (CollectionUtils.isEmpty(fscPayOrderInfoItemMapperList)) {
            fscQryCashierDownPayItemAbilityRspBo.setFscQryCashierDownPayItemList(new ArrayList());
            return fscQryCashierDownPayItemAbilityRspBo;
        }
        FscPayInfoPO fscPayInfo = this.getFscPayInfo(fscPayOrderInfoItemMapperList.get(0).getPayOrderId());
        List<FscMerchantPO> fscMerchantMapperList = this.checkfscmerchantpos(fscPayOrderInfoItemMapperList);
        List<FscMerchantPayeePO> fscMerchantPayeePoList = this.getFscMerchantPayeePOS(fscMerchantMapperList);
        List<FscPayAttachmentPO> fscPayAttachmentPoList = this.getfscpayattachmentpos(fscPayOrderInfoItemMapperList);
        if (CollectionUtils.isEmpty(fscPayAttachmentPoList)) {
            fscQryCashierDownPayItemAbilityRspBo.setFscQryCashierDownPayItemList(new ArrayList());
            return fscQryCashierDownPayItemAbilityRspBo;
        }
        String payDownRemark = "";
        payDownRemark = this.getPayDownRemark(fscPayOrderInfoItemMapperList, payDownRemark, abilityReqBO);
        PayBo payBo = new PayBo();
        payBo.setFscAttachmentBOS(new ArrayList());
        payBo.setDetailName("\u8ba2\u5355\u4ed8\u6b3e");
        payBo.setIsAppPay(FscConstants.IsAppPay.YES);
        payBo.setIsSecondPay("");
        payBo.setPayAmount(fscPayInfo.getPayAmount());
        payBo.setPayConfirmFlag(Boolean.valueOf(false));
        payBo.setPayItemNum(Long.valueOf(fscPayOrderInfoItemMapperList.size()));
        payBo.setPayOrderType(fscPayInfo.getPayOrderType());
        payBo.setPayType(fscPayInfo.getPayType());
        payBo.setRedirectUrl("www.lsugu.com");
        ArrayList payInfoItemList = new ArrayList();
        fscPayOrderInfoItemMapperList.forEach(fscPayOrderInfoItemPo -> {
            PayInfoItemBO payInfoItemBo = new PayInfoItemBO();
            payInfoItemBo.setOrderId(fscPayOrderInfoItemPo.getOrderId());
            payInfoItemBo.setOrderNo(fscPayOrderInfoItemPo.getOrderNo());
            payInfoItemBo.setPayObjectId(fscPayOrderInfoItemPo.getPayObjectId());
            payInfoItemBo.setPayObjectNo(fscPayOrderInfoItemPo.getPayObjectNo());
            payInfoItemBo.setPayeeId(fscPayOrderInfoItemPo.getPayeeId());
            payInfoItemBo.setPayeeName(fscPayOrderInfoItemPo.getPayeeName());
            payInfoItemBo.setPayerId(fscPayOrderInfoItemPo.getPayerId());
            payInfoItemBo.setPayerName(fscPayOrderInfoItemPo.getPayerName());
            payInfoItemBo.setPayerOperId(abilityReqBO.getUserId());
            payInfoItemBo.setPayerOperName(abilityReqBO.getName());
            payInfoItemBo.setPayObjectType(fscPayOrderInfoItemPo.getPayObjectType());
            payInfoItemBo.setPayOrderItemAmount(fscPayOrderInfoItemPo.getPayOrderItemAmount());
            if (this.payeeId.equals(fscPayOrderInfoItemPo.getPayeeId())) {
                payInfoItemBo.setTradeMode(FscConstants.TradeMode.TRADE);
            } else {
                payInfoItemBo.setTradeMode(FscConstants.TradeMode.MATCHING);
            }
            payInfoItemList.add(payInfoItemBo);
        });
        payBo.setPayInfoItemList(payInfoItemList);
        Map<Long, FscMerchantPayeePO> fscMerchantPayeePoMap = fscMerchantPayeePoList.stream().collect(Collectors.toMap(FscMerchantPayeePO::getMerchantId, o -> o));
        Map<Long, Long> fscMerchantMap = fscMerchantMapperList.stream().collect(Collectors.toMap(FscMerchantPO::getOrgId, FscMerchantPO::getMerchantId));
        Map<Long, List<FscPayAttachmentPO>> payAttachmentPoListMap = fscPayAttachmentPoList.stream().collect(Collectors.groupingBy(FscPayAttachmentPO::getPayOrderItemId));
        ArrayList fscQryCashierDownPayItemBoS = new ArrayList();
        String finalPayDownRemark = payDownRemark;
        fscPayOrderInfoItemMapperList.forEach(fscPayOrderInfoItemPoModel -> {
            FscQryCashierDownPayItemBO fscQryCashierDownPayItemBo = new FscQryCashierDownPayItemBO();
            fscQryCashierDownPayItemBo.setPayOrderItemId(fscPayOrderInfoItemPoModel.getPayOrderItemId());
            fscQryCashierDownPayItemBo.setPayObjectNo(fscPayOrderInfoItemPoModel.getPayObjectNo());
            fscQryCashierDownPayItemBo.setPayOrderItemAmount(fscPayOrderInfoItemPoModel.getPayOrderItemAmount());
            fscQryCashierDownPayItemBo.setBtlPayRemark(finalPayDownRemark);
            fscQryCashierDownPayItemBo.setPayBankName(((FscMerchantPayeePO)fscMerchantPayeePoMap.get(fscMerchantMap.get(fscPayOrderInfoItemPoModel.getPayeeId()))).getPayeeBankName());
            fscQryCashierDownPayItemBo.setPayBankAccount(((FscMerchantPayeePO)fscMerchantPayeePoMap.get(fscMerchantMap.get(fscPayOrderInfoItemPoModel.getPayeeId()))).getPayeeBankAccount());
            fscQryCashierDownPayItemBo.setPayeeAccountName(((FscMerchantPayeePO)fscMerchantPayeePoMap.get(fscMerchantMap.get(fscPayOrderInfoItemPoModel.getPayeeId()))).getPayeeAccountName());
            List fscPayAttachmentPoListSelf = (List)payAttachmentPoListMap.get(fscPayOrderInfoItemPoModel.getPayOrderItemId());
            if (!CollectionUtils.isEmpty((Collection)fscPayAttachmentPoListSelf)) {
                ArrayList attachmentBoS = new ArrayList();
                fscPayAttachmentPoList.forEach(fscPayAttachmentPoModel -> {
                    AttachmentBO attachmentBo = new AttachmentBO();
                    BeanUtils.copyProperties((Object)fscPayAttachmentPoModel, (Object)attachmentBo);
                    attachmentBoS.add(attachmentBo);
                });
                fscQryCashierDownPayItemBo.setAttachmentList(attachmentBoS);
            } else {
                fscQryCashierDownPayItemBo.setAttachmentList(new ArrayList());
            }
            fscQryCashierDownPayItemBoS.add(fscQryCashierDownPayItemBo);
        });
        FscQryCashierDownPayItemAbilityRspBO lianDongFscQryCashierDownPayItemAbilityRspBo = new FscQryCashierDownPayItemAbilityRspBO();
        lianDongFscQryCashierDownPayItemAbilityRspBo.setPayBo(payBo);
        lianDongFscQryCashierDownPayItemAbilityRspBo.setPayOrderId(fscPayInfo.getPayOrderId());
        lianDongFscQryCashierDownPayItemAbilityRspBo.setRespCode("0000");
        lianDongFscQryCashierDownPayItemAbilityRspBo.setRespDesc("\u6210\u529f");
        lianDongFscQryCashierDownPayItemAbilityRspBo.setFscQryCashierDownPayItemList(fscQryCashierDownPayItemBoS);
        return lianDongFscQryCashierDownPayItemAbilityRspBo;
    }

    private String getPayDownRemark(List<FscPayOrderInfoItemPO> fscPayOrderInfoItemMapperList, String payDownRemark, FscQryCashierDownPayItemAbilityReqBO abilityReqBO) {
        UocQrySaleOrderMapRspBO uocQrySaleOrderMapRspBo;
        UocQrySaleOrderMapReqBO uocQrySaleOrderMapReqBo = new UocQrySaleOrderMapReqBO();
        uocQrySaleOrderMapReqBo.setOrderId(fscPayOrderInfoItemMapperList.get(0).getOrderId());
        uocQrySaleOrderMapReqBo.setFieldCode("btlPayRemark");
        if (abilityReqBO.getPayOrderType() == null) {
            uocQrySaleOrderMapReqBo.setFieldCode("balanceBtlPayRemark");
        }
        if (!"0000".equals((uocQrySaleOrderMapRspBo = this.uocQrySaleOrderExtFiledService.qySaleOrderMap(uocQrySaleOrderMapReqBo)).getRespCode())) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u8ba2\u5355\u7ebf\u4e0b\u4ed8\u6b3e\u5907\u6ce8\u4fe1\u606f\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty((Collection)uocQrySaleOrderMapRspBo.getUocSaleOrderMapList())) {
            payDownRemark = ((UocSaleOrderMapExt)uocQrySaleOrderMapRspBo.getUocSaleOrderMapList().get(0)).getFieldValue();
        }
        return payDownRemark;
    }

    private List<FscPayAttachmentPO> getfscpayattachmentpos(List<FscPayOrderInfoItemPO> fscPayOrderInfoItemMapperList) {
        List fscPayItemIds = fscPayOrderInfoItemMapperList.stream().map(FscPayOrderInfoItemPO::getPayOrderItemId).collect(Collectors.toList());
        FscPayAttachmentPO fscPayAttachmentPo = new FscPayAttachmentPO();
        fscPayAttachmentPo.setPayOrderItemIds(fscPayItemIds);
        return this.fscPayAttachmentMapper.getList(fscPayAttachmentPo);
    }

    private List<FscPayOrderInfoItemPO> getfscpayorderinfoitempos(FscQryCashierDownPayItemAbilityReqBO abilityReqBO) {
        FscPayOrderInfoItemPO fscPayOrderInfoItemPo = new FscPayOrderInfoItemPO();
        fscPayOrderInfoItemPo.setPayObjectIds(abilityReqBO.getPayObjectIds());
        fscPayOrderInfoItemPo.setPayOrderType(abilityReqBO.getPayOrderType());
        fscPayOrderInfoItemPo.setPayItemState(FscConstants.NewPayState.PAYED);
        fscPayOrderInfoItemPo.setPayOrderTypeList(abilityReqBO.getPayOrderTypeList());
        return this.fscPayOrderInfoItemMapper.getListJoinInfo(fscPayOrderInfoItemPo);
    }

    private List<FscPayOrderInfoItemPO> getfscpayorderinfoitemposByOrderId(FscQryCashierDownPayItemAbilityReqBO abilityReqBO) {
        FscPayOrderInfoItemPO fscPayOrderInfoItemPo = new FscPayOrderInfoItemPO();
        fscPayOrderInfoItemPo.setOrderId(abilityReqBO.getOrderId());
        fscPayOrderInfoItemPo.setPayItemState(FscConstants.NewPayState.PAYED);
        fscPayOrderInfoItemPo.setPayOrderTypeList(abilityReqBO.getPayOrderTypeList());
        fscPayOrderInfoItemPo.setPayOrderType(abilityReqBO.getPayOrderType());
        return this.fscPayOrderInfoItemMapper.getListJoinInfo(fscPayOrderInfoItemPo);
    }

    private List<FscPayOrderInfoItemPO> getfscpayorderinfoitemposByOrderIdFail(FscQryCashierDownPayItemAbilityReqBO abilityReqBO) {
        ArrayList<FscPayOrderInfoItemPO> fscPayOrderInfoItemPoList = new ArrayList<FscPayOrderInfoItemPO>();
        FscPayOrderInfoItemPO fscPayOrderInfoItemPo = new FscPayOrderInfoItemPO();
        fscPayOrderInfoItemPo.setOrderId(abilityReqBO.getOrderId());
        fscPayOrderInfoItemPo.setPayItemState(FscConstants.NewPayState.PAY_FAIL);
        fscPayOrderInfoItemPo.setOrderBy("fpoii.pay_item_update_time DESC");
        fscPayOrderInfoItemPo.setPayOrderTypeList(abilityReqBO.getPayOrderTypeList());
        fscPayOrderInfoItemPo.setPayOrderType(abilityReqBO.getPayOrderType());
        FscPayOrderInfoItemPO fscPayOrderInfoItemPoFail = (FscPayOrderInfoItemPO)this.fscPayOrderInfoItemMapper.getListByFail(fscPayOrderInfoItemPo).get(0);
        if (fscPayOrderInfoItemPoFail != null) {
            FscPayOrderInfoItemPO fscPayOrderInfoItemPoFailQry = new FscPayOrderInfoItemPO();
            fscPayOrderInfoItemPoFailQry.setPayOrderId(fscPayOrderInfoItemPoFail.getPayOrderId());
            fscPayOrderInfoItemPoFailQry.setPayItemState(FscConstants.NewPayState.PAY_FAIL);
            fscPayOrderInfoItemPo.setOrderId(abilityReqBO.getOrderId());
            List listByFail = this.fscPayOrderInfoItemMapper.getList(fscPayOrderInfoItemPoFailQry);
            if (CollectionUtils.isEmpty((Collection)listByFail)) {
                return fscPayOrderInfoItemPoList;
            }
            fscPayOrderInfoItemPoList.addAll(listByFail);
            return fscPayOrderInfoItemPoList;
        }
        return fscPayOrderInfoItemPoList;
    }

    private FscPayInfoPO getFscPayInfo(Long payOrderId) {
        FscPayInfoPO fscPayInfoPo = new FscPayInfoPO();
        fscPayInfoPo.setPayOrderId(payOrderId);
        FscPayInfoPO modelBy = this.fscPayInfoMapper.getModelBy(fscPayInfoPo);
        if (modelBy == null) {
            throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return modelBy;
    }
}

