/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscShouldPayNoEnum;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscMerchantPayeeMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscPayBillCreateAtomService;
import com.tydic.fsc.pay.atom.bo.FscPayBillCreateAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscPayBillCreateAtomRspBO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscMerchantPayeePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.plugin.encoded.service.CfcRedisSerialService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPayBillCreateAtomServiceImpl
implements FscPayBillCreateAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillCreateAtomServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private CfcRedisSerialService encodedSerialGetService;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscMerchantPayeeMapper fscMerchantPayeeMapper;
    @Value(value="${MERCHANT_ORG_ID:759903388549152768}")
    private Long merchantOrgId;

    @Override
    public FscPayBillCreateAtomRspBO dealPayBillCreate(FscPayBillCreateAtomReqBO atomReqBO) {
        FscPayBillCreateAtomRspBO atomRspBO = new FscPayBillCreateAtomRspBO();
        Long fscOrderId = Sequence.getInstance().nextId();
        List<FscOrderPayItemPO> fscOrderPayItemPOs = null;
        if (!CollectionUtils.isEmpty(atomReqBO.getFscOrderPayItemBOS())) {
            fscOrderPayItemPOs = this.updateShouldPay(atomReqBO, fscOrderId, atomRspBO);
            FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
            fscOrderPayItemPO.setShouldPayId(atomReqBO.getFscOrderPayItemBOS().get(0).getShouldPayId());
            FscOrderPayItemPO fscOrderPayItemMapperModelBy = this.fscOrderPayItemMapper.getModelBy(fscOrderPayItemPO);
            if (fscOrderPayItemMapperModelBy != null) {
                FscOrderPO fscOrderPoSet = new FscOrderPO();
                fscOrderPoSet.setPayType(atomReqBO.getPayType());
                fscOrderPoSet.setPayChannel(atomReqBO.getPayChannel());
                FscOrderPO fscOrderPoWhere = new FscOrderPO();
                fscOrderPoWhere.setFscOrderId(fscOrderPayItemMapperModelBy.getFscOrderId());
                this.fscOrderMapper.updateBy(fscOrderPoSet, fscOrderPoWhere);
                FscOrderPO fscOrderPO = new FscOrderPO();
                fscOrderPO.setFscOrderId(fscOrderPayItemMapperModelBy.getFscOrderId());
                FscOrderPO fscOrderMapperModelBy = this.fscOrderMapper.getModelBy(fscOrderPO);
                if (fscOrderMapperModelBy == null) {
                    throw new FscBusinessException("190000", "\u67e5\u8be2\u4ed8\u6b3e\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
                }
                atomRspBO.setFscOrderId(fscOrderPayItemMapperModelBy.getFscOrderId());
                atomRspBO.setTotalAmount(atomReqBO.getTotalAmount());
                atomRspBO.setRespCode("0000");
                atomRspBO.setRespDesc("\u4ed8\u6b3e\u7533\u8bf7\u5355\u521b\u5efa\u6210\u529f");
                return atomRspBO;
            }
            if (atomReqBO.getPayFscOrderId() != null) {
                atomRspBO.setFscOrderId(atomReqBO.getPayFscOrderId());
                return atomRspBO;
            }
        } else {
            fscOrderPayItemPOs = this.insertShouldPay(atomReqBO, fscOrderId);
        }
        this.fscOrderPayItemMapper.insertBatch(fscOrderPayItemPOs);
        this.insertOrder(atomReqBO, fscOrderId, atomRspBO);
        this.invokeUacNoTask(atomReqBO, fscOrderId);
        atomRspBO.setFscOrderId(fscOrderId);
        atomRspBO.setTotalAmount(atomReqBO.getTotalAmount());
        atomRspBO.setRespCode("0000");
        atomRspBO.setRespDesc("\u4ed8\u6b3e\u7533\u8bf7\u5355\u521b\u5efa\u6210\u529f");
        return atomRspBO;
    }

    private void invokeUacNoTask(FscPayBillCreateAtomReqBO busiReqBO, Long fscOrderId) {
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscOrderStatusStartAtomReqBO.class);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
        if (busiReqBO.getQueryAuditFlag().booleanValue()) {
            UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
            uacNoTaskAuditCreateReqBO.setCreateOperId(busiReqBO.getUserId().toString());
            uacNoTaskAuditCreateReqBO.setCreateOperName(busiReqBO.getName());
            uacNoTaskAuditCreateReqBO.setCreateOperDept(busiReqBO.getOrgName());
            uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
            uacNoTaskAuditCreateReqBO.setMenuId("fscPayApplyOrder");
            uacNoTaskAuditCreateReqBO.setOrgId(busiReqBO.getOrgId().toString());
            ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
            UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
            uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.PAY_APPLY_ORDER);
            uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
            uacNoTaskAuditCreateInfoReqBO.setOrderId(fscOrderId);
            createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
            ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
            ApprovalObjBO approvalObjBO = new ApprovalObjBO();
            approvalObjBO.setObjId(fscOrderId.toString());
            approvalObjBO.setObjName("\u4ed8\u6b3e\u7533\u8bf7\u5355");
            approvalObjBO.setObjType(FscConstants.AuditObjType.PAY_APPLY_ORDER);
            approvalObjInfo.add(approvalObjBO);
            uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
            uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
            UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
            log.info("\u5ba1\u6838\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
            if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
                throw new FscBusinessException("194203", uacNoTaskAuditCreateRspBO.getRespDesc());
            }
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
            if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
                paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
            }
            if (uacNoTaskAuditCreateRspBO.getFinish().booleanValue()) {
                paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
            }
        }
        fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        fscOrderStatusStartAtomReqBO.setOrderId(fscOrderId);
        fscOrderStatusStartAtomReqBO.setOrderFlow(FscConstants.OrderFlow.PAY);
        fscOrderStatusStartAtomReqBO.setOperId(busiReqBO.getUserName());
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
        if (!"0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) {
            throw new FscBusinessException("194203", fscOrderStatusStartAtomRspBO.getRespDesc());
        }
    }

    private void insertOrder(FscPayBillCreateAtomReqBO busiReqBO, Long fscOrderId, FscPayBillCreateAtomRspBO atomRspBO) {
        FscShouldPayPO modelBy;
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.PAY);
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        FscShouldPayPO fscShouldPayPoModel = new FscShouldPayPO();
        fscShouldPayPoModel.setShouldPayId(busiReqBO.getFscOrderPayItemBOS().get(0).getShouldPayId());
        if (busiReqBO.getBusiCategory().equals(FscConstants.FscOrderBusiCategory.REFUND)) {
            encodedSerialGetServiceReqBO.setEncodedRuleCode("PAYMENT_RETRUN_NO");
        }
        if (busiReqBO.getBusiCategory().equals(FscConstants.FscOrderBusiCategory.PAY)) {
            encodedSerialGetServiceReqBO.setEncodedRuleCode("PAYMENT_PAY_NO");
        }
        if ((modelBy = this.fscShouldPayMapper.getModelBy(fscShouldPayPoModel)) == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5e94\u4ed8\u4fe1\u606f\u5931\u8d25");
        }
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getSerial(encodedSerialGetServiceReqBO);
        encodedSerialGetServiceReqBO.setEncodedRuleCode("PAYMENT_REQUEST_NO");
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServicePayRspBO = this.encodedSerialGetService.getSerial(encodedSerialGetServiceReqBO);
        log.debug("\u4ed8\u6b3e\u7533\u8bf7\u5355\u7f16\u53f7\u521b\u5efa\u4e86---------------------------------------------------------------------" + (String)encodedSerialGetServicePayRspBO.getSerialNoList().get(0));
        fscOrderPO.setOrderNo((String)encodedSerialGetServiceRspBO.getSerialNoList().get(0));
        fscOrderPO.setPayerId(modelBy.getPayerId());
        fscOrderPO.setPayerName(modelBy.getPayerName());
        fscOrderPO.setPayeeId(modelBy.getPayeeId());
        fscOrderPO.setPayState(FscConstants.PayOrderPayStatus.TO_PAY);
        FscMerchantPO merchantPo = new FscMerchantPO();
        merchantPo.setMerchantId(this.merchantOrgId);
        merchantPo.setExceptionFlag(Integer.valueOf(0));
        merchantPo = this.fscMerchantMapper.getModelBy(merchantPo);
        if (null == merchantPo) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u6536\u6b3e\u65b9\u4fe1\u606f\u4e3a\u7a7a");
        }
        FscMerchantPayeePO fscMerchantPayeePO = new FscMerchantPayeePO();
        fscMerchantPayeePO.setMerchantId(merchantPo.getMerchantId());
        FscMerchantPayeePO modelByPayee = this.fscMerchantPayeeMapper.getModelBy(fscMerchantPayeePO);
        if (modelByPayee == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5546\u6237\u8d26\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        fscOrderPO.setPayeeName(modelBy.getPayeeName());
        fscOrderPO.setPayeeBankAccount(modelByPayee.getPayeeBankAccount());
        fscOrderPO.setPayeeBankName(modelByPayee.getPayeeBankName());
        fscOrderPO.setPayMethod(busiReqBO.getPayMethod());
        fscOrderPO.setPayType(busiReqBO.getPayType());
        fscOrderPO.setShouldPayType(busiReqBO.getShouldPayType());
        fscOrderPO.setPayChannel(busiReqBO.getPayChannel());
        fscOrderPO.setCreateOperId(busiReqBO.getUserId());
        fscOrderPO.setCreateOperName(busiReqBO.getName());
        fscOrderPO.setCreateTime(new Date());
        fscOrderPO.setCreateCompanyId(busiReqBO.getCompanyId());
        fscOrderPO.setCreateCompanyName(busiReqBO.getCompanyName());
        fscOrderPO.setCreateOrgId(busiReqBO.getOrgId());
        fscOrderPO.setCreateOrgName(busiReqBO.getOrgName());
        fscOrderPO.setTotalCharge(busiReqBO.getTotalAmount());
        fscOrderPO.setContractNo(busiReqBO.getContractNo());
        fscOrderPO.setContractId(busiReqBO.getContractId());
        fscOrderPO.setBusiCategory(busiReqBO.getBusiCategory());
        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.toString().equals(busiReqBO.getPayType().toString())) {
            if (null != busiReqBO.getUserId()) {
                fscOrderPO.setPayOperId(busiReqBO.getUserId().toString());
            }
            fscOrderPO.setPayOperName(busiReqBO.getName());
        }
        this.fscOrderMapper.insert(fscOrderPO);
        atomRspBO.setPayNo((String)encodedSerialGetServicePayRspBO.getSerialNoList().get(0));
    }

    private List<FscOrderPayItemPO> updateShouldPay(FscPayBillCreateAtomReqBO busiReqBO, Long fscOrderId, FscPayBillCreateAtomRspBO atomRspBO) {
        FscShouldPayPO fscShouldPayPO1 = new FscShouldPayPO();
        ArrayList shouldPayIds = new ArrayList();
        busiReqBO.getFscOrderPayItemBOS().forEach(fscOrderPayItemBO -> shouldPayIds.add(fscOrderPayItemBO.getShouldPayId()));
        fscShouldPayPO1.setShouldPayIds(shouldPayIds);
        List poResult = this.fscShouldPayMapper.getList(fscShouldPayPO1);
        if (CollectionUtils.isEmpty((Collection)poResult)) {
            throw new FscBusinessException("194203", "\u5e94\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        FscShouldPayPO fscShouldPayPoSet = new FscShouldPayPO();
        fscShouldPayPoSet.setPayType(busiReqBO.getPayType());
        fscShouldPayPoSet.setPayChannel(Integer.valueOf(busiReqBO.getPayChannel()));
        FscShouldPayPO fscShouldPayPoWhere = new FscShouldPayPO();
        fscShouldPayPoWhere.setShouldPayIds(shouldPayIds);
        this.fscShouldPayMapper.updateBy(fscShouldPayPoSet, fscShouldPayPoWhere);
        HashSet shouldPayType = new HashSet();
        HashSet payerIds = new HashSet();
        HashSet payeeIds = new HashSet();
        HashSet contractNos = new HashSet();
        HashSet payType = new HashSet();
        poResult.forEach(fscShouldPayPO -> {
            if (null != fscShouldPayPO.getShouldPayType()) {
                shouldPayType.add(fscShouldPayPO.getShouldPayType());
                busiReqBO.setShouldPayType(fscShouldPayPO.getShouldPayType());
            }
            if (null != fscShouldPayPO.getPayerId()) {
                payerIds.add(fscShouldPayPO.getPayerId());
                busiReqBO.setPayerId(fscShouldPayPO.getPayerId());
                busiReqBO.setPayerName(fscShouldPayPO.getPayerName());
            }
            if (null != fscShouldPayPO.getPayeeId()) {
                payeeIds.add(fscShouldPayPO.getPayeeId());
                busiReqBO.setPayeeId(fscShouldPayPO.getPayeeId());
                busiReqBO.setPayeeName(fscShouldPayPO.getPayeeName());
            }
            if (null != fscShouldPayPO.getPayType()) {
                payType.add(fscShouldPayPO.getPayType());
            }
            if (StringUtils.hasText((String)fscShouldPayPO.getContractNo())) {
                contractNos.add(fscShouldPayPO.getContractNo());
                busiReqBO.setContractNo(fscShouldPayPO.getContractNo());
            }
            if (fscShouldPayPO.getContractId() != null) {
                busiReqBO.setContractId(fscShouldPayPO.getContractId());
            }
        });
        if (shouldPayType.size() > 1) {
            throw new FscBusinessException("194203", "\u5e94\u4ed8\u7c7b\u578b\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payerIds.size() > 1) {
            throw new FscBusinessException("194203", "\u4ed8\u6b3e\u65b9\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payeeIds.size() > 1) {
            throw new FscBusinessException("194203", "\u6536\u6b3e\u65b9\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payType.size() > 1) {
            throw new FscBusinessException("194203", "\u4ed8\u6b3e\u65b9\u5f0f\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (!FscConstants.ShouldPayType.PAYMENT_DAY_PAY.equals(busiReqBO.getShouldPayType())) {
            FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
            fscOrderPayItemPO.setShouldPayIds(shouldPayIds);
            List itemPOS = this.fscOrderPayItemMapper.getList(fscOrderPayItemPO);
            if (!CollectionUtils.isEmpty((Collection)itemPOS) && itemPOS.size() == shouldPayIds.size()) {
                HashSet payFscOrderIds = new HashSet();
                itemPOS.forEach(fscOrderPayItemPO1 -> payFscOrderIds.add(fscOrderPayItemPO1.getFscOrderId()));
                if (payFscOrderIds.size() == 1) {
                    FscOrderPO fscOrderPO = new FscOrderPO();
                    fscOrderPO.setFscOrderId((Long)payFscOrderIds.iterator().next());
                    fscOrderPO.setOrderState(FscConstants.FscPayOrderState.TO_PAY);
                    FscOrderPO fscOrderPO2 = this.fscOrderMapper.getModelBy(fscOrderPO);
                } else {
                    throw new FscBusinessException("194203", "\u5f53\u524d\u5e94\u4ed8\u4fe1\u606f\u5b58\u5728\u591a\u4e2a\u4ed8\u6b3e\u7533\u8bf7\u5355\uff0c\u8bf7\u5230\u4ed8\u6b3e\u7533\u8bf7\u9875\u9762\u8fdb\u884c\u652f\u4ed8\uff01");
                }
            }
        }
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        BigDecimal totalAmount = new BigDecimal(0);
        for (FscOrderPayItemBO fscOrderPayItemBO2 : busiReqBO.getFscOrderPayItemBOS()) {
            FscShouldPayPO fscShouldPayPoModel = new FscShouldPayPO();
            fscShouldPayPoModel.setShouldPayId(fscOrderPayItemBO2.getShouldPayId());
            FscShouldPayPO modelBy = this.fscShouldPayMapper.getModelBy(fscShouldPayPoModel);
            if (modelBy == null) {
                throw new FscBusinessException("190000", "\u67e5\u8be2\u5e94\u4ed8\u4fe1\u606f\u5931\u8d25");
            }
            FscShouldPayPO fscShouldPayPO2 = new FscShouldPayPO();
            fscShouldPayPO2.setShouldPayId(fscOrderPayItemBO2.getShouldPayId());
            fscShouldPayPO2.setPayAmount(modelBy.getShouldPayAmount().setScale(8, RoundingMode.HALF_UP));
            int count = this.fscShouldPayMapper.updateAmount(fscShouldPayPO2);
            if (count != 1) {
                throw new FscBusinessException("194203", "\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u5f85\u4ed8\u91d1\u989d\uff01");
            }
            FscOrderPayItemPO po = new FscOrderPayItemPO();
            po.setFscOrderId(fscOrderId);
            po.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setShouldPayId(fscOrderPayItemBO2.getShouldPayId());
            po.setPayAmount(modelBy.getShouldPayAmount().setScale(4, RoundingMode.HALF_UP));
            fscOrderPayItemPOs.add(po);
            totalAmount = totalAmount.add(modelBy.getShouldPayAmount().setScale(4, RoundingMode.HALF_UP));
        }
        busiReqBO.setTotalAmount(totalAmount);
        atomRspBO.setPayeeId((Long)payeeIds.iterator().next());
        atomRspBO.setPayerId((Long)payerIds.iterator().next());
        return fscOrderPayItemPOs;
    }

    private List<FscOrderPayItemPO> insertShouldPay(FscPayBillCreateAtomReqBO busiReqBO, Long fscOrderId) {
        List fscShouldPayPOS = JSON.parseArray((String)JSON.toJSONString(busiReqBO.getFscShouldPayBOS()), FscShouldPayPO.class);
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        BigDecimal totalAmount = new BigDecimal(0);
        List serialNoList = null;
        if (FscShouldPayNoEnum.getInstance((Integer)((FscShouldPayPO)fscShouldPayPOS.get(0)).getShouldPayType()) == null) {
            throw new FscBusinessException("194203", "\u5e94\u4ed8\u7c7b\u578b\u6ca1\u5b9a\u4e49\u679a\u4e3e");
        }
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(fscShouldPayPOS.size()));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscShouldPayNoEnum.getInstance((Integer)((FscShouldPayPO)fscShouldPayPOS.get(0)).getShouldPayType()).getDescr());
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getSerial(encodedSerialGetServiceReqBO);
        serialNoList = encodedSerialGetServiceRspBO.getSerialNoList();
        for (int i = 0; i < fscShouldPayPOS.size(); ++i) {
            FscShouldPayPO fscShouldPayPO = (FscShouldPayPO)fscShouldPayPOS.get(i);
            Long shouldPayId = Sequence.getInstance().nextId();
            fscShouldPayPO.setShouldPayId(shouldPayId);
            fscShouldPayPO.setCreateId(busiReqBO.getUserId());
            fscShouldPayPO.setCreateName(busiReqBO.getName());
            fscShouldPayPO.setCreateAccount(busiReqBO.getUserName());
            fscShouldPayPO.setCreateTime(new Date());
            fscShouldPayPO.setCreateCompanyId(busiReqBO.getCompanyId());
            fscShouldPayPO.setCreateCompanyName(busiReqBO.getCompanyName());
            fscShouldPayPO.setCreateOrgId(busiReqBO.getOrgId());
            fscShouldPayPO.setCreateOrgName(busiReqBO.getOrgName());
            fscShouldPayPO.setPayingAmount(fscShouldPayPO.getShouldPayAmount());
            fscShouldPayPO.setPaidAmount(new BigDecimal(0));
            fscShouldPayPO.setToPayAmount(new BigDecimal(0));
            fscShouldPayPO.setShouldPayNo((String)serialNoList.get(i));
            fscShouldPayPO.setPenalty(new BigDecimal(0));
            fscShouldPayPO.setOriginalAmount(fscShouldPayPO.getShouldPayAmount());
            fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_PAY);
            FscOrderPayItemPO po = new FscOrderPayItemPO();
            po.setFscOrderId(fscOrderId);
            po.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setShouldPayId(shouldPayId);
            po.setPayAmount(fscShouldPayPO.getShouldPayAmount());
            fscOrderPayItemPOs.add(po);
            totalAmount = totalAmount.add(fscShouldPayPO.getShouldPayAmount());
        }
        busiReqBO.setTotalAmount(totalAmount);
        this.fscShouldPayMapper.insertBatch(fscShouldPayPOS);
        return fscOrderPayItemPOs;
    }
}

