/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.DycSupplierSignContractSalesBO;
import com.tydic.fsc.bo.DycUocSaleOrderCommodityInfoBO;
import com.tydic.fsc.busibase.external.api.bo.FscDycUmcQuerySupplierListReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscDycUmcQuerySupplierListRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUmcSignContractBO;
import com.tydic.fsc.busibase.external.api.umc.FscDycUmcQuerySupplierListAbilityService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscLedgerInfoItemMapper;
import com.tydic.fsc.dao.FscLedgerInfoMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscPayInfoMapper;
import com.tydic.fsc.dao.FscPayOrderInfoItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.PayInfoItemBO;
import com.tydic.fsc.pay.busi.api.FscDealConsolidatedPayPayCreateBusiService;
import com.tydic.fsc.pay.busi.bo.FscDealConsolidatedPayPayCreateBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscDealConsolidatedPayPayCreateBusiRspBO;
import com.tydic.fsc.po.FscLedgerInfoItemPO;
import com.tydic.fsc.po.FscLedgerInfoPO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscPayInfoPO;
import com.tydic.fsc.po.FscPayOrderInfoItemPO;
import com.tydic.payment.pay.ability.PayProOrderAbilityService;
import com.tydic.payment.pay.ability.bo.PayProOrderAbilityServiceReqBo;
import com.tydic.payment.pay.ability.bo.PayProOrderAbilityServiceRspBo;
import com.tydic.payment.pay.ability.bo.SubOrderBO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.plugin.encoded.service.CfcRedisSerialService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscDealConsolidatedPayPayCreateBusiServiceImpl
implements FscDealConsolidatedPayPayCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscDealConsolidatedPayPayCreateBusiServiceImpl.class);
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscPayInfoMapper fscPayInfoMapper;
    @Autowired
    private FscPayOrderInfoItemMapper fscPayOrderInfoItemMapper;
    @Autowired
    private CfcRedisSerialService encodedSerialGetService;
    @Autowired
    private FscDycUmcQuerySupplierListAbilityService fscDycUmcQuerySupplierListAbilityService;
    @Autowired
    private FscLedgerInfoItemMapper fscLedgerInfoItemMapper;
    @Autowired
    private FscLedgerInfoMapper fscLedgerInfoMapper;
    @Autowired
    private PayProOrderAbilityService payProOrderAbilityService;
    @Value(value="${isTruePay:false}")
    private Boolean isTruePay;
    @Value(value="${APP_PAY_APP_ID:123456}")
    private String appPayAppId;
    @Value(value="${MERCHANT_ORG_ID:759903388549152768}")
    private Long merchantOrgId;
    @Value(value="${pay.center.busi.code:D500}")
    private String payBusiCode;
    @Value(value="${pay.center.req.way:1}")
    private String reqWay;
    @Value(value="${isRedirect:true}")
    private Boolean isRedirect;
    @Value(value="${PAY_MERCHANT_ORG_ID:1568200495651680256}")
    private Long payMerchantOrgId;
    @Value(value="${USER_MERCHANT_ORG_ID:305775845729763337}")
    private Long userMerchantOrgId;
    @Value(value="${payeeId:305775845729763327}")
    private Long payeeId;
    @Value(value="${fscSelfPayNotifyUrl:http://10.0.11.61:10130/dyc/fsc/noauth/dealDycPayBillCallback}")
    private String fscNotifyUrl;
    @Value(value="${fscPayNotifyUrl:http://10.0.11.61:10210/dyc/saas/self/order/noauth/dealPayCallback}")
    private String notifyUrl;
    @Value(value="${QRY_SALE_ORDER_URL:http://test1-lsugu.liando.cn:9191/dyc/saas/self/noauth/order/qrySalOrderDetail}")
    private String qrySaleOrderUrl;

    @Override
    public FscDealConsolidatedPayPayCreateBusiRspBO dealConsolidatedPay(FscDealConsolidatedPayPayCreateBusiReqBO busiReqBO) {
        Date date = new Date();
        Long payOrderId = Sequence.getInstance().nextId();
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServicePayRspBO = this.getCfcEncodedSerialGetServiceRspBO(busiReqBO);
        this.addPayInfo(busiReqBO, date, encodedSerialGetServicePayRspBO, payOrderId);
        this.addAllPayItem(busiReqBO, date, payOrderId);
        HashMap<Long, BigDecimal> merchantOrderAmountMap = new HashMap<Long, BigDecimal>(busiReqBO.getPayInfoItemList().size());
        HashMap<Long, String> fscMerchantAndPayMerchantMap = new HashMap<Long, String>(busiReqBO.getPayInfoItemList().size());
        if (FscConstants.PayObjectType.ORDER.equals(busiReqBO.getPayInfoItemList().get(0).getPayObjectType())) {
            Map<Long, BigDecimal> merchantAndPayAmoutMap = this.addAllPayItemLedger(date, payOrderId, merchantOrderAmountMap, fscMerchantAndPayMerchantMap);
            this.insertBatchLedgerList(date, payOrderId, merchantAndPayAmoutMap);
        }
        log.debug("\u4ed8\u6b3e\u4f9b\u5e94\u5546\u7684\u7ed3\u7b97\u5546\u6237\u548c\u652f\u4ed8\u4e2d\u5fc3\u5546\u6237\u5bf9\u5e94\u5173\u7cfbmap\u6700\u7ec8\u503c{}", fscMerchantAndPayMerchantMap);
        String url = this.invokePayProOrder(busiReqBO, payOrderId, merchantOrderAmountMap, fscMerchantAndPayMerchantMap);
        FscDealConsolidatedPayPayCreateBusiRspBO fscDealConsolidatedPayPayCreateBusiRspBO = new FscDealConsolidatedPayPayCreateBusiRspBO();
        fscDealConsolidatedPayPayCreateBusiRspBO.setUrl(url);
        fscDealConsolidatedPayPayCreateBusiRspBO.setPayOrderId(payOrderId);
        fscDealConsolidatedPayPayCreateBusiRspBO.setRespCode("0000");
        fscDealConsolidatedPayPayCreateBusiRspBO.setRespDesc("\u6210\u529f");
        return fscDealConsolidatedPayPayCreateBusiRspBO;
    }

    private void insertBatchLedgerList(Date date, Long payOrderId, Map<Long, BigDecimal> merchantAndPayAmoutMap) {
        log.debug("\u5f00\u59cb\u8bb0\u5f55\u5546\u6237\u5206\u8d26\u4ed8\u6b3e\u4fe1\u606f");
        ArrayList fscLedgerInfoList = new ArrayList();
        merchantAndPayAmoutMap.forEach((key, value) -> {
            FscLedgerInfoPO fscLedgerInfoPo = new FscLedgerInfoPO();
            fscLedgerInfoPo.setPayOrderId(payOrderId);
            fscLedgerInfoPo.setCreateTime(date);
            fscLedgerInfoPo.setPayLedgerId(Long.valueOf(Sequence.getInstance().nextId()));
            fscLedgerInfoPo.setServiceOrPay(FscConstants.ServiceOrPay.PAY);
            fscLedgerInfoPo.setPayOrRefund(FscConstants.PayOrRefund.PAY);
            fscLedgerInfoPo.setLedgerTotalAmount(value);
            fscLedgerInfoPo.setMerchantId(key);
            fscLedgerInfoList.add(fscLedgerInfoPo);
        });
        log.debug("\u65b0\u589e\u5206\u8d26\u4ed8\u6b3e\u4fe1\u606f\u5165\u53c2{}", fscLedgerInfoList);
        this.fscLedgerInfoMapper.insertBatch(fscLedgerInfoList);
    }

    private void addAllPayItem(FscDealConsolidatedPayPayCreateBusiReqBO busiReqBO, Date date, Long payOrderId) {
        log.debug("\u5f00\u59cb\u751f\u6210\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f");
        ArrayList fscPayOrderInfoItemPoS = new ArrayList();
        busiReqBO.getPayInfoItemList().forEach(payInfoItemBo -> {
            Long payOrderItemId = Sequence.getInstance().nextId();
            FscPayOrderInfoItemPO fscPayOrderInfoItemPo = new FscPayOrderInfoItemPO();
            BeanUtils.copyProperties((Object)payInfoItemBo, (Object)fscPayOrderInfoItemPo);
            fscPayOrderInfoItemPo.setPayOrderItemId(payOrderItemId);
            fscPayOrderInfoItemPo.setPayOrderId(payOrderId);
            fscPayOrderInfoItemPo.setPayItemCreateTime(date);
            fscPayOrderInfoItemPo.setPayItemState(FscConstants.NewPayState.NOT_PAY);
            fscPayOrderInfoItemPoS.add(fscPayOrderInfoItemPo);
        });
        log.debug("\u751f\u6210\u4ed8\u6b3e\u660e\u7ec6\u5165\u53c2{}", fscPayOrderInfoItemPoS);
        this.fscPayOrderInfoItemMapper.insertBatch(fscPayOrderInfoItemPoS);
    }

    private void addPayInfo(FscDealConsolidatedPayPayCreateBusiReqBO busiReqBO, Date date, CfcEncodedSerialGetServiceRspBO encodedSerialGetServicePayRspBO, Long payOrderId) {
        log.debug("\u5f00\u59cb\u751f\u6210\u4ed8\u6b3e\u4e3b\u5355\u4fe1\u606f");
        FscPayInfoPO fscPayInfoPo = new FscPayInfoPO();
        BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)fscPayInfoPo);
        fscPayInfoPo.setPayOrderId(payOrderId);
        fscPayInfoPo.setPayOrderNo((String)encodedSerialGetServicePayRspBO.getSerialNoList().get(0));
        fscPayInfoPo.setPayState(FscConstants.NewPayState.NOT_PAY);
        fscPayInfoPo.setPayCreateTime(date);
        fscPayInfoPo.setIsLedger(FscConstants.IsLedger.YES);
        log.debug("\u751f\u6210\u4ed8\u6b3e\u4e3b\u5355\u4fe1\u606f\u5165\u53c2{}", (Object)fscPayInfoPo);
        int insert = this.fscPayInfoMapper.insert(fscPayInfoPo);
        if (insert < 1) {
            log.debug("\u751f\u6210\u4ed8\u6b3e\u4e3b\u5355\u4fe1\u606f\u5931\u8d25{}", (Object)fscPayInfoPo);
            throw new FscBusinessException("190000", "\u521b\u5efa\u4ed8\u6b3e\u5931\u8d25");
        }
    }

    private CfcEncodedSerialGetServiceRspBO getCfcEncodedSerialGetServiceRspBO(FscDealConsolidatedPayPayCreateBusiReqBO busiReqBO) {
        log.debug("\u5f00\u59cb\u751f\u6210\u4ed8\u6b3e\u7533\u8bf7\u5355\u7f16\u53f7{}", (Object)busiReqBO);
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("PAYMENT_REQUEST_NO");
        log.debug("\u67e5\u8be2\u4ed8\u6b3e\u7533\u8bf7\u5355\u7f16\u53f7\u5165\u53c2{}", (Object)encodedSerialGetServiceReqBO);
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServicePayRspBO = this.encodedSerialGetService.getSerial(encodedSerialGetServiceReqBO);
        log.debug("\u67e5\u8be2\u4ed8\u6b3e\u7533\u8bf7\u5355\u7f16\u53f7\u51fa\u53c2{}", (Object)encodedSerialGetServicePayRspBO);
        if (CollectionUtils.isEmpty((Collection)encodedSerialGetServicePayRspBO.getSerialNoList())) {
            log.debug("\u67e5\u8be2\u4ed8\u6b3e\u7533\u8bf7\u5355\u7f16\u53f7\u5931\u8d25");
            throw new FscBusinessException("190000", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u7f16\u53f7\u751f\u6210\u5931\u8d25");
        }
        return encodedSerialGetServicePayRspBO;
    }

    private String invokePayProOrder(FscDealConsolidatedPayPayCreateBusiReqBO busiReqBO, Long payOrderId, HashMap<Long, BigDecimal> merchantOrderAmountMap, Map<Long, String> fscMerchantAndPayMerchantMap) {
        log.debug("\u5f00\u59cb\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u63a5\u53e3\u4ed8\u6b3e");
        FscMerchantPO rspPo = this.getFscMerchant();
        log.debug("\u5f00\u59cb\u7ec4\u88c5\u652f\u4ed8\u53c2\u6570");
        PayProOrderAbilityServiceReqBo payProOrderAbilityServiceReqBo = new PayProOrderAbilityServiceReqBo();
        payProOrderAbilityServiceReqBo.setBusiCode(this.payBusiCode);
        payProOrderAbilityServiceReqBo.setReqWay(this.reqWay);
        payProOrderAbilityServiceReqBo.setOutOrderId(payOrderId.toString());
        payProOrderAbilityServiceReqBo.setCreateIpAddress(busiReqBO.getRedirectUrl());
        payProOrderAbilityServiceReqBo.setMerchantId(rspPo.getPayMerchantId());
        payProOrderAbilityServiceReqBo.setCreateOperId(busiReqBO.getUserId().toString());
        payProOrderAbilityServiceReqBo.setCreateOperIdName(busiReqBO.getName());
        payProOrderAbilityServiceReqBo.setDetailName(busiReqBO.getDetailName());
        if (this.isRedirect.booleanValue()) {
            payProOrderAbilityServiceReqBo.setRedirectUrl(busiReqBO.getRedirectUrl() + "/redirect");
        } else {
            payProOrderAbilityServiceReqBo.setRedirectUrl(busiReqBO.getRedirectUrl());
        }
        if (this.isTruePay.booleanValue()) {
            payProOrderAbilityServiceReqBo.setTotalFee(MoneyUtils.yuanToFenToLong((BigDecimal)busiReqBO.getPayAmount()) + "");
        } else {
            payProOrderAbilityServiceReqBo.setTotalFee(MoneyUtils.yuanToFenToLong((BigDecimal)new BigDecimal("0.01")) + "");
        }
        if (busiReqBO.getIsAppPay() != null && busiReqBO.getIsAppPay().equals(FscConstants.IsAppPay.YES) && busiReqBO.getPayMethod() != null) {
            payProOrderAbilityServiceReqBo.setPayMethod(String.valueOf(busiReqBO.getPayMethod()));
        }
        if (FscConstants.PayObjectType.ORDER.equals(busiReqBO.getPayInfoItemList().get(0).getPayObjectType())) {
            payProOrderAbilityServiceReqBo.setNotifyUrl(this.notifyUrl);
        } else if (FscConstants.PayObjectType.FSC.equals(busiReqBO.getPayInfoItemList().get(0).getPayObjectType()) || FscConstants.PayObjectType.SERVICE.equals(busiReqBO.getPayInfoItemList().get(0).getPayObjectType()) || FscConstants.PayObjectType.PLATFORM.equals(busiReqBO.getPayInfoItemList().get(0).getPayObjectType())) {
            payProOrderAbilityServiceReqBo.setNotifyUrl(this.fscNotifyUrl);
        }
        if (FscConstants.PayObjectType.ORDER.equals(busiReqBO.getPayInfoItemList().get(0).getPayObjectType())) {
            this.setPayLedgerInfo(payOrderId, merchantOrderAmountMap, fscMerchantAndPayMerchantMap, payProOrderAbilityServiceReqBo, busiReqBO);
        }
        log.debug("\u5206\u8d26\u660e\u7ec6\u6570\u636e{}", (Object)payProOrderAbilityServiceReqBo.getSubOrderList());
        JSONObject busiReqData = new JSONObject();
        AtomicBoolean isThreeMode = this.getAtomicBoolean(busiReqBO);
        this.setPayMethods(busiReqBO, payProOrderAbilityServiceReqBo, busiReqData, isThreeMode);
        payProOrderAbilityServiceReqBo.setBusiReqData(JSONObject.toJSONString((Object)busiReqData));
        log.debug("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u5165\u53c2{}", (Object)payProOrderAbilityServiceReqBo);
        PayProOrderAbilityServiceRspBo payProOrderAbilityServiceRspBo = this.payProOrderAbilityService.dealOrder(payProOrderAbilityServiceReqBo);
        log.debug("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u51fa\u53c2{}", (Object)payProOrderAbilityServiceRspBo);
        if (!"0000".equals(payProOrderAbilityServiceRspBo.getRspCode())) {
            log.debug("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u5931\u8d25");
            throw new FscBusinessException("194202", payProOrderAbilityServiceRspBo.getRespDesc());
        }
        return payProOrderAbilityServiceRspBo.getUrl();
    }

    private AtomicBoolean getAtomicBoolean(FscDealConsolidatedPayPayCreateBusiReqBO busiReqBO) {
        AtomicBoolean isThreeMode = new AtomicBoolean(false);
        busiReqBO.getPayInfoItemList().forEach(payInfoItemBo -> {
            if (FscConstants.TradeMode.MATCHING.equals(payInfoItemBo.getTradeMode())) {
                isThreeMode.set(true);
            }
        });
        return isThreeMode;
    }

    private void setPayLedgerInfo(Long payOrderId, HashMap<Long, BigDecimal> merchantOrderAmountMap, Map<Long, String> fscMerchantAndPayMerchantMap, PayProOrderAbilityServiceReqBo payProOrderAbilityServiceReqBo, FscDealConsolidatedPayPayCreateBusiReqBO busiReqBO) {
        ArrayList divideDetailDataList = new ArrayList();
        payProOrderAbilityServiceReqBo.setDivideFlag(Boolean.valueOf(true));
        FscLedgerInfoPO fscLedgerInfoPo = new FscLedgerInfoPO();
        fscLedgerInfoPo.setPayOrRefund(FscConstants.PayOrRefund.PAY);
        fscLedgerInfoPo.setPayOrderId(payOrderId);
        fscLedgerInfoPo.setServiceOrPay(FscConstants.ServiceOrPay.PAY);
        List collect = busiReqBO.getPayInfoItemList().stream().map(PayInfoItemBO::getPayeeId).collect(Collectors.toList());
        if (!collect.contains(this.payeeId)) {
            log.debug("\u6b64\u6b21\u4e0d\u9700\u8981\u4ed8\u6b3e\u7ed9\u8054\u4e1c\uff0c\u7b49\u5f85\u5206\u8d26\u5373\u53ef");
            fscLedgerInfoPo.setRemoveMerchantId(this.merchantOrgId);
        }
        List fscLedgerInfoMapperList = this.fscLedgerInfoMapper.getList(fscLedgerInfoPo);
        fscLedgerInfoMapperList.forEach(fscLedgerInfoPoModel -> {
            log.debug("\u5206\u8d26\u6807\u8bc6\u5224\u65ad\u5f00\u59cb{}", fscLedgerInfoPoModel);
            if (!merchantOrderAmountMap.containsKey(fscLedgerInfoPoModel.getMerchantId())) {
                throw new FscBusinessException("190000", "\u5546\u6237\u53d6\u76f4\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            BigDecimal merchantIdAmount = (BigDecimal)merchantOrderAmountMap.get(fscLedgerInfoPoModel.getMerchantId());
            SubOrderBO subOrderBO = new SubOrderBO();
            if (!fscLedgerInfoPoModel.getMerchantId().equals(this.merchantOrgId) && merchantIdAmount.compareTo(fscLedgerInfoPoModel.getLedgerTotalAmount()) != 0) {
                subOrderBO.setDivideFlag(Integer.valueOf(1));
            } else {
                subOrderBO.setDivideFlag(Integer.valueOf(0));
            }
            subOrderBO.setAmount(Long.valueOf(MoneyUtils.yuanToFenToLong((BigDecimal)merchantIdAmount)));
            subOrderBO.setSubOrderId(fscLedgerInfoPoModel.getPayLedgerId().toString());
            subOrderBO.setGoodsName("\u8054\u4e1c\u5546\u54c1");
            String payMerchantId = (String)fscMerchantAndPayMerchantMap.get(fscLedgerInfoPoModel.getMerchantId());
            if (StringUtils.isEmpty((CharSequence)payMerchantId)) {
                subOrderBO.setMerchantId(this.payMerchantOrgId.toString());
            } else {
                subOrderBO.setMerchantId((String)fscMerchantAndPayMerchantMap.get(fscLedgerInfoPoModel.getMerchantId()));
            }
            divideDetailDataList.add(subOrderBO);
        });
        payProOrderAbilityServiceReqBo.setSubOrderList(divideDetailDataList);
    }

    private void setPayMethods(FscDealConsolidatedPayPayCreateBusiReqBO busiReqBO, PayProOrderAbilityServiceReqBo payProOrderAbilityServiceReqBo, JSONObject busiReqData, AtomicBoolean isThreeMode) {
        if (FscConstants.PayObjectType.ORDER.equals(busiReqBO.getPayInfoItemList().get(0).getPayObjectType()) && FscConstants.PayOrderTypeInfo.BALANCE.equals(busiReqBO.getPayOrderType())) {
            busiReqData.put("payMethods", (Object)"30");
            return;
        }
        if (FscConstants.PayObjectType.ORDER.equals(busiReqBO.getPayInfoItemList().get(0).getPayObjectType()) && payProOrderAbilityServiceReqBo.getSubOrderList().size() > 1 && !isThreeMode.get()) {
            busiReqData.put("payMethods", (Object)"610,611,612,30");
        }
        if (FscConstants.PayObjectType.ORDER.equals(busiReqBO.getPayInfoItemList().get(0).getPayObjectType()) && payProOrderAbilityServiceReqBo.getSubOrderList().size() > 1 && isThreeMode.get()) {
            busiReqData.put("payMethods", (Object)"610,611,612");
        }
        if (FscConstants.PayObjectType.ORDER.equals(busiReqBO.getPayInfoItemList().get(0).getPayObjectType()) && payProOrderAbilityServiceReqBo.getSubOrderList().size() == 1 && isThreeMode.get()) {
            busiReqData.put("payMethods", (Object)"610,611,612");
        }
        if (FscConstants.PayObjectType.ORDER.equals(busiReqBO.getPayInfoItemList().get(0).getPayObjectType()) && payProOrderAbilityServiceReqBo.getSubOrderList().size() == 1 && !isThreeMode.get()) {
            busiReqData.put("payMethods", (Object)"51,610,611,612,30");
        }
        if (FscConstants.PayObjectType.ORDER.equals(busiReqBO.getPayInfoItemList().get(0).getPayObjectType()) && payProOrderAbilityServiceReqBo.getSubOrderList().size() == 1 && isThreeMode.get()) {
            busiReqData.put("payMethods", (Object)"610,611,612");
        }
        if (FscConstants.PayObjectType.ORDER.equals(busiReqBO.getPayInfoItemList().get(0).getPayObjectType()) && this.userMerchantOrgId.equals(busiReqBO.getPayInfoItemList().get(0).getPayerId())) {
            busiReqData.put("payMethods", (Object)"611,612");
        }
        if (FscConstants.PayObjectType.FSC.equals(busiReqBO.getPayInfoItemList().get(0).getPayObjectType())) {
            busiReqData.put("payMethods", (Object)"30");
        }
        if (FscConstants.PayObjectType.SERVICE.equals(busiReqBO.getPayInfoItemList().get(0).getPayObjectType())) {
            busiReqData.put("payMethods", (Object)"30");
        }
        if (busiReqBO.getIsAppPay() != null && busiReqBO.getIsAppPay().equals(FscConstants.IsAppPay.YES)) {
            busiReqData.put("appPayAppId", (Object)this.appPayAppId);
        }
    }

    private FscMerchantPO getFscMerchant() {
        FscMerchantPO reqPo = new FscMerchantPO();
        reqPo.setDelFlag(Integer.valueOf(0));
        reqPo.setExceptionFlag(Integer.valueOf(0));
        reqPo.setStatus(Integer.valueOf(3));
        reqPo.setMerchantId(this.merchantOrgId);
        FscMerchantPO rspPo = this.fscMerchantMapper.getModelBy(reqPo);
        if (null == rspPo) {
            log.debug("\u5546\u6237\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a");
            throw new FscBusinessException("194202", "\u6536\u6b3e\u65b9\u5546\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        return rspPo;
    }

    private List<FscMerchantPO> getFscMerchantList(List<Long> orgIds, Integer ledgerCount) {
        FscMerchantPO reqPo = new FscMerchantPO();
        reqPo.setDelFlag(Integer.valueOf(0));
        reqPo.setExceptionFlag(Integer.valueOf(0));
        reqPo.setStatus(Integer.valueOf(3));
        reqPo.setOrgIds(orgIds);
        List rspPo = this.fscMerchantMapper.getList(reqPo);
        if (CollectionUtils.isEmpty((Collection)rspPo) || rspPo.size() != ledgerCount.intValue()) {
            throw new FscBusinessException("190000", "\u5176\u4e2d\u6709\u4f9b\u5e94\u5546\u672a\u914d\u7f6e\u5546\u6237\u914d\u7f6e\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return rspPo;
    }

    private List<FscMerchantPO> getFscMerchantListPay(List<Long> orgIds) {
        FscMerchantPO reqPo = new FscMerchantPO();
        reqPo.setDelFlag(Integer.valueOf(0));
        reqPo.setExceptionFlag(Integer.valueOf(0));
        reqPo.setStatus(Integer.valueOf(3));
        reqPo.setOrgIds(orgIds);
        return this.fscMerchantMapper.getList(reqPo);
    }

    private Map<Long, BigDecimal> addAllPayItemLedger(Date date, Long payOrderId, HashMap<Long, BigDecimal> merchantOrderAmountMap, Map<Long, String> fscMerchantAndPayMerchantMap) {
        log.debug("\u65b0\u589e\u4ed8\u6b3e\u4e3b\u5355\u5546\u54c1\u660e\u7ec6\u5206\u8d26\u4fe1\u606f\u5f00\u59cb{}", (Object)payOrderId);
        List<FscPayOrderInfoItemPO> fscPayOrderInfoItemMapperList = this.checkFscPayOrderInfoItem(payOrderId);
        HashMap<Long, BigDecimal> merchantAndPayAmoutMap = new HashMap<Long, BigDecimal>(fscPayOrderInfoItemMapperList.size());
        ArrayList<FscLedgerInfoItemPO> fscLedgerInfoItemList = new ArrayList<FscLedgerInfoItemPO>();
        HashMap<Long, BigDecimal> fscLedgerAmountMap = new HashMap<Long, BigDecimal>(1);
        List<Long> supIds = fscPayOrderInfoItemMapperList.stream().map(FscPayOrderInfoItemPO::getPayeeId).distinct().collect(Collectors.toList());
        HashMap<Long, Long> orgIdMerchantMap = new HashMap(fscPayOrderInfoItemMapperList.size());
        log.debug("\u6536\u6b3e\u65b9id\u96c6\u5408{}", supIds);
        Map<Long, FscUmcSignContractBO> longFscUmcSignContractBoMap = this.qryContractSign(supIds);
        log.debug("\u6709\u7b7e\u7ea6\u7533\u8bf7\u7684\u4f9b\u5e94\u5546\u96c6\u5408map{}", longFscUmcSignContractBoMap);
        ArrayList<Long> fscUmcSignContractIds = new ArrayList<Long>(longFscUmcSignContractBoMap.keySet());
        log.debug("\u6709\u7b7e\u7ea6\u7533\u8bf7\u7684\u4f9b\u5e94\u5546id\u96c6\u5408{}", fscUmcSignContractIds);
        if (!CollectionUtils.isEmpty(fscUmcSignContractIds) && fscUmcSignContractIds.size() > 0) {
            List<FscMerchantPO> fscMerchantList = this.getFscMerchantList(fscUmcSignContractIds, fscUmcSignContractIds.size());
            log.debug("\u6709\u7b7e\u7ea6\u7533\u8bf7\u7684\u4f9b\u5e94\u5546\u7684\u5546\u6237\u4fe1\u606f\u96c6\u5408{}", fscMerchantList);
            orgIdMerchantMap = fscMerchantList.stream().collect(Collectors.toMap(FscMerchantPO::getOrgId, FscMerchantPO::getMerchantId));
            log.debug("\u6709\u7b7e\u7ea6\u7533\u8bf7\u7684\u4f9b\u5e94\u5546\u7684\u5546\u6237\u548c\u673a\u6784id\u5bf9\u5e94\u5173\u7cfbmap{}", orgIdMerchantMap);
        }
        List<FscMerchantPO> fscMerchantListPay = this.getFscMerchantListPay(supIds);
        Map<Long, String> fscMerchantAndPayMerchantMapPay = fscMerchantListPay.stream().collect(Collectors.toMap(FscMerchantPO::getMerchantId, FscMerchantPO::getPayMerchantId));
        log.debug("\u4ed8\u6b3e\u4f9b\u5e94\u5546\u7684\u7ed3\u7b97\u5546\u6237\u548c\u652f\u4ed8\u4e2d\u5fc3\u5546\u6237\u5bf9\u5e94\u5173\u7cfb\u4e34\u65f6map{}", fscMerchantAndPayMerchantMapPay);
        fscMerchantAndPayMerchantMap.putAll(fscMerchantAndPayMerchantMapPay);
        log.debug("\u4ed8\u6b3e\u4f9b\u5e94\u5546\u7684\u7ed3\u7b97\u5546\u6237\u548c\u652f\u4ed8\u4e2d\u5fc3\u5546\u6237\u5bf9\u5e94\u5173\u7cfbmap{}", fscMerchantAndPayMerchantMap);
        this.forEachPayOrderItem(date, fscPayOrderInfoItemMapperList, merchantAndPayAmoutMap, fscLedgerInfoItemList, fscLedgerAmountMap, longFscUmcSignContractBoMap, orgIdMerchantMap, merchantOrderAmountMap);
        this.insertLedgerInfo(date, payOrderId, fscLedgerAmountMap);
        this.fscLedgerInfoItemMapper.insertBatch(fscLedgerInfoItemList);
        return merchantAndPayAmoutMap;
    }

    private void forEachPayOrderItem(Date date, List<FscPayOrderInfoItemPO> fscPayOrderInfoItemMapperList, HashMap<Long, BigDecimal> merchantAndPayAmoutMap, ArrayList<FscLedgerInfoItemPO> fscLedgerInfoItemList, HashMap<Long, BigDecimal> fscLedgerAmountMap, Map<Long, FscUmcSignContractBO> longFscUmcSignContractBoMap, Map<Long, Long> orgIdMerchantMap, HashMap<Long, BigDecimal> merchantOrderAmountMap) {
        fscPayOrderInfoItemMapperList.forEach(fscPayOrderInfoItemPoModel -> {
            log.debug("\u5f00\u59cb\u5faa\u73af\u4ed8\u6b3e\u5355\u660e\u7ec6\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f{}", fscPayOrderInfoItemPoModel);
            HashMap<Long, Integer> modelSettleMap = new HashMap<Long, Integer>(1);
            AtomicBoolean isInquiryOrder = new AtomicBoolean(false);
            List<DycUocSaleOrderCommodityInfoBO> dycUocSaleOrderCommodityInfoList = this.getDycUocSaleOrderCommodityInfoBoList((FscPayOrderInfoItemPO)fscPayOrderInfoItemPoModel, (Map<Long, Integer>)modelSettleMap, isInquiryOrder);
            dycUocSaleOrderCommodityInfoList = this.getDycUocSaleOrderCommodityInfoList((FscPayOrderInfoItemPO)fscPayOrderInfoItemPoModel, isInquiryOrder, dycUocSaleOrderCommodityInfoList);
            Integer modelSettle = (Integer)modelSettleMap.get(1L);
            dycUocSaleOrderCommodityInfoList.forEach(dycUocSaleOrderCommodityInfoBo -> {
                FscLedgerInfoItemPO fscLedgerInfoItemPo = this.setFscLedgerInfoItemPo(date, (FscPayOrderInfoItemPO)fscPayOrderInfoItemPoModel, (DycUocSaleOrderCommodityInfoBO)dycUocSaleOrderCommodityInfoBo);
                FscUmcSignContractBO fscUmcSignContractBo = (FscUmcSignContractBO)longFscUmcSignContractBoMap.get(Long.valueOf(dycUocSaleOrderCommodityInfoBo.getSupplierId()));
                log.debug("\u83b7\u53d6\u5230\u5bf9\u5e94\u4f9b\u5e94\u5546\u7684\u7b7e\u7ea6\u7533\u8bf7\u4fe1\u606f{}", (Object)fscUmcSignContractBo);
                if (FscConstants.ModelSettle.ELE.equals(modelSettle)) {
                    log.debug("\u8be5\u8ba2\u5355\u4e3a\u8d38\u6613\u6a21\u5f0f");
                    this.eleOrder(merchantAndPayAmoutMap, (DycUocSaleOrderCommodityInfoBO)dycUocSaleOrderCommodityInfoBo, fscLedgerInfoItemPo, merchantOrderAmountMap);
                } else {
                    log.debug("\u8be5\u8ba2\u5355\u4e3a\u4e09\u65b9\u4ea4\u6613\u6a21\u5f0f");
                    if (fscUmcSignContractBo == null) {
                        List<FscMerchantPO> fscMerchantList = this.getFscMerchantList(Collections.singletonList(Long.valueOf(dycUocSaleOrderCommodityInfoBo.getSupplierId())), 1);
                        this.notServiceFeeOrNotOnce(merchantAndPayAmoutMap, (DycUocSaleOrderCommodityInfoBO)dycUocSaleOrderCommodityInfoBo, fscLedgerInfoItemPo, merchantOrderAmountMap, fscMerchantList.get(0).getMerchantId());
                    } else {
                        String saleRate = this.serviceFeeNeedLedger((DycUocSaleOrderCommodityInfoBO)dycUocSaleOrderCommodityInfoBo, fscUmcSignContractBo);
                        if (StringUtils.isEmpty((CharSequence)saleRate)) {
                            this.commdityNotNeedServiceFee(merchantAndPayAmoutMap, orgIdMerchantMap, (DycUocSaleOrderCommodityInfoBO)dycUocSaleOrderCommodityInfoBo, fscLedgerInfoItemPo, merchantOrderAmountMap);
                        } else {
                            this.commdityNeedServiceFee(merchantAndPayAmoutMap, fscLedgerAmountMap, orgIdMerchantMap, (DycUocSaleOrderCommodityInfoBO)dycUocSaleOrderCommodityInfoBo, fscLedgerInfoItemPo, saleRate, merchantOrderAmountMap);
                        }
                    }
                }
                fscLedgerInfoItemList.add(fscLedgerInfoItemPo);
            });
        });
    }

    private List<DycUocSaleOrderCommodityInfoBO> getDycUocSaleOrderCommodityInfoList(FscPayOrderInfoItemPO fscPayOrderInfoItemPoModel, AtomicBoolean isInquiryOrder, List<DycUocSaleOrderCommodityInfoBO> dycUocSaleOrderCommodityInfoList) {
        log.debug("\u5f00\u59cb\u8bbe\u7f6e\u6df7\u5408\u652f\u4ed8\u5546\u54c1\u4fe1\u606f{}", (Object)isInquiryOrder.get());
        if (isInquiryOrder.get()) {
            DycUocSaleOrderCommodityInfoBO dycUocSaleOrderCommodityInfoBo = new DycUocSaleOrderCommodityInfoBO();
            BeanUtils.copyProperties((Object)dycUocSaleOrderCommodityInfoList.get(0), (Object)dycUocSaleOrderCommodityInfoBo);
            dycUocSaleOrderCommodityInfoBo.setSkuId("99");
            dycUocSaleOrderCommodityInfoBo.setSkuName("\u6df7\u5408\u652f\u4ed8\u8ba2\u5355\u5546\u54c1ID");
            dycUocSaleOrderCommodityInfoBo.setSalePrice(new BigDecimal("0.01"));
            dycUocSaleOrderCommodityInfoBo.setSaleFee(fscPayOrderInfoItemPoModel.getPayOrderItemAmount());
            dycUocSaleOrderCommodityInfoBo.setPurchaseCount(fscPayOrderInfoItemPoModel.getPayOrderItemAmount().divide(new BigDecimal("0.01"), 0));
            dycUocSaleOrderCommodityInfoList = Collections.singletonList(dycUocSaleOrderCommodityInfoBo);
        }
        log.debug("\u8fd4\u56de\u6df7\u5408\u652f\u4ed8\u5546\u54c1\u4fe1\u606f{}", dycUocSaleOrderCommodityInfoList);
        return dycUocSaleOrderCommodityInfoList;
    }

    private void insertLedgerInfo(Date date, Long payOrderId, HashMap<Long, BigDecimal> fscLedgerAmountMap) {
        log.debug("\u65b0\u589e\u5206\u8d26\u4fe1\u606f\uff0c\u7528\u4e8e\u8bb0\u5f55\u5206\u8d26\u4e3b\u5355\u670d\u52a1\u8d39\u4fe1\u606f\u5f00\u59cb{}", fscLedgerAmountMap);
        FscLedgerInfoPO fscLedgerInfoPo = new FscLedgerInfoPO();
        fscLedgerInfoPo.setCreateTime(date);
        fscLedgerInfoPo.setPayLedgerId(Long.valueOf(Sequence.getInstance().nextId()));
        fscLedgerInfoPo.setPayOrderId(payOrderId);
        fscLedgerInfoPo.setPayOrRefund(FscConstants.PayOrRefund.PAY);
        fscLedgerInfoPo.setServiceOrPay(FscConstants.ServiceOrPay.SERVICE);
        fscLedgerInfoPo.setMerchantId(this.merchantOrgId);
        if (fscLedgerAmountMap.get(this.merchantOrgId) != null && fscLedgerAmountMap.get(this.merchantOrgId).compareTo(BigDecimal.ZERO) > 0) {
            fscLedgerInfoPo.setLedgerTotalAmount(fscLedgerAmountMap.get(this.merchantOrgId));
        } else {
            fscLedgerInfoPo.setLedgerTotalAmount(BigDecimal.ZERO);
        }
        log.debug("\u65b0\u589e\u670d\u52a1\u8d39\u5206\u8d26\u4fe1\u606f\u5165\u53c2{}", (Object)fscLedgerInfoPo);
        int insert = this.fscLedgerInfoMapper.insert(fscLedgerInfoPo);
        log.debug("\u65b0\u589e\u670d\u52a1\u8d39\u5206\u8d26\u4fe1\u606f\u51fa\u53c2{}", (Object)insert);
        if (insert < 1) {
            throw new FscBusinessException("190000", "\u5206\u8d26\u4e3b\u5355\u4fe1\u606f\u65b0\u589e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
    }

    private List<DycUocSaleOrderCommodityInfoBO> getDycUocSaleOrderCommodityInfoBoList(FscPayOrderInfoItemPO fscPayOrderInfoItemPoModel, Map<Long, Integer> modelSettle, AtomicBoolean isInquiryOrder) {
        List<JSONObject> orderDetail = this.getOrderDetail(fscPayOrderInfoItemPoModel, modelSettle, isInquiryOrder);
        log.debug("\u5faa\u73af\u8ba2\u5355\u660e\u7ec6\u8be6\u60c5\u4fe1\u606f\u5f00\u59cb{}", orderDetail);
        List dycUocSaleOrderCommodityInfoList = JSONObject.parseArray((String)JSONObject.toJSONString(orderDetail), DycUocSaleOrderCommodityInfoBO.class);
        log.debug("\u5faa\u73af\u8ba2\u5355\u660e\u7ec6\u8be6\u60c5\u4fe1\u606f\u96c6\u5408\u51fa\u53c2{}", (Object)dycUocSaleOrderCommodityInfoList);
        return dycUocSaleOrderCommodityInfoList;
    }

    private void eleOrder(HashMap<Long, BigDecimal> merchantAndPayAmoutMap, DycUocSaleOrderCommodityInfoBO dycUocSaleOrderCommodityInfoBo, FscLedgerInfoItemPO fscLedgerInfoItemPo, HashMap<Long, BigDecimal> merchantOrderAmountMap) {
        log.debug("\u8d38\u6613\u6a21\u5f0f\u4f9b\u5e94\u5546id{}", (Object)dycUocSaleOrderCommodityInfoBo.getSupplierId());
        this.setLedgerEleInfo(dycUocSaleOrderCommodityInfoBo, fscLedgerInfoItemPo);
        this.eleOrderAmount(merchantAndPayAmoutMap, fscLedgerInfoItemPo, merchantOrderAmountMap);
    }

    private void notServiceFeeOrNotOnce(HashMap<Long, BigDecimal> merchantAndPayAmoutMap, DycUocSaleOrderCommodityInfoBO dycUocSaleOrderCommodityInfoBo, FscLedgerInfoItemPO fscLedgerInfoItemPo, HashMap<Long, BigDecimal> merchantOrderAmountMap, Long merchantId) {
        log.debug("\u4e0d\u6536\u53d6\u6216\u4e0d\u662f\u6b21\u7ea7\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u4e0d\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u4f9b\u5e94\u5546id{}", (Object)dycUocSaleOrderCommodityInfoBo.getSupplierId());
        this.setLedgerInfo(dycUocSaleOrderCommodityInfoBo, fscLedgerInfoItemPo, merchantId);
        this.replaceMerchantAndPay(merchantAndPayAmoutMap, fscLedgerInfoItemPo, merchantOrderAmountMap);
    }

    private String serviceFeeNeedLedger(DycUocSaleOrderCommodityInfoBO dycUocSaleOrderCommodityInfoBo, FscUmcSignContractBO fscUmcSignContractBo) {
        log.debug("\u6b21\u7ed3\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546id{}", (Object)dycUocSaleOrderCommodityInfoBo.getSupplierId());
        Map<Long, String> saleRateMap = fscUmcSignContractBo.getSalesBOS().stream().distinct().collect(Collectors.toMap(DycSupplierSignContractSalesBO::getItemCatId, DycSupplierSignContractSalesBO::getServiceFeeRate));
        log.debug("\u83b7\u53d6\u8d39\u7387\u51fa\u53c2{}", saleRateMap);
        return saleRateMap.get(dycUocSaleOrderCommodityInfoBo.getCommodityTypeId());
    }

    private void commdityNotNeedServiceFee(HashMap<Long, BigDecimal> merchantAndPayAmoutMap, Map<Long, Long> orgIdMerchantMap, DycUocSaleOrderCommodityInfoBO dycUocSaleOrderCommodityInfoBo, FscLedgerInfoItemPO fscLedgerInfoItemPo, HashMap<Long, BigDecimal> merchantOrderAmountMap) {
        log.debug("\u8be5\u5546\u54c1\u4e0d\u6536\u53d6\u670d\u52a1\u8d39");
        Long merchantId = this.getsaleRateCommdityNotHave(orgIdMerchantMap, dycUocSaleOrderCommodityInfoBo, fscLedgerInfoItemPo);
        this.replaceMerchantAndPayCommdityNotHave(merchantAndPayAmoutMap, fscLedgerInfoItemPo, merchantId, merchantOrderAmountMap);
    }

    private void commdityNeedServiceFee(HashMap<Long, BigDecimal> merchantAndPayAmoutMap, HashMap<Long, BigDecimal> fscLedgerAmountMap, Map<Long, Long> orgIdMerchantMap, DycUocSaleOrderCommodityInfoBO dycUocSaleOrderCommodityInfoBo, FscLedgerInfoItemPO fscLedgerInfoItemPo, String saleRate, HashMap<Long, BigDecimal> merchantOrderAmountMap) {
        log.debug("\u8be5\u5546\u54c1\u9700\u8981\u6536\u53d6\u670d\u52a1\u8d39");
        Long merchantId = this.getsaleRateCommdityHave(orgIdMerchantMap, dycUocSaleOrderCommodityInfoBo, fscLedgerInfoItemPo, saleRate);
        this.replaceMerchantAndPayCommdityHave(merchantAndPayAmoutMap, fscLedgerInfoItemPo, merchantId, merchantOrderAmountMap);
        this.replaceMerchantAndPayCommdityHaveAndLiando(merchantAndPayAmoutMap, fscLedgerInfoItemPo, merchantOrderAmountMap);
        this.getFscLedgerAmountMap(fscLedgerAmountMap, fscLedgerInfoItemPo);
    }

    private void getFscLedgerAmountMap(HashMap<Long, BigDecimal> fscLedgerAmountMap, FscLedgerInfoItemPO fscLedgerInfoItemPo) {
        if (fscLedgerAmountMap.containsKey(this.merchantOrgId)) {
            log.debug("\u8bb0\u5f55\u5206\u8d26\u670d\u52a1\u8d39\u4e3b\u5355\u4fe1\u606f\uff0c\u7528\u4e8e\u5206\u8d26\u4e3b\u5355\u91d1\u989d\u7d2f\u52a0,map\u6709\u503c{}", fscLedgerAmountMap);
            BigDecimal amount = fscLedgerAmountMap.get(this.merchantOrgId);
            log.debug("\u8bb0\u5f55\u5206\u8d26\u670d\u52a1\u8d39\u4e3b\u5355\u4fe1\u606f\uff0c\u7528\u4e8e\u5206\u8d26\u4e3b\u5355\u91d1\u989d\u7d2f\u52a0,map\u6709\u503c,\u83b7\u53d6\u6b64\u65f6\u91d1\u989d{}", (Object)amount);
            BigDecimal amountAfter = amount.add(fscLedgerInfoItemPo.getLedgerAmount());
            log.debug("\u8bb0\u5f55\u5206\u8d26\u670d\u52a1\u8d39\u4e3b\u5355\u4fe1\u606f\uff0c\u7528\u4e8e\u5206\u8d26\u4e3b\u5355\u91d1\u989d\u7d2f\u52a0,map\u6709\u503c,\u83b7\u53d6\u7d2f\u52a0\u540e\u91d1\u989d{}", (Object)amountAfter);
            fscLedgerAmountMap.replace(this.merchantOrgId, amountAfter);
            log.debug("\u8bb0\u5f55\u5206\u8d26\u670d\u52a1\u8d39\u4e3b\u5355\u4fe1\u606f\uff0c\u7528\u4e8e\u5206\u8d26\u4e3b\u5355\u91d1\u989d\u7d2f\u52a0,map\u6709\u503c,\u83b7\u53d6\u7d2f\u52a0\u540e\u5207\u6362\u91d1\u989d{}", (Object)amountAfter);
        } else {
            log.debug("\u8bb0\u5f55\u5206\u8d26\u670d\u52a1\u8d39\u4e3b\u5355\u4fe1\u606f\uff0c\u7528\u4e8e\u5206\u8d26\u4e3b\u5355\u91d1\u989d\u7d2f\u52a0,map\u65e0\u503c{}", fscLedgerAmountMap);
            fscLedgerAmountMap.put(this.merchantOrgId, fscLedgerInfoItemPo.getLedgerAmount());
        }
    }

    private void replaceMerchantAndPayCommdityHaveAndLiando(HashMap<Long, BigDecimal> merchantAndPayAmoutMap, FscLedgerInfoItemPO fscLedgerInfoItemPo, HashMap<Long, BigDecimal> merchantOrderAmountMap) {
        if (merchantAndPayAmoutMap.containsKey(this.merchantOrgId)) {
            log.debug("\u6b21\u7ed3\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546,\u8be5\u5546\u54c1\u9700\u8981\u6536\u53d6\u670d\u52a1\u8d39,\u65b0\u589e\u6216\u4fee\u6539\u8054\u4e1c\u4e3b\u5546\u6237\u91d1\u989d\uff0c\u5c06\u6210\u4ea4\u670d\u52a1\u8d39\u52a0\u5230\u8054\u4e1c\u5546\u6237\u5e94\u6536\u91d1\u989d\u4e2d,\u5e76\u4e14map\u6709\u503c{}", merchantAndPayAmoutMap);
            BigDecimal amount = merchantAndPayAmoutMap.get(this.merchantOrgId);
            log.debug("\u6b21\u7ed3\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546,\u8be5\u5546\u54c1\u9700\u8981\u6536\u53d6\u670d\u52a1\u8d39,\u65b0\u589e\u6216\u4fee\u6539\u8054\u4e1c\u4e3b\u5546\u6237\u91d1\u989d\uff0c\u5c06\u6210\u4ea4\u670d\u52a1\u8d39\u52a0\u5230\u8054\u4e1c\u5546\u6237\u5e94\u6536\u91d1\u989d\u4e2d,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u6b64\u65f6\u91d1\u989d{}", (Object)amount);
            BigDecimal amountAfter = amount.add(fscLedgerInfoItemPo.getLedgerAmount());
            log.debug("\u6b21\u7ed3\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546,\u8be5\u5546\u54c1\u9700\u8981\u6536\u53d6\u670d\u52a1\u8d39,\u65b0\u589e\u6216\u4fee\u6539\u8054\u4e1c\u4e3b\u5546\u6237\u91d1\u989d\uff0c\u5c06\u6210\u4ea4\u670d\u52a1\u8d39\u52a0\u5230\u8054\u4e1c\u5546\u6237\u5e94\u6536\u91d1\u989d\u4e2d,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u7d2f\u52a0\u540e\u91d1\u989d{}", (Object)amountAfter);
            merchantAndPayAmoutMap.replace(this.merchantOrgId, amountAfter);
            log.debug("\u6b21\u7ed3\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546,\u8be5\u5546\u54c1\u9700\u8981\u6536\u53d6\u670d\u52a1\u8d39,\u65b0\u589e\u6216\u4fee\u6539\u8054\u4e1c\u4e3b\u5546\u6237\u91d1\u989d\uff0c\u5c06\u6210\u4ea4\u670d\u52a1\u8d39\u52a0\u5230\u8054\u4e1c\u5546\u6237\u5e94\u6536\u91d1\u989d\u4e2d,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u7d2f\u52a0\u540e\u5207\u6362map\u503c{}", merchantAndPayAmoutMap);
        } else {
            log.debug("\u6b21\u7ed3\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546,\u8be5\u5546\u54c1\u9700\u8981\u6536\u53d6\u670d\u52a1\u8d39,\u65b0\u589e\u6216\u4fee\u6539\u8054\u4e1c\u4e3b\u5546\u6237\u91d1\u989d\uff0c\u5c06\u6210\u4ea4\u670d\u52a1\u8d39\u52a0\u5230\u8054\u4e1c\u5546\u6237\u5e94\u6536\u91d1\u989d\u4e2d,\u5e76\u4e14map\u65e0\u503c{}", merchantAndPayAmoutMap);
            merchantAndPayAmoutMap.put(this.merchantOrgId, fscLedgerInfoItemPo.getLedgerAmount());
        }
    }

    private FscLedgerInfoItemPO setFscLedgerInfoItemPo(Date date, FscPayOrderInfoItemPO fscPayOrderInfoItemPoModel, DycUocSaleOrderCommodityInfoBO dycUocSaleOrderCommodityInfoBo) {
        FscLedgerInfoItemPO fscLedgerInfoItemPo = new FscLedgerInfoItemPO();
        fscLedgerInfoItemPo.setPayOrderItemLedgerId(Long.valueOf(Sequence.getInstance().nextId()));
        fscLedgerInfoItemPo.setSkuId(Long.valueOf(dycUocSaleOrderCommodityInfoBo.getSkuId()));
        fscLedgerInfoItemPo.setSkuPrice(dycUocSaleOrderCommodityInfoBo.getSalePrice());
        fscLedgerInfoItemPo.setSkuNum(dycUocSaleOrderCommodityInfoBo.getPurchaseCount());
        fscLedgerInfoItemPo.setSkuRate(BigDecimal.ZERO);
        fscLedgerInfoItemPo.setIsLedger(FscConstants.IsLedger.YES);
        fscLedgerInfoItemPo.setSkuAmount(dycUocSaleOrderCommodityInfoBo.getSaleFee());
        fscLedgerInfoItemPo.setCreateTime(date);
        fscLedgerInfoItemPo.setPayOrderItemId(fscPayOrderInfoItemPoModel.getPayOrderItemId());
        fscLedgerInfoItemPo.setOrderId(fscPayOrderInfoItemPoModel.getOrderId());
        fscLedgerInfoItemPo.setPayObjectId(fscPayOrderInfoItemPoModel.getPayObjectId());
        fscLedgerInfoItemPo.setPayeeId(fscPayOrderInfoItemPoModel.getPayeeId());
        fscLedgerInfoItemPo.setPayeeName(fscPayOrderInfoItemPoModel.getPayeeName());
        fscLedgerInfoItemPo.setPayObjectType(fscPayOrderInfoItemPoModel.getPayObjectType());
        log.debug("\u5f00\u59cb\u7ec4\u88c5\u5206\u8d26\u6570\u636e{}", (Object)dycUocSaleOrderCommodityInfoBo);
        return fscLedgerInfoItemPo;
    }

    private void setLedgerInfo(DycUocSaleOrderCommodityInfoBO dycUocSaleOrderCommodityInfoBo, FscLedgerInfoItemPO fscLedgerInfoItemPo, Long merchantId) {
        fscLedgerInfoItemPo.setRelAmount(dycUocSaleOrderCommodityInfoBo.getSaleFee());
        fscLedgerInfoItemPo.setLedgerAmount(BigDecimal.ZERO);
        fscLedgerInfoItemPo.setIsLedger(FscConstants.IsLedger.NO);
        fscLedgerInfoItemPo.setPayeeMerchantId(merchantId);
    }

    private void setLedgerEleInfo(DycUocSaleOrderCommodityInfoBO dycUocSaleOrderCommodityInfoBo, FscLedgerInfoItemPO fscLedgerInfoItemPo) {
        fscLedgerInfoItemPo.setRelAmount(dycUocSaleOrderCommodityInfoBo.getSaleFee());
        fscLedgerInfoItemPo.setLedgerAmount(BigDecimal.ZERO);
        fscLedgerInfoItemPo.setIsLedger(FscConstants.IsLedger.NO);
        fscLedgerInfoItemPo.setPayeeMerchantId(this.merchantOrgId);
    }

    private void replaceMerchantAndPay(HashMap<Long, BigDecimal> merchantAndPayAmoutMap, FscLedgerInfoItemPO fscLedgerInfoItemPo, HashMap<Long, BigDecimal> merchantOrderAmountMap) {
        if (merchantAndPayAmoutMap.containsKey(fscLedgerInfoItemPo.getPayeeMerchantId())) {
            log.debug("\u4e0d\u6536\u53d6\u6216\u4e0d\u662f\u6b21\u7ea7\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u4e0d\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546,\u5e76\u4e14map\u6709\u503c{}", merchantAndPayAmoutMap);
            BigDecimal amount = merchantAndPayAmoutMap.get(fscLedgerInfoItemPo.getPayeeMerchantId());
            log.debug("\u4e0d\u6536\u53d6\u6216\u4e0d\u662f\u6b21\u7ea7\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u4e0d\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u6b64\u65f6\u91d1\u989d{}", (Object)amount);
            BigDecimal amountAfter = amount.add(fscLedgerInfoItemPo.getRelAmount());
            log.debug("\u4e0d\u6536\u53d6\u6216\u4e0d\u662f\u6b21\u7ea7\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u4e0d\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u7d2f\u52a0\u540e\u91d1\u989d{}", (Object)amountAfter);
            merchantAndPayAmoutMap.replace(fscLedgerInfoItemPo.getPayeeMerchantId(), amountAfter);
            log.debug("\u4e0d\u6536\u53d6\u6216\u4e0d\u662f\u6b21\u7ea7\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u4e0d\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u7d2f\u52a0\u540e\u5207\u6362map\u503c{}", merchantAndPayAmoutMap);
            BigDecimal merchantOrderAmountBefore = merchantOrderAmountMap.get(fscLedgerInfoItemPo.getPayeeMerchantId());
            log.debug("\u4e0d\u6536\u53d6\u6216\u4e0d\u662f\u6b21\u7ea7\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u4e0d\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546\u4ed8\u6b3e\u91d1\u989d,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u6b64\u65f6\u91d1\u989d{}", (Object)merchantOrderAmountBefore);
            BigDecimal merchantOrderAmountAfter = merchantOrderAmountBefore.add(fscLedgerInfoItemPo.getSkuAmount());
            log.debug("\u4e0d\u6536\u53d6\u6216\u4e0d\u662f\u6b21\u7ea7\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u4e0d\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546\u4ed8\u6b3e\u91d1\u989d,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u7d2f\u52a0\u540e\u91d1\u989d{}", (Object)merchantOrderAmountAfter);
            merchantOrderAmountMap.replace(fscLedgerInfoItemPo.getPayeeMerchantId(), merchantOrderAmountAfter);
            log.debug("\u4e0d\u6536\u53d6\u6216\u4e0d\u662f\u6b21\u7ea7\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u4e0d\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546\u4ed8\u6b3e\u91d1\u989d,\u83b7\u53d6\u7d2f\u52a0\u540e\u5207\u6362map\u503c{}", merchantOrderAmountMap);
        } else {
            merchantAndPayAmoutMap.put(fscLedgerInfoItemPo.getPayeeMerchantId(), fscLedgerInfoItemPo.getRelAmount());
            log.debug("\u4e0d\u6536\u53d6\u6216\u4e0d\u662f\u6b21\u7ea7\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u4e0d\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546,\u5e76\u4e14map\u65e0\u503c{}", merchantAndPayAmoutMap);
            merchantOrderAmountMap.put(fscLedgerInfoItemPo.getPayeeMerchantId(), fscLedgerInfoItemPo.getSkuAmount());
            log.debug("\u4e0d\u6536\u53d6\u6216\u4e0d\u662f\u6b21\u7ea7\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u4e0d\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546\u4ed8\u6b3e\u91d1\u989d,\u5e76\u4e14map\u65e0\u503c{}", merchantOrderAmountMap);
        }
    }

    private void eleOrderAmount(HashMap<Long, BigDecimal> merchantAndPayAmoutMap, FscLedgerInfoItemPO fscLedgerInfoItemPo, HashMap<Long, BigDecimal> merchantOrderAmountMap) {
        if (merchantAndPayAmoutMap.containsKey(this.merchantOrgId)) {
            log.debug("\u8d38\u6613\u6a21\u5f0f,\u5e76\u4e14map\u6709\u503c{}", merchantAndPayAmoutMap);
            BigDecimal amount = merchantAndPayAmoutMap.get(this.merchantOrgId);
            log.debug("\u8d38\u6613\u6a21\u5f0f,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u6b64\u65f6\u91d1\u989d{}", (Object)amount);
            BigDecimal amountAfter = amount.add(fscLedgerInfoItemPo.getRelAmount());
            log.debug("\u8d38\u6613\u6a21\u5f0f,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u7d2f\u52a0\u540e\u91d1\u989d{}", (Object)amountAfter);
            merchantAndPayAmoutMap.replace(this.merchantOrgId, amountAfter);
            log.debug("\u8d38\u6613\u6a21\u5f0f,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u7d2f\u52a0\u540e\u5207\u6362map\u503c{}", merchantAndPayAmoutMap);
            BigDecimal merchantOrderAmountBefore = merchantOrderAmountMap.get(this.merchantOrgId);
            log.debug("\u8d38\u6613\u6a21\u5f0f,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u6b64\u65f6\u91d1\u989d{}", (Object)merchantOrderAmountBefore);
            BigDecimal merchantOrderAmountAfter = merchantOrderAmountBefore.add(fscLedgerInfoItemPo.getSkuAmount());
            log.debug("\u8d38\u6613\u6a21\u5f0f,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u7d2f\u52a0\u540e\u91d1\u989d{}", (Object)merchantOrderAmountAfter);
            merchantOrderAmountMap.replace(this.merchantOrgId, merchantOrderAmountAfter);
            log.debug("\u8d38\u6613\u6a21\u5f0f,\u83b7\u53d6\u7d2f\u52a0\u540e\u5207\u6362map\u503c{}", merchantOrderAmountMap);
        } else {
            merchantAndPayAmoutMap.put(this.merchantOrgId, fscLedgerInfoItemPo.getRelAmount());
            log.debug("\u8d38\u6613\u6a21\u5f0f,\u5e76\u4e14map\u65e0\u503c{}", merchantAndPayAmoutMap);
            merchantOrderAmountMap.put(this.merchantOrgId, fscLedgerInfoItemPo.getSkuAmount());
            log.debug("\u8d38\u6613\u6a21\u5f0f,\u5e76\u4e14map\u65e0\u503c{}", merchantOrderAmountMap);
        }
    }

    private Long getsaleRateCommdityNotHave(Map<Long, Long> orgIdMerchantMap, DycUocSaleOrderCommodityInfoBO dycUocSaleOrderCommodityInfoBo, FscLedgerInfoItemPO fscLedgerInfoItemPo) {
        fscLedgerInfoItemPo.setRelAmount(dycUocSaleOrderCommodityInfoBo.getSaleFee());
        fscLedgerInfoItemPo.setLedgerAmount(BigDecimal.ZERO);
        fscLedgerInfoItemPo.setIsLedger(FscConstants.IsLedger.NO);
        Long merchantId = orgIdMerchantMap.get(Long.valueOf(dycUocSaleOrderCommodityInfoBo.getSupplierId()));
        if (merchantId == null) {
            throw new FscBusinessException("190000", "\u4f9b\u5e94\u5546" + dycUocSaleOrderCommodityInfoBo.getSupplierId() + "\u672a\u914d\u7f6e\u5546\u6237\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        fscLedgerInfoItemPo.setPayeeMerchantId(merchantId);
        return merchantId;
    }

    private void replaceMerchantAndPayCommdityNotHave(HashMap<Long, BigDecimal> merchantAndPayAmoutMap, FscLedgerInfoItemPO fscLedgerInfoItemPo, Long merchantId, HashMap<Long, BigDecimal> merchantOrderAmountMap) {
        if (merchantAndPayAmoutMap.containsKey(merchantId)) {
            log.debug("\u6b21\u7ed3\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546,\u8be5\u5546\u54c1\u4e0d\u6536\u53d6\u670d\u52a1\u8d39,\u5e76\u4e14map\u6709\u503c{}", merchantAndPayAmoutMap);
            BigDecimal amount = merchantAndPayAmoutMap.get(merchantId);
            log.debug("\u6b21\u7ed3\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546,\u8be5\u5546\u54c1\u4e0d\u6536\u53d6\u670d\u52a1\u8d39,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u6b64\u65f6\u91d1\u989d{}", (Object)amount);
            BigDecimal amountAfter = amount.add(fscLedgerInfoItemPo.getRelAmount());
            log.debug("\u6b21\u7ed3\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546,\u8be5\u5546\u54c1\u4e0d\u6536\u53d6\u670d\u52a1\u8d39,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u7d2f\u52a0\u540e\u91d1\u989d{}", (Object)amountAfter);
            merchantAndPayAmoutMap.replace(merchantId, amountAfter);
            log.debug("\u6b21\u7ed3\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546,\u8be5\u5546\u54c1\u4e0d\u6536\u53d6\u670d\u52a1\u8d39,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u7d2f\u52a0\u540e\u5207\u6362map\u503c{}", merchantAndPayAmoutMap);
            BigDecimal merchantOrderAmountBefore = merchantOrderAmountMap.get(merchantId);
            log.debug("\u6b21\u7ed3\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546\u4ed8\u6b3e\u91d1\u989d,\u8be5\u5546\u54c1\u4e0d\u6536\u53d6\u670d\u52a1\u8d39,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u6b64\u65f6\u91d1\u989d{}", (Object)merchantOrderAmountBefore);
            BigDecimal merchantOrderAmountAfter = merchantOrderAmountBefore.add(fscLedgerInfoItemPo.getSkuAmount());
            log.debug("\u6b21\u7ed3\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546\u4ed8\u6b3e\u91d1\u989d,\u8be5\u5546\u54c1\u4e0d\u6536\u53d6\u670d\u52a1\u8d39,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u7d2f\u52a0\u540e\u91d1\u989d{}", (Object)merchantOrderAmountAfter);
            merchantOrderAmountMap.replace(merchantId, merchantOrderAmountAfter);
            log.debug("\u6b21\u7ed3\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546\u4ed8\u6b3e\u91d1\u989d,\u8be5\u5546\u54c1\u4e0d\u6536\u53d6\u670d\u52a1\u8d39,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u7d2f\u52a0\u540e\u5207\u6362map\u503c{}", merchantOrderAmountMap);
        } else {
            merchantAndPayAmoutMap.put(merchantId, fscLedgerInfoItemPo.getRelAmount());
            log.debug("\u4e0d\u6536\u53d6\u6216\u4e0d\u662f\u6b21\u7ea7\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u4e0d\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546,\u5e76\u4e14map\u65e0\u503c{}", merchantAndPayAmoutMap);
            merchantOrderAmountMap.put(merchantId, fscLedgerInfoItemPo.getSkuAmount());
            log.debug("\u4e0d\u6536\u53d6\u6216\u4e0d\u662f\u6b21\u7ea7\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u4e0d\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546\u4ed8\u6b3e\u91d1\u989d,\u5e76\u4e14map\u65e0\u503c{}", merchantOrderAmountMap);
        }
    }

    private Long getsaleRateCommdityHave(Map<Long, Long> orgIdMerchantMap, DycUocSaleOrderCommodityInfoBO dycUocSaleOrderCommodityInfoBo, FscLedgerInfoItemPO fscLedgerInfoItemPo, String saleRate) {
        fscLedgerInfoItemPo.setIsLedger(FscConstants.IsLedger.YES);
        log.debug("\u670d\u52a1\u8d39\u8d39\u7387{}", (Object)saleRate);
        BigDecimal saleRateRel = new BigDecimal(saleRate).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
        log.debug("\u670d\u52a1\u8d39\u771f\u5b9e\u8d39\u7387{}", (Object)saleRateRel);
        BigDecimal serviceFeePrice = dycUocSaleOrderCommodityInfoBo.getSalePrice().multiply(saleRateRel).setScale(2, 0);
        log.debug("\u6210\u4ea4\u670d\u52a1\u8d39\u5355\u4ef7\u91d1\u989d{}", (Object)serviceFeePrice);
        BigDecimal serviceFee = serviceFeePrice.multiply(dycUocSaleOrderCommodityInfoBo.getPurchaseCount()).setScale(2, 0);
        log.debug("\u6210\u4ea4\u670d\u52a1\u8d39\u91d1\u989d{}", (Object)serviceFee);
        BigDecimal relAmount = dycUocSaleOrderCommodityInfoBo.getSaleFee().subtract(serviceFee);
        fscLedgerInfoItemPo.setRelAmount(relAmount);
        fscLedgerInfoItemPo.setLedgerAmount(serviceFee);
        fscLedgerInfoItemPo.setSkuRate(saleRateRel);
        Long merchantId = orgIdMerchantMap.get(Long.valueOf(dycUocSaleOrderCommodityInfoBo.getSupplierId()));
        if (merchantId == null) {
            throw new FscBusinessException("190000", "\u4f9b\u5e94\u5546" + dycUocSaleOrderCommodityInfoBo.getSupplierId() + "\u672a\u914d\u7f6e\u5546\u6237\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        fscLedgerInfoItemPo.setPayeeMerchantId(merchantId);
        return merchantId;
    }

    private void replaceMerchantAndPayCommdityHave(HashMap<Long, BigDecimal> merchantAndPayAmoutMap, FscLedgerInfoItemPO fscLedgerInfoItemPo, Long merchantId, HashMap<Long, BigDecimal> merchantOrderAmountMap) {
        if (merchantAndPayAmoutMap.containsKey(merchantId)) {
            log.debug("\u6b21\u7ed3\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546,\u8be5\u5546\u54c1\u9700\u8981\u6536\u53d6\u670d\u52a1\u8d39,\u5e76\u4e14map\u6709\u503c{}", merchantAndPayAmoutMap);
            BigDecimal amount = merchantAndPayAmoutMap.get(merchantId);
            log.debug("\u6b21\u7ed3\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546,\u8be5\u5546\u54c1\u9700\u8981\u6536\u53d6\u670d\u52a1\u8d39,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u6b64\u65f6\u91d1\u989d{}", (Object)amount);
            BigDecimal amountAfter = amount.add(fscLedgerInfoItemPo.getRelAmount());
            log.debug("\u6b21\u7ed3\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546,\u8be5\u5546\u54c1\u9700\u8981\u6536\u53d6\u670d\u52a1\u8d39,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u7d2f\u52a0\u540e\u91d1\u989d{}", (Object)amountAfter);
            merchantAndPayAmoutMap.replace(merchantId, amountAfter);
            log.debug("\u6b21\u7ed3\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546,\u8be5\u5546\u54c1\u9700\u8981\u6536\u53d6\u670d\u52a1\u8d39,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u7d2f\u52a0\u540e\u5207\u6362map\u503c{}", merchantAndPayAmoutMap);
            BigDecimal merchantOrderAmountBefore = merchantOrderAmountMap.get(merchantId);
            log.debug("\u6b21\u7ed3\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546,\u8be5\u5546\u54c1\u9700\u8981\u6536\u53d6\u670d\u52a1\u8d39,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u6b64\u65f6\u91d1\u989d{}", (Object)merchantOrderAmountBefore);
            BigDecimal merchantOrderAmountAfter = merchantOrderAmountBefore.add(fscLedgerInfoItemPo.getSkuAmount());
            log.debug("\u6b21\u7ed3\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546,\u8be5\u5546\u54c1\u9700\u8981\u6536\u53d6\u670d\u52a1\u8d39,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u7d2f\u52a0\u540e\u91d1\u989d{}", (Object)merchantOrderAmountAfter);
            merchantOrderAmountMap.replace(merchantId, merchantOrderAmountAfter);
            log.debug("\u6b21\u7ed3\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546,\u8be5\u5546\u54c1\u9700\u8981\u6536\u53d6\u670d\u52a1\u8d39,\u5e76\u4e14map\u6709\u503c,\u83b7\u53d6\u7d2f\u52a0\u540e\u5207\u6362map\u503c{}", merchantOrderAmountMap);
        } else {
            merchantAndPayAmoutMap.put(merchantId, fscLedgerInfoItemPo.getRelAmount());
            log.debug("\u4e0d\u6536\u53d6\u6216\u4e0d\u662f\u6b21\u7ea7\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u4e0d\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546,\u5e76\u4e14map\u65e0\u503c{}", merchantAndPayAmoutMap);
            merchantOrderAmountMap.put(merchantId, fscLedgerInfoItemPo.getSkuAmount());
            log.debug("\u6b21\u7ed3\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u9700\u8981\u5206\u8d26\u7ed9\u8054\u4e1c\u7684\u4f9b\u5e94\u5546,\u8be5\u5546\u54c1\u9700\u8981\u6536\u53d6\u670d\u52a1\u8d39,\u5e76\u4e14map\u65e0\u503c{}", merchantOrderAmountMap);
        }
    }

    private List<FscPayOrderInfoItemPO> checkFscPayOrderInfoItem(Long payOrderId) {
        log.debug("\u6821\u9a8c\u660e\u7ec6\u662f\u5426\u5b58\u5728\uff0c\u5e76\u8fd4\u56de\u660e\u7ec6\u96c6\u5408{}", (Object)payOrderId);
        FscPayOrderInfoItemPO fscPayOrderInfoItemPo = new FscPayOrderInfoItemPO();
        fscPayOrderInfoItemPo.setPayOrderId(payOrderId);
        List fscPayOrderInfoItemMapperList = this.fscPayOrderInfoItemMapper.getList(fscPayOrderInfoItemPo);
        log.debug("\u6821\u9a8c\u660e\u7ec6\u662f\u5426\u5b58\u5728\uff0c\u5e76\u8fd4\u56de\u660e\u7ec6\u96c6\u5408\u51fa\u53c2{}", (Object)fscPayOrderInfoItemMapperList);
        if (CollectionUtils.isEmpty((Collection)fscPayOrderInfoItemMapperList)) {
            throw new FscBusinessException("190000", "\u4ed8\u6b3e\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return fscPayOrderInfoItemMapperList;
    }

    private List<JSONObject> getOrderDetail(FscPayOrderInfoItemPO fscPayOrderInfoItemPoModel, Map<Long, Integer> modelSettle, AtomicBoolean isInquiryOrder) {
        log.debug("\u5f00\u59cb\u5faa\u73af\u4ed8\u6b3e\u5355\u660e\u7ec6\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f{}", (Object)fscPayOrderInfoItemPoModel);
        HashMap<String, String> content = new HashMap<String, String>(2);
        content.put("saleOrderId", fscPayOrderInfoItemPoModel.getPayObjectId().toString());
        content.put("orderId", fscPayOrderInfoItemPoModel.getOrderId().toString());
        log.debug("\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u4fe1\u606f\u5165\u53c2{}", (Object)(this.qrySaleOrderUrl + JSONObject.toJSONString(content)));
        String resultData = HttpUtil.post((String)this.qrySaleOrderUrl, (String)JSONObject.toJSONString(content));
        log.debug("\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u4fe1\u606f\u51fa\u53c2{}", (Object)resultData);
        if (!StringUtils.isEmpty((CharSequence)resultData)) {
            JSONObject jsonObject = JSONObject.parseObject((String)resultData);
            Object code = jsonObject.get((Object)"code");
            if (!"0".equals(code)) {
                throw new FscBusinessException("190000", jsonObject.get((Object)"message").toString());
            }
            JSONObject data = (JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString((Object)jsonObject.get((Object)"data")), JSONObject.class);
            String modelSettleString = JSONObject.toJSONString((Object)data.get((Object)"modelSettle"));
            log.debug("\u8ba2\u5355\u7ed3\u7b97\u6a21\u5f0f\u51fa\u53c2{}", (Object)modelSettleString);
            modelSettle.put(1L, Integer.valueOf(modelSettleString));
            log.debug("\u8be5\u8ba2\u5355\u7684\u7ed3\u7b97\u6a21\u5f0fmap{}", modelSettle);
            String payType = data.get((Object)"payType").toString();
            log.debug("\u8ba2\u5355\u662f\u5426\u6df7\u5408\u652f\u4ed8\u6807\u8bc6\u51fa\u53c2{}", (Object)payType);
            log.debug("\u56fa\u5b9a\u989d\u5ea6\u52a0\u6df7\u5408\u652f\u4ed8{}", (Object)FscConstants.PayOrderType.FIXED_LIMIT_ADD_PAY_FIRST.toString());
            log.debug("\u6bd4\u8f83\u7ed3\u679c{}", (Object)FscConstants.PayOrderType.FIXED_LIMIT_ADD_PAY_FIRST.toString().equals(payType));
            if (FscConstants.PayOrderType.FIXED_LIMIT_ADD_PAY_FIRST.toString().equals(payType) || FscConstants.PayOrderType.TEMPORARY_LIMIT_ADD_PAY_FIRST.toString().equals(payType)) {
                log.debug("\u8fdb\u5165\u6df7\u5408\u652f\u4ed8{}", (Object)payType);
                isInquiryOrder.set(true);
                log.debug("\u51fa\u5165\u6df7\u5408\u652f\u4ed8{}", (Object)isInquiryOrder.get());
            }
            return JSONObject.parseArray((String)JSONObject.toJSONString((Object)data.get((Object)"saleOrderDetailServiceRspItemBoList")), JSONObject.class);
        }
        throw new FscBusinessException("190000", "\u67e5\u8be2\u9500\u552e\u5355\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff01");
    }

    private Map<Long, FscUmcSignContractBO> qryContractSign(List<Long> supIds) {
        FscDycUmcQuerySupplierListReqBO fscDycUmcQuerySupplierListReqBO = new FscDycUmcQuerySupplierListReqBO();
        fscDycUmcQuerySupplierListReqBO.setSupplierIds(supIds);
        log.debug("\u6b21\u5ea6\u6210\u4ea4\u670d\u52a1\u8d39\u67e5\u8be2\u7b7e\u7ea6\u7533\u8bf7\u5165\u53c2{}", (Object)JSON.toJSONString((Object)fscDycUmcQuerySupplierListReqBO));
        FscDycUmcQuerySupplierListRspBO fscDycUmcQuerySupplierListRspBO = this.fscDycUmcQuerySupplierListAbilityService.querySupplierList(fscDycUmcQuerySupplierListReqBO);
        if (!CollectionUtils.isEmpty((Collection)fscDycUmcQuerySupplierListRspBO.getSignContractBOS())) {
            log.debug("\u6b21\u5ea6\u6210\u4ea4\u670d\u52a1\u8d39\u67e5\u8be2\u7b7e\u7ea6\u7533\u8bf7\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)fscDycUmcQuerySupplierListRspBO.getSignContractBOS()));
        }
        if (!"0000".equals(fscDycUmcQuerySupplierListRspBO.getRespCode()) || CollectionUtils.isEmpty((Collection)fscDycUmcQuerySupplierListRspBO.getSignContractBOS())) {
            return new HashMap<Long, FscUmcSignContractBO>();
        }
        return fscDycUmcQuerySupplierListRspBO.getSignContractBOS().stream().filter(fscUmcSignContractBO -> StringUtils.isNotBlank((CharSequence)fscUmcSignContractBO.getExtField1()) && "4".equals(fscUmcSignContractBO.getExtField1()) && !CollectionUtils.isEmpty((Collection)fscUmcSignContractBO.getSalesBOS())).collect(Collectors.toMap(FscUmcSignContractBO::getSupplierId, fscUmcSignContractBO -> fscUmcSignContractBO));
    }
}

