/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCallMoneyItemMapper;
import com.tydic.fsc.dao.FscCallMoneyMapper;
import com.tydic.fsc.dao.FscCostOrderMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscCostOrderAtomService;
import com.tydic.fsc.pay.atom.bo.FscCostOrderAtomBO;
import com.tydic.fsc.pay.atom.bo.FscCostOrderAtomRspBO;
import com.tydic.fsc.pay.atom.bo.FscCostOrderReqBO;
import com.tydic.fsc.po.FscCallMoneyItemPO;
import com.tydic.fsc.po.FscCallMoneyPO;
import com.tydic.fsc.po.FscCostOrderPO;
import com.tydic.fsc.po.FscOrderPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscCostOrderAtomServiceImpl
implements FscCostOrderAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscCostOrderAtomServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscCostOrderMapper fscCostOrderMapper;
    @Autowired
    private FscCallMoneyItemMapper fscCallMoneyItemMapper;
    @Autowired
    private FscCallMoneyMapper fscCallMoneyMapper;

    @Override
    public FscCostOrderAtomRspBO costOrder(FscCostOrderReqBO reqBO) {
        log.debug("\u6210\u672c\u7cfb\u7edf\u56de\u8c03atom\u8fdb\u5165{}", (Object)reqBO);
        Date now = new Date();
        FscCallMoneyPO fscCallMoneyPo = this.getFscCallMoneyPo(reqBO, now);
        ArrayList<FscCallMoneyItemPO> fscCallMoneyItemPoList = new ArrayList<FscCallMoneyItemPO>();
        if (!StringUtils.isEmpty((Object)reqBO.getContractNo())) {
            this.setContract(reqBO, now, fscCallMoneyPo, fscCallMoneyItemPoList);
        } else {
            log.debug("\u4e0b\u6e38\u65e0\u5408\u540c\u4ed8\u6b3e\u56de\u8c03");
            if (CollectionUtils.isEmpty(reqBO.getFscOrderList())) {
                throw new FscBusinessException("190000", "\u4e0b\u6e38\u65e0\u5408\u540c\u4ed8\u6b3e\u56de\u8c03\u5165\u53c2\u5bf9\u8d26\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            fscCallMoneyPo.setCallMoneyType(FscConstants.CallMoneyType.NOT_CONTRACT_PAY);
            List<FscOrderPO> fscOrderPoList = this.getFscOrderPoS(reqBO);
            this.delMoney(reqBO.getThisPay(), fscOrderPoList, fscCallMoneyItemPoList, fscCallMoneyPo, now, FscConstants.CallMoneyPayType.THIS_PAY);
        }
        this.insertInfo(fscCallMoneyPo, fscCallMoneyItemPoList);
        FscCostOrderAtomRspBO rspBO = new FscCostOrderAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5bf9\u8d26\u6210\u529f");
        return rspBO;
    }

    private void insertInfo(FscCallMoneyPO fscCallMoneyPo, List<FscCallMoneyItemPO> fscCallMoneyItemPoList) {
        int insert = this.fscCallMoneyMapper.insert(fscCallMoneyPo);
        if (insert < 1) {
            throw new FscBusinessException("190000", "\u65b0\u589e\u672c\u6b21\u4ed8\u6b3e\u4fe1\u606f\u8bb0\u5f55\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty(fscCallMoneyItemPoList)) {
            this.fscCallMoneyItemMapper.insertBatch(fscCallMoneyItemPoList);
        }
    }

    private void setContract(FscCostOrderReqBO reqBO, Date now, FscCallMoneyPO fscCallMoneyPo, List<FscCallMoneyItemPO> fscCallMoneyItemPoList) {
        log.debug("\u4e0b\u6e38\u5408\u540c\u4ed8\u6b3e\u56de\u8c03");
        fscCallMoneyPo.setCallMoneyType(FscConstants.CallMoneyType.CONTRACT_PAY);
        fscCallMoneyPo.setContractNo(reqBO.getContractNo());
        FscCostOrderPO fscCostOrderPo = new FscCostOrderPO();
        fscCostOrderPo.setContractNo(reqBO.getContractNo());
        log.debug("\u6210\u672c\u7cfb\u7edf\u67e5\u8be2\u9884\u5b58\u6b3e\u6570\u636e\u5165\u53c2{}", (Object)fscCostOrderPo);
        FscCostOrderPO modelBy = this.fscCostOrderMapper.getModelBy(fscCostOrderPo);
        if (CollectionUtils.isEmpty(reqBO.getFscOrderList())) {
            this.setNotFscOrder(reqBO.getThisPay(), now, fscCallMoneyPo, fscCallMoneyItemPoList);
            log.debug("\u6210\u672c\u7cfb\u7edf\u56de\u8c03\u9884\u5b58\u6b3e");
            if (modelBy == null) {
                log.debug("\u6210\u672c\u7cfb\u7edf\u56de\u8c03\u9884\u5b58\u6b3e\u4e3a\u7a7a\u65b0\u589e");
                this.dealCostHaveNot(reqBO, now, fscCostOrderPo);
            } else {
                log.debug("\u6210\u672c\u7cfb\u7edf\u56de\u8c03\u9884\u5b58\u6b3e\u4e0d\u4e3a\u7a7a\u66f4\u65b0");
                this.dealCostHave(reqBO, now, modelBy);
            }
        } else {
            log.debug("\u6210\u672c\u7cfb\u7edf\u56de\u8c03\u5bf9\u8d26\u5355");
            List<FscOrderPO> fscOrderPoList = this.getFscOrderPoS(reqBO);
            BigDecimal money = reqBO.getThisPay();
            log.debug("\u672c\u6b21\u56de\u4f20\u91d1\u989d{}", (Object)money);
            if (modelBy == null) {
                log.debug("\u9884\u5b58\u6b3e\u6ca1\u6709\u503c\uff0c\u5148\u4f7f\u7528\u672c\u6b21\u4ed8\u6b3e\u91d1\u989d\u4ed8\u6b3e\uff0c\u5982\u679c\u6709\u4f59\u989d\u65b0\u589e\u9884\u5b58\u6b3e\u4fe1\u606f\u518d\u5b58\u5165\u9884\u5b58\u6b3e\u4e2d");
                money = this.delMoney(money, fscOrderPoList, fscCallMoneyItemPoList, fscCallMoneyPo, now, FscConstants.CallMoneyPayType.THIS_PAY);
                log.debug("\u4ed8\u6b3e\u540e\u5269\u4f59\u91d1\u989d{}", (Object)money);
                if (money.compareTo(BigDecimal.ZERO) > 0) {
                    log.debug("\u5982\u679c\u672c\u6b21\u4ed8\u6b3e\u540e\u8fd8\u6709\u5269\u4f59\u5219\u5b58\u5165\u9884\u5b58\u6b3e");
                    this.dealCostHaveNotComPareToZeroBig(now, fscCostOrderPo, money, fscCallMoneyPo, fscCallMoneyItemPoList);
                }
            } else {
                log.debug("\u5b58\u5728\u9884\u5b58\u6b3e\uff0c\u5148\u7528\u672c\u6b21\u652f\u4ed8\u91d1\u989d\uff0c\u518d\u7528\u9884\u5b58\u6b3e\uff0c\u5982\u679c\u5df2\u7ecf\u586b\u6ee1\uff0c\u5219\u5b58\u5165\u9884\u5b58\u6b3e\u4e2d");
                BigDecimal advance = modelBy.getTotalPay().subtract(modelBy.getRebateMoney());
                log.debug("\u9884\u5b58\u6b3e\u5269\u4f59\u91d1\u989d{}", (Object)advance);
                log.debug("\u5b58\u5728\u9884\u5b58\u6b3e\uff0c\u5f00\u59cb\u4f7f\u7528\u672c\u6b21\u4ed8\u6b3e\u91d1\u989d\u4ed8\u6b3e");
                money = this.delMoney(money, fscOrderPoList, fscCallMoneyItemPoList, fscCallMoneyPo, now, FscConstants.CallMoneyPayType.THIS_PAY);
                log.debug("\u5b58\u5728\u9884\u5b58\u6b3e\uff0c\u4ed8\u6b3e\u540e\u5269\u4f59\u91d1\u989d{}", (Object)money);
                if (money.compareTo(BigDecimal.ZERO) > 0) {
                    log.debug("\u5b58\u5728\u9884\u5b58\u6b3e\uff0c\u4ed8\u6b3e\u540e\u5269\u4f59\u91d1\u989d\u5927\u4e8e0{}", (Object)money);
                    this.dealCostHaveComPareToZeroLow(now, modelBy, money, fscCallMoneyItemPoList, fscCallMoneyPo);
                } else {
                    log.debug("\u5b58\u5728\u9884\u5b58\u6b3e\uff0c\u4ed8\u6b3e\u540e\u5269\u4f59\u91d1\u989d\u7b49\u4e8e0{}", (Object)money);
                    this.dealCostHaveComPareToZeroBig(now, modelBy, fscOrderPoList, advance, fscCallMoneyItemPoList, fscCallMoneyPo);
                }
            }
        }
    }

    private void setNotFscOrder(BigDecimal money, Date now, FscCallMoneyPO fscCallMoneyPo, List<FscCallMoneyItemPO> fscCallMoneyItemPoList) {
        FscCallMoneyItemPO fscCallMoneyItemPo = new FscCallMoneyItemPO();
        fscCallMoneyItemPo.setCreateTime(now);
        fscCallMoneyItemPo.setFscCallMoneyId(fscCallMoneyPo.getFscCallMoneyId());
        fscCallMoneyItemPo.setFscCallMoneyItemId(Long.valueOf(Sequence.getInstance().nextId()));
        fscCallMoneyItemPo.setPayMoeny(money);
        fscCallMoneyItemPo.setCallMoneyPayType(FscConstants.CallMoneyPayType.ADD_PAY);
        fscCallMoneyItemPoList.add(fscCallMoneyItemPo);
    }

    private FscCallMoneyPO getFscCallMoneyPo(FscCostOrderReqBO reqBO, Date now) {
        FscCallMoneyPO fscCallMoneyPo = new FscCallMoneyPO();
        fscCallMoneyPo.setPayTime(reqBO.getPayTime());
        fscCallMoneyPo.setTotalMoney(reqBO.getThisPay());
        fscCallMoneyPo.setCreateTime(now);
        fscCallMoneyPo.setFscCallMoneyId(Long.valueOf(Sequence.getInstance().nextId()));
        return fscCallMoneyPo;
    }

    private void dealCostHaveNot(FscCostOrderReqBO reqBO, Date now, FscCostOrderPO fscCostOrderPo) {
        fscCostOrderPo.setRebateMoney(BigDecimal.ZERO);
        fscCostOrderPo.setTotalPay(reqBO.getThisPay());
        fscCostOrderPo.setUpdateTime(now);
        fscCostOrderPo.setCreateTime(now);
        log.debug("\u6210\u672c\u7cfb\u7edf\u56de\u8c03\u9884\u5b58\u6b3e\u4e3a\u7a7a\u65b0\u589e\u5165\u53c2{}", (Object)fscCostOrderPo);
        this.fscCostOrderMapper.insert(fscCostOrderPo);
    }

    private void dealCostHave(FscCostOrderReqBO reqBO, Date now, FscCostOrderPO modelBy) {
        FscCostOrderPO update = new FscCostOrderPO();
        update.setId(modelBy.getId());
        update.setUpdateTime(now);
        update.setTotalPay(reqBO.getThisPay().add(modelBy.getTotalPay()));
        log.debug("\u6210\u672c\u7cfb\u7edf\u56de\u8c03\u9884\u5b58\u6b3e\u4e0d\u4e3a\u7a7a\u66f4\u65b0\u5165\u53c2{}", (Object)update);
        this.fscCostOrderMapper.updateById(update);
    }

    private List<FscOrderPO> getFscOrderPoS(FscCostOrderReqBO reqBO) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        List fscOrderIds = reqBO.getFscOrderList().stream().map(FscCostOrderAtomBO::getFscOrderId).collect(Collectors.toList());
        fscOrderPo.setFscOrderIds(fscOrderIds);
        if (!StringUtils.isEmpty((Object)reqBO.getContractNo())) {
            fscOrderPo.setContractNo(reqBO.getContractNo());
        }
        log.debug("\u6210\u672c\u7cfb\u7edf\u56de\u8c03\u5bf9\u8d26\u5355\u67e5\u8be2\u5165\u53c2{}", (Object)fscOrderPo);
        List fscOrderPoList = this.fscOrderMapper.getList(fscOrderPo);
        log.debug("\u6210\u672c\u7cfb\u7edf\u56de\u8c03\u5bf9\u8d26\u5355\u67e5\u8be2\u51fa\u53c2{}", (Object)fscOrderPoList);
        if (fscOrderPoList.size() != fscOrderIds.size()) {
            log.debug("\u6210\u672c\u7cfb\u7edf\u56de\u8c03\u5bf9\u8d26\u5355\u67e5\u8be2\u51fa\u53c2\u4e0d\u4e00\u81f4{}", (Object)fscOrderPoList);
            throw new FscBusinessException("190000", "\u5bf9\u8d26\u5355\u96c6\u5408\u4e2d\u5b58\u5728\u6709\u5bf9\u8d26\u5355\u672a\u627e\u5230");
        }
        return fscOrderPoList;
    }

    private void dealCostHaveNotComPareToZeroBig(Date now, FscCostOrderPO fscCostOrderPo, BigDecimal money, FscCallMoneyPO fscCallMoneyPo, List<FscCallMoneyItemPO> fscCallMoneyItemPoList) {
        this.setNotFscOrder(money, now, fscCallMoneyPo, fscCallMoneyItemPoList);
        fscCostOrderPo.setRebateMoney(BigDecimal.ZERO);
        fscCostOrderPo.setTotalPay(money);
        fscCostOrderPo.setUpdateTime(now);
        fscCostOrderPo.setCreateTime(now);
        log.debug("\u9884\u5b58\u6b3e\u6ca1\u6709\u503c\uff0c\u65b0\u589e\u9884\u5b58\u6b3e\u4fe1\u606f{}", (Object)fscCostOrderPo);
        this.fscCostOrderMapper.insert(fscCostOrderPo);
    }

    private void dealCostHaveComPareToZeroLow(Date now, FscCostOrderPO modelBy, BigDecimal money, List<FscCallMoneyItemPO> fscCallMoneyItemPoList, FscCallMoneyPO fscCallMoneyPo) {
        this.setNotFscOrder(money, now, fscCallMoneyPo, fscCallMoneyItemPoList);
        FscCostOrderPO update = new FscCostOrderPO();
        update.setId(modelBy.getId());
        update.setUpdateTime(now);
        update.setTotalPay(money.add(modelBy.getTotalPay()));
        log.debug("\u9884\u5b58\u6b3e\u672a\u7528\u5b8c\u66f4\u65b0\u5df2\u6263\u91d1\u989d\u548c\u603b\u91d1\u989d\u5165\u53c2{}", (Object)update);
        this.fscCostOrderMapper.updateById(update);
    }

    private void dealCostHaveComPareToZeroBig(Date now, FscCostOrderPO modelBy, List<FscOrderPO> fscOrderPoList, BigDecimal advance, List<FscCallMoneyItemPO> fscCallMoneyItemPoList, FscCallMoneyPO fscCallMoneyPo) {
        log.debug("\u5b58\u5728\u9884\u5b58\u6b3e\uff0c\u4ed8\u6b3e\u540e\u5269\u4f59\u91d1\u989d\u7b49\u4e8e0,\u5e76\u4e14\u9884\u5b58\u6b3e\u91d1\u989d\u5927\u4e8e0\uff0c\u4f7f\u7528\u9884\u5b58\u6b3e\u4ed8\u6b3e");
        advance = this.delMoney(advance, fscOrderPoList, fscCallMoneyItemPoList, fscCallMoneyPo, now, FscConstants.CallMoneyPayType.FIRST_PAY);
        log.debug("\u5b58\u5728\u9884\u5b58\u6b3e\uff0c\u4ed8\u6b3e\u540e\u5269\u4f59\u91d1\u989d\u7b49\u4e8e0,\u5e76\u4e14\u9884\u5b58\u6b3e\u91d1\u989d\u5927\u4e8e0\uff0c\u4f7f\u7528\u9884\u5b58\u6b3e\u4ed8\u6b3e\u540e\u5269\u4f59\u91d1\u989d{}", (Object)advance);
        FscCostOrderPO update = new FscCostOrderPO();
        update.setId(modelBy.getId());
        update.setUpdateTime(now);
        BigDecimal rebateMoney = modelBy.getTotalPay().subtract(advance);
        log.debug("\u6263\u51cf\u91d1\u989d\u503c{}", (Object)rebateMoney);
        if (advance.compareTo(BigDecimal.ZERO) > 0) {
            log.debug("\u9884\u5b58\u6b3e\u672a\u7528\u5b8c\u66f4\u65b0\u5df2\u6263\u91d1\u989d");
        } else {
            log.debug("\u9884\u5b58\u6b3e\u5df2\u4f7f\u7528\u5b8c\u66f4\u65b0\u5df2\u6263\u91d1\u989d\u548c\u603b\u91d1\u989d");
        }
        update.setRebateMoney(rebateMoney);
        log.debug("\u9884\u5b58\u6b3e\u672a\u7528\u5b8c\u66f4\u65b0\u5df2\u6263\u91d1\u989d\u548c\u603b\u91d1\u989d\u5165\u53c2{}", (Object)update);
        this.fscCostOrderMapper.updateById(update);
    }

    private BigDecimal delMoney(BigDecimal money, List<FscOrderPO> fscOrderPoList, List<FscCallMoneyItemPO> fscCallMoneyItemPoList, FscCallMoneyPO fscCallMoneyPo, Date now, Integer callPayType) {
        log.debug("\u5f00\u59cb\u66f4\u65b0\u6210\u672c\u7cfb\u7edf\u4ed8\u6b3e\u6570\u636e");
        for (FscOrderPO orderPo : fscOrderPoList) {
            log.debug("\u5f00\u59cb\u66f4\u65b0\u6210\u672c\u7cfb\u7edf\u4ed8\u6b3e\u6570\u636e\u5faa\u73af\u5f00\u59cb{}", (Object)orderPo);
            FscCallMoneyItemPO fscCallMoneyItemPo = this.getFscCallMoneyItemPo(fscCallMoneyPo, now, orderPo, callPayType);
            if (FscConstants.CostPayState.PAYED.equals(orderPo.getCostPayState())) continue;
            FscOrderPO orderPoSet = new FscOrderPO();
            orderPoSet.setFscOrderId(orderPo.getFscOrderId());
            if (money.add(orderPo.getPayMoney()).compareTo(orderPo.getTotalCombinedPaymentCredit()) >= 0) {
                orderPoSet.setCostPayState(FscConstants.CostPayState.PAYED);
                orderPoSet.setPayMoney(orderPo.getTotalCombinedPaymentCredit());
                fscCallMoneyItemPo.setPayMoeny(money.subtract(money.add(orderPo.getPayMoney()).subtract(orderPo.getTotalCombinedPaymentCredit())));
                money = money.add(orderPo.getPayMoney()).subtract(orderPo.getTotalCombinedPaymentCredit());
            } else {
                fscCallMoneyItemPo.setPayMoeny(money);
                orderPoSet.setCostPayState(FscConstants.CostPayState.PART_PAY);
                orderPoSet.setPayMoney(money.add(orderPo.getPayMoney()));
                money = BigDecimal.ZERO;
            }
            fscCallMoneyItemPoList.add(fscCallMoneyItemPo);
            orderPo.setCostPayState(orderPoSet.getCostPayState());
            orderPo.setPayMoney(orderPoSet.getPayMoney());
            log.debug("\u5f00\u59cb\u66f4\u65b0\u6210\u672c\u7cfb\u7edf\u4ed8\u6b3e\u6570\u636e\u5165\u53c2{}", (Object)orderPoSet);
            this.fscOrderMapper.updateById(orderPoSet);
            if (money.compareTo(BigDecimal.ZERO) != 0) continue;
            break;
        }
        return money;
    }

    private FscCallMoneyItemPO getFscCallMoneyItemPo(FscCallMoneyPO fscCallMoneyPo, Date now, FscOrderPO orderPo, Integer callPayType) {
        FscCallMoneyItemPO fscCallMoneyItemPo = new FscCallMoneyItemPO();
        fscCallMoneyItemPo.setFscCallMoneyItemId(Long.valueOf(Sequence.getInstance().nextId()));
        fscCallMoneyItemPo.setFscCallMoneyId(fscCallMoneyPo.getFscCallMoneyId());
        fscCallMoneyItemPo.setCreateTime(now);
        fscCallMoneyItemPo.setFscOrderId(orderPo.getFscOrderId());
        fscCallMoneyItemPo.setCallMoneyPayType(callPayType);
        return fscCallMoneyItemPo;
    }
}

