/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscPayAttachmentMapper;
import com.tydic.fsc.dao.FscPayInfoMapper;
import com.tydic.fsc.dao.FscPayOrderInfoItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.FscDealDownPayConfirmBusiService;
import com.tydic.fsc.pay.busi.api.FscUpdateCashierDownPayItemStateBusiService;
import com.tydic.fsc.pay.busi.bo.FscDealDownPayConfirmBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscDealDownPayConfirmBusiRspBO;
import com.tydic.fsc.pay.busi.bo.FscUpdateCashierDownPayItemStateBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscUpdateCashierDownPayItemStateBusiRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscPayAttachmentPO;
import com.tydic.fsc.po.FscPayInfoPO;
import com.tydic.fsc.po.FscPayOrderInfoItemPO;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscDealDownPayConfirmBusiServiceImpl
implements FscDealDownPayConfirmBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscDealDownPayConfirmBusiServiceImpl.class);
    @Autowired
    private FscPayInfoMapper fscPayInfoMapper;
    @Autowired
    private FscPayOrderInfoItemMapper fscPayOrderInfoItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscUpdateCashierDownPayItemStateBusiService fscUpdateCashierDownPayItemStateBusiService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscPayAttachmentMapper fscPayAttachmentMapper;

    @Override
    public FscDealDownPayConfirmBusiRspBO dealDownPayConfirm(FscDealDownPayConfirmBusiReqBO busiReqBO) {
        Date date = new Date();
        List<FscOrderPO> fscOrderPoList = this.getIntegerListMap(busiReqBO);
        Map<Long, List<FscOrderPO>> fscOrderMap = fscOrderPoList.stream().collect(Collectors.groupingBy(FscOrderPO::getFscOrderId));
        for (Long fscOrderId : busiReqBO.getFscOrderIds()) {
            if (fscOrderMap.get(fscOrderId) == null) {
                log.debug("\u5bf9\u8d26\u5355id\u4e3a{}\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u8d26\u5355\u76f8\u5173\u4fe1\u606f", (Object)fscOrderId);
                throw new FscBusinessException("190000", "\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u8d26\u5355\u76f8\u5173\u4fe1\u606f");
            }
            FscOrderPO fscOrderPo = fscOrderMap.get(fscOrderId).get(0);
            if (FscConstants.FscServiceOrderState.PAYING.equals(fscOrderPo.getOrderState())) continue;
            log.debug("\u5bf9\u8d26\u5355\u5355id\u4e3a:{}\u4e0d\u5904\u4e8e\u5f85\u786e\u8ba4\u4ed8\u6b3e\u7684\u72b6\u6001", (Object)fscOrderId);
            throw new FscBusinessException("190000", "\u5bf9\u8d26\u5355\u53f7\u4e3a:" + fscOrderPo.getOrderNo() + "\u5df2\u7ecf\u786e\u8ba4\u4ed8\u6b3e");
        }
        FscOrderPO set = new FscOrderPO();
        set.setPayConfirmId(busiReqBO.getUserName());
        set.setPayConfirmName(busiReqBO.getName());
        set.setPayConfirmTime(date);
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderIds(busiReqBO.getFscOrderIds());
        this.fscOrderMapper.updateBy(set, where);
        List<FscPayInfoPO> paying = this.getFscPayInfoPoS(busiReqBO);
        if (CollectionUtils.isEmpty(paying)) {
            log.debug("\u67e5\u8be2\u786e\u8ba4\u652f\u4ed8\u5bf9\u8d26\u5355\u5bf9\u5e94\u7684\u4ed8\u6b3e\u5355\u636e\u51fa\u53c2\u4e3a\u7a7a{}", paying);
            throw new FscBusinessException("190000", "\u67e5\u8be2\u786e\u8ba4\u652f\u4ed8\u5bf9\u8d26\u5355\u5bf9\u5e94\u7684\u4ed8\u6b3e\u5355\u636e\u4e3a\u7a7a");
        }
        log.debug("\u67e5\u8be2\u786e\u8ba4\u652f\u4ed8\u5bf9\u8d26\u5355\u5bf9\u5e94\u7684\u4ed8\u6b3e\u5355\u636e\u51fa\u53c2\u4e0d\u4e3a\u7a7a{}", paying);
        List<Long> payOrderIds = paying.stream().map(FscPayInfoPO::getPayOrderId).collect(Collectors.toList());
        if (busiReqBO.getPayFlag().booleanValue()) {
            log.debug("\u652f\u4ed8\u786e\u8ba4\u4e3a\u5df2\u4ed8\u6b3e\u5f00\u59cb");
            this.updatePayInfo(payOrderIds, date, FscConstants.NewPayState.PAYED);
        } else {
            log.debug("\u652f\u4ed8\u786e\u8ba4\u4e3a\u672a\u4ed8\u6b3e\u5f00\u59cb");
            this.updatePayInfo(payOrderIds, date, FscConstants.NewPayState.PAY_FAIL);
            FscUpdateCashierDownPayItemStateBusiReqBO fscUpdateCashierDownPayItemStateBusiReqBo = new FscUpdateCashierDownPayItemStateBusiReqBO();
            fscUpdateCashierDownPayItemStateBusiReqBo.setPayObjectIds(busiReqBO.getFscOrderIds());
            log.debug("\u66f4\u65b0\u4ed8\u6b3e\u5355\u660e\u7ec6\u72b6\u6001\u5165\u53c2{}", (Object)fscUpdateCashierDownPayItemStateBusiReqBo);
            FscUpdateCashierDownPayItemStateBusiRspBO fscUpdateCashierDownPayItemStateBusiRspBO = this.fscUpdateCashierDownPayItemStateBusiService.updateCashierDownPayItemState(fscUpdateCashierDownPayItemStateBusiReqBo);
            log.debug("\u66f4\u65b0\u4ed8\u6b3e\u5355\u660e\u7ec6\u72b6\u6001\u51fa\u53c2{}", (Object)fscUpdateCashierDownPayItemStateBusiRspBO);
            if (!"0000".equals(fscUpdateCashierDownPayItemStateBusiRspBO.getRespCode())) {
                throw new FscBusinessException(fscUpdateCashierDownPayItemStateBusiRspBO.getRespCode(), fscUpdateCashierDownPayItemStateBusiRspBO.getRespDesc());
            }
        }
        this.updatePayItem(date, payOrderIds);
        this.invokeFscOrderStatusFlow(busiReqBO);
        if (StringUtils.isNotBlank((CharSequence)busiReqBO.getRemark())) {
            this.updateRemark(busiReqBO);
        }
        FscDealDownPayConfirmBusiRspBO fscDealDownPayConfirmBusiRspBO = new FscDealDownPayConfirmBusiRspBO();
        fscDealDownPayConfirmBusiRspBO.setRespCode("0000");
        fscDealDownPayConfirmBusiRspBO.setRespDesc("\u6210\u529f");
        return fscDealDownPayConfirmBusiRspBO;
    }

    private void updateRemark(FscDealDownPayConfirmBusiReqBO busiReqBO) {
        log.debug("\u4fee\u6539\u9644\u4ef6\u8868\u4e2d\u7684\u5907\u6ce8\u5f00\u59cb");
        FscPayAttachmentPO fscPayAttachmentSet = new FscPayAttachmentPO();
        fscPayAttachmentSet.setRemark(busiReqBO.getRemark());
        FscPayAttachmentPO fscPayAttachmentWhere = new FscPayAttachmentPO();
        fscPayAttachmentWhere.setPayOrderId(busiReqBO.getFscOrderIds().get(0));
        log.debug("\u4fee\u6539\u9644\u4ef6\u8868\u4e2d\u7684\u5907\u6ce8\u5f00\u59cb\u5165\u53c2where{}", (Object)fscPayAttachmentWhere);
        log.debug("\u4fee\u6539\u9644\u4ef6\u8868\u4e2d\u7684\u5907\u6ce8\u5f00\u59cb\u5165\u53c2Set{}", (Object)fscPayAttachmentSet);
        try {
            this.fscPayAttachmentMapper.updateBy(fscPayAttachmentSet, fscPayAttachmentWhere);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u9644\u8fd1\u8868\u4e2d\u7684\u5907\u6ce8\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new FscBusinessException("194202", "\u4fdd\u5b58\u5907\u6ce8\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void invokeFscOrderStatusFlow(FscDealDownPayConfirmBusiReqBO busiReqBO) {
        log.debug("\u6d41\u8f6c\u72b6\u6001\u5f00\u59cb");
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBo = new FscOrderStatusFlowAtomReqBO();
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        if (busiReqBO.getPayFlag().booleanValue()) {
            paramMap.put("payFlag", FscConstants.ProcessParam.payFlag1);
        } else {
            paramMap.put("payFlag", FscConstants.ProcessParam.payFlag0);
        }
        busiReqBO.getFscOrderIds().forEach(fscOrderId -> {
            fscOrderStatusFlowAtomReqBo.setOrderId(fscOrderId);
            fscOrderStatusFlowAtomReqBo.setParamMap(paramMap);
            log.debug("\u6d41\u8f6c\u72b6\u6001\u5165\u53c2{}", (Object)fscOrderStatusFlowAtomReqBo);
            FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBo);
            log.debug("\u6d41\u8f6c\u72b6\u6001\u51fa\u53c2{}", (Object)atomRspBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                log.debug("\u6d41\u8f6c\u72b6\u6001\u5931\u8d25");
                throw new FscBusinessException("194202", atomRspBO.getRespDesc());
            }
        });
    }

    private List<FscPayInfoPO> getFscPayInfoPoS(FscDealDownPayConfirmBusiReqBO busiReqBO) {
        FscPayInfoPO fscPayInfoPo = new FscPayInfoPO();
        fscPayInfoPo.setPayObjectIds(busiReqBO.getFscOrderIds());
        log.debug("\u67e5\u8be2\u786e\u8ba4\u652f\u4ed8\u5bf9\u8d26\u5355\u5bf9\u5e94\u7684\u4ed8\u6b3e\u5355\u636e\u5165\u53c2{}", (Object)fscPayInfoPo);
        fscPayInfoPo.setPayState(FscConstants.NewPayState.PAYED);
        List paying = this.fscPayInfoMapper.getListByPayObjectIdsPaying(fscPayInfoPo);
        log.debug("\u67e5\u8be2\u786e\u8ba4\u652f\u4ed8\u5bf9\u8d26\u5355\u5bf9\u5e94\u7684\u4ed8\u6b3e\u5355\u636e\u51fa\u53c2{}", (Object)paying);
        return paying;
    }

    private void updatePayItem(Date date, List<Long> payOrderIds) {
        log.debug("\u66f4\u65b0\u652f\u4ed8\u660e\u7ec6\u8868\u5f00\u59cb");
        FscPayOrderInfoItemPO fscPayOrderInfoItemPoWhere = new FscPayOrderInfoItemPO();
        fscPayOrderInfoItemPoWhere.setPayOrderIds(payOrderIds);
        FscPayOrderInfoItemPO fscPayOrderInfoItemPoSet = new FscPayOrderInfoItemPO();
        fscPayOrderInfoItemPoSet.setPayItemUpdateTime(date);
        log.debug("\u66f4\u65b0\u652f\u4ed8\u660e\u7ec6\u8868\u5f00\u59cb\u5165\u53c2where{}", (Object)fscPayOrderInfoItemPoWhere);
        log.debug("\u66f4\u65b0\u652f\u4ed8\u660e\u7ec6\u8868\u5f00\u59cb\u5165\u53c2Set{}", (Object)fscPayOrderInfoItemPoSet);
        this.fscPayOrderInfoItemMapper.updateBy(fscPayOrderInfoItemPoSet, fscPayOrderInfoItemPoWhere);
    }

    private List<FscOrderPO> getIntegerListMap(FscDealDownPayConfirmBusiReqBO busiReqBO) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderIds(busiReqBO.getFscOrderIds());
        List fscOrderPoList = this.fscOrderMapper.getList(fscOrderPo);
        if (CollectionUtils.isEmpty((Collection)fscOrderPoList)) {
            log.debug("\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u8d26\u5355\u76f8\u5173\u4fe1\u606f");
            throw new FscBusinessException("190000", "\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u8d26\u5355\u76f8\u5173\u4fe1\u606f");
        }
        return fscOrderPoList;
    }

    private void updatePayInfo(List<Long> payOrderIds, Date date, Integer payState) {
        log.debug("\u4fee\u6539\u4ed8\u6b3e\u5355\u72b6\u6001\u60c5\u5f00\u59cb");
        FscPayInfoPO fscPayInfoWherePo = new FscPayInfoPO();
        fscPayInfoWherePo.setPayOrderIds(payOrderIds);
        FscPayInfoPO fscPayInfoSetPo = new FscPayInfoPO();
        fscPayInfoSetPo.setPayUpdateTime(date);
        fscPayInfoSetPo.setPayState(payState);
        log.debug("\u4fee\u6539\u4ed8\u6b3e\u5355\u72b6\u6001\u5165\u53c2where{}", (Object)fscPayInfoWherePo);
        log.debug("\u4fee\u6539\u4ed8\u6b3e\u5355\u72b6\u6001\u5165\u53c2Set{}", (Object)fscPayInfoSetPo);
        int update = this.fscPayInfoMapper.updateBy(fscPayInfoSetPo, fscPayInfoWherePo);
        if (update < 1) {
            throw new FscBusinessException("190000", "\u4fee\u6539\u4ed8\u6b3e\u72b6\u6001\u5931\u8d25");
        }
    }
}

