/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.oc.service.saleorder.UocGetSaleOrderDetailExtService;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspBo;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocProOrderPaymentCallbackAbilityBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocProOrderPaymentCallbackAbilityReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocProOrderPaymentCallbackAbilityRspBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocProOrderPaymentCallbackAbilityService;
import com.tydic.fsc.common.ability.api.FscComErpPayOffAbilityService;
import com.tydic.fsc.common.ability.bo.FscComErpPayOffAbilityReqBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscLedgerInfoItemMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscPayInfoMapper;
import com.tydic.fsc.dao.FscPayOrderInfoItemMapper;
import com.tydic.fsc.dao.FscPayOrderMapper;
import com.tydic.fsc.dao.FscPayRelationMapper;
import com.tydic.fsc.dao.FscReceivableInfoMapper;
import com.tydic.fsc.dao.FscRefundFailureRecordMapper;
import com.tydic.fsc.dao.FscRefundInfoMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.FscPaySuccessCallBackOrderBO;
import com.tydic.fsc.pay.atom.api.FscDealPaySuccessAtomService;
import com.tydic.fsc.pay.atom.bo.FscDealPaySuccessAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscDealPaySuccessAtomRspBO;
import com.tydic.fsc.pay.busi.api.FscCreateRefundBusiService;
import com.tydic.fsc.pay.busi.api.FscDealRefundBusiService;
import com.tydic.fsc.pay.busi.api.FscPayBillCallbackBusiService;
import com.tydic.fsc.pay.busi.bo.FscCreateRefundBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscCreateRefundBusiRspBO;
import com.tydic.fsc.pay.busi.bo.FscDealRefundBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscDealRefundBusiRspBO;
import com.tydic.fsc.pay.busi.bo.FscPayBillCallbackBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayBillCallbackBusiRspBO;
import com.tydic.fsc.po.FscLedgerInfoItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscPayInfoPO;
import com.tydic.fsc.po.FscPayOrderInfoItemPO;
import com.tydic.fsc.po.FscPayOrderPO;
import com.tydic.fsc.po.FscPayRelationPO;
import com.tydic.fsc.po.FscReceivableInfoPO;
import com.tydic.fsc.po.FscRefundFailureRecordPO;
import com.tydic.fsc.po.FscRefundInfoPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.payment.bill.util.DateUtil;
import com.tydic.payment.pay.ability.PayProRefundAbilityService;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayBillCallbackBusiServiceImpl
implements FscPayBillCallbackBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillCallbackBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscPayInfoMapper fscPayInfoMapper;
    @Autowired
    private FscPayOrderInfoItemMapper fscPayOrderInfoItemMapper;
    @Autowired
    private FscUocProOrderPaymentCallbackAbilityService fscUocProOrderPaymentCallbackAbilityService;
    @Autowired
    private FscCreateRefundBusiService fscCreateRefundBusiService;
    @Autowired
    private FscDealRefundBusiService fscDealRefundBusiService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscLedgerInfoItemMapper fscLedgerInfoItemMapper;
    private static String SUCCESS = "SUCCESS";
    @Value(value="${sleepTime:3000}")
    private String sleepTime;
    @Value(value="${pay.center.busi.code:D500}")
    private String payBusiCode;
    @Value(value="${QRY_SALE_ORDER_URL:http://test1-lsugu.liando.cn:9191/dyc/saas/self/noauth/order/qrySalOrderDetail}")
    private String qrySaleOrderUrl;
    @Autowired
    private FscPayOrderMapper fscPayOrderMapper;
    @Autowired
    private FscPayRelationMapper fscPayRelationMapper;
    @Autowired
    private FscDealPaySuccessAtomService fscDealPaySuccessAtomService;
    @Autowired
    private FscComErpPayOffAbilityService fscComErpPayOffAbilityService;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private PayProRefundAbilityService payProRefundAbilityService;
    @Autowired
    private FscRefundFailureRecordMapper fscRefundFailureRecordMapper;
    @Autowired
    private FscRefundInfoMapper fscRefundInfoMapper;
    @Value(value="${isNewPay:false}")
    private Boolean isNewPay;
    @Autowired
    private UocGetSaleOrderDetailExtService uocGetSaleOrderDetailExtService;
    @Autowired
    private FscReceivableInfoMapper fscReceivableInfoMapper;

    @Override
    public FscPayBillCallbackBusiRspBO dealPayBillCallback(FscPayBillCallbackBusiReqBO busiReqBO) {
        if (this.isNewPay.booleanValue()) {
            FscPayBillCallbackBusiRspBO fscPayBillCallbackBusiRspBo;
            block21: {
                fscPayBillCallbackBusiRspBo = new FscPayBillCallbackBusiRspBO();
                try {
                    log.debug("\u652f\u4ed8\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u5f00\u59cb");
                    this.sleep();
                    Date date = new Date();
                    Long payOrderId = Long.valueOf(busiReqBO.getFscPayCallbackContentBO().getOutOrderId());
                    FscPayInfoPO fscPayInfoModelBy = this.getFscPayInfoPO(payOrderId);
                    List<FscPayOrderInfoItemPO> fscPayOrderInfoItemList = this.getFscPayOrderInfoItemPOS(payOrderId);
                    Map<Long, List<FscPayOrderInfoItemPO>> fscPayOrderInfoItemPoMap = fscPayOrderInfoItemList.stream().collect(Collectors.groupingBy(FscPayOrderInfoItemPO::getPayObjectId));
                    if (SUCCESS.equals(busiReqBO.getFscPayCallbackContentBO().getResultCode())) {
                        if (FscConstants.NewPayMethod.DOWN.toString().equals(busiReqBO.getFscPayCallbackContentBO().getPayMethod())) {
                            List<FscPayOrderInfoItemPO> fscPayOrderInfoItemListSucess = this.getFscPayOrderInfoItemPoListNotPay(payOrderId);
                            this.downPay(busiReqBO, fscPayBillCallbackBusiRspBo, fscPayOrderInfoItemListSucess, fscPayInfoModelBy);
                            if (FscConstants.PayObjectType.ORDER.equals(fscPayOrderInfoItemList.get(0).getPayObjectType())) {
                                this.dealNeedPay(busiReqBO, date, fscPayOrderInfoItemList, fscPayBillCallbackBusiRspBo);
                            }
                            return fscPayBillCallbackBusiRspBo;
                        }
                        if (!FscConstants.NewPayChannel.DOWN.equals(busiReqBO.getFscPayCallbackContentBO().getPaymentInsId())) {
                            this.upPay(busiReqBO, fscPayBillCallbackBusiRspBo, date, payOrderId, fscPayInfoModelBy, fscPayOrderInfoItemList, fscPayOrderInfoItemPoMap);
                            if (FscConstants.PayObjectType.ORDER.equals(fscPayOrderInfoItemList.get(0).getPayObjectType())) {
                                this.dealNeedPay(busiReqBO, date, fscPayOrderInfoItemList, fscPayBillCallbackBusiRspBo);
                            }
                            return fscPayBillCallbackBusiRspBo;
                        }
                        break block21;
                    }
                    this.payFail(busiReqBO, fscPayBillCallbackBusiRspBo, date, payOrderId, fscPayOrderInfoItemList, fscPayInfoModelBy);
                    return fscPayBillCallbackBusiRspBo;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            fscPayBillCallbackBusiRspBo.setRespCode("0000");
            fscPayBillCallbackBusiRspBo.setRespDesc("\u6210\u529f");
            return fscPayBillCallbackBusiRspBo;
        }
        FscPayRelationPO fscPayRelationPoModel = new FscPayRelationPO();
        fscPayRelationPoModel.setPayOrderId(Long.valueOf(busiReqBO.getFscPayCallbackContentBO().getOutOrderId()));
        FscPayRelationPO fscPayRelationMapperModelBySelect = this.fscPayRelationMapper.getModelBy(fscPayRelationPoModel);
        if (fscPayRelationMapperModelBySelect == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u652f\u4ed8\u5173\u7cfb\u4e3a\u7a7a");
        }
        FscOrderPayItemPO fscOrderPayItemPoModel = new FscOrderPayItemPO();
        fscOrderPayItemPoModel.setFscOrderId(fscPayRelationMapperModelBySelect.getFscOrderId());
        List fscOrderPayItemMapperModelBy = this.fscOrderPayItemMapper.getList(fscOrderPayItemPoModel);
        if (CollectionUtils.isEmpty((Collection)fscOrderPayItemMapperModelBy)) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u652f\u4ed8\u5173\u7cfb\u660e\u7ec6\u4e3a\u7a7a");
        }
        FscShouldPayPO fscShouldPayPoModel = new FscShouldPayPO();
        fscShouldPayPoModel.setShouldPayId(((FscOrderPayItemPO)fscOrderPayItemMapperModelBy.get(0)).getShouldPayId());
        FscShouldPayPO fscShouldPayMapperModel = this.fscShouldPayMapper.getModelBy(fscShouldPayPoModel);
        if (fscShouldPayMapperModel == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5e94\u4ed8\u4fe1\u606f\u4e3a\u7a7a");
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(fscPayRelationMapperModelBySelect.getFscOrderId());
        FscOrderPO fscOrderPoModel = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (fscOrderPoModel == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u4ed8\u6b3e\u7ed3\u7b97\u5355\u4e3a\u7a7a");
        }
        if (FscConstants.ShouldObjectType.ORDER_SHOULD.equals(fscShouldPayMapperModel.getShouldPayType())) {
            log.debug("\u5224\u65ad\u662f\u5426\u5df2\u53d6\u6d88\u8ba2\u5355\u5f00\u59cb\u4e86");
            HashMap<String, String> content = new HashMap<String, String>(2);
            content.put("saleOrderId", fscShouldPayMapperModel.getObjectId().toString());
            content.put("orderId", fscShouldPayMapperModel.getOrderId().toString());
            log.debug("\u5224\u65ad\u662f\u5426\u5df2\u53d6\u6d88\u8ba2\u5355\u5165\u53c2{}", (Object)(this.qrySaleOrderUrl + JSONObject.toJSONString(content)));
            String resultData = HttpUtil.post((String)this.qrySaleOrderUrl, (String)JSONObject.toJSONString(content));
            log.debug("\u5224\u65ad\u662f\u5426\u5df2\u53d6\u6d88\u8ba2\u5355\u51fa\u53c2{}", (Object)resultData);
            if (!StringUtils.isEmpty((CharSequence)resultData)) {
                JSONObject jsonObject = JSONObject.parseObject((String)resultData);
                Object code = jsonObject.get((Object)"code");
                if (!"0".equals(code)) {
                    throw new FscBusinessException("190000", jsonObject.get((Object)"message").toString());
                }
                JSONObject data = (JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString((Object)jsonObject.get((Object)"data")), JSONObject.class);
                Object saleOrderState = data.get((Object)"saleOrderState");
                if ("XS_QX_QX".equals(saleOrderState)) {
                    FscCreateRefundBusiRspBO refund = this.getFscCreateRefundBusiRspBO(fscShouldPayMapperModel, fscOrderPoModel);
                    this.payRefund(busiReqBO, refund);
                }
            } else {
                throw new FscBusinessException("190000", "\u67e5\u8be2\u9500\u552e\u5355\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        Long payOrderId = Long.parseLong(busiReqBO.getFscPayCallbackContentBO().getOutOrderId());
        this.updatePayOrder(payOrderId, busiReqBO);
        this.updateMainOrder(busiReqBO, payOrderId);
        List<Long> payFscOrderId = this.getFscOrderId(payOrderId);
        List<Long> temp = this.updateFscOrderOrOrder(payFscOrderId, busiReqBO);
        ArrayList<Long> resultFscOrderIds = new ArrayList<Long>(payFscOrderId);
        if (!CollectionUtils.isEmpty(temp)) {
            resultFscOrderIds.addAll(temp);
        }
        FscOrderPO set = new FscOrderPO();
        set.setPayOperId(busiReqBO.getFscPayCallbackContentBO().getCreateOperId());
        set.setPayOperName(busiReqBO.getFscPayCallbackContentBO().getCreatOperName());
        set.setPayTime(DateUtil.strToDateyyyyMMddHHmmss((String)busiReqBO.getFscPayCallbackContentBO().getTradeTime()));
        set.setTransactionId(busiReqBO.getFscPayCallbackContentBO().getPayNotifyTransId());
        set.setUpdateTime(new Date());
        set.setPayState(FscConstants.PayStatus.PAYED);
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderIds(payFscOrderId);
        this.fscOrderMapper.updateBy(set, where);
        FscPayBillCallbackBusiRspBO busiRspBO = new FscPayBillCallbackBusiRspBO();
        busiRspBO.setResultFscOrderIds(resultFscOrderIds);
        ArrayList<FscPaySuccessCallBackOrderBO> fscPaySuccessCallBackOrderBoS = new ArrayList<FscPaySuccessCallBackOrderBO>();
        FscPaySuccessCallBackOrderBO fscPaySuccessCallBackOrderBO = new FscPaySuccessCallBackOrderBO();
        fscPaySuccessCallBackOrderBO.setObjectId(fscShouldPayMapperModel.getObjectId());
        fscPaySuccessCallBackOrderBO.setOrderId(fscShouldPayMapperModel.getOrderId());
        if (!StringUtils.isBlank((CharSequence)busiReqBO.getFscPayCallbackContentBO().getResultCode()) && "FAIL".equals(busiReqBO.getFscPayCallbackContentBO().getResultCode())) {
            fscPaySuccessCallBackOrderBO.setPayResult(Boolean.valueOf(false));
        } else if (!StringUtils.isBlank((CharSequence)busiReqBO.getFscPayCallbackContentBO().getResultCode()) && "SUCCESS".equals(busiReqBO.getFscPayCallbackContentBO().getResultCode())) {
            fscPaySuccessCallBackOrderBO.setPayResult(Boolean.valueOf(true));
        }
        fscPaySuccessCallBackOrderBoS.add(fscPaySuccessCallBackOrderBO);
        busiRspBO.setFscPaySuccessCallBackOrderBOList(fscPaySuccessCallBackOrderBoS);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u652f\u4ed8\u56de\u8c03\u6210\u529f");
        return busiRspBO;
    }

    private void dealNeedPay(FscPayBillCallbackBusiReqBO busiReqBO, Date date, List<FscPayOrderInfoItemPO> fscPayOrderInfoItemList, FscPayBillCallbackBusiRspBO fscPayBillCallbackBusiRspBo) {
        UocGetSaleOrderDetailServiceReqBo uocGetSaleOrderDetailServiceReqBo = new UocGetSaleOrderDetailServiceReqBo();
        uocGetSaleOrderDetailServiceReqBo.setOrderId(fscPayOrderInfoItemList.get(0).getOrderId());
        uocGetSaleOrderDetailServiceReqBo.setSaleOrderId(fscPayOrderInfoItemList.get(0).getPayObjectId());
        log.debug("\u4fee\u6539\u5e94\u6536\u4ed8\u6b3e\u65b9\u5f0f\u5b57\u6bb5\u53ca\u6d41\u6c34\u53f7\u67e5\u8be2\u7236\u5355\u4fe1\u606f\u5165\u53c2{}", (Object)uocGetSaleOrderDetailServiceReqBo);
        UocGetSaleOrderDetailServiceRspBo saleOrderDetail = this.uocGetSaleOrderDetailExtService.getSaleOrderDetail(uocGetSaleOrderDetailServiceReqBo);
        log.debug("\u4fee\u6539\u5e94\u6536\u4ed8\u6b3e\u65b9\u5f0f\u5b57\u6bb5\u53ca\u6d41\u6c34\u53f7\u67e5\u8be2\u7236\u5355\u4fe1\u606f\u51fa\u53c2{}", (Object)uocGetSaleOrderDetailServiceReqBo);
        if (saleOrderDetail == null) {
            throw new FscBusinessException("190000", "\u5f02\u6b65\u4fee\u6539\u5e94\u6536\u4ed8\u6b3e\u65b9\u5f0f\u5b57\u6bb5\u53ca\u6d41\u6c34\u53f7\u67e5\u8be2\u7236\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (saleOrderDetail.getUpperOrderId() == null) {
            throw new FscBusinessException("190000", "\u5f02\u6b65\u4fee\u6539\u5e94\u6536\u4ed8\u6b3e\u65b9\u5f0f\u5b57\u6bb5\u53ca\u6d41\u6c34\u53f7\u67e5\u8be2\u7236\u5355\u4fe1\u606f\u7684\u7236\u5355ID\u4e3a\u7a7a");
        }
        FscReceivableInfoPO fscReceivableInfoPo = new FscReceivableInfoPO();
        fscReceivableInfoPo.setParentSaleOrderId(saleOrderDetail.getUpperOrderId());
        fscReceivableInfoPo.setPayOrderType(FscConstants.PayOrderTypeInfo.FIRST);
        FscReceivableInfoPO modelBy = this.fscReceivableInfoMapper.getModelBy(fscReceivableInfoPo);
        if (modelBy != null && !FscConstants.ReceivablePayState.DEL.equals(modelBy.getPayState())) {
            if (FscConstants.payOrderChannel.PAY_DOWN.toString().equals(busiReqBO.getFscPayCallbackContentBO().getPayMethod())) {
                FscReceivableInfoPO fscReceivableInfoPoSet = new FscReceivableInfoPO();
                fscReceivableInfoPoSet.setUpdateTime(date);
                fscReceivableInfoPoSet.setExtends5(FscConstants.NewPayMethod.DOWN.toString());
                FscReceivableInfoPO fscReceivableInfoPoWhere = new FscReceivableInfoPO();
                fscReceivableInfoPoWhere.setFscReceivableId(modelBy.getFscReceivableId());
                this.fscReceivableInfoMapper.updateBy(fscReceivableInfoPoSet, fscReceivableInfoPoWhere);
            } else {
                FscReceivableInfoPO fscReceivableInfoPoSet = new FscReceivableInfoPO();
                fscReceivableInfoPoSet.setUpdateTime(date);
                fscReceivableInfoPoSet.setExtends5(FscConstants.payOrderChannel.PAY_UP.toString());
                if (FscConstants.NewPayChannel.YBPAY.equals(busiReqBO.getFscPayCallbackContentBO().getPaymentInsId())) {
                    fscReceivableInfoPoSet.setExtends8("201");
                }
                if (FscConstants.NewPayChannel.WO.equals(busiReqBO.getFscPayCallbackContentBO().getPaymentInsId())) {
                    fscReceivableInfoPoSet.setExtends8("502");
                }
                fscReceivableInfoPoSet.setExtends7(busiReqBO.getFscPayCallbackContentBO().getPayNotifyTransId());
                FscReceivableInfoPO fscReceivableInfoPoWhere = new FscReceivableInfoPO();
                fscReceivableInfoPoWhere.setFscReceivableId(modelBy.getFscReceivableId());
                this.fscReceivableInfoMapper.updateBy(fscReceivableInfoPoSet, fscReceivableInfoPoWhere);
            }
            fscPayBillCallbackBusiRspBo.setPayOrderType(modelBy.getPayOrderType());
            fscPayBillCallbackBusiRspBo.setOrderShouldPayId(Long.valueOf(modelBy.getExtends1()));
            fscPayBillCallbackBusiRspBo.setSaleOrderId(modelBy.getParentSaleOrderId());
        } else {
            fscPayBillCallbackBusiRspBo.setPayOrderType(null);
            fscPayBillCallbackBusiRspBo.setOrderShouldPayId(null);
            fscPayBillCallbackBusiRspBo.setSaleOrderId(null);
        }
        log.debug("\u4fee\u6539\u5e94\u6536\u4ed8\u6b3e\u65b9\u5f0f\u5b57\u6bb5\u53ca\u6d41\u6c34\u53f7\u67e5\u8be2\u65b9\u6cd5\u51fa\u53c2{}", (Object)fscPayBillCallbackBusiRspBo);
    }

    private void payFail(FscPayBillCallbackBusiReqBO busiReqBO, FscPayBillCallbackBusiRspBO fscPayBillCallbackBusiRspBo, Date date, Long payOrderId, List<FscPayOrderInfoItemPO> fscPayOrderInfoItemList, FscPayInfoPO fscPayInfoModelBy) {
        log.debug("\u4ed8\u6b3e\u5931\u8d25\u573a\u666f");
        this.updatePayInfo(payOrderId, date, FscConstants.NewPayState.PAY_FAIL, busiReqBO);
        this.updatePayInfoItem(payOrderId, date, FscConstants.NewPayState.PAY_FAIL);
        this.orderFail(busiReqBO, fscPayBillCallbackBusiRspBo, fscPayOrderInfoItemList, fscPayInfoModelBy);
        fscPayBillCallbackBusiRspBo.setRespCode("0000");
        fscPayBillCallbackBusiRspBo.setRespDesc("\u6210\u529f");
    }

    private void orderFail(FscPayBillCallbackBusiReqBO busiReqBO, FscPayBillCallbackBusiRspBO fscPayBillCallbackBusiRspBo, List<FscPayOrderInfoItemPO> fscPayOrderInfoItemList, FscPayInfoPO fscPayInfoModelBy) {
        if (FscConstants.PayObjectType.ORDER.equals(fscPayOrderInfoItemList.get(0).getPayObjectType())) {
            log.debug("\u8ba2\u5355\u4ed8\u6b3e\u5931\u8d25\u53c2\u6570\u7ec4\u88c5");
            List<FscPaySuccessCallBackOrderBO> fscPaySuccessCallBackOrderBoS = this.getFscPaySuccessCallBackOrderBOS(busiReqBO, fscPayOrderInfoItemList, fscPayInfoModelBy);
            log.debug("\u8ba2\u5355\u4ed8\u6b3e\u5931\u8d25\u53c2\u6570\u7ec4\u88c5\u7ed3\u679c{}", fscPaySuccessCallBackOrderBoS);
            fscPayBillCallbackBusiRspBo.setFscPaySuccessCallBackOrderBOList(fscPaySuccessCallBackOrderBoS);
        }
    }

    private void upPay(FscPayBillCallbackBusiReqBO busiReqBO, FscPayBillCallbackBusiRspBO fscPayBillCallbackBusiRspBo, Date date, Long payOrderId, FscPayInfoPO fscPayInfoModelBy, List<FscPayOrderInfoItemPO> fscPayOrderInfoItemList, Map<Long, List<FscPayOrderInfoItemPO>> fscPayOrderInfoItemPoMap) {
        List<FscPayInfoPO> payObjectBoList;
        this.updatePayInfo(payOrderId, date, FscConstants.NewPayState.PAYED, busiReqBO);
        this.updatePayInfoItem(payOrderId, date, FscConstants.NewPayState.PAYED);
        if (FscConstants.PayObjectType.ORDER.equals(fscPayOrderInfoItemList.get(0).getPayObjectType())) {
            this.orderCancle(busiReqBO, fscPayBillCallbackBusiRspBo, date, payOrderId, fscPayInfoModelBy, fscPayOrderInfoItemList);
        }
        if (!CollectionUtils.isEmpty(payObjectBoList = this.getFscPayInfoPoS(payOrderId, fscPayOrderInfoItemList))) {
            this.TwicePay(busiReqBO, date, payOrderId, fscPayInfoModelBy, fscPayOrderInfoItemList);
            log.debug("\u8fdb\u5165\u67e5\u8be2\u660e\u7ec6\u4e2d\u5df2\u7ecf\u6709\u652f\u4ed8\u6210\u529f\u7684\u660e\u7ec6\u6210\u529f\u4e86");
        } else if (FscConstants.PayObjectType.ORDER.equals(fscPayOrderInfoItemList.get(0).getPayObjectType())) {
            this.orderSucess(busiReqBO, fscPayBillCallbackBusiRspBo, date, payOrderId, fscPayInfoModelBy, fscPayOrderInfoItemList);
        } else if (FscConstants.PayObjectType.FSC.equals(fscPayOrderInfoItemList.get(0).getPayObjectType())) {
            this.fscSucess(busiReqBO, fscPayBillCallbackBusiRspBo, date, payOrderId, fscPayOrderInfoItemList, fscPayOrderInfoItemPoMap);
        } else if (FscConstants.PayObjectType.SERVICE.equals(fscPayOrderInfoItemList.get(0).getPayObjectType()) || FscConstants.PayObjectType.PLATFORM.equals(fscPayOrderInfoItemList.get(0).getPayObjectType())) {
            this.servicePay(busiReqBO, fscPayBillCallbackBusiRspBo, date, payOrderId, fscPayOrderInfoItemList);
        }
    }

    private void servicePay(FscPayBillCallbackBusiReqBO busiReqBO, FscPayBillCallbackBusiRspBO fscPayBillCallbackBusiRspBo, Date date, Long payOrderId, List<FscPayOrderInfoItemPO> fscPayOrderInfoItemList) {
        log.debug("\u670d\u52a1\u8d39\u4ed8\u6b3e\u56de\u8c03\u5f00\u59cb");
        Map<Integer, List<FscOrderPO>> collectMap = this.getIntegerListMap(fscPayOrderInfoItemList);
        List<FscOrderPO> fscOrderPayingPoS = collectMap.get(FscConstants.FscServiceOrderState.PAYING);
        log.debug("\u4ed8\u6b3e\u5904\u7406\u4e2d\u7684\u6570\u636e" + fscOrderPayingPoS);
        List<FscOrderPO> fscOrderNotPayPoS = collectMap.get(FscConstants.FscServiceOrderState.NOT_SERVICE_PAYING);
        log.debug("\u5f85\u4ed8\u6b3e\u7684\u6570\u636e" + fscOrderNotPayPoS);
        if (CollectionUtils.isEmpty(fscOrderPayingPoS) ? fscOrderNotPayPoS.size() != fscPayOrderInfoItemList.size() : (CollectionUtils.isEmpty(fscOrderNotPayPoS) ? fscOrderPayingPoS.size() != fscPayOrderInfoItemList.size() : fscOrderPayingPoS.size() + fscOrderNotPayPoS.size() != fscPayOrderInfoItemList.size())) {
            throw new FscBusinessException("190000", "\u4ed8\u6b3e\u6570\u91cf\u4e8e\u5f53\u524d\u4ed8\u6b3e\u72b6\u6001\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u8bd5");
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag0);
        this.invokeFscOrderStatusFlow(fscPayOrderInfoItemList, paramMap);
        List<Long> collect = fscPayOrderInfoItemList.stream().map(FscPayOrderInfoItemPO::getPayObjectId).collect(Collectors.toList());
        fscPayBillCallbackBusiRspBo.setServiceFeeFscOrderIdList(collect);
        fscPayBillCallbackBusiRspBo.setRespCode("0000");
        fscPayBillCallbackBusiRspBo.setRespDesc("\u6210\u529f");
    }

    private void fscSucess(FscPayBillCallbackBusiReqBO busiReqBO, FscPayBillCallbackBusiRspBO fscPayBillCallbackBusiRspBo, Date date, Long payOrderId, List<FscPayOrderInfoItemPO> fscPayOrderInfoItemList, Map<Long, List<FscPayOrderInfoItemPO>> fscPayOrderInfoItemPoMap) {
        log.debug("\u5bf9\u8d26\u5355\u4ed8\u6b3e\u56de\u8c03\u5f00\u59cb");
        HashMap paramMap = new HashMap();
        Map<Integer, List<FscOrderPO>> collect = this.getIntegerListMap(fscPayOrderInfoItemList);
        List<FscOrderPO> fscOrderPayingPoS = collect.get(FscConstants.FscServiceOrderState.PAYING);
        log.debug("\u4ed8\u6b3e\u5904\u7406\u4e2d\u7684\u6570\u636e" + fscOrderPayingPoS);
        List<FscOrderPO> fscOrderNotPayPoS = collect.get(FscConstants.FscServiceOrderState.NOT_PAYING);
        log.debug("\u5f85\u4ed8\u6b3e\u7684\u6570\u636e" + fscOrderNotPayPoS);
        if (CollectionUtils.isEmpty(fscOrderPayingPoS) ? fscOrderNotPayPoS.size() != fscPayOrderInfoItemList.size() : (CollectionUtils.isEmpty(fscOrderNotPayPoS) ? fscOrderPayingPoS.size() != fscPayOrderInfoItemList.size() : fscOrderPayingPoS.size() + fscOrderNotPayPoS.size() != fscPayOrderInfoItemList.size())) {
            throw new FscBusinessException("190000", "\u4ed8\u6b3e\u6570\u91cf\u4e0e\u5f53\u524d\u4ed8\u6b3e\u72b6\u6001\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u8bd5");
        }
        ArrayList<FscPayOrderInfoItemPO> fscPayOrderInfoItemPoS = new ArrayList<FscPayOrderInfoItemPO>();
        if (!CollectionUtils.isEmpty(fscOrderPayingPoS)) {
            fscOrderPayingPoS.forEach(fscOrderPoPaying -> fscPayOrderInfoItemPoS.add((FscPayOrderInfoItemPO)((List)fscPayOrderInfoItemPoMap.get(fscOrderPoPaying.getFscOrderId())).get(0)));
        }
        if (!CollectionUtils.isEmpty(fscOrderNotPayPoS)) {
            fscOrderNotPayPoS.forEach(fscOrderNotPay -> {
                this.invokeFscOrderStatusFlow(fscPayOrderInfoItemList, paramMap);
                fscPayOrderInfoItemPoS.add((FscPayOrderInfoItemPO)((List)fscPayOrderInfoItemPoMap.get(fscOrderNotPay.getFscOrderId())).get(0));
            });
        }
        fscPayBillCallbackBusiRspBo.setFscPayOrderInfoItemList(fscPayOrderInfoItemPoS);
        this.sleep();
        fscPayBillCallbackBusiRspBo.setRespCode("0000");
        fscPayBillCallbackBusiRspBo.setRespDesc("\u6210\u529f");
    }

    private void orderSucess(FscPayBillCallbackBusiReqBO busiReqBO, FscPayBillCallbackBusiRspBO fscPayBillCallbackBusiRspBo, Date date, Long payOrderId, FscPayInfoPO fscPayInfoModelBy, List<FscPayOrderInfoItemPO> fscPayOrderInfoItemList) {
        log.debug("\u53cd\u9988\u8ba2\u5355\u4e3a\u6210\u529f");
        List<FscPaySuccessCallBackOrderBO> fscPaySuccessCallBackOrderBoS = this.getFscPaySuccessCallBackOrderBOS(busiReqBO, fscPayOrderInfoItemList, fscPayInfoModelBy);
        log.debug("\u8ba2\u5355\u4ed8\u6b3e\u6210\u529f\u53c2\u6570\u7ec4\u88c5\u7ed3\u679c{}", fscPaySuccessCallBackOrderBoS);
        fscPayBillCallbackBusiRspBo.setFscPaySuccessCallBackOrderBOList(fscPaySuccessCallBackOrderBoS);
        if (!FscConstants.PayOrderTypeInfo.BALANCE.equals(fscPayInfoModelBy.getPayOrderType())) {
            this.updateOrderPayState(busiReqBO, fscPayInfoModelBy, fscPayOrderInfoItemList);
        }
    }

    private void TwicePay(FscPayBillCallbackBusiReqBO busiReqBO, Date date, Long payOrderId, FscPayInfoPO fscPayInfoModelBy, List<FscPayOrderInfoItemPO> fscPayOrderInfoItemList) {
        log.debug("\u8fdb\u5165\u67e5\u8be2\u660e\u7ec6\u4e2d\u5df2\u7ecf\u6709\u652f\u4ed8\u6210\u529f\u7684\u660e\u7ec6\uff0c\u9000\u6b3e");
        BigDecimal refundMoney = BigDecimal.ZERO;
        for (FscPayOrderInfoItemPO fscPayOrderInfoItemPo : fscPayOrderInfoItemList) {
            FscCreateRefundBusiRspBO refund = this.createRefund(fscPayOrderInfoItemPo, fscPayInfoModelBy);
            if (refund == null || !"0000".equals(refund.getRespCode())) continue;
            refundMoney = this.dealRefund(refundMoney, refund, payOrderId);
        }
        this.updatePayInfoRepeated(date, payOrderId, fscPayInfoModelBy, refundMoney, FscConstants.NewPayState.CONSOLIDATED_PAY, busiReqBO);
        this.updatePayInfoItem(payOrderId, date, FscConstants.NewPayState.CONSOLIDATED_PAY);
        log.debug("\u8fdb\u5165\u67e5\u8be2\u660e\u7ec6\u4e2d\u5df2\u7ecf\u6709\u652f\u4ed8\u6210\u529f\u7684\u660e\u7ec6\u51fa\u5165\u4e86");
    }

    private void orderCancle(FscPayBillCallbackBusiReqBO busiReqBO, FscPayBillCallbackBusiRspBO fscPayBillCallbackBusiRspBo, Date date, Long payOrderId, FscPayInfoPO fscPayInfoModelBy, List<FscPayOrderInfoItemPO> fscPayOrderInfoItemList) {
        log.debug("\u8fdb\u5165\u67e5\u8be2\u8ba2\u5355\u662f\u5426\u5df2\u7ecf\u53d6\u6d88");
        AtomicReference<Boolean> f = new AtomicReference<Boolean>(false);
        for (FscPayOrderInfoItemPO fscPayOrderInfoItemPo : fscPayOrderInfoItemList) {
            if (this.getOrderState(f, fscPayOrderInfoItemPo)) break;
        }
        if (f.get().booleanValue()) {
            log.debug("\u8fdb\u5165\u67e5\u8be2\u8ba2\u5355\u5df2\u7ecf\u53d6\u6d88\uff0c\u9000\u6b3e");
            BigDecimal refundMoney = BigDecimal.ZERO;
            for (FscPayOrderInfoItemPO fscPayOrderInfoItemPo : fscPayOrderInfoItemList) {
                FscCreateRefundBusiRspBO refund = this.createRefund(fscPayOrderInfoItemPo, fscPayInfoModelBy);
                if (refund == null || !"0000".equals(refund.getRespCode())) continue;
                refundMoney = this.dealRefund(refundMoney, refund, payOrderId);
            }
            this.updatePayInfoRepeated(date, payOrderId, fscPayInfoModelBy, refundMoney, FscConstants.NewPayState.ORDER_CHANL, busiReqBO);
            this.updatePayInfoItem(payOrderId, date, FscConstants.NewPayState.ORDER_CHANL);
            fscPayBillCallbackBusiRspBo.setRespCode("0000");
            fscPayBillCallbackBusiRspBo.setRespDesc("\u6210\u529f");
        }
    }

    private void downPay(FscPayBillCallbackBusiReqBO busiReqBO, FscPayBillCallbackBusiRspBO fscPayBillCallbackBusiRspBo, List<FscPayOrderInfoItemPO> fscPayOrderInfoItemList, FscPayInfoPO fscPayInfoModelBy) {
        log.debug("\u8fdb\u5165\u5f53\u524d\u652f\u4ed8\u5355\u4e3a\u5df2\u652f\u4ed8");
        if (FscConstants.PayObjectType.ORDER.equals(fscPayOrderInfoItemList.get(0).getPayObjectType())) {
            log.debug("\u8fdb\u5165\u5f53\u524d\u652f\u4ed8\u5355\u4e3a\u5df2\u652f\u4ed8\u8ba2\u5355");
            List<FscPaySuccessCallBackOrderBO> fscPaySuccessCallBackOrderBoS = this.getFscPaySuccessCallBackOrderBOS(busiReqBO, fscPayOrderInfoItemList, fscPayInfoModelBy);
            log.debug("\u8ba2\u5355\u4ed8\u6b3e\u6210\u529f\u53c2\u6570\u7ec4\u88c5\u7ed3\u679c{}", fscPaySuccessCallBackOrderBoS);
            fscPayBillCallbackBusiRspBo.setFscPaySuccessCallBackOrderBOList(fscPaySuccessCallBackOrderBoS);
            fscPayBillCallbackBusiRspBo.setRespCode("0000");
            fscPayBillCallbackBusiRspBo.setRespDesc("\u6210\u529f");
        } else {
            fscPayBillCallbackBusiRspBo.setRespCode("0000");
            fscPayBillCallbackBusiRspBo.setRespDesc("\u6210\u529f");
        }
    }

    private void invokeFscOrderStatusFlow(List<FscPayOrderInfoItemPO> fscPayOrderInfoItemList, Map<String, Object> paramMap) {
        log.debug("\u6d41\u8f6c\u72b6\u6001\u5f00\u59cb");
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBo = new FscOrderStatusFlowAtomReqBO();
        fscPayOrderInfoItemList.forEach(fscPayOrderInfoItemPo -> {
            fscOrderStatusFlowAtomReqBo.setOrderId(fscPayOrderInfoItemPo.getPayObjectId());
            fscOrderStatusFlowAtomReqBo.setParamMap(paramMap);
            log.debug("\u6d41\u8f6c\u72b6\u6001\u5165\u53c2{}", (Object)fscOrderStatusFlowAtomReqBo);
            FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBo);
            log.debug("\u6d41\u8f6c\u72b6\u6001\u51fa\u53c2{}", (Object)atomRspBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                log.debug("\u6d41\u8f6c\u72b6\u6001\u5931\u8d25");
                throw new FscBusinessException("194202", atomRspBO.getRespDesc());
            }
        });
    }

    private List<FscPayInfoPO> getFscPayInfoPoS(Long payOrderId, List<FscPayOrderInfoItemPO> fscPayOrderInfoItemList) {
        log.debug("\u8fdb\u5165\u67e5\u8be2\u660e\u7ec6\u4e2d\u662f\u5426\u5df2\u7ecf\u6709\u652f\u4ed8\u6210\u529f\u7684\u660e\u7ec6");
        List payObjectIds = fscPayOrderInfoItemList.stream().map(FscPayOrderInfoItemPO::getPayObjectId).collect(Collectors.toList());
        FscPayInfoPO fscPayInfoPo = new FscPayInfoPO();
        fscPayInfoPo.setPayObjectIds(payObjectIds);
        fscPayInfoPo.setPayOrderId(payOrderId);
        log.debug("\u67e5\u8be2\u660e\u7ec6\u4e2d\u662f\u5426\u5df2\u7ecf\u6709\u652f\u4ed8\u6210\u529f\u7684\u660e\u7ec6\u5165\u53c2{}", (Object)fscPayInfoPo);
        List payObjectBoList = this.fscPayInfoMapper.getListByPayObjectIds(fscPayInfoPo);
        log.debug("\u67e5\u8be2\u660e\u7ec6\u4e2d\u662f\u5426\u5df2\u7ecf\u6709\u652f\u4ed8\u6210\u529f\u7684\u660e\u7ec6\u51fa\u53c2{}", (Object)payObjectBoList);
        return payObjectBoList;
    }

    private void sleep() {
        log.debug("\u5f00\u59cb\u7761\u7720{}", (Object)System.currentTimeMillis());
        try {
            Thread.sleep(Long.parseLong(this.sleepTime));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        log.debug("\u7ed3\u675f\u7761\u7720{}", (Object)System.currentTimeMillis());
    }

    private boolean getOrderState(AtomicReference<Boolean> f, FscPayOrderInfoItemPO fscPayOrderInfoItemPo) {
        log.debug("\u5224\u65ad\u662f\u5426\u5df2\u53d6\u6d88\u8ba2\u5355\u5f00\u59cb\u4e86");
        HashMap<String, String> content = new HashMap<String, String>(2);
        content.put("saleOrderId", fscPayOrderInfoItemPo.getPayObjectId().toString());
        content.put("orderId", fscPayOrderInfoItemPo.getOrderId().toString());
        log.debug("\u5224\u65ad\u662f\u5426\u5df2\u53d6\u6d88\u8ba2\u5355\u5165\u53c2{}", (Object)(this.qrySaleOrderUrl + JSONObject.toJSONString(content)));
        String resultData = HttpUtil.post((String)this.qrySaleOrderUrl, (String)JSONObject.toJSONString(content));
        log.debug("\u5224\u65ad\u662f\u5426\u5df2\u53d6\u6d88\u8ba2\u5355\u51fa\u53c2{}", (Object)resultData);
        if (!StringUtils.isEmpty((CharSequence)resultData)) {
            JSONObject jsonObject = JSONObject.parseObject((String)resultData);
            Object code = jsonObject.get((Object)"code");
            if (!"0".equals(code)) {
                throw new FscBusinessException("190000", jsonObject.get((Object)"message").toString());
            }
            JSONObject data = (JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString((Object)jsonObject.get((Object)"data")), JSONObject.class);
            Object saleOrderState = data.get((Object)"saleOrderState");
            if ("XS_QX_QX".equals(saleOrderState)) {
                f.set(true);
                return true;
            }
        } else {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u9500\u552e\u5355\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff01");
        }
        return false;
    }

    private void updatePayInfoRepeated(Date date, Long payOrderId, FscPayInfoPO fscPayInfoModelBy, BigDecimal refundMoney, Integer payState, FscPayBillCallbackBusiReqBO busiReqBO) {
        log.debug("\u4fee\u6539\u4ed8\u6b3e\u72b6\u6001\u4e3a\u91cd\u590d\u652f\u4ed8\u6216\u8ba2\u5355\u53d6\u6d88\u652f\u4ed8\u5f00\u59cb");
        FscPayInfoPO fscPayInfoPoWhere = new FscPayInfoPO();
        fscPayInfoPoWhere.setPayOrderId(payOrderId);
        FscPayInfoPO fscPayInfoPoSet = new FscPayInfoPO();
        fscPayInfoPoSet.setPayRefundAmount(refundMoney);
        fscPayInfoPoSet.setPayUpdateTime(date);
        fscPayInfoPoSet.setPayRefundTime(date);
        fscPayInfoPoSet.setPayState(payState);
        fscPayInfoPoSet.setPayChannel(busiReqBO.getFscPayCallbackContentBO().getPaymentInsId());
        if (!StringUtils.isEmpty((CharSequence)busiReqBO.getFscPayCallbackContentBO().getPayMethod())) {
            fscPayInfoPoSet.setPayMethod(Integer.valueOf(busiReqBO.getFscPayCallbackContentBO().getPayMethod()));
        }
        if (BigDecimal.ZERO.compareTo(refundMoney) == 0) {
            fscPayInfoPoSet.setPayRepeatedPayment(FscConstants.PayRefundState.FAIL);
        }
        if (fscPayInfoModelBy.getPayAmount().compareTo(refundMoney) == 0) {
            fscPayInfoPoSet.setPayRepeatedPayment(FscConstants.PayRefundState.SUCCESS);
        }
        if (fscPayInfoModelBy.getPayAmount().compareTo(refundMoney) > 0) {
            fscPayInfoPoSet.setPayRepeatedPayment(FscConstants.PayRefundState.PART_SUCCESS);
        }
        log.debug("\u4fee\u6539\u4ed8\u6b3e\u72b6\u6001\u4e3a\u91cd\u590d\u652f\u4ed8\u6216\u8ba2\u5355\u53d6\u6d88\u652f\u4ed8\u5165\u53c2where{}", (Object)fscPayInfoPoWhere);
        log.debug("\u4fee\u6539\u4ed8\u6b3e\u72b6\u6001\u4e3a\u91cd\u590d\u652f\u4ed8\u6216\u8ba2\u5355\u53d6\u6d88\u652f\u4ed8\u5165\u53c2set{}", (Object)fscPayInfoPoSet);
        int update = this.fscPayInfoMapper.updateBy(fscPayInfoPoSet, fscPayInfoPoWhere);
        log.debug("\u4fee\u6539\u4ed8\u6b3e\u72b6\u6001\u4e3a\u91cd\u590d\u652f\u4ed8\u6216\u8ba2\u5355\u53d6\u6d88\u652f\u4ed8\u51fa\u53c2{}", (Object)update);
        if (update < 1) {
            throw new FscBusinessException("190000", "\u4fee\u6539\u4ed8\u6b3e\u72b6\u6001\u5931\u8d25");
        }
    }

    private BigDecimal dealRefund(BigDecimal refundMoney, FscCreateRefundBusiRspBO refund, Long payOrderId) {
        log.debug("\u5f00\u59cb\u9000\u6b3e\u4e86");
        try {
            FscDealRefundBusiReqBO fscDealRefundBusiReqBo = new FscDealRefundBusiReqBO();
            fscDealRefundBusiReqBo.setRefundId(refund.getRefundId());
            fscDealRefundBusiReqBo.setPayOrderId(payOrderId);
            log.debug("\u9000\u6b3e\u5165\u53c2{}", (Object)fscDealRefundBusiReqBo);
            FscDealRefundBusiRspBO fscDealRefundBusiRspBO = this.fscDealRefundBusiService.dealRefund(fscDealRefundBusiReqBo);
            log.debug("\u9000\u6b3e\u51fa\u53c2{}", (Object)fscDealRefundBusiRspBO);
            if ("0000".equals(fscDealRefundBusiRspBO.getRespCode())) {
                refundMoney = refundMoney.add(refund.getRefundAmount());
                return refundMoney;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return refundMoney;
    }

    private List<FscPaySuccessCallBackOrderBO> getFscPaySuccessCallBackOrderBOS(FscPayBillCallbackBusiReqBO busiReqBO, List<FscPayOrderInfoItemPO> fscPayOrderInfoItemList, FscPayInfoPO fscPayInfoModelBy) {
        List payOrderItemIdList = fscPayOrderInfoItemList.stream().map(FscPayOrderInfoItemPO::getPayOrderItemId).collect(Collectors.toList());
        FscLedgerInfoItemPO fscLedgerInfoItemPo = new FscLedgerInfoItemPO();
        fscLedgerInfoItemPo.setPayLedgerItemIds(payOrderItemIdList);
        log.debug("\u67e5\u8be2\u8be5\u660e\u7ec6\u662f\u5426\u9700\u8981\u63a8\u9001\u5206\u8d26\u5165\u53c2{}", (Object)fscLedgerInfoItemPo);
        List fscLedgerInfoItemMapperList = this.fscLedgerInfoItemMapper.getList(fscLedgerInfoItemPo);
        log.debug("\u67e5\u8be2\u8be5\u660e\u7ec6\u662f\u5426\u9700\u8981\u63a8\u9001\u5206\u8d26\u51fa\u53c2{}", (Object)fscLedgerInfoItemMapperList);
        Map<Long, List<FscLedgerInfoItemPO>> fscLedgerInfoItemMap = fscLedgerInfoItemMapperList.stream().collect(Collectors.groupingBy(FscLedgerInfoItemPO::getPayOrderItemId));
        log.debug("\u67e5\u8be2\u8be5\u660e\u7ec6\u662f\u5426\u9700\u8981\u63a8\u9001\u5206\u8d26\u5165\u53c2map{}", fscLedgerInfoItemMap);
        ArrayList<FscPaySuccessCallBackOrderBO> fscPaySuccessCallBackOrderBoS = new ArrayList<FscPaySuccessCallBackOrderBO>();
        fscPayOrderInfoItemList.forEach(fscPayOrderInfoItemPo -> {
            FscPaySuccessCallBackOrderBO fscPaySuccessCallBackOrderBO = new FscPaySuccessCallBackOrderBO();
            fscPaySuccessCallBackOrderBO.setObjectId(fscPayOrderInfoItemPo.getPayObjectId());
            fscPaySuccessCallBackOrderBO.setOrderId(fscPayOrderInfoItemPo.getOrderId());
            fscPaySuccessCallBackOrderBO.setPayOrderType(fscPayInfoModelBy.getPayOrderType());
            if (StringUtils.isNotBlank((CharSequence)busiReqBO.getFscPayCallbackContentBO().getPayMethod())) {
                fscPaySuccessCallBackOrderBO.setPayMod(Integer.valueOf(busiReqBO.getFscPayCallbackContentBO().getPayMethod()));
            }
            if (!StringUtils.isBlank((CharSequence)busiReqBO.getFscPayCallbackContentBO().getResultCode()) && "FAIL".equals(busiReqBO.getFscPayCallbackContentBO().getResultCode())) {
                fscPaySuccessCallBackOrderBO.setPayResult(Boolean.valueOf(false));
            } else if (!StringUtils.isBlank((CharSequence)busiReqBO.getFscPayCallbackContentBO().getResultCode()) && "SUCCESS".equals(busiReqBO.getFscPayCallbackContentBO().getResultCode())) {
                fscPaySuccessCallBackOrderBO.setPayResult(Boolean.valueOf(true));
            }
            List fscLedgerInfoItemPoList = (List)fscLedgerInfoItemMap.get(fscPayOrderInfoItemPo.getPayOrderItemId());
            fscPaySuccessCallBackOrderBO.setIsLedger(Boolean.valueOf(false));
            fscLedgerInfoItemPoList.forEach(fscLedgerInfoItemPoModel -> {
                if (fscLedgerInfoItemPoModel.getLedgerAmount().compareTo(BigDecimal.ZERO) != 0) {
                    fscPaySuccessCallBackOrderBO.setIsLedger(Boolean.valueOf(true));
                }
            });
            fscPaySuccessCallBackOrderBoS.add(fscPaySuccessCallBackOrderBO);
        });
        log.debug("\u7ec4\u88c5\u8fd4\u56de\u8ba2\u5355\u6d41\u8f6c\u8ba2\u5355\u72b6\u6001\u6570\u636e{}", fscPaySuccessCallBackOrderBoS);
        return fscPaySuccessCallBackOrderBoS;
    }

    private void updateOrderPayState(FscPayBillCallbackBusiReqBO busiReqBO, FscPayInfoPO fscPayInfoModelBy, List<FscPayOrderInfoItemPO> fscPayOrderInfoItemList) {
        log.debug("\u8fdb\u5165\u5f53\u524d\u652f\u4ed8\u5355\u4e3a\u5df2\u652f\u4ed8\u8ba2\u5355\u5f00\u59cb\u4fee\u6539\u8ba2\u5355\u4ed8\u6b3e\u72b6\u6001");
        FscUocProOrderPaymentCallbackAbilityReqBO fscUocProOrderPaymentCallbackAbilityReqBo = new FscUocProOrderPaymentCallbackAbilityReqBO();
        ArrayList uocPaymentCallbackBoS = new ArrayList();
        fscPayOrderInfoItemList.forEach(fscPayOrderInfoItemPo -> {
            FscUocProOrderPaymentCallbackAbilityBO fscUocProOrderPaymentCallbackAbilityBo = new FscUocProOrderPaymentCallbackAbilityBO();
            fscUocProOrderPaymentCallbackAbilityBo.setShouldPayMoney(fscPayOrderInfoItemPo.getPayOrderItemAmount());
            fscUocProOrderPaymentCallbackAbilityBo.setPayMod(Integer.valueOf(busiReqBO.getFscPayCallbackContentBO().getPayMethod()));
            fscUocProOrderPaymentCallbackAbilityBo.setFscShouldPayId(fscPayOrderInfoItemPo.getPayOrderItemId());
            fscUocProOrderPaymentCallbackAbilityBo.setObjectId(fscPayOrderInfoItemPo.getPayObjectId());
            fscUocProOrderPaymentCallbackAbilityBo.setOrderId(fscPayOrderInfoItemPo.getOrderId());
            if (SUCCESS.equals(busiReqBO.getFscPayCallbackContentBO().getResultCode())) {
                fscUocProOrderPaymentCallbackAbilityBo.setPayResult(Boolean.valueOf(true));
            } else {
                fscUocProOrderPaymentCallbackAbilityBo.setPayResult(Boolean.valueOf(false));
            }
            uocPaymentCallbackBoS.add(fscUocProOrderPaymentCallbackAbilityBo);
        });
        fscUocProOrderPaymentCallbackAbilityReqBo.setUocPaymentCallbackBOS(uocPaymentCallbackBoS);
        log.debug("\u8fdb\u5165\u5f53\u524d\u652f\u4ed8\u5355\u4e3a\u5df2\u652f\u4ed8\u8ba2\u5355\u5f00\u59cb\u4fee\u6539\u8ba2\u5355\u4ed8\u6b3e\u72b6\u6001\u5165\u53c2{}", (Object)fscUocProOrderPaymentCallbackAbilityReqBo);
        FscUocProOrderPaymentCallbackAbilityRspBO fscUocProOrderPaymentCallbackAbilityRspBO = this.fscUocProOrderPaymentCallbackAbilityService.dealOrderPaymentCallback(fscUocProOrderPaymentCallbackAbilityReqBo);
        log.debug("\u8fdb\u5165\u5f53\u524d\u652f\u4ed8\u5355\u4e3a\u5df2\u652f\u4ed8\u8ba2\u5355\u5f00\u59cb\u4fee\u6539\u8ba2\u5355\u4ed8\u6b3e\u72b6\u6001\u51fa\u53c2{}", (Object)fscUocProOrderPaymentCallbackAbilityRspBO);
        if (!"0000".equals(fscUocProOrderPaymentCallbackAbilityRspBO.getRespCode())) {
            log.debug("\u8fdb\u5165\u5f53\u524d\u652f\u4ed8\u5355\u4e3a\u5df2\u652f\u4ed8\u8ba2\u5355\u5f00\u59cb\u4fee\u6539\u8ba2\u5355\u4ed8\u6b3e\u72b6\u6001\u5931\u8d25");
            throw new FscBusinessException(fscUocProOrderPaymentCallbackAbilityRspBO.getRespCode(), fscUocProOrderPaymentCallbackAbilityRspBO.getRespDesc());
        }
    }

    private FscCreateRefundBusiRspBO createRefund(FscPayOrderInfoItemPO fscPayOrderInfoItemList, FscPayInfoPO fscPayInfoModelBy) {
        FscCreateRefundBusiReqBO fscCreateRefundBusiReqBo = new FscCreateRefundBusiReqBO();
        fscCreateRefundBusiReqBo.setCreateOperId(fscPayOrderInfoItemList.getPayerOperId());
        fscCreateRefundBusiReqBo.setCreateOperName(fscPayOrderInfoItemList.getPayerOperName());
        fscCreateRefundBusiReqBo.setCreateTime(new Date());
        fscCreateRefundBusiReqBo.setOrderId(fscPayOrderInfoItemList.getOrderId());
        fscCreateRefundBusiReqBo.setSaleOrderId(fscPayOrderInfoItemList.getPayObjectId());
        fscCreateRefundBusiReqBo.setSaleOrderNo(fscPayOrderInfoItemList.getPayObjectNo());
        fscCreateRefundBusiReqBo.setCreateType(FscConstants.RefundType.TWICE_PAY);
        fscCreateRefundBusiReqBo.setOrderAmount(fscPayOrderInfoItemList.getPayOrderItemAmount());
        fscCreateRefundBusiReqBo.setRefundAmount(fscPayOrderInfoItemList.getPayOrderItemAmount());
        fscCreateRefundBusiReqBo.setPurchaserId(fscPayOrderInfoItemList.getPayerId().toString());
        fscCreateRefundBusiReqBo.setPurchaserName(fscPayOrderInfoItemList.getPayerName());
        fscCreateRefundBusiReqBo.setSupplierId(fscPayOrderInfoItemList.getPayeeId().toString());
        fscCreateRefundBusiReqBo.setSupplierName(fscPayOrderInfoItemList.getPayeeName());
        fscCreateRefundBusiReqBo.setPayOrderType(fscPayInfoModelBy.getPayOrderType());
        FscCreateRefundBusiRspBO refund = null;
        try {
            log.debug("\u9000\u6b3e\u5355\u521b\u5efa\u5165\u53c2{}", (Object)fscCreateRefundBusiReqBo);
            refund = this.fscCreateRefundBusiService.createRefund(fscCreateRefundBusiReqBo);
            log.debug("\u9000\u6b3e\u5355\u521b\u5efa\u51fa\u53c2{}", (Object)refund);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return refund;
    }

    private FscPayInfoPO getFscPayInfoPO(Long payOrderId) {
        log.debug("\u67e5\u8be2\u4ed8\u6b3e\u4e3b\u5355\u8be6\u60c5\u5f00\u59cb");
        FscPayInfoPO fscPayInfoPo = new FscPayInfoPO();
        fscPayInfoPo.setPayOrderId(payOrderId);
        log.debug("\u67e5\u8be2\u4ed8\u6b3e\u4e3b\u5355\u8be6\u60c5\u5165\u53c2{}", (Object)fscPayInfoPo);
        FscPayInfoPO fscPayInfoModelBy = this.fscPayInfoMapper.getModelBy(fscPayInfoPo);
        log.debug("\u67e5\u8be2\u4ed8\u6b3e\u4e3b\u5355\u8be6\u60c5\u51fa\u53c2{}", (Object)fscPayInfoModelBy);
        if (fscPayInfoModelBy == null) {
            log.debug("\u67e5\u8be2\u4ed8\u6b3e\u4e3b\u5355\u8be6\u60c5\u67e5\u8be2\u4e3a\u7a7a");
            throw new FscBusinessException("190000", "\u67e5\u8be2\u4ed8\u6b3e\u4e3b\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        return fscPayInfoModelBy;
    }

    private List<FscPayOrderInfoItemPO> getFscPayOrderInfoItemPOS(Long payOrderId) {
        log.debug("\u67e5\u8be2\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5f00\u59cb");
        FscPayOrderInfoItemPO fscPayOrderInfoItemPo = new FscPayOrderInfoItemPO();
        fscPayOrderInfoItemPo.setPayOrderId(payOrderId);
        log.debug("\u67e5\u8be2\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5165\u53c2{}", (Object)fscPayOrderInfoItemPo);
        List fscPayOrderInfoItemList = this.fscPayOrderInfoItemMapper.getList(fscPayOrderInfoItemPo);
        log.debug("\u67e5\u8be2\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u51fa\u53c2{}", (Object)fscPayOrderInfoItemList);
        if (CollectionUtils.isEmpty((Collection)fscPayOrderInfoItemList)) {
            log.debug("\u67e5\u8be2\u4ed8\u6b3e\u660e\u7ec6\u4e3a\u7a7a");
            throw new FscBusinessException("190000", "\u67e5\u8be2\u4ed8\u6b3e\u660e\u7ec6\u4e3a\u7a7a");
        }
        return fscPayOrderInfoItemList;
    }

    private List<FscPayOrderInfoItemPO> getFscPayOrderInfoItemPoListNotPay(Long payOrderId) {
        log.debug("\u67e5\u8be2\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5f00\u59cb");
        FscPayOrderInfoItemPO fscPayOrderInfoItemPo = new FscPayOrderInfoItemPO();
        fscPayOrderInfoItemPo.setPayOrderId(payOrderId);
        fscPayOrderInfoItemPo.setPayItemState(FscConstants.NewPayState.NOT_PAY);
        log.debug("\u67e5\u8be2\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5165\u53c2{}", (Object)fscPayOrderInfoItemPo);
        List fscPayOrderInfoItemList = this.fscPayOrderInfoItemMapper.getList(fscPayOrderInfoItemPo);
        log.debug("\u67e5\u8be2\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u51fa\u53c2{}", (Object)fscPayOrderInfoItemList);
        if (CollectionUtils.isEmpty((Collection)fscPayOrderInfoItemList)) {
            log.debug("\u67e5\u8be2\u4ed8\u6b3e\u660e\u7ec6\u4e3a\u7a7a");
            throw new FscBusinessException("190000", "\u67e5\u8be2\u4ed8\u6b3e\u660e\u7ec6\u4e3a\u7a7a");
        }
        FscPayOrderInfoItemPO fscPayOrderInfoItemPoWhere = new FscPayOrderInfoItemPO();
        List payItemIds = fscPayOrderInfoItemList.stream().map(FscPayOrderInfoItemPO::getPayOrderItemId).collect(Collectors.toList());
        fscPayOrderInfoItemPoWhere.setPayOrderItemIds(payItemIds);
        FscPayOrderInfoItemPO fscPayOrderInfoItemPoSet = new FscPayOrderInfoItemPO();
        fscPayOrderInfoItemPoSet.setPayItemState(FscConstants.NewPayState.PAYED);
        this.fscPayOrderInfoItemMapper.updateBy(fscPayOrderInfoItemPoSet, fscPayOrderInfoItemPoWhere);
        return fscPayOrderInfoItemList;
    }

    private void updatePayInfo(Long payOrderId, Date date, Integer payState, FscPayBillCallbackBusiReqBO busiReqBO) {
        log.debug("\u4fee\u6539\u4ed8\u6b3e\u5355\u72b6\u6001\u60c5\u5f00\u59cb");
        FscPayInfoPO fscPayInfoWherePo = new FscPayInfoPO();
        fscPayInfoWherePo.setPayOrderId(payOrderId);
        FscPayInfoPO fscPayInfoSetPo = new FscPayInfoPO();
        fscPayInfoSetPo.setPayUpdateTime(date);
        fscPayInfoSetPo.setPayState(payState);
        fscPayInfoSetPo.setPayChannel(busiReqBO.getFscPayCallbackContentBO().getPaymentInsId());
        if (!StringUtils.isEmpty((CharSequence)busiReqBO.getFscPayCallbackContentBO().getPayMethod())) {
            fscPayInfoSetPo.setPayMethod(Integer.valueOf(busiReqBO.getFscPayCallbackContentBO().getPayMethod()));
        }
        log.debug("\u4fee\u6539\u4ed8\u6b3e\u5355\u72b6\u6001\u5165\u53c2where{}", (Object)fscPayInfoWherePo);
        log.debug("\u4fee\u6539\u4ed8\u6b3e\u5355\u72b6\u6001\u5165\u53c2Set{}", (Object)fscPayInfoSetPo);
        int update = this.fscPayInfoMapper.updateBy(fscPayInfoSetPo, fscPayInfoWherePo);
        if (update < 1) {
            throw new FscBusinessException("190000", "\u4fee\u6539\u4ed8\u6b3e\u72b6\u6001\u5931\u8d25");
        }
    }

    private void updatePayInfoItem(Long payOrderId, Date date, Integer payItemState) {
        log.debug("\u4fee\u6539\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5f00\u59cb");
        FscPayOrderInfoItemPO fscPayOrderInfoItemWherePo = new FscPayOrderInfoItemPO();
        fscPayOrderInfoItemWherePo.setPayOrderId(payOrderId);
        FscPayOrderInfoItemPO fscPayOrderInfoItemSetPo = new FscPayOrderInfoItemPO();
        fscPayOrderInfoItemSetPo.setPayItemUpdateTime(date);
        fscPayOrderInfoItemSetPo.setPayItemState(payItemState);
        log.debug("\u4fee\u6539\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5165\u53c2where{}", (Object)fscPayOrderInfoItemWherePo);
        log.debug("\u4fee\u6539\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5165\u53c2Set{}", (Object)fscPayOrderInfoItemSetPo);
        int update = this.fscPayOrderInfoItemMapper.updateBy(fscPayOrderInfoItemSetPo, fscPayOrderInfoItemWherePo);
        log.debug("\u4fee\u6539\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u6570\u91cf{}", (Object)update);
        if (update < 1) {
            throw new FscBusinessException("190000", "\u4fee\u6539\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
        }
    }

    private Map<Integer, List<FscOrderPO>> getIntegerListMap(List<FscPayOrderInfoItemPO> fscPayOrderInfoItemList) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderIds(fscPayOrderInfoItemList.stream().map(FscPayOrderInfoItemPO::getPayObjectId).collect(Collectors.toList()));
        List fscOrderPoList = this.fscOrderMapper.getList(fscOrderPo);
        Map<Integer, List<FscOrderPO>> collect = fscOrderPoList.stream().collect(Collectors.groupingBy(FscOrderPO::getOrderState));
        return collect;
    }

    private FscCreateRefundBusiRspBO getFscCreateRefundBusiRspBO(FscShouldPayPO fscShouldPayMapperModel, FscOrderPO fscOrderPo) {
        FscCreateRefundBusiReqBO fscCreateRefundBusiReqBo = new FscCreateRefundBusiReqBO();
        fscCreateRefundBusiReqBo.setCreateOperId(1L);
        fscCreateRefundBusiReqBo.setCreateOperName("\u8fd0\u8425\u4eba\u5458");
        fscCreateRefundBusiReqBo.setCreateTime(new Date());
        fscCreateRefundBusiReqBo.setOrderId(fscShouldPayMapperModel.getOrderId());
        fscCreateRefundBusiReqBo.setSaleOrderId(fscShouldPayMapperModel.getObjectId());
        fscCreateRefundBusiReqBo.setSaleOrderNo(fscShouldPayMapperModel.getObjectNo());
        fscCreateRefundBusiReqBo.setCreateType(FscConstants.RefundType.ORDER_CHANNEL);
        fscCreateRefundBusiReqBo.setOrderAmount(fscShouldPayMapperModel.getShouldPayAmount());
        fscCreateRefundBusiReqBo.setRefundAmount(fscShouldPayMapperModel.getShouldPayAmount());
        fscCreateRefundBusiReqBo.setPurchaserId(fscOrderPo.getCreateCompanyId().toString());
        fscCreateRefundBusiReqBo.setPurchaserName(fscOrderPo.getCreateCompanyName());
        fscCreateRefundBusiReqBo.setSupplierId(fscShouldPayMapperModel.getPayeeId().toString());
        fscCreateRefundBusiReqBo.setSupplierName(fscShouldPayMapperModel.getPayeeName());
        FscCreateRefundBusiRspBO refund = null;
        try {
            log.debug("\u9000\u6b3e\u5355\u521b\u5efa\u5165\u53c2{}", (Object)fscCreateRefundBusiReqBo);
            refund = this.fscCreateRefundBusiService.createRefund(fscCreateRefundBusiReqBo);
            log.debug("\u9000\u6b3e\u5355\u521b\u5efa\u51fa\u53c2{}", (Object)refund);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return refund;
    }

    private void payRefund(FscPayBillCallbackBusiReqBO busiReqBO, FscCreateRefundBusiRspBO refund) {
        log.debug("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u9000\u6b3e\u5f00\u59cb");
        Long oriOutOrderId = Sequence.getInstance().nextId();
        PayProRefundAbilityReqBo payProRefundAbilityReqBo = new PayProRefundAbilityReqBo();
        payProRefundAbilityReqBo.setBusiCode(this.payBusiCode);
        payProRefundAbilityReqBo.setRefundOutOrderId(String.valueOf(oriOutOrderId));
        payProRefundAbilityReqBo.setOriOutOrderId(busiReqBO.getFscPayCallbackContentBO().getOutOrderId());
        payProRefundAbilityReqBo.setOrderType("06");
        payProRefundAbilityReqBo.setRefundFee(MoneyUtils.yuanToFenToLong((BigDecimal)refund.getRefundAmount()) + "");
        try {
            log.debug("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u9000\u6b3e\u5165\u53c2{}", (Object)payProRefundAbilityReqBo);
            PayProRefundAbilityRspBo payProRefundAbilityRspBo = this.payProRefundAbilityService.dealRefund(payProRefundAbilityReqBo);
            log.debug("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u9000\u6b3e\u51fa\u53c2{}", (Object)payProRefundAbilityRspBo);
            if (payProRefundAbilityRspBo.getRespCode().equals("0000")) {
                log.debug("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u9000\u6b3e\u6210\u529f{}", (Object)payProRefundAbilityRspBo);
                if ("0000".equals(refund.getRespCode())) {
                    FscRefundInfoPO fscRefundInfoPoSet = new FscRefundInfoPO();
                    fscRefundInfoPoSet.setRefundState(FscConstants.RefundState.REFUND);
                    FscRefundInfoPO fscRefundInfoPoWhere = new FscRefundInfoPO();
                    fscRefundInfoPoWhere.setRefundId(refund.getRefundId());
                    this.fscRefundInfoMapper.updateBy(fscRefundInfoPoSet, fscRefundInfoPoWhere);
                }
            }
        }
        catch (Exception e) {
            log.debug("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u9000\u6b3e\u5931\u8d25");
            FscRefundFailureRecordPO fscRefundFailureRecordPo = new FscRefundFailureRecordPO();
            fscRefundFailureRecordPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscRefundFailureRecordPo.setCreateTime(new Date());
            fscRefundFailureRecordPo.setPayState(FscConstants.PayOrderStatus.TO_PAY);
            fscRefundFailureRecordPo.setPayOrderId(Long.valueOf(busiReqBO.getFscPayCallbackContentBO().getOutOrderId()));
            this.fscRefundFailureRecordMapper.insert(fscRefundFailureRecordPo);
        }
    }

    private void updateMainOrder(FscPayBillCallbackBusiReqBO busiReqBO, Long payOrderId) {
        FscPayRelationPO fscPayRelationPo = new FscPayRelationPO();
        fscPayRelationPo.setPayOrderId(payOrderId);
        FscPayRelationPO fscPayRelationMapperModelBy = this.fscPayRelationMapper.getModelBy(fscPayRelationPo);
        if (fscPayRelationMapperModelBy != null) {
            FscOrderPO fscOrderPoWhere = new FscOrderPO();
            fscOrderPoWhere.setFscOrderId(fscPayRelationMapperModelBy.getFscOrderId());
            FscOrderPO fscOrderPoSet = new FscOrderPO();
            fscOrderPoSet.setPayChannel(busiReqBO.getFscPayCallbackContentBO().getPaymentInsId().toString());
            fscOrderPoSet.setPayMethod(busiReqBO.getFscPayCallbackContentBO().getPayMethod());
            this.fscOrderMapper.updateBy(fscOrderPoSet, fscOrderPoWhere);
        }
    }

    private void sendMq(Long fscOrderId, FscPayBillCallbackBusiReqBO reqBO) {
        FscComErpPayOffAbilityReqBo fscComErpPayOffAbilityReqBo = new FscComErpPayOffAbilityReqBo();
        fscComErpPayOffAbilityReqBo.setFscOrderId(fscOrderId);
        fscComErpPayOffAbilityReqBo.setUserId(Long.valueOf(reqBO.getFscPayCallbackContentBO().getCreateOperId()));
        fscComErpPayOffAbilityReqBo.setUserName(reqBO.getFscPayCallbackContentBO().getCreatOperName());
        this.fscComErpPayOffAbilityService.dealErpPayOff(fscComErpPayOffAbilityReqBo);
    }

    private List<Long> updateFscOrderOrOrder(List<Long> payFscOrderId, FscPayBillCallbackBusiReqBO busiReqBO) {
        FscDealPaySuccessAtomReqBO fscDealPaySuccessAtomReqBO = new FscDealPaySuccessAtomReqBO();
        fscDealPaySuccessAtomReqBO.setFscPayCallbackContentBO(busiReqBO.getFscPayCallbackContentBO());
        fscDealPaySuccessAtomReqBO.setPayFscOrderId(payFscOrderId);
        FscDealPaySuccessAtomRspBO atomRspBO = this.fscDealPaySuccessAtomService.dealPaySuccess(fscDealPaySuccessAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException("193201", atomRspBO.getRespDesc());
        }
        return atomRspBO.getResultFscOrderIds();
    }

    private void updatePayOrder(Long payOrderId, FscPayBillCallbackBusiReqBO busiReqBO) {
        FscPayOrderPO fscPayOrderPO = new FscPayOrderPO();
        if (!StringUtils.isBlank((CharSequence)busiReqBO.getFscPayCallbackContentBO().getResultCode()) && "FAIL".equals(busiReqBO.getFscPayCallbackContentBO().getResultCode())) {
            fscPayOrderPO.setPayStatus(FscConstants.PayOrderPayStatus.PAY_FAIL);
        } else {
            fscPayOrderPO.setPayStatus(FscConstants.PayOrderPayStatus.PAIED);
        }
        fscPayOrderPO.setPayMethod(busiReqBO.getFscPayCallbackContentBO().getPayMethod());
        fscPayOrderPO.setUpdateTime(new Date());
        fscPayOrderPO.setPayOrderId(payOrderId);
        int count = this.fscPayOrderMapper.updateById(fscPayOrderPO);
        if (count != 1) {
            throw new FscBusinessException("193201", "\u652f\u4ed8\u5355\u4e0d\u5b58\u5728\uff01");
        }
    }

    private List<Long> getFscOrderId(Long payOrderId) {
        FscPayRelationPO fscPayRelationPO = new FscPayRelationPO();
        fscPayRelationPO.setPayOrderId(payOrderId);
        List pos = this.fscPayRelationMapper.getList(fscPayRelationPO);
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        pos.forEach(fscPayRelationPO1 -> fscOrderIds.add(fscPayRelationPO1.getFscOrderId()));
        return fscOrderIds;
    }

    private void invokeFscOrderStatusFlow(List<Long> payFscOrderId, FscPayBillCallbackBusiReqBO busiReqBO) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        if (!StringUtils.isBlank((CharSequence)busiReqBO.getFscPayCallbackContentBO().getResultCode()) && "FAIL".equals(busiReqBO.getFscPayCallbackContentBO().getResultCode())) {
            paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag3);
        } else {
            paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag0);
        }
        payFscOrderId.forEach(fscOrderId -> {
            fscOrderStatusFlowAtomReqBO.setCurStatus(FscConstants.FscPayOrderState.TO_PAY);
            fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderId);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException("193201", atomRspBO.getRespDesc());
            }
        });
    }
}

