/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscPayCallbackContentBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscPayIntfLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPayBillCallbackAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayBillCallbackAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayBillCallbackAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscPayBillCallbackBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayBillCallbackBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayBillCallbackBusiRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscPayIntfLogPO;
import com.tydic.fsc.po.FscPayOrderInfoItemPO;
import com.tydic.payment.pay.sdk.PayCenterUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscPayBillCallbackAbilityService"})
public class FscPayBillCallbackAbilityServiceImpl
implements FscPayBillCallbackAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillCallbackAbilityServiceImpl.class);
    @Value(value="${payPublicKey}")
    private String payPublicKey;
    @Autowired
    private FscPayBillCallbackBusiService fscPayBillCallbackBusiService;
    @Autowired
    private FscPayIntfLogMapper fscPayIntfLogMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Value(value="${payCallBackFail:}")
    private String payCallBackFailFlag;
    @Value(value="${isNewPay:false}")
    private Boolean isNewPay;

    @PostMapping(value={"dealPayBillCallback"})
    public FscPayBillCallbackAbilityRspBO dealPayBillCallback(@RequestBody FscPayBillCallbackAbilityReqBO abilityReqBO) {
        FscPayCallbackContentBO fscPayCallbackContentBO;
        if (this.isNewPay.booleanValue()) {
            FscPayCallbackContentBO fscPayCallbackContentBO2;
            log.debug("\u4ed8\u6b3e\u56de\u8c03\u5f00\u59cb\u5165\u53c2{}", (Object)abilityReqBO);
            if (abilityReqBO.getOutOrderId() != null) {
                fscPayCallbackContentBO2 = new FscPayCallbackContentBO();
                fscPayCallbackContentBO2.setOutOrderId(abilityReqBO.getOutOrderId().toString());
            } else {
                String content = PayCenterUtils.deCode((String)abilityReqBO.getContent(), (String)this.payPublicKey);
                fscPayCallbackContentBO2 = (FscPayCallbackContentBO)JSON.parseObject((String)content, FscPayCallbackContentBO.class);
                if ("payCallBackFailFlag".equals(this.payCallBackFailFlag)) {
                    fscPayCallbackContentBO2.setResultCode("FAIL");
                    log.debug("\u6d4b\u8bd5\u5931\u8d25\u573a\u666f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscPayCallbackContentBO2, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                }
            }
            FscPayBillCallbackBusiReqBO fscPayBillCallbackBusiReqBO = new FscPayBillCallbackBusiReqBO();
            fscPayBillCallbackBusiReqBO.setFscPayCallbackContentBO(fscPayCallbackContentBO2);
            log.debug("\u4ed8\u6b3e\u56de\u8c03\u5904\u7406\u5165\u53c2{}", (Object)fscPayBillCallbackBusiReqBO);
            FscPayBillCallbackBusiRspBO busiRspBO = this.fscPayBillCallbackBusiService.dealPayBillCallback(fscPayBillCallbackBusiReqBO);
            log.debug("\u4ed8\u6b3e\u56de\u8c03\u5904\u7406\u51fa\u53c2{}", (Object)busiRspBO);
            if ("0000".equals(busiRspBO.getRespCode())) {
                if (!CollectionUtils.isEmpty(busiRspBO.getFscPayOrderInfoItemList())) {
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    log.debug("\u5bf9\u8d26\u5355\u4ed8\u6b3e\u5355\u6d41\u8f6c\u5230\u5df2\u5b8c\u6210\u5165\u53c2{}", busiRspBO.getFscPayOrderInfoItemList());
                    this.invokeFscOrderStatusFlow(busiRspBO.getFscPayOrderInfoItemList(), paramMap);
                    log.debug("\u540c\u6b65\u5bf9\u8d26\u5355\u72b6\u6001es\u5f00\u59cb");
                    List<Long> collect = busiRspBO.getFscPayOrderInfoItemList().stream().map(FscPayOrderInfoItemPO::getPayObjectId).collect(Collectors.toList());
                    this.sendMq(collect);
                }
                if (!CollectionUtils.isEmpty(busiRspBO.getServiceFeeFscOrderIdList())) {
                    log.debug("\u540c\u6b65\u670d\u52a1\u8d39es\u5f00\u59cb");
                    this.sendMq(busiRspBO.getServiceFeeFscOrderIdList());
                }
            }
            FscPayBillCallbackAbilityRspBO abilityRspBO = (FscPayBillCallbackAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiRspBO)), FscPayBillCallbackAbilityRspBO.class);
            FscPayIntfLogPO fscPayIntfLogPo = new FscPayIntfLogPO();
            fscPayIntfLogPo.setCreateTime(new Date());
            fscPayIntfLogPo.setReqJson(JSON.toJSONString((Object)abilityReqBO));
            fscPayIntfLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscPayIntfLogPo.setIntfResult(FscConstants.InfcProcessResult.SUCCESS);
            fscPayIntfLogPo.setSerialNo(fscPayCallbackContentBO2.getOutOrderId());
            if ("0000".equals(busiRspBO.getRespCode())) {
                fscPayIntfLogPo.setBusiResult(FscConstants.InfcProcessResult.SUCCESS);
            } else {
                fscPayIntfLogPo.setBusiResult(FscConstants.InfcProcessResult.FAIL);
                fscPayIntfLogPo.setRspJson(JSON.toJSONString((Object)((Object)busiRspBO)));
            }
            fscPayIntfLogPo.setServiceCode("FscPayBillCallbackAbilityService");
            this.fscPayIntfLogMapper.insert(fscPayIntfLogPo);
            return abilityRspBO;
        }
        if (abilityReqBO.getOutOrderId() != null) {
            fscPayCallbackContentBO = new FscPayCallbackContentBO();
            fscPayCallbackContentBO.setOutOrderId(abilityReqBO.getOutOrderId().toString());
        } else {
            String content = PayCenterUtils.deCode((String)abilityReqBO.getContent(), (String)this.payPublicKey);
            fscPayCallbackContentBO = (FscPayCallbackContentBO)JSON.parseObject((String)content, FscPayCallbackContentBO.class);
            if ("payCallBackFailFlag".equals(this.payCallBackFailFlag)) {
                fscPayCallbackContentBO.setResultCode("FAIL");
                log.debug("\u6d4b\u8bd5\u5931\u8d25\u573a\u666f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscPayCallbackContentBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            }
        }
        FscPayBillCallbackBusiReqBO fscPayBillCallbackBusiReqBO = new FscPayBillCallbackBusiReqBO();
        fscPayCallbackContentBO.setPayMethod(fscPayCallbackContentBO.getPaymentInsId().toString());
        fscPayBillCallbackBusiReqBO.setFscPayCallbackContentBO(fscPayCallbackContentBO);
        FscPayBillCallbackBusiRspBO busiRspBO = this.fscPayBillCallbackBusiService.dealPayBillCallback(fscPayBillCallbackBusiReqBO);
        if (!CollectionUtils.isEmpty(busiRspBO.getResultFscOrderIds())) {
            FscOrderPO orderPoModel = new FscOrderPO();
            orderPoModel.setFscOrderIds(busiRspBO.getResultFscOrderIds());
            List fscOrderPoS = this.fscOrderMapper.getList(orderPoModel);
            if (CollectionUtils.isEmpty((Collection)fscOrderPoS)) {
                throw new FscBusinessException("190000", "\u67e5\u8be2\u4e3b\u5355\u4fe1\u606f\u4e3a\u7a7a");
            }
            if ("0000".equals(busiRspBO.getRespCode())) {
                fscOrderPoS.forEach(fscOrderPO -> {
                    if (!fscOrderPO.getOrderFlow().equals(FscConstants.OrderFlow.PL_SERVICE_FEE) && !fscOrderPO.getOrderFlow().equals(FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE)) {
                        log.debug("\u6d4b\u8bd5\u4ed8\u6b3e\u7533\u8bf7\u5355\u540c\u6b65es\u5f00\u59cb\u4e86----------------------------------------------------------" + busiRspBO.getResultFscOrderIds().toString());
                        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderPO.getFscOrderId());
                        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
                    }
                });
            }
        }
        FscPayBillCallbackAbilityRspBO abilityRspBO = (FscPayBillCallbackAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiRspBO)), FscPayBillCallbackAbilityRspBO.class);
        FscPayIntfLogPO fscPayIntfLogPO = new FscPayIntfLogPO();
        fscPayIntfLogPO.setCreateTime(new Date());
        fscPayIntfLogPO.setReqJson(JSON.toJSONString((Object)abilityReqBO));
        fscPayIntfLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscPayIntfLogPO.setIntfResult(FscConstants.InfcProcessResult.SUCCESS);
        fscPayIntfLogPO.setSerialNo(fscPayCallbackContentBO.getOutOrderId());
        if ("0000".equals(busiRspBO.getRespCode())) {
            fscPayIntfLogPO.setBusiResult(FscConstants.InfcProcessResult.SUCCESS);
        } else {
            fscPayIntfLogPO.setBusiResult(FscConstants.InfcProcessResult.FAIL);
            fscPayIntfLogPO.setRspJson(JSON.toJSONString((Object)((Object)busiRspBO)));
        }
        fscPayIntfLogPO.setServiceCode("FscPayBillCallbackAbilityService");
        this.fscPayIntfLogMapper.insert(fscPayIntfLogPO);
        return abilityRspBO;
    }

    private void sendMq(List<Long> fscOrderIds) {
        for (Long fscOrderId : fscOrderIds) {
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        }
    }

    private void invokeFscOrderStatusFlow(List<FscPayOrderInfoItemPO> fscPayOrderInfoItemList, Map<String, Object> paramMap) {
        log.debug("\u6d41\u8f6c\u72b6\u6001\u5f00\u59cb");
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBo = new FscOrderStatusFlowAtomReqBO();
        fscPayOrderInfoItemList.forEach(fscPayOrderInfoItemPo -> {
            fscOrderStatusFlowAtomReqBo.setOrderId(fscPayOrderInfoItemPo.getPayObjectId());
            fscOrderStatusFlowAtomReqBo.setParamMap(paramMap);
            log.debug("\u6d41\u8f6c\u72b6\u6001\u5165\u53c2{}", (Object)fscOrderStatusFlowAtomReqBo);
            FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBo);
            log.debug("\u6d41\u8f6c\u72b6\u6001\u51fa\u53c2{}", (Object)atomRspBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                log.debug("\u6d41\u8f6c\u72b6\u6001\u5931\u8d25");
                throw new FscBusinessException("194202", atomRspBO.getRespDesc());
            }
        });
    }
}

