/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.common.api.LdUmcTimeDataDailyOrdersFunction;
import com.tydic.dyc.atom.common.bo.LdUmcTimeDataDailyOrdersFunctionReqBo;
import com.tydic.dyc.atom.common.bo.LdUmcTimeDataDailyOrdersFunctionRspBo;
import com.tydic.dyc.atom.common.bo.LdUocSaleOrderInfoBO;
import com.tydic.dyc.atom.common.util.DateUtil;
import com.tydic.dyc.umc.service.ldOrganization.UmcQryLdOrgInfoListService;
import com.tydic.dyc.umc.service.ldUser.bo.UmcUserAndOrgInfoBo;
import com.tydic.dyc.umc.service.reportForm.bo.UmcCreateDataDailyOrdersReqBo;
import com.tydic.dyc.umc.service.reportForm.bo.UmcCreateDataDailyOrdersRspBo;
import com.tydic.dyc.umc.service.reportForm.bo.UmcGetDataDailyOrdersListReqBo;
import com.tydic.dyc.umc.service.reportForm.bo.UmcGetDataDailyOrdersListRspBo;
import com.tydic.dyc.umc.service.reportForm.service.UmcCreateDataDailyOrdersService;
import com.tydic.dyc.umc.service.reportForm.service.UmcGetDataDailyOrdersListService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LdUmcTimeDataDailyOrdersFunctionImpl
implements LdUmcTimeDataDailyOrdersFunction {
    private static final Logger log = LoggerFactory.getLogger(LdUmcTimeDataDailyOrdersFunctionImpl.class);
    public static final String EXTERNAL = "2";
    public static final String INSIDE = "4";
    @Autowired
    private UmcGetDataDailyOrdersListService umcGetDataDailyOrdersListService;
    @Autowired
    private UmcQryLdOrgInfoListService umcQryLdOrgInfoListService;
    @Autowired
    private UmcCreateDataDailyOrdersService umcCreateDataDailyOrdersService;

    @Override
    public LdUmcTimeDataDailyOrdersFunctionRspBo timeDataDailyOrders(LdUmcTimeDataDailyOrdersFunctionReqBo reqBo) {
        log.debug("\u7edf\u8ba1\u6bcf\u65e5\u8ba2\u5355\u60c5\u51b5\u65f6\u8ba2\u5355\u67e5\u8be2\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)reqBo);
        this.checkIsDailyOrders(reqBo);
        UmcCreateDataDailyOrdersReqBo umcCreateDataDailyOrdersReqBo = this.getUmcCreateDataDailyOrdersReqBo(reqBo);
        HashSet<Long> smeOrgIds = new HashSet<Long>();
        HashSet<Long> restaurantOrgIds = new HashSet<Long>();
        HashSet<Long> kaOrgIds = new HashSet<Long>();
        List<UmcUserAndOrgInfoBo> umcUserAndOrgInfoBos = reqBo.getUmcUserAndOrgInfoBos();
        if (CollectionUtils.isNotEmpty(umcUserAndOrgInfoBos)) {
            for (UmcUserAndOrgInfoBo each : umcUserAndOrgInfoBos) {
                if ("1".equals(each.getEnterpriseType()) || EXTERNAL.equals(each.getEnterpriseType())) {
                    if (!"1".equals(each.getBusinessClassification())) {
                        smeOrgIds.add(each.getOrgId());
                    }
                    if ("3".equals(each.getBusinessClassification())) {
                        kaOrgIds.add(each.getOrgId());
                    }
                }
                if (!"1".equals(each.getBusinessClassification())) continue;
                restaurantOrgIds.add(each.getOrgId());
            }
        }
        umcCreateDataDailyOrdersReqBo.setSmeCustSum(BigDecimal.valueOf(smeOrgIds.size()));
        umcCreateDataDailyOrdersReqBo.setRestCustSum(BigDecimal.valueOf(restaurantOrgIds.size()));
        umcCreateDataDailyOrdersReqBo.setKaCustSum(BigDecimal.valueOf(kaOrgIds.size()));
        BigDecimal smeOrderCustSum = new BigDecimal(0);
        BigDecimal smeOrderMoneySum = new BigDecimal(0);
        BigDecimal smeOrderSum = new BigDecimal(0);
        BigDecimal interDirectOrderMoneySum = new BigDecimal(0);
        BigDecimal interDirectOrderSum = new BigDecimal(0);
        BigDecimal interTripartiteOrderMoneySum = new BigDecimal(0);
        BigDecimal interTripartiteOrderSum = new BigDecimal(0);
        BigDecimal restOrderCustSum = new BigDecimal(0);
        BigDecimal restOrderSum = new BigDecimal(0);
        BigDecimal restOrderMoneySum = new BigDecimal(0);
        BigDecimal interOrderSum = new BigDecimal(0);
        BigDecimal interOrderMoneySum = new BigDecimal(0);
        BigDecimal kaOrderCustSum = new BigDecimal(0);
        BigDecimal kaOrderSum = new BigDecimal(0);
        BigDecimal kaOrderMoneySum = new BigDecimal(0);
        HashSet<Long> smeOrderOrgIds = new HashSet<Long>();
        HashSet<Long> restOrderOrgIds = new HashSet<Long>();
        HashSet<Long> kaOrderOrgIds = new HashSet<Long>();
        List<LdUocSaleOrderInfoBO> rows = reqBo.getUocSaleOrderInfoBos();
        if (CollectionUtils.isNotEmpty(rows)) {
            for (LdUocSaleOrderInfoBO each : rows) {
                if (each.getPurchaseOrgId() == null) continue;
                Long purchaseOrgId = Long.valueOf(each.getPurchaseOrgId());
                if ("1".equals(each.getInternalUserFlag()) || EXTERNAL.equals(each.getInternalUserFlag())) {
                    if (CollectionUtils.isNotEmpty(smeOrgIds) && smeOrgIds.contains(purchaseOrgId)) {
                        smeOrderOrgIds.add(purchaseOrgId);
                        smeOrderMoneySum = smeOrderMoneySum.add(each.getSaleOrderTotal());
                        smeOrderSum = smeOrderSum.add(BigDecimal.valueOf(1L));
                    }
                    if (CollectionUtils.isNotEmpty(restaurantOrgIds) && smeOrgIds.contains(restaurantOrgIds)) {
                        restOrderOrgIds.add(purchaseOrgId);
                        restOrderMoneySum = restOrderMoneySum.add(each.getSaleOrderTotal());
                        restOrderSum = restOrderSum.add(BigDecimal.valueOf(1L));
                    }
                    if (!CollectionUtils.isNotEmpty(kaOrgIds) || !smeOrgIds.contains(kaOrgIds)) continue;
                    kaOrderOrgIds.add(purchaseOrgId);
                    kaOrderMoneySum = kaOrderMoneySum.add(each.getSaleOrderTotal());
                    kaOrderSum = kaOrderSum.add(BigDecimal.valueOf(1L));
                    continue;
                }
                if (!"3".equals(each.getInternalUserFlag()) && !INSIDE.equals(each.getInternalUserFlag())) continue;
                if (StringUtils.isNotBlank((String)each.getOrgNoFullPath()) && each.getOrgNoFullPath().contains("00000628")) {
                    interOrderMoneySum = interOrderMoneySum.add(each.getSaleOrderTotal());
                    interOrderSum = interOrderSum.add(BigDecimal.valueOf(1L));
                }
                if (!StringUtils.isNotBlank((String)each.getOrgNoFullPath()) || !each.getOrgNoFullPath().contains("00000866")) continue;
                if ("1".equals(each.getModelSettle())) {
                    interDirectOrderMoneySum = interDirectOrderMoneySum.add(each.getSaleOrderTotal());
                    interDirectOrderSum = interDirectOrderSum.add(BigDecimal.valueOf(1L));
                    continue;
                }
                if (!EXTERNAL.equals(each.getModelSettle())) continue;
                interTripartiteOrderMoneySum = interTripartiteOrderMoneySum.add(each.getSaleOrderTotal());
                interTripartiteOrderSum = interTripartiteOrderSum.add(BigDecimal.valueOf(1L));
            }
        }
        smeOrderCustSum = smeOrderCustSum.add(BigDecimal.valueOf(smeOrderOrgIds.size()));
        restOrderCustSum = restOrderCustSum.add(BigDecimal.valueOf(restOrderOrgIds.size()));
        kaOrderCustSum = kaOrderCustSum.add(BigDecimal.valueOf(kaOrderOrgIds.size()));
        umcCreateDataDailyOrdersReqBo.setSmeOrderCustSum(smeOrderCustSum);
        umcCreateDataDailyOrdersReqBo.setSmeOrderMoneySum(smeOrderMoneySum);
        umcCreateDataDailyOrdersReqBo.setSmeOrderSum(smeOrderSum);
        umcCreateDataDailyOrdersReqBo.setInterDirectOrderMoneySum(interDirectOrderMoneySum);
        umcCreateDataDailyOrdersReqBo.setInterDirectOrderSum(interDirectOrderSum);
        umcCreateDataDailyOrdersReqBo.setInterTripartiteOrderSum(interTripartiteOrderSum);
        umcCreateDataDailyOrdersReqBo.setInterTripartiteOrderMoneySum(interTripartiteOrderMoneySum);
        umcCreateDataDailyOrdersReqBo.setRestOrderSum(restOrderSum);
        umcCreateDataDailyOrdersReqBo.setRestOrderMoneySum(restOrderMoneySum);
        umcCreateDataDailyOrdersReqBo.setRestOrderCustSum(restOrderCustSum);
        umcCreateDataDailyOrdersReqBo.setKaOrderSum(kaOrderSum);
        umcCreateDataDailyOrdersReqBo.setKaOrderMoneySu(kaOrderMoneySum);
        umcCreateDataDailyOrdersReqBo.setKaOrderCustSum(kaOrderCustSum);
        umcCreateDataDailyOrdersReqBo.setInterOrderSum(interOrderSum);
        umcCreateDataDailyOrdersReqBo.setInterOrderMoneySum(interOrderMoneySum);
        umcCreateDataDailyOrdersReqBo.setCreatedTime(reqBo.getStatisticalTime());
        UmcCreateDataDailyOrdersRspBo dataDailyOrders = this.umcCreateDataDailyOrdersService.createDataDailyOrders(umcCreateDataDailyOrdersReqBo);
        if (!"0000".equals(dataDailyOrders.getRespCode())) {
            throw new ZTBusinessException(dataDailyOrders.getRespDesc());
        }
        LdUmcTimeDataDailyOrdersFunctionRspBo ldUmcTimeDataDailyOrdersFunctionRspBo = new LdUmcTimeDataDailyOrdersFunctionRspBo();
        return ldUmcTimeDataDailyOrdersFunctionRspBo;
    }

    private void checkIsDailyOrders(LdUmcTimeDataDailyOrdersFunctionReqBo reqBo) {
        UmcGetDataDailyOrdersListReqBo umcGetDataDailyOrdersListReqBo = new UmcGetDataDailyOrdersListReqBo();
        umcGetDataDailyOrdersListReqBo.setCreatedTimeStart(DateUtil.getCurrentDateEndTime(reqBo.getStatisticalTime()));
        umcGetDataDailyOrdersListReqBo.setCreatedTimeStart(DateUtil.getCurrentDateStartTime(reqBo.getStatisticalTime()));
        UmcGetDataDailyOrdersListRspBo dataDailyOrdersList = this.umcGetDataDailyOrdersListService.getDataDailyOrdersList(umcGetDataDailyOrdersListReqBo);
        if (!"0000".equals(dataDailyOrdersList.getRespCode())) {
            throw new ZTBusinessException(dataDailyOrdersList.getRespDesc());
        }
        if (CollectionUtils.isNotEmpty((Collection)dataDailyOrdersList.getRows())) {
            throw new ZTBusinessException("\u5df2\u7ecf\u65b0\u589e\u8fc7\u6bcf\u65e5\u8ba2\u5355\u60c5\u51b5\u7684\u6570\u636e\u4e86");
        }
    }

    private UmcCreateDataDailyOrdersReqBo getUmcCreateDataDailyOrdersReqBo(LdUmcTimeDataDailyOrdersFunctionReqBo reqBo) {
        UmcCreateDataDailyOrdersReqBo umcCreateDataDailyOrdersReqBo = new UmcCreateDataDailyOrdersReqBo();
        umcCreateDataDailyOrdersReqBo.setCreatedTime(reqBo.getStatisticalTime());
        umcCreateDataDailyOrdersReqBo.setSmeCustSum(new BigDecimal(0));
        umcCreateDataDailyOrdersReqBo.setSmeOrderCustSum(new BigDecimal(0));
        umcCreateDataDailyOrdersReqBo.setSmeOrderMoneySum(new BigDecimal(0));
        umcCreateDataDailyOrdersReqBo.setSmeOrderSum(new BigDecimal(0));
        umcCreateDataDailyOrdersReqBo.setInterDirectOrderMoneySum(new BigDecimal(0));
        umcCreateDataDailyOrdersReqBo.setInterDirectOrderSum(new BigDecimal(0));
        umcCreateDataDailyOrdersReqBo.setInterTripartiteOrderMoneySum(new BigDecimal(0));
        umcCreateDataDailyOrdersReqBo.setInterTripartiteOrderSum(new BigDecimal(0));
        umcCreateDataDailyOrdersReqBo.setRestCustSum(new BigDecimal(0));
        umcCreateDataDailyOrdersReqBo.setRestOrderCustSum(new BigDecimal(0));
        umcCreateDataDailyOrdersReqBo.setRestOrderMoneySum(new BigDecimal(0));
        umcCreateDataDailyOrdersReqBo.setRestOrderSum(new BigDecimal(0));
        umcCreateDataDailyOrdersReqBo.setInterOrderMoneySum(new BigDecimal(0));
        umcCreateDataDailyOrdersReqBo.setInterOrderSum(new BigDecimal(0));
        umcCreateDataDailyOrdersReqBo.setKaCustSum(new BigDecimal(0));
        umcCreateDataDailyOrdersReqBo.setKaOrderCustSum(new BigDecimal(0));
        umcCreateDataDailyOrdersReqBo.setKaOrderMoneySu(new BigDecimal(0));
        umcCreateDataDailyOrdersReqBo.setKaOrderSum(new BigDecimal(0));
        return umcCreateDataDailyOrdersReqBo;
    }
}

