/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.common.api.LdUmcGenerateContractFunction;
import com.tydic.dyc.atom.common.bo.DycUmcCreditAccountPeriodApplyFunctionBo;
import com.tydic.dyc.atom.common.bo.DycUmcCreditContractApplyFunctionBo;
import com.tydic.dyc.atom.common.bo.DycUmcCreditCustomerApplyFunctionBo;
import com.tydic.dyc.atom.common.bo.DycUmcCreditRelatedCustomerApplyFunctionBo;
import com.tydic.dyc.atom.common.bo.LdUmcGenerateContractReqBo;
import com.tydic.dyc.atom.common.bo.LdUmcGenerateContractRspBo;
import com.tydic.dyc.atom.common.util.AmountToWords;
import com.tydic.dyc.atom.common.util.PdfExporterUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.service.creditApply.UmcQryGenerateContractInfoService;
import com.tydic.dyc.umc.service.creditApply.bo.UmcQryGenerateContractInfoReqBo;
import com.tydic.dyc.umc.service.creditApply.bo.UmcQryGenerateContractInfoRspBo;
import com.tydic.dyc.umc.service.invoice.bo.UmcInvoiceInfoBo;
import com.tydic.dyc.umc.service.user.bo.UmcMemberBO;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class LdUmcGenerateContractFunctionImpl
implements LdUmcGenerateContractFunction {
    private static final Logger log = LoggerFactory.getLogger(LdUmcGenerateContractFunctionImpl.class);
    @Autowired
    private UmcQryGenerateContractInfoService umcQryGenerateContractInfoService;
    @Value(value="${CONTRACT_TEMPLATE1:http://10.0.11.60:8001/OSN/api/getQyentid/v1}")
    private String contractTemplate1;
    @Value(value="${CONTRACT_TEMPLATE2:http://10.0.11.60:8001/OSN/api/getQyentid/v1}")
    private String contractTemplate2;
    @Value(value="${CONTRACT_TEMPLATE3:http://10.0.11.60:8001/OSN/api/getQyentid/v1}")
    private String contractTemplate3;
    @Value(value="${CONTRACT_TEMPLATE4:http://10.0.11.60:8001/OSN/api/getQyentid/v1}")
    private String contractTemplate4;
    @Value(value="${CONTRACT_TEMPLATE5:http://10.0.11.60:8001/OSN/api/getQyentid/v1}")
    private String contractTemplate5;
    @Value(value="${CONTRACT_TEMPLATE6:http://10.0.11.60:8001/OSN/api/getQyentid/v1}")
    private String contractTemplate6;
    @Value(value="${CONTRACT_TEMPLATE7:http://10.0.11.60:8001/OSN/api/getQyentid/v1}")
    private String contractTemplate7;
    @Value(value="${CONTRACT_TEMPLATE8:http://10.0.11.60:8001/OSN/api/getQyentid/v1}")
    private String contractTemplate8;
    @Value(value="${CONTRACT_TEMPLATE9:http://10.0.11.60:8001/OSN/api/getQyentid/v1}")
    private String contractTemplate9;

    @Override
    public LdUmcGenerateContractRspBo generateContract(LdUmcGenerateContractReqBo reqBo) {
        LdUmcGenerateContractRspBo rspBo = new LdUmcGenerateContractRspBo();
        if (StringUtils.isBlank((CharSequence)reqBo.getInvoiceId())) {
            throw new ZTBusinessException("\u53d1\u7968Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UmcQryGenerateContractInfoReqBo umcQryGenerateContractInfoReqBo = new UmcQryGenerateContractInfoReqBo();
        umcQryGenerateContractInfoReqBo.setApplyId(reqBo.getApplyId());
        umcQryGenerateContractInfoReqBo.setInvoiceId(Long.valueOf(Long.parseLong(reqBo.getInvoiceId())));
        umcQryGenerateContractInfoReqBo.setOrgIdWeb(reqBo.getOrgIdWeb());
        UmcQryGenerateContractInfoRspBo umcQryGenerateContractInfoRspBo = this.umcQryGenerateContractInfoService.qryGenerateContractInfo(umcQryGenerateContractInfoReqBo);
        if (!"0000".equals(umcQryGenerateContractInfoRspBo.getRespCode())) {
            throw new ZTBusinessException(umcQryGenerateContractInfoRspBo.getRespDesc());
        }
        DycUmcCreditCustomerApplyFunctionBo umcCreditCustomerApplyFunctionBo = new DycUmcCreditCustomerApplyFunctionBo();
        String contractTemplate = "";
        if ("1".equals(umcCreditCustomerApplyFunctionBo.getEnterpriseType())) {
            if ("1".equals(umcCreditCustomerApplyFunctionBo.getParkClassification())) {
                contractTemplate = "1".equals(reqBo.getIsGuarantor()) ? this.contractTemplate4 : this.contractTemplate5;
            } else if ("2".equals(umcCreditCustomerApplyFunctionBo.getParkClassification())) {
                contractTemplate = "1".equals(reqBo.getIsGuarantor()) ? this.contractTemplate2 : this.contractTemplate3;
            } else if ("3".equals(umcCreditCustomerApplyFunctionBo.getParkClassification())) {
                contractTemplate = "1".equals(reqBo.getIsGuarantor()) ? this.contractTemplate8 : this.contractTemplate9;
            } else if ("4".equals(umcCreditCustomerApplyFunctionBo.getParkClassification())) {
                contractTemplate = "1".equals(reqBo.getIsGuarantor()) ? this.contractTemplate6 : this.contractTemplate7;
            } else if ("5".equals(umcCreditCustomerApplyFunctionBo.getParkClassification())) {
                contractTemplate = "1".equals(reqBo.getIsGuarantor()) ? this.contractTemplate4 : this.contractTemplate5;
            }
        }
        switch (contractTemplate) {
            case "2": {
                byte[] bytes2 = this.dealPdfExporter2(reqBo, this.contractTemplate2);
                break;
            }
            case "3": {
                log.debug("\u8fdb\u5165\u6a21\u72483{}", (Object)this.contractTemplate3);
                byte[] bytes3 = this.dealPdfExporter3(reqBo, this.contractTemplate3, umcQryGenerateContractInfoRspBo);
                rspBo.setStampedPdfBytes(bytes3);
                break;
            }
            case "4": {
                byte[] bytes4 = this.dealPdfExporter4(reqBo, this.contractTemplate4);
                break;
            }
            case "5": {
                byte[] bytes5 = this.dealPdfExporter5(reqBo, this.contractTemplate5);
                break;
            }
            case "6": {
                byte[] bytes6 = this.dealPdfExporter6(reqBo, this.contractTemplate6);
                break;
            }
            case "7": {
                byte[] bytes7 = this.dealPdfExporter7(reqBo, this.contractTemplate7);
                break;
            }
            case "8": {
                byte[] bytes8 = this.dealPdfExporter8(reqBo, this.contractTemplate8);
                break;
            }
            case "9": {
                byte[] bytes9 = this.dealPdfExporter9(reqBo, this.contractTemplate9);
                break;
            }
            default: {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[approval]\u4e0d\u5408\u6cd5");
            }
        }
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    private byte[] dealPdfExporter9(LdUmcGenerateContractReqBo reqBo, String contractTemplate9) {
        return new byte[0];
    }

    private byte[] dealPdfExporter8(LdUmcGenerateContractReqBo reqBo, String contractTemplate8) {
        return new byte[0];
    }

    private byte[] dealPdfExporter7(LdUmcGenerateContractReqBo reqBo, String contractTemplate7) {
        return new byte[0];
    }

    private byte[] dealPdfExporter6(LdUmcGenerateContractReqBo reqBo, String contractTemplate6) {
        return new byte[0];
    }

    private byte[] dealPdfExporter5(LdUmcGenerateContractReqBo reqBo, String contractTemplate5) {
        return new byte[0];
    }

    private byte[] dealPdfExporter4(LdUmcGenerateContractReqBo reqBo, String contractTemplate4) {
        return new byte[0];
    }

    private byte[] dealPdfExporter3(LdUmcGenerateContractReqBo reqBo, String url, UmcQryGenerateContractInfoRspBo umcQryGenerateContractInfoRspBo) {
        SimpleDateFormat day;
        SimpleDateFormat year;
        DycUmcCreditCustomerApplyFunctionBo umcCreditCustomerApplyBo = reqBo.getUmcCreditCustomerApplyBo();
        DycUmcCreditContractApplyFunctionBo umcCreditContractApplyBo = reqBo.getUmcCreditContractApplyBo();
        DycUmcCreditAccountPeriodApplyFunctionBo umcCreditAccountPeriodApplyBo = reqBo.getUmcCreditAccountPeriodApplyBo();
        UmcMemberBO umcMemberBo = umcQryGenerateContractInfoRspBo.getUmcMemberBo();
        UmcInvoiceInfoBo umcInvoiceInfoBo = umcQryGenerateContractInfoRspBo.getUmcInvoiceInfoBo();
        HashMap<String, String> replaceMap = new HashMap<String, String>();
        replaceMap.put("contractCode", "");
        SimpleDateFormat shortSdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date();
        String format = shortSdf.format(date.getTime());
        replaceMap.put("signingDate", format);
        replaceMap.put("orgNamePur", reqBo.getOrgNameWeb());
        replaceMap.put("addressPur", umcCreditCustomerApplyBo.getRegisteredAddress());
        replaceMap.put("legalRepresentative", umcCreditCustomerApplyBo.getLegalRepresentative());
        replaceMap.put("contactName", umcCreditCustomerApplyBo.getContactName());
        replaceMap.put("contactEmail", umcCreditCustomerApplyBo.getContactEmail());
        replaceMap.put("contactTel", umcCreditCustomerApplyBo.getContactPhone());
        replaceMap.put("bankAccountName", umcCreditCustomerApplyBo.getBankAccountName());
        replaceMap.put("bankAccount", umcCreditCustomerApplyBo.getBankAccount());
        replaceMap.put("dutyParagraph", umcCreditCustomerApplyBo.getDutyParagraph());
        replaceMap.put("companyTel", "");
        replaceMap.put("companyFax", "");
        if ("1".equals(umcCreditContractApplyBo.getProductPrice())) {
            replaceMap.put("productPrice", "A");
        } else if ("2".equals(umcCreditContractApplyBo.getProductPrice())) {
            replaceMap.put("productPrice", "B");
            replaceMap.put("productPriceRegular", umcCreditContractApplyBo.getProductPriceOther());
        } else if ("3".equals(umcCreditContractApplyBo.getProductPrice())) {
            replaceMap.put("productPrice", "C");
        } else if ("4".equals(umcCreditContractApplyBo.getProductPrice())) {
            replaceMap.put("productPrice", "D");
            replaceMap.put("productPriceOther", "");
        }
        if (reqBo.getCreditLimit() != null) {
            replaceMap.put("creditLimit", reqBo.getCreditLimit().toString());
            String str = AmountToWords.convertToWords(reqBo.getCreditLimit());
            replaceMap.put("creditLimitCap", str);
            replaceMap.put("creditlimitPur", reqBo.getCreditLimit().toString() + " " + str);
        }
        if (StringUtils.isNotBlank((CharSequence)umcCreditAccountPeriodApplyBo.getPaymentTime())) {
            String[] split = umcCreditAccountPeriodApplyBo.getPaymentTime().split(",");
            StringBuilder paymentTime = new StringBuilder();
            StringBuilder paymentPeriod = new StringBuilder();
            for (int i = 0; i < split.length; ++i) {
                if ("1".equals(split[i])) {
                    paymentTime.append("A");
                    paymentPeriod.append("\u73b0\u6b3e\u73b0\u8d27");
                } else if ("2".equals(split[i])) {
                    paymentTime.append("B");
                    paymentPeriod.append("\u6708\u7ed3");
                    String accountPeriod = umcCreditAccountPeriodApplyBo.getAccountPeriod();
                    if ("1".equals(accountPeriod)) {
                        paymentPeriod.append("+").append("\u5f00\u7968\u5f53\u6708\u6700\u540e\u4e00\u4e2a\u5de5\u4f5c\u65e5");
                    } else if ("2".equals(accountPeriod)) {
                        paymentPeriod.append("+").append("\u5f00\u7968\u6b21\u6708\u6700\u540e\u4e00\u4e2a\u5de5\u4f5c\u65e5");
                    } else if ("3".equals(accountPeriod)) {
                        paymentPeriod.append("+").append("\u7968\u523030\u5929");
                    }
                } else if ("3".equals(split[i])) {
                    paymentTime.append("C");
                    paymentPeriod.append("\u6839\u636e\u8ba2\u5355\u7684\u7ea6\u5b9a\u4ed8\u6b3e");
                } else if ("4".equals(split[i])) {
                    paymentTime.append("D");
                    paymentPeriod.append("\u5176\u4ed6");
                    replaceMap.put("paymentTimeOther", umcCreditAccountPeriodApplyBo.getExtField1());
                }
                if (i >= split.length - 1) continue;
                paymentPeriod.append("\u3001");
            }
            replaceMap.put("paymentTime", paymentTime.toString());
            replaceMap.put("paymentPeriod", paymentPeriod.toString());
        }
        if (umcCreditContractApplyBo.getContractEndTime() != null) {
            long time = umcCreditContractApplyBo.getContractEndTime().getTime();
            year = new SimpleDateFormat("yyyy");
            replaceMap.put("contractEndTimeYear", year.format(time));
            SimpleDateFormat moon = new SimpleDateFormat("MM");
            replaceMap.put("contractEndTimeMoon", moon.format(time));
            day = new SimpleDateFormat("dd");
            replaceMap.put("contractEndTimeDay", day.format(time));
        }
        replaceMap.put("contractAttachments", "");
        replaceMap.put("affiliatedCompanyName", umcCreditContractApplyBo.getAffiliatedCompanyName());
        if (umcCreditContractApplyBo.getSigningDate() != null) {
            long time = umcCreditContractApplyBo.getSigningDateEnd().getTime();
            year = new SimpleDateFormat("yyyy");
            replaceMap.put("signingDateYear", year.format(time));
            SimpleDateFormat moon = new SimpleDateFormat("MM");
            replaceMap.put("signingDateMoom", moon.format(time));
            day = new SimpleDateFormat("dd");
            replaceMap.put("signingDateDay", day.format(time));
        }
        replaceMap.put("signingNumber", umcCreditContractApplyBo.getSigningNumber());
        replaceMap.put("contractName", umcCreditContractApplyBo.getContractName());
        if ("1".equals(reqBo.getIsAffiliate())) {
            List<DycUmcCreditRelatedCustomerApplyFunctionBo> umcCreditRelatedCustomerApplyBos = reqBo.getUmcCreditRelatedCustomerApplyBos();
            int i = 1;
            for (DycUmcCreditRelatedCustomerApplyFunctionBo each : umcCreditRelatedCustomerApplyBos) {
                String relatedCustomerName = each.getRelatedCustomerName();
                String creditCode = each.getCreditCode();
                String address = each.getAddress();
                if (i == 1) {
                    replaceMap.put("affiliateName1", relatedCustomerName);
                    replaceMap.put("affiliateCredit1", creditCode);
                    replaceMap.put("affiliateAddress1", address);
                }
                if (i == 2) {
                    replaceMap.put("affiliateName2", relatedCustomerName);
                    replaceMap.put("affiliateCredit2", creditCode);
                    replaceMap.put("affiliateAddress2", address);
                }
                if (i == 3) {
                    replaceMap.put("affiliateName3", relatedCustomerName);
                    replaceMap.put("affiliateCredit3", creditCode);
                    replaceMap.put("affiliateAddress3", address);
                }
                ++i;
            }
        }
        replaceMap.put("regAccount", umcMemberBo.getRegAccount());
        replaceMap.put("custName", umcMemberBo.getCustName());
        replaceMap.put("custDuties", "");
        replaceMap.put("regMobile", umcMemberBo.getRegMobile());
        replaceMap.put("regEmail", umcMemberBo.getRegEmail());
        replaceMap.put("invoiceType", umcInvoiceInfoBo.getInvoiceTypeName());
        replaceMap.put("invoiceTitle", umcInvoiceInfoBo.getInvoiceTitle());
        replaceMap.put("taxpayerId", umcInvoiceInfoBo.getTaxpayerId());
        replaceMap.put("invoiceAddress", umcInvoiceInfoBo.getAddress());
        replaceMap.put("contact", umcInvoiceInfoBo.getContact());
        replaceMap.put("invoiceContactTel", umcInvoiceInfoBo.getPhone());
        replaceMap.put("bank", umcInvoiceInfoBo.getBank());
        replaceMap.put("invoicePhone", umcInvoiceInfoBo.getContactPhone());
        replaceMap.put("account", umcInvoiceInfoBo.getAccount());
        replaceMap.put("invoiceEmail", umcInvoiceInfoBo.getContactMail());
        byte[] bytes = PdfExporterUtil.dealPdfExporter(url, replaceMap);
        return bytes;
    }

    private byte[] dealPdfExporter2(LdUmcGenerateContractReqBo reqBo, String contractTemplate2) {
        return new byte[0];
    }
}

