/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.dyc.atom.common.api.LdUmcGetEntidFunction;
import com.tydic.dyc.atom.common.bo.LdUmcGetEntidFunctionBo;
import com.tydic.dyc.atom.common.bo.LdUmcGetEntidFunctionReqBo;
import com.tydic.dyc.atom.common.bo.LdUmcGetEntidFunctionRspBo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class LdUmcGetEntidFunctionImpl
implements LdUmcGetEntidFunction {
    private static final Logger log = LoggerFactory.getLogger(LdUmcGetEntidFunctionImpl.class);
    @Value(value="${GET_ENTID_URL:http://10.0.11.60:8001/OSN/api/getQyentid/v1}")
    private String getEntidUrl;
    @Autowired
    private CacheClient cacheService;
    @Value(value="${workflow_user_info:180}")
    private int WORKFLOW_USER_INFO;

    @Override
    public LdUmcGetEntidFunctionRspBo getEntid(LdUmcGetEntidFunctionReqBo reqBo) {
        LdUmcGetEntidFunctionBo reqObj = new LdUmcGetEntidFunctionBo();
        String redisKey = JSON.toJSONString((Object)((Object)reqBo));
        log.debug("\u83b7\u53d6\u4f01\u4e1a\u552f\u4e00\u6807\u8bc6\u63a5\u53e3-redis\u7684key\u503c\u4e3a\uff1a{}", (Object)redisKey);
        Object redisValue = this.cacheService.get(redisKey);
        log.debug("\u83b7\u53d6\u4f01\u4e1a\u552f\u4e00\u6807\u8bc6\u63a5\u53e3-redis\u83b7\u53d6\u5230\u7684\u503c\u4e3a\uff1a{}", redisValue);
        if (redisValue == null) {
            String key = "";
            if (CollectionUtil.isNotEmpty(reqBo.getEnterpriseName()) && !"[]".equals(reqBo.getEnterpriseName().toString())) {
                key = reqBo.getEnterpriseName().toString().replaceAll("(?:\\[|null|\\]| +)", "");
                reqObj.setKey(key);
                reqObj.setKey_type("1");
            }
            if (CollectionUtil.isNotEmpty(reqBo.getCreditCode()) && !"[]".equals(reqBo.getCreditCode().toString())) {
                key = reqBo.getCreditCode().toString().replaceAll("(?:\\[|null|\\]| +)", "");
                reqObj.setKey(key);
                reqObj.setKey_type("2");
            }
            if (CollectionUtil.isNotEmpty(reqBo.getRegistrationNo()) && !"[]".equals(reqBo.getRegistrationNo().toString())) {
                key = reqBo.getRegistrationNo().toString().replaceAll("(?:\\[|null|\\]| +)", "");
                reqObj.setKey(key);
                reqObj.setKey_type("3");
            }
            if (CollectionUtil.isNotEmpty(reqBo.getOrganizationCode()) && !"[]".equals(reqBo.getOrganizationCode().toString())) {
                key = reqBo.getOrganizationCode().toString().replaceAll("(?:\\[|null|\\]| +)", "");
                reqObj.setKey(key);
                reqObj.setKey_type("4");
            }
            String reqString = JSON.toJSONString((Object)reqObj);
            String url = this.getEntidUrl;
            log.debug("\u83b7\u53d6\u4f01\u4e1a\u552f\u4e00\u6807\u8bc6\u63a5\u53e3 \u5165\u53c2----url:{}\nreqString: {}", (Object)url, (Object)reqString);
            String result = SSLClient.doPost((String)url, (String)reqString);
            log.debug("\u83b7\u53d6\u4f01\u4e1a\u552f\u4e00\u6807\u8bc6\u63a5\u53e3 \u51fa\u53c2----result:{}", (Object)result);
            if (StringUtils.isBlank((CharSequence)result)) {
                throw new ZTBusinessException("\u83b7\u53d6\u4f01\u4e1a\u552f\u4e00\u6807\u8bc6\u6821\u9a8c\u5f02\u5e38");
            }
            LdUmcGetEntidFunctionRspBo rspBo = (LdUmcGetEntidFunctionRspBo)((Object)JSONObject.parseObject((String)result, LdUmcGetEntidFunctionRspBo.class));
            if (!"200".equals(rspBo.getCode())) {
                log.error("\u83b7\u53d6\u4f01\u4e1a\u552f\u4e00\u6807\u8bc6\u5931\u8d25:{}", (Object)rspBo.getMsg());
                throw new ZTBusinessException("\u64bc\u5730\u63a5\u53e3\u8c03\u7528\u5931\u8d25!");
            }
            this.cacheService.set(redisKey, (Object)JSON.toJSONString((Object)((Object)rspBo)), this.WORKFLOW_USER_INFO);
            return rspBo;
        }
        LdUmcGetEntidFunctionRspBo rspBO = (LdUmcGetEntidFunctionRspBo)((Object)JSONObject.parseObject((String)((String)redisValue), LdUmcGetEntidFunctionRspBo.class));
        log.debug("\u83b7\u53d6\u4f01\u4e1a\u552f\u4e00\u6807\u8bc6\u63a5\u53e3-redis\u89e3\u6790\u51fa\u6765\u7684\u503c\u4e3a\uff1a{}", (Object)rspBO);
        return rspBO;
    }
}

