/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.util;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfExporterUtil {
    private static final Logger log = LoggerFactory.getLogger(PdfExporterUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] dealPdfExporter(String importTemplate, Map<String, String> replaceMap) {
        InputStream fis = null;
        try {
            fis = new URL(importTemplate).openStream();
        }
        catch (IOException e) {
            log.error("\u6a21\u7248\u83b7\u53d6\u5931\u8d25{},{}", (Object)importTemplate, (Object)e.getMessage());
            throw new ZTBusinessException("\u6a21\u7248\u83b7\u53d6\u5931\u8d25");
        }
        if (fis == null) {
            throw new ZTBusinessException("\u6a21\u7248\u83b7\u53d6\u5931\u8d25");
        }
        PdfReader template = null;
        PdfStamper target = null;
        File targetTempFile = null;
        try {
            template = new PdfReader(fis);
            targetTempFile = File.createTempFile("pdfTemp", ".pdf");
            OutputStream outputStream = Files.newOutputStream(targetTempFile.toPath(), new OpenOption[0]);
            target = new PdfStamper(template, outputStream);
            AcroFields form = target.getAcroFields();
            BaseFont font = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            form.addSubstitutionFont(font);
            form.setGenerateAppearances(true);
            for (String map : replaceMap.keySet()) {
                form.setField(map, replaceMap.get(map));
            }
            target.setFormFlattening(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (target != null) {
                try {
                    target.close();
                }
                catch (DocumentException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (template != null) {
                template.close();
            }
        }
        if (targetTempFile == null) {
            throw new ZTBusinessException("\u4e34\u65f6pdf\u6587\u4ef6\u4e2d\u6ca1\u6709\u6570\u636e");
        }
        return PdfExporterUtil.getPdfFile(targetTempFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getPdfFile(File pdfFile) {
        try {
            PdfReader reader = new PdfReader(pdfFile.getAbsolutePath());
            ByteArrayOutputStream stamperOutputStream = new ByteArrayOutputStream();
            PdfStamper stamper = new PdfStamper(reader, (OutputStream)stamperOutputStream);
            stamper.close();
            reader.close();
            byte[] byArray = stamperOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            pdfFile.delete();
        }
        return null;
    }
}

