/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.impl;

import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.atom.common.api.LdUpcomingPushFunction;
import com.tydic.dyc.atom.common.bo.LdAddTaskMessageBo;
import com.tydic.dyc.atom.common.bo.LdUpcomingPushFunctionReqBo;
import com.tydic.dyc.atom.common.bo.LdUpcomingPushFunctionRspBo;
import com.tydic.dyc.umc.service.UnifiedWaitDown.UmcQueryUnifiedWaitDownService;
import com.tydic.dyc.umc.service.UnifiedWaitDown.bo.UmcQueryUnifiedWaitDownReqBO;
import com.tydic.dyc.umc.service.UnifiedWaitDown.bo.UmcQueryUnifiedWaitDownRspBO;
import com.tydic.dyc.umc.service.ldUser.UmcQryUserInfoListByUserIdsService;
import com.tydic.dyc.umc.service.ldUser.bo.UmcQryUserInfoBo;
import com.tydic.dyc.umc.service.ldUser.bo.UmcQryUserInfoListByUserIdsReqBo;
import com.tydic.dyc.umc.service.ldUser.bo.UmcQryUserInfoListByUserIdsRspBo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LdUpcomingPushFunctionImpl
implements LdUpcomingPushFunction {
    private static final Logger log = LoggerFactory.getLogger(LdUpcomingPushFunctionImpl.class);
    public static final String OPERATOR_TYPE = "7";
    public static final String LD_TODO = "LD_TODO_";
    public static final String SEPARATOR = ",";
    @Value(value="${ld_url:http://test1-lsugu.liando.cn:9191/}")
    private String ldUrl;
    @Autowired
    private KafkaProducer<String, String> kafkaProducer;
    @Autowired
    private UmcQueryUnifiedWaitDownService umcQueryUnifiedWaitDownService;
    @Autowired
    private UmcQryUserInfoListByUserIdsService umcQryUserInfoListByUserIdsService;
    @Autowired
    private CacheClient cacheService;
    @Value(value="${LD_SYSTEM_CODE:lsugu}")
    private String systemCode;
    @Value(value="${is_send_todo:false}")
    private Boolean isSendTodo;
    @Value(value="${KAFKA_ENABLE_LD:false}")
    private Boolean kafkaEnableLd;

    @Override
    public LdUpcomingPushFunctionRspBo sendToDone(LdUpcomingPushFunctionReqBo reqBo) {
        log.debug("\u8054\u4e1c\u5f85\u529e\u63a8\u9001\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)reqBo);
        this.checkInitReq(reqBo);
        LdUpcomingPushFunctionRspBo rspBo = new LdUpcomingPushFunctionRspBo();
        if (this.isSendTodo.booleanValue()) {
            UmcQueryUnifiedWaitDownReqBO umcQueryUnifiedWaitDownAbilityReqBO = new UmcQueryUnifiedWaitDownReqBO();
            umcQueryUnifiedWaitDownAbilityReqBO.setWaitCode(reqBo.getWaitCode());
            UmcQueryUnifiedWaitDownRspBO umcQueryUnifiedWaitDownAbilityRspBO = this.umcQueryUnifiedWaitDownService.queryUnified(umcQueryUnifiedWaitDownAbilityReqBO);
            if (!"0000".equals(umcQueryUnifiedWaitDownAbilityRspBO.getRespCode())) {
                throw new ZTBusinessException(umcQueryUnifiedWaitDownAbilityRspBO.getRespDesc());
            }
            log.debug("\u63a8\u9001\u5f85\u529e\u67e5\u8be2\u914d\u7f6e\u8868\u4e2d\u7684\u4fe1\u606f\uff1a{}", (Object)umcQueryUnifiedWaitDownAbilityRspBO);
            this.sendDone(reqBo, umcQueryUnifiedWaitDownAbilityRspBO);
            if (!CollectionUtils.isEmpty(reqBo.getTaskApproveIds())) {
                UmcQryUserInfoListByUserIdsReqBo umcQryUserInfoListByUserIdsReqBo = new UmcQryUserInfoListByUserIdsReqBo();
                umcQryUserInfoListByUserIdsReqBo.setUserIds(reqBo.getTaskApproveIds());
                UmcQryUserInfoListByUserIdsRspBo umcQryUserInfoListByUserIdsRspBo = this.umcQryUserInfoListByUserIdsService.qryUserInfoListByUserIds(umcQryUserInfoListByUserIdsReqBo);
                if (!"0000".equals(umcQryUserInfoListByUserIdsRspBo.getRespCode())) {
                    throw new ZTBusinessException(umcQryUserInfoListByUserIdsRspBo.getRespDesc());
                }
                log.debug("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)umcQryUserInfoListByUserIdsRspBo);
                List rows = umcQryUserInfoListByUserIdsRspBo.getRows();
                if (!CollectionUtils.isEmpty((Collection)rows)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (UmcQryUserInfoBo each : rows) {
                        if (StringUtils.isBlank((CharSequence)each.getRegAccount())) continue;
                        stringBuffer.append(each.getUserId());
                        stringBuffer.append(SEPARATOR);
                        this.sendToDone(reqBo, umcQueryUnifiedWaitDownAbilityRspBO, each);
                    }
                    this.cacheService.set(LD_TODO + reqBo.getOrderId(), (Object)stringBuffer);
                }
            }
        }
        return rspBo;
    }

    private void sendDone(LdUpcomingPushFunctionReqBo reqBo, UmcQueryUnifiedWaitDownRspBO umcQueryUnifiedWaitDownAbilityRspBO) {
        Object o = this.cacheService.get(LD_TODO + reqBo.getOrderId());
        if (o != null) {
            String str = o.toString();
            String[] taskApproveIds = str.split(SEPARATOR);
            ArrayList<Long> userIds = new ArrayList<Long>();
            for (String taskApproveId : taskApproveIds) {
                userIds.add(Long.parseLong(taskApproveId));
            }
            if (!CollectionUtils.isEmpty(userIds)) {
                UmcQryUserInfoListByUserIdsReqBo umcQryUserInfoListByUserIdsReqBo = new UmcQryUserInfoListByUserIdsReqBo();
                umcQryUserInfoListByUserIdsReqBo.setUserIds(userIds);
                UmcQryUserInfoListByUserIdsRspBo umcQryUserInfoListByUserIdsRspBo = this.umcQryUserInfoListByUserIdsService.qryUserInfoListByUserIds(umcQryUserInfoListByUserIdsReqBo);
                if (!"0000".equals(umcQryUserInfoListByUserIdsRspBo.getRespCode())) {
                    throw new ZTBusinessException(umcQryUserInfoListByUserIdsRspBo.getRespDesc());
                }
                log.debug("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)umcQryUserInfoListByUserIdsRspBo);
                List rows = umcQryUserInfoListByUserIdsRspBo.getRows();
                for (UmcQryUserInfoBo each : rows) {
                    LdAddTaskMessageBo ldAddTaskMessageBo = new LdAddTaskMessageBo();
                    ldAddTaskMessageBo.setOperatorType("4");
                    ldAddTaskMessageBo.setSystemCode(this.systemCode);
                    ldAddTaskMessageBo.setTaskId(reqBo.getOrderId() + each.getCustId());
                    ldAddTaskMessageBo.setTaskApproveNum(each.getRegAccount());
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String format = simpleDateFormat.format(new Date());
                    ldAddTaskMessageBo.setTaskDoneDate(format);
                    ldAddTaskMessageBo.setTaskArriveDate(format);
                    ldAddTaskMessageBo.setTodoType("\u94fe\u4e0aU\u8c37");
                    ldAddTaskMessageBo.setPcTaskUrl(this.ldUrl + "#/casBridge?extStr=" + reqBo.getWaitCode());
                    ldAddTaskMessageBo.setMobileTaskUrl(this.ldUrl);
                    ProducerRecord record = new ProducerRecord("q.from.lsugu.todo", (Object)"test_b", (Object)JSONArray.toJSONString((Object)ldAddTaskMessageBo));
                    RecordMetadata metadata = null;
                    if (!this.kafkaEnableLd.booleanValue()) continue;
                    try {
                        Future send = this.kafkaProducer.send(record);
                        metadata = (RecordMetadata)send.get();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.error("\u7ed9\u8054\u4e1c\u53d1\u9001\u5df2\u529e\u5931\u8d25{}", (Object)e.getMessage());
                        throw new ZTBusinessException("\u7ed9\u8054\u4e1c\u53d1\u9001\u5df2\u529e\u5931\u8d25:" + e.getMessage());
                    }
                    if (null != metadata) {
                        log.debug("\u540c\u6b65\u53d1\u9001\u540e\u83b7\u5f97\u5206\u533a\u4e3a :" + metadata.partition() + " \uff0c\u540c\u6b65\u53d1\u9001\u540e\u83b7\u5f97offset\u4e3a :" + metadata.offset());
                    }
                    this.kafkaProducer.close();
                }
            }
        }
    }

    private void sendToDone(LdUpcomingPushFunctionReqBo reqBo, UmcQueryUnifiedWaitDownRspBO umcQueryUnifiedWaitDownAbilityRspBO, UmcQryUserInfoBo each) {
        LdAddTaskMessageBo ldAddTaskMessageBo = new LdAddTaskMessageBo();
        ldAddTaskMessageBo.setOperatorType(OPERATOR_TYPE);
        ldAddTaskMessageBo.setSystemCode(this.systemCode);
        ldAddTaskMessageBo.setTaskId(reqBo.getOrderId() + each.getCustId());
        ldAddTaskMessageBo.setTitle(umcQueryUnifiedWaitDownAbilityRspBO.getTaskTitle());
        if (StringUtils.isBlank((CharSequence)reqBo.getTaskStartNum())) {
            ldAddTaskMessageBo.setTaskStartNum(each.getRegAccount());
        } else {
            ldAddTaskMessageBo.setTaskStartNum(reqBo.getTaskStartNum());
        }
        ldAddTaskMessageBo.setTaskApproveNum(each.getRegAccount());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String format = simpleDateFormat.format(new Date());
        ldAddTaskMessageBo.setTaskArriveDate(format);
        ldAddTaskMessageBo.setTodoType("\u94fe\u4e0aU\u8c37");
        ldAddTaskMessageBo.setPcTaskUrl(this.ldUrl + "#/casBridge?extStr=" + reqBo.getWaitCode());
        ldAddTaskMessageBo.setMobileTaskUrl(this.ldUrl);
        ldAddTaskMessageBo.setTitle(umcQueryUnifiedWaitDownAbilityRspBO.getTaskTitle());
        ProducerRecord record = new ProducerRecord("q.from.lsugu.todo", (Object)"test_b", (Object)JSONArray.toJSONString((Object)ldAddTaskMessageBo));
        RecordMetadata metadata = null;
        if (this.kafkaEnableLd.booleanValue()) {
            try {
                Future send = this.kafkaProducer.send(record);
                metadata = (RecordMetadata)send.get();
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u7ed9\u8054\u4e1c\u53d1\u9001\u5f85\u529e\u5931\u8d25{}", (Object)e.getMessage());
                throw new ZTBusinessException("\u7ed9\u8054\u4e1c\u53d1\u9001\u5f85\u529e\u5931\u8d25:" + e.getMessage());
            }
            if (null != metadata) {
                log.debug("\u540c\u6b65\u53d1\u9001\u540e\u83b7\u5f97\u5206\u533a\u4e3a :" + metadata.partition() + " \uff0c\u540c\u6b65\u53d1\u9001\u540e\u83b7\u5f97offset\u4e3a :" + metadata.offset());
            }
            this.kafkaProducer.close();
        }
    }

    public void checkInitReq(LdUpcomingPushFunctionReqBo reqBo) {
        if (null == reqBo) {
            throw new ZTBusinessException("\u5165\u53c2\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOrderId())) {
            throw new ZTBusinessException("\u5ba1\u6279id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getWaitCode())) {
            throw new ZTBusinessException("\u914d\u7f6e\u8868\u4e2d\u7684code\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBo.getTaskApproveIds())) {
            throw new ZTBusinessException("\u4efb\u52a1\u5ba1\u6279\u4eba\u7684\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public LdUpcomingPushFunctionRspBo endOfProcess(LdUpcomingPushFunctionReqBo reqBo) {
        if (null == reqBo) {
            throw new ZTBusinessException("\u5165\u53c2\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOrderId())) {
            throw new ZTBusinessException("\u5ba1\u6279id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getWaitCode())) {
            throw new ZTBusinessException("\u914d\u7f6e\u8868\u4e2d\u7684code\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.isSendTodo.booleanValue()) {
            UmcQueryUnifiedWaitDownReqBO umcQueryUnifiedWaitDownAbilityReqBO = new UmcQueryUnifiedWaitDownReqBO();
            umcQueryUnifiedWaitDownAbilityReqBO.setWaitCode(reqBo.getWaitCode());
            UmcQueryUnifiedWaitDownRspBO umcQueryUnifiedWaitDownAbilityRspBO = this.umcQueryUnifiedWaitDownService.queryUnified(umcQueryUnifiedWaitDownAbilityReqBO);
            if (!"0000".equals(umcQueryUnifiedWaitDownAbilityRspBO.getRespCode())) {
                throw new ZTBusinessException(umcQueryUnifiedWaitDownAbilityRspBO.getRespDesc());
            }
            this.sendDone(reqBo, umcQueryUnifiedWaitDownAbilityRspBO);
            this.cacheService.delete(LD_TODO + reqBo.getOrderId());
        }
        LdUpcomingPushFunctionRspBo rspBo = new LdUpcomingPushFunctionRspBo();
        return rspBo;
    }
}

