/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.util;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfExporterUtil {
    private static final Logger log = LoggerFactory.getLogger(PdfExporterUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getPdfFile(File pdfFile) {
        try {
            PdfReader reader = new PdfReader(pdfFile.getAbsolutePath());
            ByteArrayOutputStream stamperOutputStream = new ByteArrayOutputStream();
            PdfStamper stamper = new PdfStamper(reader, (OutputStream)stamperOutputStream);
            stamper.close();
            reader.close();
            byte[] byArray = stamperOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("pdf\u751f\u6210\u5931\u8d25{}", (Object)e.getMessage());
        }
        finally {
            pdfFile.delete();
        }
        return null;
    }

    public static InputStream getInputStream(String url) {
        InputStream fis = null;
        try {
            fis = new URL(url).openStream();
        }
        catch (IOException e) {
            log.error("\u6a21\u7248\u83b7\u53d6\u5931\u8d25{},{}", (Object)url, (Object)e.getMessage());
            throw new ZTBusinessException("\u6a21\u7248\u83b7\u53d6\u5931\u8d25");
        }
        if (fis == null) {
            throw new ZTBusinessException("\u6a21\u7248\u83b7\u53d6\u5931\u8d25");
        }
        return fis;
    }

    public static void replacePdfStamper(Map<String, String> replaceMap, Map<String, String> checkBoxMap, PdfReader reader, ByteArrayOutputStream bos, BaseFont baseFont) throws DocumentException, IOException {
        PdfStamper stamper = new PdfStamper(reader, (OutputStream)bos);
        ArrayList<BaseFont> substitutionFonts = new ArrayList<BaseFont>();
        substitutionFonts.add(baseFont);
        AcroFields form = stamper.getAcroFields();
        form.setSubstitutionFonts(substitutionFonts);
        for (String map : replaceMap.keySet()) {
            form.setFieldProperty(map, "textfont", (Object)baseFont, null);
            form.setField(map, replaceMap.get(map));
        }
        for (String map : checkBoxMap.keySet()) {
            form.setField(map, checkBoxMap.get(map), true);
        }
        stamper.setFormFlattening(true);
        stamper.close();
    }

    public static BaseFont createFont() throws DocumentException, IOException {
        String fontPath = "https://liando-mall-prod.oss-cn-beijing.aliyuncs.com/cfc/contractPdf/SIMSUN.TTC";
        return BaseFont.createFont((String)(fontPath + ",0"), (String)"Identity-H", (boolean)true);
    }

    public static void createBlankTable(PdfWriter writer, Document document, BaseFont font, int height) throws DocumentException {
        PdfPTable table = new PdfPTable(new float[]{30.0f});
        table.setTotalWidth(600.0f);
        table.setPaddingTop(500.0f);
        table.setLockedWidth(true);
        table.setHorizontalAlignment(1);
        table.writeSelectedRows(0, -1, 500.0f, 800.0f, writer.getDirectContentUnder());
        Font textFont = new Font(font, 7.0f, 0);
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(" ", textFont));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(6);
        cell.setBorder(0);
        cell.setFixedHeight((float)height);
        cell.setColspan(1);
        table.addCell(cell);
        document.add((Element)table);
    }

    public static PdfPCell createSetCell(String value, Font font, int colspan, int horizontalAlignment) {
        PdfPCell cell = new PdfPCell();
        cell.setPhrase(new Phrase(value, font));
        cell.setColspan(colspan);
        cell.setVerticalAlignment(1);
        cell.setHorizontalAlignment(horizontalAlignment);
        return cell;
    }
}

