/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.selfrun.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.selfrun.api.LdUocCancelContractFunction;
import com.tydic.dyc.atom.selfrun.api.LdUocEQryContractStateFunction;
import com.tydic.dyc.atom.selfrun.api.LdUocERescissionContractFunction;
import com.tydic.dyc.atom.selfrun.api.LdUocERevokeContractFunction;
import com.tydic.dyc.atom.selfrun.bo.LdUocCancelContractFunctionReqBo;
import com.tydic.dyc.atom.selfrun.bo.LdUocCancelContractFunctionRspBo;
import com.tydic.dyc.atom.selfrun.bo.LdUocEQryContractStateFunctionReqBo;
import com.tydic.dyc.atom.selfrun.bo.LdUocEQryContractStateFunctionRspBo;
import com.tydic.dyc.atom.selfrun.bo.LdUocERescissionContractFunctionReqBo;
import com.tydic.dyc.atom.selfrun.bo.LdUocERescissionContractFunctionRspBo;
import com.tydic.dyc.atom.selfrun.bo.LdUocERevokeContractFunctionReqBo;
import com.tydic.dyc.atom.selfrun.bo.LdUocERevokeContractFunctionRspBo;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.oc.constants.UocExtConstant;
import com.tydic.dyc.oc.service.contract.UocQryContractManageInfoService;
import com.tydic.dyc.oc.service.contract.UocUpdateContractManageInfoService;
import com.tydic.dyc.oc.service.contract.bo.UocContractOperationRecordsBo;
import com.tydic.dyc.oc.service.contract.bo.UocQryContractManageInfoReqBo;
import com.tydic.dyc.oc.service.contract.bo.UocQryContractManageInfoRspBo;
import com.tydic.dyc.oc.service.contract.bo.UocUpdateContractManageInfoReqBo;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LdUocCancelContractFunctionImpl
implements LdUocCancelContractFunction {
    private static final Logger log = LoggerFactory.getLogger(LdUocCancelContractFunctionImpl.class);
    public static final Integer SIGN_FLOW_STATUS_SIGNING = 1;
    public static final Integer SIGN_FLOW_STATUS_COMPLETE = 2;
    @Autowired
    private UocQryContractManageInfoService uocQryContractManageInfoService;
    @Autowired
    private UocUpdateContractManageInfoService uocUpdateContractManageInfoService;
    @Autowired
    private LdUocEQryContractStateFunction ldUocEQryContractStateFunction;
    @Autowired
    private LdUocERevokeContractFunction ldUocERevokeContractFunction;
    @Autowired
    private LdUocERescissionContractFunction ldUocERescissionContractFunction;

    @Override
    public LdUocCancelContractFunctionRspBo createContractManage(LdUocCancelContractFunctionReqBo reqBO) {
        this.validateParam(reqBO);
        UocQryContractManageInfoRspBo uocQryContractManageInfoRspBo = this.getUocQryContractManageInfoRspBo(reqBO);
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(UocExtConstant.SignatureContractState.DRAFT);
        statusList.add(UocExtConstant.SignatureContractState.REFUSED);
        statusList.add(UocExtConstant.SignatureContractState.EXPIRED);
        ArrayList<Integer> statusEList = new ArrayList<Integer>();
        statusEList.add(UocExtConstant.SignatureContractState.ARCHIVED);
        statusEList.add(UocExtConstant.SignatureContractState.SIGNING);
        if (statusList.contains(uocQryContractManageInfoRspBo.getContractState())) {
            this.updateContractManageInfo(reqBO, uocQryContractManageInfoRspBo, UocExtConstant.SignatureContractState.CANCELED);
        } else if (statusEList.contains(uocQryContractManageInfoRspBo.getContractState())) {
            if (uocQryContractManageInfoRspBo.getSigningMethod().equals(UocExtConstant.SignatureMethod.OFFLINE)) {
                this.updateContractManageInfo(reqBO, uocQryContractManageInfoRspBo, UocExtConstant.SignatureContractState.CANCELED);
            } else {
                this.dealCallSign(reqBO, uocQryContractManageInfoRspBo);
            }
        } else {
            throw new ZTBusinessException("\u8be5\u72b6\u6001\u7684\u5408\u540c\u4e0d\u5141\u8bb8\u53d6\u6d88");
        }
        LdUocCancelContractFunctionRspBo rspBo = new LdUocCancelContractFunctionRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void dealCallSign(LdUocCancelContractFunctionReqBo reqBO, UocQryContractManageInfoRspBo uocQryContractManageInfoRspBo) {
        LdUocEQryContractStateFunctionReqBo qryContractStateFunctionReqBo = new LdUocEQryContractStateFunctionReqBo();
        qryContractStateFunctionReqBo.setSignFlowId(uocQryContractManageInfoRspBo.getSignFlowId());
        LdUocEQryContractStateFunctionRspBo qryContractStateFunctionRspBo = this.ldUocEQryContractStateFunction.qryContractState(qryContractStateFunctionReqBo);
        if (qryContractStateFunctionRspBo.getSignFlowStatus().equals(SIGN_FLOW_STATUS_SIGNING)) {
            LdUocERevokeContractFunctionReqBo revokeContractFunctionReqBo = new LdUocERevokeContractFunctionReqBo();
            revokeContractFunctionReqBo.setSignFlowId(uocQryContractManageInfoRspBo.getSignFlowId());
            revokeContractFunctionReqBo.setRevokeReason(reqBO.getRemark());
            LdUocERevokeContractFunctionRspBo revokeContractFunctionRspBo = this.ldUocERevokeContractFunction.revokeContract(revokeContractFunctionReqBo);
            if (!"0".equals(revokeContractFunctionRspBo.getCode())) {
                throw new ZTBusinessException("\u8c03\u7528E\u7b7e\u5b9d\u64a4\u9500\u6d41\u7a0b\u5931\u8d25");
            }
            this.updateContractManageInfo(reqBO, uocQryContractManageInfoRspBo, UocExtConstant.SignatureContractState.CANCELLING);
        } else if (qryContractStateFunctionRspBo.getSignFlowStatus().equals(SIGN_FLOW_STATUS_COMPLETE)) {
            LdUocERescissionContractFunctionReqBo rescissionContractFunctionReqBo = (LdUocERescissionContractFunctionReqBo)((Object)JUtil.js((Object)((Object)reqBO), LdUocERescissionContractFunctionReqBo.class));
            LdUocERescissionContractFunctionRspBo rescissionContractFunctionRspBo = this.ldUocERescissionContractFunction.revokeContract(rescissionContractFunctionReqBo);
            if (!"0".equals(rescissionContractFunctionRspBo.getCode())) {
                throw new ZTBusinessException("\u8c03\u7528E\u7b7e\u5b9d\u89e3\u7ea6\u6d41\u7a0b\u5931\u8d25");
            }
            uocQryContractManageInfoRspBo.setCancelFlowId(rescissionContractFunctionRspBo.getCancelFlowId());
            this.updateContractManageInfo(reqBO, uocQryContractManageInfoRspBo, UocExtConstant.SignatureContractState.CANCELLING);
        } else {
            this.updateContractManageInfo(reqBO, uocQryContractManageInfoRspBo, UocExtConstant.SignatureContractState.CANCELED);
        }
    }

    private void updateContractManageInfo(LdUocCancelContractFunctionReqBo reqBO, UocQryContractManageInfoRspBo uocQryContractManageInfoRspBo, Integer status) {
        UocUpdateContractManageInfoReqBo uocUpdateContractManageInfoReqBo = new UocUpdateContractManageInfoReqBo();
        uocUpdateContractManageInfoReqBo.setContractState(status);
        uocUpdateContractManageInfoReqBo.setUpdatedId(reqBO.getUserIdIn());
        uocUpdateContractManageInfoReqBo.setUpdatedName(reqBO.getCustNameIn());
        uocUpdateContractManageInfoReqBo.setContractId(uocQryContractManageInfoRspBo.getContractId());
        uocUpdateContractManageInfoReqBo.setCancelFlowId(uocQryContractManageInfoRspBo.getCancelFlowId());
        UocContractOperationRecordsBo uocContractOperationRecordsBo = new UocContractOperationRecordsBo();
        uocContractOperationRecordsBo.setOperationType("5");
        uocContractOperationRecordsBo.setContractId(uocQryContractManageInfoRspBo.getContractId());
        uocContractOperationRecordsBo.setRemark(reqBO.getRemark());
        uocUpdateContractManageInfoReqBo.setUocContractOperationRecordsBo(uocContractOperationRecordsBo);
        this.uocUpdateContractManageInfoService.updateContractManageInfo(uocUpdateContractManageInfoReqBo);
    }

    private UocQryContractManageInfoRspBo getUocQryContractManageInfoRspBo(LdUocCancelContractFunctionReqBo reqBO) {
        UocQryContractManageInfoReqBo uocQryContractManageInfoReqBo = (UocQryContractManageInfoReqBo)JUtil.js((Object)((Object)reqBO), UocQryContractManageInfoReqBo.class);
        uocQryContractManageInfoReqBo.setIsQryAttachmentInfo(Boolean.valueOf(true));
        UocQryContractManageInfoRspBo uocQryContractManageInfoRspBo = this.uocQryContractManageInfoService.qryContractManageInfo(uocQryContractManageInfoReqBo);
        if (!"0000".equals(uocQryContractManageInfoRspBo.getRespCode())) {
            log.error("\u67e5\u8be2\u5408\u540c\u4fe1\u606f\u5931\u8d25:{}", (Object)uocQryContractManageInfoRspBo.getMessage());
            throw new ZTBusinessException("\u67e5\u8be2\u5408\u540c\u4fe1\u606f\u5931\u8d25");
        }
        return uocQryContractManageInfoRspBo;
    }

    private void validateParam(LdUocCancelContractFunctionReqBo reqBo) {
        if (null == reqBo) {
            throw new ZTBusinessException("reqBo\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

