/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.selfrun.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.constants.EsignHeaderConstant;
import com.tydic.dyc.atom.base.utils.EsignFileBean;
import com.tydic.dyc.atom.base.utils.HttpClientUtil;
import com.tydic.dyc.atom.selfrun.api.LdUocEUploadPendingDocumentsFunction;
import com.tydic.dyc.atom.selfrun.bo.LdUocERspBo;
import com.tydic.dyc.atom.selfrun.bo.LdUocEUploadPendingDocumentsFunctionReqBO;
import com.tydic.dyc.atom.selfrun.bo.LdUocEUploadPendingDocumentsFunctionRspBO;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class LdUocEUploadPendingDocumentsFunctionImpl
implements LdUocEUploadPendingDocumentsFunction {
    private static final Logger log = LoggerFactory.getLogger(LdUocEUploadPendingDocumentsFunctionImpl.class);
    public static final String CODE = "0";
    @Value(value="${E_GET_FILE_UPLOAD_URL:http://59.110.216.211/OSN/api/queryUser/v1}")
    private String eGetFileUploadUrl;
    @Value(value="${E_GET_FILE_UPLOAD_STATUS_URL:http://59.110.216.211/OSN/api/queryUser/v1}")
    private String eGetFileUploadStatusUrl;

    @Override
    public LdUocEUploadPendingDocumentsFunctionRspBO uploadPendingDocuments(LdUocEUploadPendingDocumentsFunctionReqBO reqBO) {
        this.validateParam(reqBO);
        EsignFileBean esignFileBean = new EsignFileBean(reqBO.getFilePath());
        JSONObject jsonObject = this.sendEGetFileUploadUrl(esignFileBean);
        String fileId = jsonObject.get((Object)"fileId").toString();
        if (StringUtils.isBlank((CharSequence)fileId)) {
            throw new ZTBusinessException("\u83b7\u53d6\u5230\u5230\u6587\u4ef6id\u4e3a\u7a7a");
        }
        String fileUploadUrl = jsonObject.get((Object)"fileUploadUrl").toString();
        if (StringUtils.isBlank((CharSequence)fileId)) {
            throw new ZTBusinessException("\u83b7\u53d6\u5230\u5230\u6587\u4ef6\u4e0a\u4f20url\u4e3a\u7a7a");
        }
        LdUocEUploadPendingDocumentsFunctionImpl.uploadFile(esignFileBean, fileUploadUrl);
        if (reqBO.getIsPolling() != null && reqBO.getIsPolling().booleanValue()) {
            this.sendQryFileStatus(fileId);
        }
        LdUocEUploadPendingDocumentsFunctionRspBO rspBO = new LdUocEUploadPendingDocumentsFunctionRspBO();
        rspBO.setFileId(fileId);
        rspBO.setFileName(esignFileBean.getFileName());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void sendQryFileStatus(String fileId) {
        for (int i = 0; i < 3; ++i) {
            JSONObject jsonParam = new JSONObject();
            jsonParam.put("fileId", (Object)fileId);
            log.debug("\u8c03\u7528e\u7b7e\u5b9d\u67e5\u8be2\u6587\u4ef6\u72b6\u6001\u5165\u53c2\uff1a{}", (Object)jsonParam);
            JSONObject jsonObject = HttpClientUtil.httpPost((String)this.eGetFileUploadStatusUrl, (JSONObject)jsonParam);
            log.debug("\u8c03\u7528e\u7b7e\u5b9d\u67e5\u8be2\u6587\u4ef6\u72b6\u6001\u51fa\u53c2\uff1a{}", (Object)jsonObject);
            LdUocERspBo ldUocERspBo = (LdUocERspBo)((Object)JSON.parseObject((String)jsonObject.toJSONString(), LdUocERspBo.class));
            if (!CODE.equals(ldUocERspBo.getCode()) || ldUocERspBo.getData() == null) {
                throw new ZTBusinessException("\u8c03\u7528e\u7b7e\u5b9d\u67e5\u8be2\u6587\u4ef6\u72b6\u6001\u5931\u8d25");
            }
            Object fileStatus = JSON.parseObject((String)ldUocERspBo.getData().toString()).get((Object)"fileStatus");
            if (fileStatus == null) {
                throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u6587\u4ef6\u72b6\u6001");
            }
            log.debug(String.format("\u67e5\u8be2\u6587\u4ef6\u72b6\u6001\u6267\u884c\u7b2c%s\u6b21", i + 1));
            String status = fileStatus.toString();
            if ("2".equalsIgnoreCase(status) || "5".equalsIgnoreCase(status)) {
                log.debug("\u6587\u4ef6\u51c6\u5907\u5b8c\u6210");
                break;
            }
            log.debug("\u6587\u4ef6\u672a\u51c6\u5907\u5b8c\u6210,\u7b49\u5f85\u4e24\u79d2\u91cd\u65b0\u67e5\u8be2");
            try {
                TimeUnit.SECONDS.sleep(2L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void uploadFile(EsignFileBean esignFileBean, String fileUploadUrl) {
        HashMap<String, String> header = new HashMap<String, String>(2);
        header.put("Content-MD5", esignFileBean.getFileContentMD5());
        header.put("Content-Type", EsignHeaderConstant.CONTENTTYPE_STREAM.VALUE());
        try {
            LdUocEUploadPendingDocumentsFunctionImpl.sendHttpPut(fileUploadUrl, esignFileBean.getFileBytes(), header);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u4e0a\u4f20\u6587\u4ef6\u6d41\u63a5\u53e3\u5931\u8d25{}", (Object)e.getMessage());
        }
    }

    private JSONObject sendEGetFileUploadUrl(EsignFileBean esignFileBean) {
        String jsonParam = "{\n    \"contentMd5\": \"" + esignFileBean.getFileContentMD5() + "\",\n    \"fileName\":\"" + esignFileBean.getFileName() + "\",    \"fileSize\": " + esignFileBean.getFileSize() + ",\n    \"convertToPDF\": false,\n    \"contentType\": \"" + EsignHeaderConstant.CONTENTTYPE_STREAM.VALUE() + "\"\n}";
        log.debug("\u8c03\u7528e\u7b7e\u5b9d\u83b7\u53d6\u6587\u4ef6\u4e0a\u4f20\u5730\u5740\u5165\u53c2\uff1a{}", (Object)jsonParam);
        String paramRsp = HttpUtil.post((String)this.eGetFileUploadUrl, (String)jsonParam);
        log.debug("\u8c03\u7528e\u7b7e\u5b9d\u83b7\u53d6\u6587\u4ef6\u4e0a\u4f20\u5730\u5740\u51fa\u53c2\uff1a{}", (Object)paramRsp);
        LdUocERspBo ldUocERspBo = (LdUocERspBo)((Object)JSON.parseObject((String)paramRsp, LdUocERspBo.class));
        if (!CODE.equals(ldUocERspBo.getCode())) {
            throw new ZTBusinessException("\u8c03\u7528e\u7b7e\u5b9d\u6587\u4ef6\u4e0a\u4f20\u63a5\u53e3\u5931\u8d25");
        }
        return JSON.parseObject((String)ldUocERspBo.getData().toString());
    }

    private static String sendHttpPut(String url, byte[] requestBody, Map<String, String> headers) throws IOException {
        HttpResponse httpResponse;
        HttpEntity responseEntity;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPut httpPut = new HttpPut(url);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            httpPut.setHeader(entry.getKey(), entry.getValue());
        }
        if (requestBody != null) {
            httpPut.setEntity((HttpEntity)new ByteArrayEntity(requestBody));
        }
        if ((responseEntity = (httpResponse = httpClient.execute((HttpUriRequest)httpPut)).getEntity()) != null) {
            return EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8);
        }
        return null;
    }

    private void validateParam(LdUocEUploadPendingDocumentsFunctionReqBO reqBo) {
        if (null == reqBo) {
            throw new ZTBusinessException("\u5165\u53c2reqBo\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getFilePath())) {
            throw new ZTBusinessException("\u5165\u53c2\u6587\u4ef6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

