/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.selfrun.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.constants.EsignHeaderConstant;
import com.tydic.dyc.atom.base.utils.EsignFileBean;
import com.tydic.dyc.atom.base.utils.EsignFileTransformation;
import com.tydic.dyc.atom.base.utils.HttpClientUtil;
import com.tydic.dyc.atom.selfrun.api.LdUocEUploadPendingDocumentsFunction;
import com.tydic.dyc.atom.selfrun.bo.LdUocERspBo;
import com.tydic.dyc.atom.selfrun.bo.LdUocEUploadPendingDocumentsFunctionReqBO;
import com.tydic.dyc.atom.selfrun.bo.LdUocEUploadPendingDocumentsFunctionRspBO;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class LdUocEUploadPendingDocumentsFunctionImpl
implements LdUocEUploadPendingDocumentsFunction {
    private static final Logger log = LoggerFactory.getLogger(LdUocEUploadPendingDocumentsFunctionImpl.class);
    public static final String CODE = "0";
    @Value(value="${E_GET_FILE_UPLOAD_URL:${ESB_ACCESS_IP}/OSN/api/eSignfileUploadUrl/v1}")
    private String eGetFileUploadUrl;
    @Value(value="${E_GET_FILE_UPLOAD_STATUS_URL:${ESB_ACCESS_IP}/OSN/api/eSignfiles/v1}")
    private String eGetFileUploadStatusUrl;

    @Override
    public LdUocEUploadPendingDocumentsFunctionRspBO uploadPendingDocuments(LdUocEUploadPendingDocumentsFunctionReqBO reqBO) {
        this.validateParam(reqBO);
        EsignFileBean esignFileBean = new EsignFileBean(reqBO.getFilePath(), reqBO.getFileName());
        JSONObject jsonObject = this.sendEGetFileUploadUrl(esignFileBean);
        String fileId = jsonObject.get((Object)"fileId").toString();
        if (StringUtils.isBlank((CharSequence)fileId)) {
            throw new ZTBusinessException("\u83b7\u53d6\u5230\u5230\u6587\u4ef6id\u4e3a\u7a7a");
        }
        String fileUploadUrl = jsonObject.get((Object)"fileUploadUrl").toString();
        if (StringUtils.isBlank((CharSequence)fileId)) {
            throw new ZTBusinessException("\u83b7\u53d6\u5230\u5230\u6587\u4ef6\u4e0a\u4f20url\u4e3a\u7a7a");
        }
        LdUocEUploadPendingDocumentsFunctionImpl.uploadFile(esignFileBean, fileUploadUrl);
        LdUocEUploadPendingDocumentsFunctionRspBO rspBO = new LdUocEUploadPendingDocumentsFunctionRspBO();
        if (reqBO.getIsPolling() != null && reqBO.getIsPolling().booleanValue()) {
            Integer fileTotalPageCount = this.sendQryFileStatus(fileId);
            rspBO.setFileTotalPageCount(fileTotalPageCount);
        }
        rspBO.setFileId(fileId);
        rspBO.setFileName(esignFileBean.getFileName());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Integer sendQryFileStatus(String fileId) {
        Integer fileTotalPageCount = null;
        for (int i = 0; i < 3; ++i) {
            JSONObject jsonParam = new JSONObject();
            jsonParam.put("fileId", (Object)fileId);
            jsonParam.put("hsn", (Object)"openesign");
            log.debug("\u8c03\u7528e\u7b7e\u5b9d\u67e5\u8be2\u6587\u4ef6\u72b6\u6001\u5165\u53c2\uff1a{}", (Object)jsonParam);
            JSONObject jsonObject = HttpClientUtil.httpPost((String)this.eGetFileUploadStatusUrl, (JSONObject)jsonParam);
            log.debug("\u8c03\u7528e\u7b7e\u5b9d\u67e5\u8be2\u6587\u4ef6\u72b6\u6001\u51fa\u53c2\uff1a{}", (Object)jsonObject);
            LdUocERspBo ldUocERspBo = (LdUocERspBo)((Object)JSON.parseObject((String)jsonObject.toJSONString(), LdUocERspBo.class));
            if (!CODE.equals(ldUocERspBo.getCode()) || ldUocERspBo.getData() == null) {
                throw new ZTBusinessException("\u8c03\u7528e\u7b7e\u5b9d\u67e5\u8be2\u6587\u4ef6\u72b6\u6001\u5931\u8d25");
            }
            JSONObject jsonObject1 = JSON.parseObject((String)ldUocERspBo.getData().toString());
            String fileStatus = jsonObject1.getString("fileStatus");
            if (fileStatus == null) {
                throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u6587\u4ef6\u72b6\u6001");
            }
            log.debug(String.format("\u67e5\u8be2\u6587\u4ef6\u72b6\u6001\u6267\u884c\u7b2c%s\u6b21", i + 1));
            if ("2".equalsIgnoreCase(fileStatus) || "5".equalsIgnoreCase(fileStatus)) {
                log.debug("\u6587\u4ef6\u51c6\u5907\u5b8c\u6210");
                fileTotalPageCount = jsonObject1.getInteger("fileTotalPageCount");
                break;
            }
            log.debug("\u6587\u4ef6\u672a\u51c6\u5907\u5b8c\u6210,\u7b49\u5f85\u4e24\u79d2\u91cd\u65b0\u67e5\u8be2");
            try {
                TimeUnit.SECONDS.sleep(2L);
                continue;
            }
            catch (InterruptedException e) {
                throw new ZTBusinessException(e.getMessage());
            }
        }
        return fileTotalPageCount;
    }

    private static void uploadFile(EsignFileBean esignFileBean, String fileUploadUrl) {
        HashMap<String, String> header = new HashMap<String, String>(2);
        header.put("Content-MD5", esignFileBean.getFileContentMD5());
        header.put("Content-Type", EsignHeaderConstant.CONTENTTYPE_STREAM.VALUE());
        try {
            String rsp = LdUocEUploadPendingDocumentsFunctionImpl.sendHttpPut(fileUploadUrl, EsignFileTransformation.getFileBytes((String)esignFileBean.getFilePath()), header);
            if (rsp == null) {
                throw new ZTBusinessException("\u8c03\u7528\u4e0a\u4f20\u6587\u4ef6\u6d41\u63a5\u53e3\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u4e0a\u4f20\u6587\u4ef6\u6d41\u63a5\u53e3\u5931\u8d25{}", (Object)e.getMessage());
            throw new ZTBusinessException("\u8c03\u7528\u4e0a\u4f20\u6587\u4ef6\u6d41\u63a5\u53e3\u5931\u8d25");
        }
    }

    private JSONObject sendEGetFileUploadUrl(EsignFileBean esignFileBean) {
        String jsonParam = "{\n    \"hsn\":\"openesign\",\n    \"contentMd5\": \"" + esignFileBean.getFileContentMD5() + "\",\n    \"fileName\":\"" + esignFileBean.getFileName() + "\",    \"fileSize\": " + esignFileBean.getFileSize() + ",\n    \"convertToPDF\": false,\n    \"contentType\": \"" + EsignHeaderConstant.CONTENTTYPE_STREAM.VALUE() + "\"\n}";
        log.debug("\u8c03\u7528e\u7b7e\u5b9d\u83b7\u53d6\u6587\u4ef6\u4e0a\u4f20\u5730\u5740\u5165\u53c2\uff1a{}", (Object)jsonParam);
        String paramRsp = HttpUtil.post((String)this.eGetFileUploadUrl, (String)jsonParam);
        log.debug("\u8c03\u7528e\u7b7e\u5b9d\u83b7\u53d6\u6587\u4ef6\u4e0a\u4f20\u5730\u5740\u51fa\u53c2\uff1a{}", (Object)paramRsp);
        LdUocERspBo ldUocERspBo = (LdUocERspBo)((Object)JSON.parseObject((String)paramRsp, LdUocERspBo.class));
        if (!CODE.equals(ldUocERspBo.getCode())) {
            throw new ZTBusinessException("\u8c03\u7528e\u7b7e\u5b9d\u6587\u4ef6\u4e0a\u4f20\u63a5\u53e3\u5931\u8d25");
        }
        if (ldUocERspBo.getData() == null) {
            throw new ZTBusinessException("\u8c03\u7528e\u7b7e\u5b9d\u6587\u4ef6\u4e0a\u4f20\u63a5\u53e3\u5931\u8d25");
        }
        return JSON.parseObject((String)ldUocERspBo.getData().toString());
    }

    private static String sendHttpPut(String url, byte[] requestBody, Map<String, String> headers) throws IOException {
        HttpResponse httpResponse;
        HttpEntity responseEntity;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPut httpPut = new HttpPut(url);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            httpPut.setHeader(entry.getKey(), entry.getValue());
        }
        if (requestBody != null) {
            httpPut.setEntity((HttpEntity)new ByteArrayEntity(requestBody));
        }
        if ((responseEntity = (httpResponse = httpClient.execute((HttpUriRequest)httpPut)).getEntity()) != null) {
            return EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8);
        }
        return null;
    }

    private void validateParam(LdUocEUploadPendingDocumentsFunctionReqBO reqBo) {
        if (null == reqBo) {
            throw new ZTBusinessException("\u5165\u53c2reqBo\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getFilePath())) {
            throw new ZTBusinessException("\u5165\u53c2\u6587\u4ef6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static void main(String[] args) {
        EsignFileBean esignFileBean = new EsignFileBean("https://liando-mall-prod.oss-cn-beijing.aliyuncs.com/cfc/contractPdf/%E9%94%80%E5%94%AE%E6%A1%86%E6%9E%B6%E5%90%88%E5%90%8C%EF%BC%88%E9%94%80%E5%94%AE%E6%9C%AA%E5%8A%9E%E8%AF%81%EF%BC%89-%E5%A2%9E%E5%8A%A0%E6%8B%85%E4%BF%9D%E6%9D%A1%E6%AC%BE.pdf", "\u9500\u552e\u6846\u67b6\u5408\u540c\uff08\u9500\u552e\u672a\u529e\u8bc1\uff09-\u589e\u52a0\u62c5\u4fdd\u6761\u6b3e.pdf");
        LdUocEUploadPendingDocumentsFunctionImpl.uploadFile(esignFileBean, "https://esignoss.esign.cn/1111564182/3dd8edd7-8552-4561-8f31-7771c00f65d8/%E9%94%80%E5%94%AE%E6%A1%86%E6%9E%B6%E5%90%88%E5%90%8C%EF%BC%88%E9%94%80%E5%94%AE%E6%9C%AA%E5%8A%9E%E8%AF%81%EF%BC%89-%E5%A2%9E%E5%8A%A0%E6%8B%85%E4%BF%9D%E6%9D%A1%E6%AC%BE.pdf?Expires=1700819194&OSSAccessKeyId=STS.NUHt5mwFwGmLMLRRGiAaaArwa&Signature=Z9AEKodA%2FJUEcpb1l%2BG5iZG2wDg%3D&callback-var=eyJ4OmZpbGVfa2V5IjoiJDc2Yzg0NGEyLWM4YjEtNDRiZi1hOWJjLTA3ZDY2OWM3Yzg1NiQxMjQzNTMwNjUwIn0%3D%0A&callback=eyJjYWxsYmFja1VybCI6Imh0dHA6Ly9zbWx0YXBpLnRzaWduLmNuL2FueWRvb3IvZmlsZS1zeXN0ZW0vY2FsbGJhY2svYWxpb3NzIiwiY2FsbGJhY2tCb2R5IjogIntcIm1pbWVUeXBlXCI6JHttaW1lVHlwZX0sXCJzaXplXCI6ICR7c2l6ZX0sXCJidWNrZXRcIjogJHtidWNrZXR9LFwib2JqZWN0XCI6ICR7b2JqZWN0fSxcImV0YWdcIjogJHtldGFnfSxcImZpbGVfa2V5XCI6JHt4OmZpbGVfa2V5fX0iLCJjYWxsYmFja0JvZHlUeXBlIjogImFwcGxpY2F0aW9uL2pzb24ifQ%3D%3D%0A&security-token=CAIS%2BAF1q6Ft5B2yfSjIr5b9P4%2FZmplW8K%2BnT2rjtkc8Te5Nrrfcgzz2IHtKdXRvBu8Xs%2F4wnmxX7f4YlqB6T55OSAmcNZEoUVyuHqv4MeT7oMWQweEurv%2FMQBqyaXPS2MvVfJ%2BOLrf0ceusbFbpjzJ6xaCAGxypQ12iN%2B%2Fm6%2FNgdc9FHHPPD1x8CcxROxFppeIDKHLVLozNCBPxhXfKB0ca0WgVy0EHsPnvm5DNs0uH1AKjkbRM9r6ceMb0M5NeW75kSMqw0eBMca7M7TVd8RAi9t0t1%2FIVpGiY4YDAWQYLv0rda7DOltFiMkpla7MmXqlft%2BhzcgeQY0pc%2FRqAAT3oG3ZaojLt4%2F7OxQWia7Owu3wn%2FVqBgxFxmyi2npBeOy%2F4DZgqcSTmPgKQ%2FQh93OYFfYoX8qrsBSiRj%2FthzTBGcLcaHrYNSk67OxPj0t4vfZHfDrllkeXPC2cuhRqk2s1CpFU2UGARw4QDXGJkvHgyqexBz%2FrWuURPYsCZUS4oIAA%3D");
    }
}

