/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.smcsdk.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkStockNumInfoBO;
import com.tydic.smcsdk.bo.SmcsdkStockNumBO;
import com.tydic.smcsdk.dao.SmcsdkMsgLogMapper;
import com.tydic.smcsdk.dao.SmcsdkSkuStockInfoMapper;
import com.tydic.smcsdk.dao.SmcsdkStockInfoOperateLogMapper;
import com.tydic.smcsdk.dao.SmcsdkSupStockInfoMapper;
import com.tydic.smcsdk.dao.po.SmcsdkMsgLogPO;
import com.tydic.smcsdk.dao.po.SmcsdkSkuStockInfoPO;
import com.tydic.smcsdk.dao.po.SmcsdkStockInfoOperateLogPO;
import com.tydic.smcsdk.dao.po.SmcsdkSupStockInfoPO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.util.StringUtils;

public class SmcsdkUpdateStockNumConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(SmcsdkUpdateStockNumConsumer.class);
    @Autowired
    private SmcsdkMsgLogMapper smcsdkMsgLogMapper;
    @Autowired
    private SmcsdkSupStockInfoMapper smcsdkSupStockInfoMapper;
    @Autowired
    private SmcsdkSkuStockInfoMapper smcsdkSkuStockInfoMapper;
    @Autowired
    private SmcsdkStockInfoOperateLogMapper smcsdkStockInfoOperateLogMapper;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO = (SmcsdkOperateStockNumReqBO)JSON.parseObject((String)message.getContent(), (TypeReference)new TypeReference<SmcsdkOperateStockNumReqBO>(){}, (Feature[])new Feature[0]);
        log.info("\u5e93\u5b58\u6570\u91cf\u66f4\u65b0\u6d88\u8d39\u8005\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)smcsdkOperateStockNumReqBO));
        if (null != smcsdkOperateStockNumReqBO) {
            List smcsdkStockNumInfoBOs = smcsdkOperateStockNumReqBO.getSmcsdkStockNumInfoBOs();
            for (SmcsdkStockNumInfoBO smcsdkStockNumInfoBO : smcsdkStockNumInfoBOs) {
                Boolean checkMessageFlag;
                String unikey = smcsdkOperateStockNumReqBO.getUniKey() + "_" + smcsdkStockNumInfoBO.getStockhouseId() + "_" + smcsdkStockNumInfoBO.getSkuId();
                if (StringUtils.hasText((String)smcsdkStockNumInfoBO.getSupplierId())) {
                    unikey = unikey + "_" + smcsdkStockNumInfoBO.getSupplierId();
                }
                if ((checkMessageFlag = this.checkMessage(unikey, smcsdkStockNumInfoBO, smcsdkOperateStockNumReqBO, message)).booleanValue()) continue;
                try {
                    Boolean checkSkuStockInfoFlag;
                    if (StringUtils.hasText((String)smcsdkStockNumInfoBO.getSupplierId())) {
                        Boolean checkSupStockInfoFlag = this.checkSupStockInfo(smcsdkStockNumInfoBO, smcsdkOperateStockNumReqBO);
                        if (!checkSupStockInfoFlag.booleanValue()) {
                            this.insertSupStockInfo(smcsdkStockNumInfoBO, smcsdkOperateStockNumReqBO);
                        }
                        this.updateSupStockInfo(smcsdkStockNumInfoBO, smcsdkOperateStockNumReqBO);
                    }
                    if (!(checkSkuStockInfoFlag = this.checkSkuStockInfo(smcsdkStockNumInfoBO, smcsdkOperateStockNumReqBO)).booleanValue()) {
                        this.insertSkuStockInfo(smcsdkStockNumInfoBO, smcsdkOperateStockNumReqBO);
                    }
                    this.updateSkuStockInfo(smcsdkStockNumInfoBO, smcsdkOperateStockNumReqBO);
                    SmcsdkStockInfoOperateLogPO smcsdkStockInfoOperateLogPO = new SmcsdkStockInfoOperateLogPO();
                    smcsdkStockInfoOperateLogPO.setOperateLogId(Sequence.getInstance().nextId());
                    smcsdkStockInfoOperateLogPO.setShareId1(smcsdkOperateStockNumReqBO.getShareId1());
                    smcsdkStockInfoOperateLogPO.setShareId2(smcsdkOperateStockNumReqBO.getShareId2());
                    smcsdkStockInfoOperateLogPO.setSupplierId(smcsdkStockNumInfoBO.getSupplierId());
                    smcsdkStockInfoOperateLogPO.setSkuId(smcsdkStockNumInfoBO.getSkuId());
                    smcsdkStockInfoOperateLogPO.setStockhouseId(smcsdkStockNumInfoBO.getStockhouseId());
                    smcsdkStockInfoOperateLogPO.setOperateType(smcsdkOperateStockNumReqBO.getOperateType());
                    smcsdkStockInfoOperateLogPO.setOperateTime(new Date());
                    smcsdkStockInfoOperateLogPO.setOperateNo(smcsdkOperateStockNumReqBO.getOperateNo());
                    smcsdkStockInfoOperateLogPO.setObjectId(smcsdkOperateStockNumReqBO.getObjectId());
                    smcsdkStockInfoOperateLogPO.setObjectType(smcsdkOperateStockNumReqBO.getObjectType());
                    smcsdkStockInfoOperateLogPO.setOperateNum(smcsdkStockNumInfoBO.getOperateNum());
                    this.smcsdkStockInfoOperateLogMapper.insert(smcsdkStockInfoOperateLogPO);
                }
                catch (Exception e) {
                    log.info("\u6d88\u8d39\u8005\u5f02\u5e38" + e);
                    SmcsdkMsgLogPO smcsdkMsgLogPO = new SmcsdkMsgLogPO();
                    smcsdkMsgLogPO.setMsgStatus("20");
                    smcsdkMsgLogPO.setUnikey(unikey);
                    smcsdkMsgLogPO.setShareId1(smcsdkOperateStockNumReqBO.getShareId1());
                    smcsdkMsgLogPO.setShareId2(smcsdkOperateStockNumReqBO.getShareId2());
                    String failReson = e.getMessage();
                    if (failReson.length() > 2048) {
                        failReson = failReson.substring(0, 2047);
                    }
                    smcsdkMsgLogPO.setFailReson(failReson);
                    this.smcsdkMsgLogMapper.updateByUnikey(smcsdkMsgLogPO);
                }
            }
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void updateSupStockInfo(SmcsdkStockNumInfoBO bo, SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO2) {
        SmcsdkStockNumBO smcsdkStockNumBO = this.getSmcsdkStockNumBO(smcsdkOperateStockNumReqBO2.getOperateType(), bo);
        SmcsdkSupStockInfoPO smcsdkSupStockInfoPO = new SmcsdkSupStockInfoPO();
        smcsdkSupStockInfoPO.setShareId1(smcsdkOperateStockNumReqBO2.getShareId1());
        smcsdkSupStockInfoPO.setShareId2(smcsdkOperateStockNumReqBO2.getShareId2());
        smcsdkSupStockInfoPO.setUpdateTime(new Date());
        smcsdkSupStockInfoPO.setUpdateNo(smcsdkOperateStockNumReqBO2.getOperateNo());
        smcsdkSupStockInfoPO.setSupplierId(bo.getSupplierId());
        smcsdkSupStockInfoPO.setSkuId(bo.getSkuId());
        smcsdkSupStockInfoPO.setStockhouseId(bo.getStockhouseId());
        smcsdkSupStockInfoPO.setTotalNum(smcsdkStockNumBO.getTotalNum());
        smcsdkSupStockInfoPO.setUnsaleNum(smcsdkStockNumBO.getUnsaleNum());
        smcsdkSupStockInfoPO.setLockNum(smcsdkStockNumBO.getLockNum());
        smcsdkSupStockInfoPO.setSaledNum(smcsdkStockNumBO.getSaledNum());
        this.smcsdkSupStockInfoMapper.updateSupStockInfo(smcsdkSupStockInfoPO);
    }

    private void updateSkuStockInfo(SmcsdkStockNumInfoBO bo, SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO2) {
        SmcsdkStockNumBO smcsdkStockNumBO = this.getSmcsdkStockNumBO(smcsdkOperateStockNumReqBO2.getOperateType(), bo);
        SmcsdkSkuStockInfoPO smcsdkSkuStockInfoPO = new SmcsdkSkuStockInfoPO();
        smcsdkSkuStockInfoPO.setShareId1(smcsdkOperateStockNumReqBO2.getShareId1());
        smcsdkSkuStockInfoPO.setShareId2(smcsdkOperateStockNumReqBO2.getShareId2());
        smcsdkSkuStockInfoPO.setUpdateTime(new Date());
        smcsdkSkuStockInfoPO.setUpdateNo(smcsdkOperateStockNumReqBO2.getOperateNo());
        smcsdkSkuStockInfoPO.setSkuId(bo.getSkuId());
        smcsdkSkuStockInfoPO.setStockhouseId(bo.getStockhouseId());
        smcsdkSkuStockInfoPO.setTotalNum(smcsdkStockNumBO.getTotalNum());
        smcsdkSkuStockInfoPO.setUnsaleNum(smcsdkStockNumBO.getUnsaleNum());
        smcsdkSkuStockInfoPO.setLockNum(smcsdkStockNumBO.getLockNum());
        smcsdkSkuStockInfoPO.setSaledNum(smcsdkStockNumBO.getSaledNum());
        smcsdkSkuStockInfoPO.setCancelStock(smcsdkStockNumBO.getCancelStock());
        this.smcsdkSkuStockInfoMapper.updateSkuStockInfo(smcsdkSkuStockInfoPO);
    }

    private void insertSkuStockInfo(SmcsdkStockNumInfoBO bo, SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO2) {
        block2: {
            SmcsdkSkuStockInfoPO smcsdkSkuStockInfoPO = new SmcsdkSkuStockInfoPO();
            smcsdkSkuStockInfoPO.setShareId1(smcsdkOperateStockNumReqBO2.getShareId1());
            smcsdkSkuStockInfoPO.setShareId2(smcsdkOperateStockNumReqBO2.getShareId2());
            smcsdkSkuStockInfoPO.setSkuStockId(Sequence.getInstance().nextId());
            smcsdkSkuStockInfoPO.setSkuId(bo.getSkuId());
            smcsdkSkuStockInfoPO.setStockhouseId(bo.getStockhouseId());
            smcsdkSkuStockInfoPO.setCreateTime(new Date());
            smcsdkSkuStockInfoPO.setCreateNo(smcsdkOperateStockNumReqBO2.getOperateNo());
            try {
                this.smcsdkSkuStockInfoMapper.insert(smcsdkSkuStockInfoPO);
            }
            catch (Exception e) {
                if (!(e instanceof DuplicateKeyException)) break block2;
                log.info("\u5355\u54c1\u5e93\u5b58\u4fe1\u606f\u5df2\u5b58\u5728");
            }
        }
    }

    private void insertSupStockInfo(SmcsdkStockNumInfoBO bo, SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO2) {
        block2: {
            SmcsdkSupStockInfoPO smcsdkSupStockInfoPO = new SmcsdkSupStockInfoPO();
            smcsdkSupStockInfoPO.setShareId1(smcsdkOperateStockNumReqBO2.getShareId1());
            smcsdkSupStockInfoPO.setShareId2(smcsdkOperateStockNumReqBO2.getShareId2());
            smcsdkSupStockInfoPO.setSupStockId(Sequence.getInstance().nextId());
            smcsdkSupStockInfoPO.setSkuId(bo.getSkuId());
            smcsdkSupStockInfoPO.setSupplierId(bo.getSupplierId());
            smcsdkSupStockInfoPO.setStockhouseId(bo.getStockhouseId());
            smcsdkSupStockInfoPO.setCreateTime(new Date());
            smcsdkSupStockInfoPO.setCreateNo(smcsdkOperateStockNumReqBO2.getOperateNo());
            try {
                this.smcsdkSupStockInfoMapper.insert(smcsdkSupStockInfoPO);
            }
            catch (Exception e) {
                if (!(e instanceof DuplicateKeyException)) break block2;
                log.info("\u4f9b\u5e94\u5546\u5e93\u5b58\u4fe1\u606f\u5df2\u5b58\u5728");
            }
        }
    }

    private Boolean checkSkuStockInfo(SmcsdkStockNumInfoBO bo, SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO) {
        SmcsdkSkuStockInfoPO smcsdkSkuStockInfoPO = new SmcsdkSkuStockInfoPO();
        smcsdkSkuStockInfoPO.setShareId1(smcsdkOperateStockNumReqBO.getShareId1());
        smcsdkSkuStockInfoPO.setShareId2(smcsdkOperateStockNumReqBO.getShareId2());
        smcsdkSkuStockInfoPO.setStockhouseId(bo.getStockhouseId());
        smcsdkSkuStockInfoPO.setSkuId(bo.getSkuId());
        int count = this.smcsdkSkuStockInfoMapper.checkSkuStockInfo(smcsdkSkuStockInfoPO);
        if (count == 1) {
            return true;
        }
        return false;
    }

    private Boolean checkSupStockInfo(SmcsdkStockNumInfoBO bo, SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO) {
        SmcsdkSupStockInfoPO smcsdkSupStockInfoPO = new SmcsdkSupStockInfoPO();
        smcsdkSupStockInfoPO.setShareId1(smcsdkOperateStockNumReqBO.getShareId1());
        smcsdkSupStockInfoPO.setShareId2(smcsdkOperateStockNumReqBO.getShareId2());
        smcsdkSupStockInfoPO.setStockhouseId(bo.getStockhouseId());
        smcsdkSupStockInfoPO.setSupplierId(bo.getSupplierId());
        smcsdkSupStockInfoPO.setSkuId(bo.getSkuId());
        int count = this.smcsdkSupStockInfoMapper.checkSupStockInfo(smcsdkSupStockInfoPO);
        if (count == 1) {
            return true;
        }
        return false;
    }

    private Boolean checkMessage(String unikey, SmcsdkStockNumInfoBO smcsdkStockNumInfoBO, SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO, ProxyMessage message) {
        try {
            SmcsdkMsgLogPO smcsdkMsgLogPO = new SmcsdkMsgLogPO();
            smcsdkMsgLogPO.setShareId1(smcsdkOperateStockNumReqBO.getShareId1());
            smcsdkMsgLogPO.setShareId2(smcsdkOperateStockNumReqBO.getShareId2());
            smcsdkMsgLogPO.setMsgLogId(Sequence.getInstance().nextId());
            smcsdkMsgLogPO.setObjectId(smcsdkOperateStockNumReqBO.getObjectId());
            smcsdkMsgLogPO.setObjectType(smcsdkOperateStockNumReqBO.getObjectType());
            smcsdkMsgLogPO.setTopic(message.getSubject());
            smcsdkMsgLogPO.setMessageId(message.getMessageId());
            smcsdkMsgLogPO.setTag(message.getTag());
            smcsdkMsgLogPO.setOperateTime(new Date());
            smcsdkMsgLogPO.setUnikey(unikey);
            smcsdkMsgLogPO.setStockhouseId(smcsdkStockNumInfoBO.getStockhouseId());
            smcsdkMsgLogPO.setSupplierId(smcsdkStockNumInfoBO.getSupplierId());
            smcsdkMsgLogPO.setSkuId(smcsdkStockNumInfoBO.getSkuId());
            String msgContent = JSON.toJSONString((Object)smcsdkStockNumInfoBO);
            if (msgContent.length() > 2048) {
                msgContent = msgContent.substring(0, 2047);
            }
            smcsdkMsgLogPO.setMsgContent(msgContent);
            smcsdkMsgLogPO.setMsgStatus("10");
            this.smcsdkMsgLogMapper.insert(smcsdkMsgLogPO);
        }
        catch (Exception e) {
            if (e instanceof DuplicateKeyException) {
                log.info("\u6d88\u8d39\u8005\u91cd\u590d\u6d88\u8d39" + e);
            } else {
                log.info("\u5176\u4ed6\u9519\u8bef\u6d88\u8d39" + e);
            }
            return true;
        }
        return false;
    }

    private SmcsdkStockNumBO getSmcsdkStockNumBO(String operateType2, SmcsdkStockNumInfoBO bo) {
        if ("10".equals(operateType2)) {
            return this.processPurchaseInStock(bo);
        }
        if ("11".equals(operateType2)) {
            return this.processSaleReturnInStock(bo);
        }
        if ("20".equals(operateType2)) {
            return this.processSaleLockStock(bo);
        }
        if ("30".equals(operateType2)) {
            return this.processSaleUnLockStock(bo);
        }
        if ("40".equals(operateType2)) {
            return this.processSaleOutStock(bo);
        }
        return null;
    }

    private SmcsdkStockNumBO processPurchaseInStock(SmcsdkStockNumInfoBO bo) {
        SmcsdkStockNumBO smcsdkStockNumBO = new SmcsdkStockNumBO();
        smcsdkStockNumBO.setTotalNum(bo.getOperateNum());
        smcsdkStockNumBO.setUnsaleNum(bo.getOperateNum());
        return smcsdkStockNumBO;
    }

    private SmcsdkStockNumBO processSaleReturnInStock(SmcsdkStockNumInfoBO bo) {
        SmcsdkStockNumBO smcsdkStockNumBO = new SmcsdkStockNumBO();
        smcsdkStockNumBO.setUnsaleNum(bo.getOperateNum());
        smcsdkStockNumBO.setCancelStock(bo.getOperateNum());
        return smcsdkStockNumBO;
    }

    private SmcsdkStockNumBO processSaleLockStock(SmcsdkStockNumInfoBO bo) {
        SmcsdkStockNumBO smcsdkStockNumBO = new SmcsdkStockNumBO();
        smcsdkStockNumBO.setLockNum(bo.getOperateNum());
        smcsdkStockNumBO.setUnsaleNum(-bo.getOperateNum().longValue());
        return smcsdkStockNumBO;
    }

    private SmcsdkStockNumBO processSaleUnLockStock(SmcsdkStockNumInfoBO bo) {
        SmcsdkStockNumBO smcsdkStockNumBO = new SmcsdkStockNumBO();
        smcsdkStockNumBO.setUnsaleNum(bo.getOperateNum());
        smcsdkStockNumBO.setLockNum(-bo.getOperateNum().longValue());
        return smcsdkStockNumBO;
    }

    private SmcsdkStockNumBO processSaleOutStock(SmcsdkStockNumInfoBO bo) {
        SmcsdkStockNumBO smcsdkStockNumBO = new SmcsdkStockNumBO();
        smcsdkStockNumBO.setUnsaleNum(-bo.getOperateNum().longValue());
        smcsdkStockNumBO.setSaledNum(bo.getOperateNum());
        smcsdkStockNumBO.setLockNum(-bo.getOperateNum().longValue());
        return smcsdkStockNumBO;
    }
}

