/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.base.constant;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelExportUtil {
    public static Workbook getWorkbook(InputStream inputStream) throws Exception {
        return WorkbookFactory.create((InputStream)inputStream);
    }

    public static List<List<String>> getRowData(Sheet sheet, int start) throws Exception {
        ArrayList<List<String>> dataList = new ArrayList<List<String>>();
        int end = sheet.getPhysicalNumberOfRows();
        for (int i = start; i < end; ++i) {
            Row row = sheet.getRow(i);
            int cells = row.getPhysicalNumberOfCells();
            ArrayList<String> cellDataList = new ArrayList<String>();
            for (int j = 0; j < cells; ++j) {
                Cell cell = row.getCell(j);
                cellDataList.add(ExcelExportUtil.getCellValueToString(cell));
            }
            dataList.add(cellDataList);
        }
        return dataList;
    }

    public static void createSheet(Workbook workbook, String sheetName, String[] title, List<List<String>> rowList) {
        int i;
        Sheet sheet = workbook.createSheet(sheetName);
        Row titleRow = sheet.createRow(0);
        for (i = 0; i < title.length; ++i) {
            titleRow.createCell(i).setCellValue(title[i]);
        }
        for (i = 0; i < rowList.size(); ++i) {
            Row row = sheet.createRow(i + 1);
            List<String> rowData = rowList.get(i);
            for (int j = 0; j < rowData.size(); ++j) {
                row.createCell(j).setCellValue(rowData.get(j));
            }
        }
    }

    public static String getCellValueToString(Cell cell) {
        String strCell = "";
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case BOOLEAN: {
                strCell = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case NUMERIC: {
                cell.setCellType(CellType.STRING);
                strCell = cell.toString();
                break;
            }
            case STRING: {
                strCell = cell.getStringCellValue();
                break;
            }
        }
        return strCell;
    }

    public static List<List<String>> dataToString(List<?> sourceList, String ... importFields) {
        ArrayList<List<String>> dataList = new ArrayList<List<String>>();
        sourceList.forEach(data -> {
            Class<?> cls = data.getClass();
            ArrayList<String> dataValues = new ArrayList<String>();
            for (String fieldName : importFields) {
                try {
                    Field field = cls.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    dataValues.add(String.valueOf(field.get(data)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            dataList.add(dataValues);
        });
        return dataList;
    }
}

