/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.base.constant;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class ExcelNewUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelNewUtils.class);
    private static final String EXCEL_XLS = "xls";
    private static final String EXCEL_XLSX = "xlsx";
    private static final String PATH = "dyc-common";
    @Value(value="${plugin.file.type}")
    private static String fileType;
    @Value(value="${oss.fileUrl:}")
    private static String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private static String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private static String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private static String fastdfsDownloadUrl;

    public static void getExcelDataInfo(String path, List<String> heads, Integer titleLine, List<List<String>> datas, Integer readLine, Integer sheetAt) throws Exception {
        int count = 1;
        try {
            URL url = new URL(path);
            File file = new File(url.getFile());
            InputStream inputStream = url.openStream();
            ExcelNewUtils.checkExcelVaild(path);
            Workbook workbook = ExcelNewUtils.getWorkbok(path, inputStream);
            Sheet sheet = workbook.getSheetAt(sheetAt.intValue());
            int title = 0;
            for (Row row : sheet) {
                Object obj;
                Cell cell;
                int i;
                ArrayList<String> c = new ArrayList<String>();
                int end = row.getLastCellNum();
                if ((row.getCell(0) == null || "".equals(row.getCell(0).toString())) && (row.getCell(1) == null || "".equals(row.getCell(1).toString()))) continue;
                if (count == titleLine) {
                    title = end;
                    for (i = 0; i < end; ++i) {
                        cell = row.getCell(i, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                        if (cell == null) {
                            heads.add("");
                            continue;
                        }
                        obj = ExcelNewUtils.getValue(cell);
                        heads.add(String.valueOf(obj).trim());
                    }
                }
                if (count >= readLine) {
                    for (i = 0; i < title; ++i) {
                        cell = row.getCell(i, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                        if (cell == null) {
                            c.add("");
                            continue;
                        }
                        obj = ExcelNewUtils.getValue(cell);
                        c.add(String.valueOf(obj).trim());
                    }
                }
                ++count;
                if (c.size() <= 0) continue;
                datas.add(c);
            }
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u7b2c" + count + "\u6570\u636e\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    public static void getExcelDate(String path, List<List<String>> data, Integer readLine, Integer sheetAt) throws Exception {
        int count = 1;
        try {
            URL url = new URL(path);
            File file = new File(url.getFile());
            InputStream inputStream = url.openStream();
            ExcelNewUtils.checkExcelVaild(path);
            Workbook workbook = ExcelNewUtils.getWorkbok(path, inputStream);
            Sheet sheet = workbook.getSheetAt(sheetAt.intValue());
            for (Row row : sheet) {
                ArrayList<String> c = new ArrayList<String>();
                int end = row.getLastCellNum();
                if (!(row.getCell(0) != null && !"".equals(row.getCell(0).toString()) || row.getCell(1) != null && !"".equals(row.getCell(1).toString()))) continue;
                for (int i = 0; i < end; ++i) {
                    Cell cell = row.getCell(i, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                    if (count < readLine) continue;
                    if (cell == null) {
                        c.add("");
                        continue;
                    }
                    Object obj = ExcelNewUtils.getValue(cell);
                    c.add(String.valueOf(obj).trim());
                }
                ++count;
                if (c.size() <= 0) continue;
                data.add(c);
            }
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u7b2c" + count + "\u6570\u636e\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    private static void checkExcelVaild(String filePath) throws Exception {
        if (filePath == null) {
            return;
        }
        String extString = filePath.substring(filePath.lastIndexOf(".") + 1);
        if (!EXCEL_XLS.equals(extString) && !EXCEL_XLSX.equals(extString)) {
            throw new Exception("\u6587\u4ef6\u4e0d\u662fExcel");
        }
    }

    private static Workbook getWorkbok(String filePath, InputStream inputStream) throws IOException {
        if (filePath == null) {
            return null;
        }
        String extString = filePath.substring(filePath.lastIndexOf(".") + 1);
        if (!EXCEL_XLS.equals(extString) && !EXCEL_XLSX.equals(extString)) {
            throw new IOException("\u6587\u4ef6\u4e0d\u662fExcel");
        }
        HSSFWorkbook wb = null;
        if (EXCEL_XLS.equals(extString)) {
            wb = new HSSFWorkbook(inputStream);
        } else if (EXCEL_XLSX.equals(extString)) {
            wb = new XSSFWorkbook(inputStream);
        }
        return wb;
    }

    private static Object getValue(Cell cell) {
        Object obj = null;
        cell.setCellType(CellType.STRING);
        switch (cell.getCellType()) {
            case BOOLEAN: {
                obj = cell.getBooleanCellValue();
                break;
            }
            case ERROR: {
                obj = cell.getErrorCellValue();
                break;
            }
            case NUMERIC: {
                obj = cell.getNumericCellValue();
                break;
            }
            case STRING: {
                obj = cell.getStringCellValue();
                break;
            }
        }
        return obj;
    }

    public static void main(String[] args) throws Exception {
        ExcelNewUtils.checkExcelVaild("https://" + ossFileUrl + PATH + "/\u65e0\u534f\u8bae\u5bfc\u5165\u5546\u54c1\u6a21\u677f." + EXCEL_XLSX);
        int num = 0;
        try {
            for (int i = 0; i < 3; ++i) {
                ++num;
                i = 1 / 0;
            }
        }
        catch (Exception e) {
            System.out.println(num);
        }
    }
}

