/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.base.constant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtils.class);
    private static final String EXCEL_XLS = "xls";
    private static final String EXCEL_XLSX = "xlsx";

    public static void getExcelDate(String path, List<List<String>> data, Integer readLine, Integer readCell) throws Exception {
        URL url = new URL(path);
        File file = new File(url.getFile());
        InputStream inputStream = url.openStream();
        ExcelUtils.checkExcelVaild(file);
        Workbook workbook = ExcelUtils.getWorkbok(file, inputStream);
        int count = 2;
        Sheet sheet = workbook.getSheetAt(0);
        for (int rowNum = 2; rowNum <= sheet.getLastRowNum(); ++rowNum) {
            ArrayList<String> c = new ArrayList<String>();
            if (sheet.getRow(rowNum).getPhysicalNumberOfCells() == 0) continue;
            short end = sheet.getRow(rowNum).getLastCellNum();
            for (int i = readCell.intValue(); i < end; ++i) {
                Cell cell = sheet.getRow(rowNum).getCell(i);
                if (cell == null) {
                    c.add("");
                    continue;
                }
                Object obj = ExcelUtils.getValue(cell);
                if (count < readLine) continue;
                c.add(String.valueOf(obj).trim());
            }
            ++count;
            if (c.size() <= 0) continue;
            data.add(c);
        }
    }

    public static void checkExcelVaild(File file) throws Exception {
        if (!file.getName().endsWith(EXCEL_XLS) && !file.getName().endsWith(EXCEL_XLSX)) {
            throw new Exception("\u6587\u4ef6\u4e0d\u662fExcel");
        }
    }

    public static Workbook getWorkbok(File file, InputStream inputStream) throws IOException {
        HSSFWorkbook wb = null;
        if (file.getName().endsWith(EXCEL_XLS)) {
            wb = new HSSFWorkbook(inputStream);
        } else if (file.getName().endsWith(EXCEL_XLSX)) {
            wb = new XSSFWorkbook(inputStream);
        }
        return wb;
    }

    public static Object getValue(Cell cell) {
        Object obj = null;
        cell.setCellType(CellType.STRING);
        switch (cell.getCellTypeEnum()) {
            case BOOLEAN: {
                obj = cell.getBooleanCellValue();
                break;
            }
            case ERROR: {
                obj = cell.getErrorCellValue();
                break;
            }
            case NUMERIC: {
                obj = cell.getNumericCellValue();
                break;
            }
            case STRING: {
                obj = cell.getStringCellValue();
                break;
            }
        }
        return obj;
    }
}

