/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.bo.RspUccBo;
import com.tydic.commodity.base.enumType.ApprovalTypeEnum;
import com.tydic.commodity.busibase.busi.api.UccSendMessageAndNoteAtomService;
import com.tydic.commodity.busibase.busi.bo.UccSendMessageAndNoteAtomBO;
import com.tydic.commodity.busibase.busi.bo.UccSendMessageAndNoteAtomReqBO;
import com.tydic.commodity.busibase.busi.bo.UccSendMessageAndNoteAtomRspBO;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.utils.HSHttpHelper;
import com.tydic.commodity.utils.HSNHttpHeader;
import com.tydic.commodity.utils.HttpRetBean;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UccSendMessageAndNoteAtomServiceImpl
implements UccSendMessageAndNoteAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccSendMessageAndNoteAtomServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Value(value="${UCC_SEND_MESSAGE_AND_NOTE_URL}")
    private String UCC_SEND_MESSAGE_AND_NOTE_URL;

    @Override
    public UccSendMessageAndNoteAtomRspBO sendMessageAndNote(UccSendMessageAndNoteAtomReqBO reqBO) {
        UccSendMessageAndNoteAtomRspBO rspBO = new UccSendMessageAndNoteAtomRspBO();
        log.info("\u53d1\u901a\u77e5\u539f\u5b50\u670d\u52a1\u5165\u53c2{}->" + JSON.toJSONString((Object)reqBO));
        for (String approveInstId : reqBO.getTaskList().keySet()) {
            String reqStr = this.initReqStr(reqBO.getTaskList().get(approveInstId));
            log.info("\u901a\u77e5\u4e2d\u5fc3\u901a\u77e5\u53d1\u9001\u5165\u53c2{}->" + reqStr);
            HttpRetBean httpRetBean = null;
            try {
                httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.UCC_SEND_MESSAGE_AND_NOTE_URL), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes("UTF-8"), "UTF-8", false);
            }
            catch (Exception e) {
                log.error("\u901a\u77e5\u4e2d\u5fc3\u901a\u77e5\u53d1\u9001\u63a5\u53e3\u51fa\u9519\uff1a" + e.getMessage());
                throw new ZTBusinessException("\u901a\u77e5\u4e2d\u5fc3\u901a\u77e5\u53d1\u9001\u63a5\u53e3\u51fa\u9519");
            }
            if (httpRetBean.getStatus() != 200) {
                log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.UCC_SEND_MESSAGE_AND_NOTE_URL + "]");
                throw new ZTBusinessException("\u901a\u77e5\u4e2d\u5fc3\u901a\u77e5\u53d1\u9001\u63a5\u53e3\u51fa\u9519\uff0chttp_status = " + httpRetBean.getStatus());
            }
            log.info("\u901a\u77e5\u4e2d\u5fc3\u901a\u77e5\u53d1\u9001\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                log.error("\u901a\u77e5\u4e2d\u5fc3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                throw new ZTBusinessException("\u901a\u77e5\u4e2d\u5fc3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            RspUccBo rspUccBo = this.resolveRsp(returnString);
            log.info("\u901a\u77e5\u4e2d\u5fc3\u54cd\u5e94\u6570\u636e\uff1a" + JSON.toJSONString((Object)rspUccBo.toString()));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String initReqStr(List<UccSendMessageAndNoteAtomBO> taskList) {
        JSONObject reqJson = new JSONObject();
        if (taskList.get(0).getBusinessType().equals(ApprovalTypeEnum.uccOnShelfProcessOrder.getStep())) {
            reqJson.put("taskCode", (Object)"ucc_on_shelf_approve_note");
        } else if (taskList.get(0).getBusinessType().equals(ApprovalTypeEnum.uccOffShelfProcessOrder.getStep())) {
            reqJson.put("taskCode", (Object)"ucc_off_shelf_approve_note");
        } else if (taskList.get(0).getBusinessType().equals(ApprovalTypeEnum.uccReinstateProcessOrder.getStep())) {
            reqJson.put("taskCode", (Object)"ucc_reinstate_approve_note");
        } else if (taskList.get(0).getBusinessType().equals(ApprovalTypeEnum.uccEditProcessOrder.getStep())) {
            // empty if block
        }
        JSONObject data = new JSONObject();
        data.put("linkUrl", (Object)taskList.get(0).getLinkUrl());
        data.put("skuCode", (Object)taskList.get(0).getBusinessCode());
        reqJson.put("data", (Object)data.toJSONString());
        reqJson.put("sendId", (Object)taskList.get(0).getCreateUserId());
        reqJson.put("sendName", (Object)taskList.get(0).getCreateUserName());
        JSONArray receivers = new JSONArray();
        for (UccSendMessageAndNoteAtomBO each : taskList) {
            JSONObject receiver = new JSONObject();
            receiver.put("receiverId", (Object)each.getUserId());
            receiver.put("receiverName", (Object)each.getUserName());
            receivers.add((Object)receiver);
        }
        reqJson.put("receivers", (Object)receivers);
        return reqJson.toString();
    }

    private RspUccBo resolveRsp(String returnString) {
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            return (RspUccBo)JSON.toJavaObject((JSON)rspJsonObject, RspUccBo.class);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u901a\u77e5\u4e2d\u5fc3\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
            throw new RuntimeException("\u8f6c\u6362\u901a\u77e5\u4e2d\u5fc3\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
        }
    }
}

