/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.consumer;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.commodity.base.bo.SelfRunSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.enumType.ApprovalTypeEnum;
import com.tydic.commodity.busibase.busi.api.UccApproveTaskSyncBusiService;
import com.tydic.commodity.busibase.busi.api.UccApproveTaskUpdateApprovalPersonBusiService;
import com.tydic.commodity.busibase.busi.bo.ApproveTaskSyncBO;
import com.tydic.commodity.busibase.busi.bo.UccApproveTaskSyncBusiReqBO;
import com.tydic.commodity.busibase.busi.bo.UccApproveTaskSyncBusiRspBO;
import com.tydic.commodity.busibase.busi.bo.UccSendTodoBusiReqBO;
import com.tydic.commodity.consumer.MapKeyComparator;
import com.tydic.commodity.consumer.bo.DycUccApproveTaskSyncBO;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class DycUccApproveTaskSyncConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(DycUccApproveTaskSyncConsumer.class);
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccApproveTaskSyncBusiService uccApproveTaskSyncBusiService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Resource(name="dycUccSendTodoProducer")
    private ProxyMessageProducer dycUccSendTodoProducer;
    @Autowired
    private UccApproveTaskUpdateApprovalPersonBusiService uccApproveTaskUpdateApprovalPersonBusiService;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        String content = proxyMessage.getContent();
        log.info("\u6d41\u7a0b\u4efb\u52a1\u6d88\u8d39\u8005\u6536\u5230\uff0c\u6570\u636e\u5185\u5bb9\u5982\u4e0b:{}" + content);
        try {
            DycUccApproveTaskSyncBO dycUccApproveTaskSyncBO = (DycUccApproveTaskSyncBO)JSON.parseObject((String)content, DycUccApproveTaskSyncBO.class);
            log.info("\u8f6c\u6362\u540e\u53c2\u6570\u5982\u4e0b:{}", (Object)JSON.toJSONString((Object)dycUccApproveTaskSyncBO));
            if (dycUccApproveTaskSyncBO != null) {
                log.info("\u5ba1\u6279\u56de\u8c03\u6d88\u8d39\u8005mq\u6536\u5230\u7684\u6d41\u7a0b\u5b9e\u4f8bId:" + dycUccApproveTaskSyncBO.getProcInstId());
                if (!CollectionUtils.isEmpty(dycUccApproveTaskSyncBO.getTaskList())) {
                    Map<String, List<ApproveTaskSyncBO>> stepListMap = dycUccApproveTaskSyncBO.getTaskList().stream().collect(Collectors.groupingBy(ApproveTaskSyncBO::getStepId));
                    stepListMap = DycUccApproveTaskSyncConsumer.sortMapByKey(stepListMap);
                    log.info("=\u6392\u5e8f\u540e\u54e6=" + JSON.toJSONString(stepListMap));
                    for (String s : stepListMap.keySet()) {
                        UccApproveTaskSyncBusiReqBO uccApproveTaskSyncBusiReqBO = new UccApproveTaskSyncBusiReqBO();
                        BeanUtils.copyProperties((Object)dycUccApproveTaskSyncBO, (Object)((Object)uccApproveTaskSyncBusiReqBO));
                        uccApproveTaskSyncBusiReqBO.setTaskList(stepListMap.get(s));
                        this.dealSubjectLogic(uccApproveTaskSyncBusiReqBO, dycUccApproveTaskSyncBO);
                    }
                    List steps = dycUccApproveTaskSyncBO.getTaskList().stream().map(ApproveTaskSyncBO::getStepId).distinct().collect(Collectors.toList());
                    if ((steps.size() > 1 || "true".equals(dycUccApproveTaskSyncBO.getLinkJudge())) && dycUccApproveTaskSyncBO.getIsfinish().booleanValue()) {
                        this.uccApproveTaskUpdateApprovalPersonBusiService.updatePerson(dycUccApproveTaskSyncBO.getProcInstId());
                    }
                } else {
                    UccApproveTaskSyncBusiReqBO uccApproveTaskSyncBusiReqBO = new UccApproveTaskSyncBusiReqBO();
                    BeanUtils.copyProperties((Object)dycUccApproveTaskSyncBO, (Object)((Object)uccApproveTaskSyncBusiReqBO));
                    this.dealSubjectLogic(uccApproveTaskSyncBusiReqBO, dycUccApproveTaskSyncBO);
                }
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            log.error("\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
            return ProxyConsumerStatus.RECONSUME_LATER;
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u540c\u6b65\u6d88\u8d39\u8005\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return ProxyConsumerStatus.RECONSUME_LATER;
        }
    }

    public ProxyConsumerStatus dealSubjectLogic(UccApproveTaskSyncBusiReqBO uccApproveTaskSyncBusiReqBO, DycUccApproveTaskSyncBO dycUccApproveTaskSyncBO) {
        List<UccCommodityPo> uccCommodityPos;
        Map<Long, List<UccCommodityPo>> collect;
        log.info("\u5ba1\u6279\u5217\u8868\u5faa\u73af\u5165\u53c2\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)((Object)uccApproveTaskSyncBusiReqBO)));
        UccApproveTaskSyncBusiRspBO rspBO = this.uccApproveTaskSyncBusiService.ApproveTaskSync(uccApproveTaskSyncBusiReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            log.error("\u5ba1\u6279\u56de\u8c03\u6d88\u8d39\u8005mq\u6536\u5230\u7684\u6d41\u7a0b\u5b9e\u4f8bId" + dycUccApproveTaskSyncBO.getProcInstId() + "\u5904\u7406\u5931\u8d25\uff01" + rspBO.getRespDesc());
            return ProxyConsumerStatus.RECONSUME_LATER;
        }
        if (!CollectionUtils.isEmpty(rspBO.getSpuIds()) && (collect = (uccCommodityPos = this.uccCommodityMapper.qeryBatchCommdity(rspBO.getSpuIds())).stream().collect(Collectors.groupingBy(UccCommodityPo::getSupplierShopId))) != null) {
            for (Long supplierShopId : collect.keySet()) {
                ArrayList spus = new ArrayList(collect.get(supplierShopId).stream().map(UccCommodityPo::getCommodityId).collect(Collectors.toSet()));
                SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setCommodityIds((List)Lists.newArrayList(spus));
                syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                try {
                    log.info("\u5ba1\u6279\u6d88\u8d39\u8005es\u540c\u6b65\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty("LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty("LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                }
            }
        }
        UccSendTodoBusiReqBO uccSendTodoBusiReqBO = new UccSendTodoBusiReqBO();
        if (!CollectionUtils.isEmpty(uccApproveTaskSyncBusiReqBO.getTaskList())) {
            try {
                List<Long> taskIds = uccApproveTaskSyncBusiReqBO.getTaskList().stream().map(ApproveTaskSyncBO::getApproveTaskId).collect(Collectors.toList());
                uccSendTodoBusiReqBO.setTaskIds(taskIds);
                if (ApprovalTypeEnum.uccEditProcessOrder.code().equals(uccApproveTaskSyncBusiReqBO.getTaskList().get(0).getBusinessType())) {
                    UccCommodityPo commodityById = this.uccCommodityMapper.getCommodityById(Long.parseLong(uccApproveTaskSyncBusiReqBO.getTaskList().get(0).getBusinessId()));
                    uccSendTodoBusiReqBO.setSource(commodityById.getCommoditySource());
                } else {
                    List<UccSkuPo> uccSkuPoList = this.uccSkuMapper.batchQrySku(Arrays.asList(Long.parseLong(uccApproveTaskSyncBusiReqBO.getTaskList().get(0).getBusinessId())), null);
                    uccSendTodoBusiReqBO.setSource(uccSkuPoList.get(0).getSkuSource());
                }
                if (uccApproveTaskSyncBusiReqBO.getTaskList().get(0).getBusinessType().equals(ApprovalTypeEnum.uccOnShelfProcessOrder.code())) {
                    uccSendTodoBusiReqBO.setObjType(Integer.parseInt(ApprovalTypeEnum.uccOnShelfProcessOrder.getStep()));
                } else if (uccApproveTaskSyncBusiReqBO.getTaskList().get(0).getBusinessType().equals(ApprovalTypeEnum.uccOffShelfProcessOrder.code())) {
                    uccSendTodoBusiReqBO.setObjType(Integer.parseInt(ApprovalTypeEnum.uccOffShelfProcessOrder.getStep()));
                } else if (uccApproveTaskSyncBusiReqBO.getTaskList().get(0).getBusinessType().equals(ApprovalTypeEnum.uccReinstateProcessOrder.code())) {
                    uccSendTodoBusiReqBO.setObjType(Integer.parseInt(ApprovalTypeEnum.uccReinstateProcessOrder.getStep()));
                } else if (uccApproveTaskSyncBusiReqBO.getTaskList().get(0).getBusinessType().equals(ApprovalTypeEnum.uccEditProcessOrder.code())) {
                    uccSendTodoBusiReqBO.setObjType(Integer.parseInt(ApprovalTypeEnum.uccEditProcessOrder.getStep()));
                }
                this.dycUccSendTodoProducer.send(new ProxyMessage(PropertiesUtil.getProperty("UCC_SEND_TODO_TOPIC"), "*", JSON.toJSONString((Object)((Object)uccSendTodoBusiReqBO))));
            }
            catch (Exception e) {
                log.error("\u5ba1\u6279mq\u6d88\u8d39\u8005 \u53d1\u9001\u5f85\u529emq\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return null;
    }

    public static Map<String, List<ApproveTaskSyncBO>> sortMapByKey(Map<String, List<ApproveTaskSyncBO>> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        TreeMap<String, List<ApproveTaskSyncBO>> sortMap = new TreeMap<String, List<ApproveTaskSyncBO>>(new MapKeyComparator());
        sortMap.putAll(map);
        return sortMap;
    }
}

