/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.comb.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.bo.UccEstoreLadderPriceBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.enumType.CommodityEnum;
import com.tydic.commodity.base.enumType.SkuEnum;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.busibase.comb.api.UccSkuManagementListQryCombService;
import com.tydic.commodity.busibase.comb.bo.UccCombEsCommodityBo;
import com.tydic.commodity.busibase.comb.bo.UccSkuManagementListCombQryBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuManagementListQryCombReqBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuManagementListQryCombRspBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.EacRuTaskMapper;
import com.tydic.commodity.dao.UccCommodityDetailMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSaleNumMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.EacRuTaskPO;
import com.tydic.commodity.po.UccCommodityDetailPO;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccSaleNumPo;
import com.tydic.commodity.po.UccSkuExpandPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.utils.MoneyUtils;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class UccSkuManagementListQryCombServiceImpl
implements UccSkuManagementListQryCombService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuManagementListQryCombServiceImpl.class);
    private static final long serialVersionUID = 1956659951572577168L;
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private UccBaseDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private EacRuTaskMapper eacRuTaskMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccSaleNumMapper uccSaleNumMapper;
    private UccCommodityDetailMapper uccCommodityDetailMapper;
    private Long userId;

    @Override
    public UccSkuManagementListQryCombRspBO getSkuManagementListQry(UccSkuManagementListQryCombReqBO reqBO) {
        BoolQueryBuilder extBoolQueryBuilder;
        String queryString;
        String result;
        this.userId = reqBO.getUserId();
        UccSkuManagementListQryCombRspBO rspBo = new UccSkuManagementListQryCombRspBO();
        if (ObjectUtils.isEmpty((Object)reqBO.getUpcCode())) {
            reqBO.setUpcCode(reqBO.getAgrModel());
        }
        if (StringUtils.isEmpty((Object)(result = this.searchInfo(queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder = this.buildEsSql(reqBO)))))) {
            rspBo.setTotal(0);
            rspBo.setRespCode("0000");
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList());
            return rspBo;
        }
        rspBo = this.dealSearchData(result, reqBO);
        if (!CollectionUtils.isEmpty((Collection)rspBo.getRows())) {
            List<Long> spuIds;
            List<UccCommodityDetailPO> detailMapperListBySpuIds;
            List<Long> skus = rspBo.getRows().stream().map(UccSkuManagementListCombQryBO::getSkuId).collect(Collectors.toList());
            List<UccSaleNumPo> salNumBySkuIds = this.uccSaleNumMapper.getSalNumBySkuIds(skus);
            if (!CollectionUtils.isEmpty(salNumBySkuIds)) {
                Map<Long, BigDecimal> soldMap = salNumBySkuIds.stream().collect(Collectors.toMap(UccSaleNumPo::getSkuId, UccSaleNumPo::getSoldNumber));
                for (UccSkuManagementListCombQryBO row : rspBo.getRows()) {
                    if (!soldMap.containsKey(row.getSkuId())) continue;
                    row.setSoldNumber(soldMap.get(row.getSkuId()));
                }
            }
            List<UccSkuPricePo> bathPrice = this.uccSkuPriceMapper.batchQryPriBySkuIds(skus, null);
            if (!ObjectUtils.isEmpty((Object)reqBO.getCmsQuery()) && !CollectionUtils.isEmpty(detailMapperListBySpuIds = this.uccCommodityDetailMapper.getListBySpuIds(spuIds = rspBo.getRows().stream().map(UccSkuManagementListCombQryBO::getCommodityId).collect(Collectors.toList())))) {
                Map<Long, List<UccCommodityDetailPO>> longListMap = detailMapperListBySpuIds.stream().collect(Collectors.groupingBy(UccCommodityDetailPO::getCommodityId));
                for (UccSkuManagementListCombQryBO each : rspBo.getRows()) {
                    if (!longListMap.containsKey(each.getCommodityId())) continue;
                    each.setCommodityPcDetailUrl(((UccCommodityDetailPO)((List)longListMap.get(each.getCommodityId())).get(0)).getCommodityPcDetailUrl());
                }
            }
            if (!CollectionUtils.isEmpty((Collection)rspBo.getRows())) {
                List<UccSkuPricePo> pricePos;
                List<UccLadderPricePO> ladderPricePOS;
                Map<Integer, List<UccSkuPricePo>> groupBySwitch = bathPrice.stream().collect(Collectors.groupingBy(UccSkuPricePo::getSwitchOn));
                Map<Long, List<UccSkuPricePo>> addCoeficientMap = bathPrice.stream().collect(Collectors.groupingBy(UccSkuPricePo::getSkuId));
                for (UccSkuManagementListCombQryBO each : rspBo.getRows()) {
                    if (addCoeficientMap.containsKey(each.getSkuId()) && !StringUtils.isEmpty((Object)addCoeficientMap.get(each.getSkuId()).get(0).getAddCoefficient())) {
                        each.setMarkupRate(new BigDecimal(addCoeficientMap.get(each.getSkuId()).get(0).getAddCoefficient()));
                    }
                    if (!ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_ON_SHELF_GO.equals(reqBO.getApprovalStatus()) || !ObjectUtils.isEmpty((Object)each.getMarkupRate()) || each.getSkuSource() != 3 || !"1".equals(each.getAgrModel())) continue;
                    each.setSalePrice(null);
                }
                if (groupBySwitch.containsKey(1) && !CollectionUtils.isEmpty(ladderPricePOS = this.uccLadderPriceMapper.selectListBySku(skus = (pricePos = groupBySwitch.get(1)).stream().map(UccSkuPricePo::getSkuId).collect(Collectors.toList())))) {
                    Map<Long, List<UccLadderPricePO>> ladderMap = ladderPricePOS.stream().collect(Collectors.groupingBy(UccLadderPricePO::getSkuId));
                    Iterator<Long> iterator = ladderMap.keySet().iterator();
                    HashMap<Long, List> longListMap = new HashMap<Long, List>();
                    while (iterator.hasNext()) {
                        Long key = iterator.next();
                        List<UccLadderPricePO> mapPos = ladderMap.get(key);
                        List eachBo = JSONObject.parseArray((String)JSONObject.toJSONString(mapPos), UccEstoreLadderPriceBO.class);
                        eachBo.sort(new Comparator<UccEstoreLadderPriceBO>(){

                            @Override
                            public int compare(UccEstoreLadderPriceBO o1, UccEstoreLadderPriceBO o2) {
                                return o2.getStart().compareTo(o1.getStart());
                            }
                        });
                        for (UccEstoreLadderPriceBO each : eachBo) {
                            if (each.getStart() != null) {
                                each.setStart(MoneyUtils.haoToYuan(each.getStart()));
                            }
                            if (each.getStop() != null) {
                                each.setStop(MoneyUtils.haoToYuan(each.getStop()));
                            }
                            if (each.getPrice() == null) continue;
                            each.setPrice(MoneyUtils.haoToYuan(each.getPrice()));
                        }
                        longListMap.put(key, eachBo);
                    }
                    if (!longListMap.isEmpty()) {
                        for (UccSkuManagementListCombQryBO each : rspBo.getRows()) {
                            if (!longListMap.containsKey(each.getSkuId())) continue;
                            each.setLadderPriceInfo((List)longListMap.get(each.getSkuId()));
                        }
                    }
                }
            }
        }
        return rspBo;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private BoolQueryBuilder buildEsSql(UccSkuManagementListQryCombReqBO reqBo) {
        RangeQueryBuilder createTimeQb;
        WildcardQueryBuilder wildcardQuery;
        BoolQueryBuilder shouldBuilder;
        WildcardQueryBuilder wildcardQuery2;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!CollectionUtils.isEmpty(reqBo.getExportSkuIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", reqBo.getExportSkuIds()));
        }
        if (reqBo.getSkuSource() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)reqBo.getSkuSource()));
        }
        if (reqBo.getSourceAssort() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sourceAssort", (Object)reqBo.getSourceAssort()));
        }
        if (reqBo.getApprovalStatus() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_approval_status", (Object)reqBo.getApprovalStatus()));
        }
        if (reqBo.getBrandId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_id", (Object)reqBo.getBrandId()));
        }
        if (reqBo.getVendorId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)reqBo.getVendorId()));
        }
        if (reqBo.getSupplierId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id", (Object)reqBo.getSupplierId()));
        }
        if (reqBo.getSkuId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_id", (Object)reqBo.getSkuId()));
        }
        if (reqBo.getCommodityId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_id", (Object)reqBo.getCommodityId()));
        }
        if (reqBo.getL4mgCategoryId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l4mg_category_id", (Object)reqBo.getL4mgCategoryId()));
        }
        if (reqBo.getCommodityTypeId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_id", (Object)reqBo.getCommodityTypeId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"create_oper_id", (String)reqBo.getCreateOperId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSupplierOrgId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_org_id", (String)reqBo.getSupplierOrgId()));
        }
        if (reqBo.getSupplierShopId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_shop_id", (Object)reqBo.getSupplierShopId()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getOperIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operIds.keyword", reqBo.getOperIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getCommodityIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_id", reqBo.getCommodityIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getOperOrgIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operOrgIds", reqBo.getOperOrgIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getOperRoleIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operRoleIds", reqBo.getOperRoleIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getOperStationCodes())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operStationCodes", reqBo.getOperStationCodes()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getOtherSourceCodes())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"other_source_code.keyword", reqBo.getOtherSourceCodes()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getSkuStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_status", reqBo.getSkuStatus()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getCommodityStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_status", reqBo.getCommodityStatus()));
        }
        if (reqBo.getAgreementId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_id", (Object)reqBo.getAgreementId()));
        }
        if (reqBo.getAgreementDetailsId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_details_id", (Object)reqBo.getAgreementDetailsId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getUpcCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"upc", (String)reqBo.getUpcCode()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSpuId())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"ext_spu_id.keyword", (String)("*" + reqBo.getExtSpuId() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!CollectionUtils.isEmpty(reqBo.getCommodityTypeNames())) {
            shouldBuilder = QueryBuilders.boolQuery();
            for (String typeName : reqBo.getCommodityTypeNames()) {
                wildcardQuery = QueryBuilders.wildcardQuery((String)"type_name.keyword", (String)("*" + typeName + "*"));
                shouldBuilder.should((QueryBuilder)wildcardQuery);
            }
            boolQueryBuilder.must((QueryBuilder)shouldBuilder);
        }
        if (!CollectionUtils.isEmpty(reqBo.getSkuCodes())) {
            shouldBuilder = QueryBuilders.boolQuery();
            for (String skuCode : reqBo.getSkuCodes()) {
                wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_code.keyword", (String)("*" + skuCode + "*"));
                shouldBuilder.should((QueryBuilder)wildcardQuery);
            }
            boolQueryBuilder.must((QueryBuilder)shouldBuilder);
        }
        if (!CollectionUtils.isEmpty(reqBo.getCommodityCodes())) {
            shouldBuilder = QueryBuilders.boolQuery();
            for (String commodityCode : reqBo.getCommodityCodes()) {
                wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_code.keyword", (String)("*" + commodityCode + "*"));
                shouldBuilder.should((QueryBuilder)wildcardQuery);
            }
            boolQueryBuilder.must((QueryBuilder)shouldBuilder);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSkuId())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"ext_sku_id.keyword", (String)("*" + reqBo.getExtSkuId() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getBrandName())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"brand_name.keyword", (String)("*" + reqBo.getBrandName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityName())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"commodity_name.keyword", (String)("*" + reqBo.getCommodityName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityExpand1())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"commodity_expand1.keyword", (String)("*" + reqBo.getCommodityExpand1() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getVendorName())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"vendor_name.keyword", (String)("*" + reqBo.getVendorName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuName())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"sku_name.keyword", (String)("*" + reqBo.getSkuName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialCode())) {
            if (reqBo.getIsMaterCode() != null) {
                if (reqBo.getIsMaterCode() == 1) {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"material_code.keyword", (String[])new String[]{reqBo.getMaterialCode()}));
                }
            } else {
                wildcardQuery2 = QueryBuilders.wildcardQuery((String)"material_code.keyword", (String)("*" + reqBo.getMaterialCode() + "*"));
                boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceName())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"other_source_name.keyword", (String)("*" + reqBo.getOtherSourceName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getModel())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"model.keyword", (String)("*" + reqBo.getModel() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSpec())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"spec.keyword", (String)("*" + reqBo.getSpec() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialName())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"material_name.keyword", (String)("*" + reqBo.getMaterialName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityCode())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"commodity_code.keyword", (String)("*" + reqBo.getCommodityCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuCode())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"sku_code.keyword", (String)("*" + reqBo.getSkuCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceCode())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"other_source_code.keyword", (String)("*" + reqBo.getOtherSourceCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        RangeQueryBuilder discountQb = null;
        if (!ObjectUtil.isEmpty((Object)reqBo.getDiscountStar())) {
            discountQb = QueryBuilders.rangeQuery((String)"discounts").gte((Object)reqBo.getDiscountStar().divide(new BigDecimal("100")));
            boolQueryBuilder.must((QueryBuilder)discountQb);
        }
        if (!ObjectUtil.isEmpty((Object)reqBo.getDiscountEnd())) {
            discountQb = QueryBuilders.rangeQuery((String)"discounts").lte((Object)reqBo.getDiscountEnd().divide(new BigDecimal("100")));
            boolQueryBuilder.must((QueryBuilder)discountQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateTimeStar())) {
            createTimeQb = QueryBuilders.rangeQuery((String)"create_time").gte((Object)reqBo.getCreateTimeStar().getTime());
            boolQueryBuilder.must((QueryBuilder)createTimeQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateTimeEnd())) {
            createTimeQb = QueryBuilders.rangeQuery((String)"create_time").lte((Object)reqBo.getCreateTimeEnd().getTime());
            boolQueryBuilder.must((QueryBuilder)createTimeQb);
        }
        RangeQueryBuilder maerketQb = null;
        if (!StringUtils.isEmpty((Object)reqBo.getMarketPriceStar())) {
            maerketQb = QueryBuilders.rangeQuery((String)"market_price").gte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getMarketPriceStar()));
            boolQueryBuilder.must((QueryBuilder)maerketQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMarketPriceEnd())) {
            maerketQb = QueryBuilders.rangeQuery((String)"market_price").lte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getMarketPriceEnd()));
            boolQueryBuilder.must((QueryBuilder)maerketQb);
        }
        RangeQueryBuilder saleQb = null;
        if (!StringUtils.isEmpty((Object)reqBo.getSalePriceStar())) {
            saleQb = QueryBuilders.rangeQuery((String)"sale_price").gte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getSalePriceStar()));
            boolQueryBuilder.must((QueryBuilder)saleQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSalePriceEnd())) {
            saleQb = QueryBuilders.rangeQuery((String)"sale_price").lte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getSalePriceEnd()));
            boolQueryBuilder.must((QueryBuilder)saleQb);
        }
        return boolQueryBuilder;
    }

    private String excuteEsSql(UccSkuManagementListQryCombReqBO reqBo, BoolQueryBuilder extBoolQueryBuilder) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("track_total_hits", (Object)true);
        queryJson.put("size", (Object)reqBo.getPageSize());
        queryJson.put("from", (Object)(reqBo.getPageSize() * (reqBo.getPageNo() - 1)));
        String queryString = null;
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        SortOrder orderType = SortOrder.DESC;
        if (reqBo.getOrderType() != null && reqBo.getOrderType() == 1) {
            orderType = SortOrder.ASC;
        }
        String sortField = "";
        if (reqBo.getOrderByColumn() != null) {
            if (reqBo.getOrderByColumn() == 0) {
                sortField = "create_time";
            } else if (reqBo.getOrderByColumn() == 1) {
                sortField = "sold_number";
            } else if (reqBo.getOrderByColumn() == 2) {
                sortField = "on_shelve_time";
            } else if (reqBo.getOrderByColumn() == 3) {
                sortField = "sale_price";
            } else if (reqBo.getOrderByColumn() == 4) {
                sortField = "discounts";
            } else if (reqBo.getOrderByColumn() == 5) {
                sortField = "comment_number";
            }
        }
        if (!StringUtils.isEmpty((Object)sortField)) {
            FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)sortField).order(orderType);
            queryJson.put("sort", (Object)JSONObject.parseObject((String)sortQuery.toString()));
        }
        return queryJson.toString();
    }

    private UccSkuManagementListQryCombRspBO dealSearchData(String result, UccSkuManagementListQryCombReqBO reqBo) {
        UccSkuManagementListQryCombRspBO rspBo = new UccSkuManagementListQryCombRspBO();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = 0;
        try {
            total = hitsObj.getInteger("total");
        }
        catch (Exception e) {
            JSONObject totalObj = (JSONObject)hitsObj.get((Object)"total");
            total = totalObj.getInteger("value");
        }
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        }
        ArrayList<UccCombEsCommodityBo> commodityModels = new ArrayList<UccCombEsCommodityBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                UccCombEsCommodityBo commodity = new UccCombEsCommodityBo();
                try {
                    commodity = (UccCombEsCommodityBo)JSON.toJavaObject((JSON)data, UccCombEsCommodityBo.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                    if (!skuIdSet.contains(commodity.getSku_id())) {
                        commodityModels.add(commodity);
                    }
                    skuIdSet.add(commodity.getSku_id());
                }
            }
        }
        rspBo = this.copyData(commodityModels, total, reqBo.getPageNo(), reqBo.getPageSize());
        return rspBo;
    }

    private UccSkuManagementListQryCombRspBO copyData(List<UccCombEsCommodityBo> commodityModels, Integer totalNum, int pageNo, int pageSize) {
        UccSkuManagementListQryCombRspBO rspBo = new UccSkuManagementListQryCombRspBO();
        ArrayList<UccSkuManagementListCombQryBO> uccSkuManagementListQryBOs = new ArrayList<UccSkuManagementListCombQryBO>();
        if (totalNum != null) {
            rspBo.setPageNo(pageNo);
            int size = pageSize;
            int totalPage = 0;
            int add = 0;
            Integer total = 0;
            totalPage = totalNum / size;
            add = totalNum % size == 0 ? 0 : 1;
            total = totalNum;
            rspBo.setTotal(totalPage + add);
            rspBo.setRecordsTotal(total);
            DicDictionaryPo dicDictionaryPo = null;
            if (!CollectionUtils.isEmpty(commodityModels)) {
                for (UccCombEsCommodityBo cnncEsCommodityBo : commodityModels) {
                    Serializable eacRuTaskPO;
                    UccSkuManagementListCombQryBO uccSkuManagementListQryBO = new UccSkuManagementListCombQryBO();
                    uccSkuManagementListQryBO.setCommodityCode(cnncEsCommodityBo.getCommodity_code());
                    uccSkuManagementListQryBO.setCommodityId(cnncEsCommodityBo.getCommodity_id());
                    uccSkuManagementListQryBO.setCommodityName(cnncEsCommodityBo.getCommodity_name());
                    uccSkuManagementListQryBO.setSkuId(cnncEsCommodityBo.getSku_id());
                    uccSkuManagementListQryBO.setSkuCode(cnncEsCommodityBo.getSku_code());
                    uccSkuManagementListQryBO.setSkuName(cnncEsCommodityBo.getSku_name());
                    uccSkuManagementListQryBO.setSkuSource(cnncEsCommodityBo.getSku_source());
                    uccSkuManagementListQryBO.setSourceAssort(cnncEsCommodityBo.getSourceAssort());
                    uccSkuManagementListQryBO.setCommodityTypeId(cnncEsCommodityBo.getType_id());
                    uccSkuManagementListQryBO.setCommodityTypeName(cnncEsCommodityBo.getType_name());
                    uccSkuManagementListQryBO.setCatalogId(cnncEsCommodityBo.getL4mg_category_id());
                    uccSkuManagementListQryBO.setCatalogName(cnncEsCommodityBo.getL4mg_category_name());
                    uccSkuManagementListQryBO.setMainPic(cnncEsCommodityBo.getPicture_url());
                    uccSkuManagementListQryBO.setApprovalStatus(cnncEsCommodityBo.getSku_approval_status());
                    dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(cnncEsCommodityBo.getCommodity_status().toString(), CommodityEnum.COMMODITY_STATUS.toString());
                    if (dicDictionaryPo != null) {
                        uccSkuManagementListQryBO.setCommodityStatusDesc(dicDictionaryPo.getTitle());
                    }
                    if ((dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(cnncEsCommodityBo.getSku_status()), SkuEnum.SKU_STATUS.toString())) != null) {
                        uccSkuManagementListQryBO.setSkuStatusDesc(dicDictionaryPo.getTitle());
                        if (SkuStatusEnum.DOWN_FRAME_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.EC_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.ENFORCE_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.WARN_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status())) {
                            uccSkuManagementListQryBO.setSkuStatusDesc("\u5df2\u4e0b\u67b6");
                            uccSkuManagementListQryBO.setDownTypeDesc(dicDictionaryPo.getTitle());
                            try {
                                eacRuTaskPO = new UccSkuExpandPo();
                                ((UccSkuExpandPo)eacRuTaskPO).setSkuId(uccSkuManagementListQryBO.getSkuId());
                                List<UccSkuExpandPo> uccSkuExpandPos = this.uccSkuExpandMapper.querySkuExpand((UccSkuExpandPo)eacRuTaskPO);
                                if (!CollectionUtils.isEmpty(uccSkuExpandPos)) {
                                    uccSkuManagementListQryBO.setDownReason(uccSkuExpandPos.get(0).getExpand16());
                                }
                            }
                            catch (Exception e) {
                                log.error("\u67e5\u8be2\u4e0b\u67b6\u539f\u56e0\u5931\u8d25", (Object)e.getMessage());
                            }
                        }
                    }
                    if (cnncEsCommodityBo.getSku_approval_status() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(cnncEsCommodityBo.getSku_approval_status()), SkuEnum.SKU_APPROVAL_STATUS.toString())) != null) {
                        uccSkuManagementListQryBO.setApprovalStatusDesc(dicDictionaryPo.getTitle());
                    }
                    if ((dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(cnncEsCommodityBo.getSku_source()), SkuEnum.SKU_SOURCE.toString())) != null) {
                        uccSkuManagementListQryBO.setSkuSourceDesc(dicDictionaryPo.getTitle());
                    }
                    if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getUpc()) && cnncEsCommodityBo.getSku_source() == 3 && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(cnncEsCommodityBo.getUpc(), "UCC_AGR_MODEL_CONFIG")) != null) {
                        uccSkuManagementListQryBO.setAgrModel(cnncEsCommodityBo.getUpc());
                        uccSkuManagementListQryBO.setAgrModelStr(dicDictionaryPo.getTitle());
                    }
                    uccSkuManagementListQryBO.setBrandId(cnncEsCommodityBo.getBrand_id());
                    uccSkuManagementListQryBO.setBrandName(cnncEsCommodityBo.getBrand_name());
                    uccSkuManagementListQryBO.setVendorId(cnncEsCommodityBo.getVendor_id());
                    uccSkuManagementListQryBO.setMaterialCode(cnncEsCommodityBo.getMaterial_code());
                    uccSkuManagementListQryBO.setMaterialName(cnncEsCommodityBo.getMaterial_name());
                    uccSkuManagementListQryBO.setCommodityStatus(cnncEsCommodityBo.getCommodity_status());
                    uccSkuManagementListQryBO.setSkuStatus(cnncEsCommodityBo.getSku_status());
                    uccSkuManagementListQryBO.setMeasureId(cnncEsCommodityBo.getMeasure_id());
                    uccSkuManagementListQryBO.setMeasureName(cnncEsCommodityBo.getMeasure_name());
                    uccSkuManagementListQryBO.setSettlementUnit(cnncEsCommodityBo.getSettlement_unit());
                    if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getDiscounts())) {
                        uccSkuManagementListQryBO.setDiscount(new BigDecimal(cnncEsCommodityBo.getDiscounts()));
                    }
                    if (cnncEsCommodityBo.getDown_time() != null) {
                        uccSkuManagementListQryBO.setDownTime(new Date(cnncEsCommodityBo.getDown_time()));
                    } else {
                        UccSkuExpandPo expandPo = new UccSkuExpandPo();
                        expandPo.setSkuId(cnncEsCommodityBo.getSku_id());
                        UccSkuExpandPo model = this.uccSkuExpandMapper.getModel(expandPo);
                        if (!ObjectUtils.isEmpty((Object)model)) {
                            uccSkuManagementListQryBO.setDownTime(model.getExpand24());
                            uccSkuManagementListQryBO.setDownReason(model.getExpand16());
                        }
                    }
                    if (cnncEsCommodityBo.getUp_time() != null) {
                        uccSkuManagementListQryBO.setUpTime(new Date(cnncEsCommodityBo.getUp_time()));
                    }
                    if (cnncEsCommodityBo.getOn_shelve_time() != 0L) {
                        uccSkuManagementListQryBO.setOnShelveTime(new Date(cnncEsCommodityBo.getOn_shelve_time()));
                    }
                    uccSkuManagementListQryBO.setL4mgCategoryId(cnncEsCommodityBo.getL4mg_category_id());
                    uccSkuManagementListQryBO.setL4mgCategoryName(cnncEsCommodityBo.getL4mg_category_name());
                    uccSkuManagementListQryBO.setSalePrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getSale_price()));
                    uccSkuManagementListQryBO.setAgreementPrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getAgreement_price()));
                    uccSkuManagementListQryBO.setMarketPrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getMarket_price()));
                    uccSkuManagementListQryBO.setSupplierShopId(cnncEsCommodityBo.getSupplier_shop_id());
                    uccSkuManagementListQryBO.setSell(cnncEsCommodityBo.getSell());
                    uccSkuManagementListQryBO.setSpec(cnncEsCommodityBo.getSpec());
                    uccSkuManagementListQryBO.setModel(cnncEsCommodityBo.getModel());
                    if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getPicture_url())) {
                        uccSkuManagementListQryBO.setPicUrl(cnncEsCommodityBo.getPicture_url());
                    } else {
                        uccSkuManagementListQryBO.setPicUrl(cnncEsCommodityBo.getCommd_pic_url());
                    }
                    uccSkuManagementListQryBO.setRate(cnncEsCommodityBo.getTaxRate());
                    uccSkuManagementListQryBO.setPreDeliverDay(cnncEsCommodityBo.getPre_deliver_day());
                    uccSkuManagementListQryBO.setMoq(cnncEsCommodityBo.getMoq());
                    uccSkuManagementListQryBO.setSalesUnitId(cnncEsCommodityBo.getSales_unit_id());
                    uccSkuManagementListQryBO.setSalesUnitName(cnncEsCommodityBo.getSales_unit_name());
                    uccSkuManagementListQryBO.setSwitchOn(cnncEsCommodityBo.getSwitch_on());
                    uccSkuManagementListQryBO.setOtherSourceCode(cnncEsCommodityBo.getOther_source_code());
                    uccSkuManagementListQryBO.setOtherSourceName(cnncEsCommodityBo.getOther_source_name());
                    uccSkuManagementListQryBO.setCommodityExpand1(cnncEsCommodityBo.getCommodity_expand1());
                    uccSkuManagementListQryBO.setVendorName(cnncEsCommodityBo.getVendor_name());
                    if (cnncEsCommodityBo.getComment_number() != null) {
                        uccSkuManagementListQryBO.setTotalNum(MoneyUtils.haoToYuan(cnncEsCommodityBo.getComment_number()));
                    } else {
                        uccSkuManagementListQryBO.setTotalNum(new BigDecimal("0"));
                    }
                    uccSkuManagementListQryBO.setSupplierId(cnncEsCommodityBo.getSupplier_id());
                    uccSkuManagementListQryBO.setSupplierName(cnncEsCommodityBo.getSupplier_name());
                    uccSkuManagementListQryBO.setExtSpuId(cnncEsCommodityBo.getExt_spu_id());
                    uccSkuManagementListQryBO.setExtSkuId(cnncEsCommodityBo.getExt_sku_id());
                    uccSkuManagementListQryBO.setCreateTime(new Date(cnncEsCommodityBo.getCreate_time()));
                    if (!ObjectUtils.isEmpty((Object)cnncEsCommodityBo.getUpdate_time())) {
                        uccSkuManagementListQryBO.setUpdateTime(new Date(cnncEsCommodityBo.getUpdate_time()));
                    }
                    log.info("==\u6253\u5370\u5ba1\u6279\u65e5\u5fd7==" + this.userId);
                    log.info("==\u6253\u5370\u5ba1\u6279\u65e5\u5fd7==" + JSON.toJSONString((Object)uccSkuManagementListQryBO));
                    if (this.userId != null && uccSkuManagementListQryBO.getApprovalStatus() != null && uccSkuManagementListQryBO.getApprovalStatus() != 0) {
                        eacRuTaskPO = new EacRuTaskPO();
                        ((EacRuTaskPO)eacRuTaskPO).setBusinessId(uccSkuManagementListQryBO.getSkuId().toString());
                        ((EacRuTaskPO)eacRuTaskPO).setStatus("ACTIVE");
                        ((EacRuTaskPO)eacRuTaskPO).setTacheCode(cnncEsCommodityBo.getTache_code());
                        ((EacRuTaskPO)eacRuTaskPO).setUserId(this.userId.toString());
                        ((EacRuTaskPO)eacRuTaskPO).setOrderBy("CREATE_TIME");
                        List<EacRuTaskPO> list = this.eacRuTaskMapper.getList((EacRuTaskPO)eacRuTaskPO);
                        if (!CollectionUtils.isEmpty(list)) {
                            uccSkuManagementListQryBO.setTaskId(list.get(0).getTaskId());
                            uccSkuManagementListQryBO.setIsJoinTransfer(list.get(0).getIsJoinTransfer());
                        }
                    }
                    if (cnncEsCommodityBo.getAudit_time() != null) {
                        uccSkuManagementListQryBO.setAuditTime(new Date(cnncEsCommodityBo.getAudit_time()));
                    }
                    uccSkuManagementListQryBOs.add(uccSkuManagementListQryBO);
                }
            }
            rspBo.setRows(uccSkuManagementListQryBOs);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

