/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.utils;

import com.tydic.commodity.base.exception.BusinessException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.springframework.util.StringUtils;

public class DateUtils {
    private static final SimpleDateFormat shortSdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat longHourSdf = new SimpleDateFormat("yyyy-MM-dd HH");
    private static final SimpleDateFormat longSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String dateToStr(Date date) {
        try {
            SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return DATE_FORMAT.format(date);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
        }
    }

    public static Date strToDate(String str) {
        if (StringUtils.isEmpty((Object)str)) {
            return null;
        }
        try {
            SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return DATE_FORMAT.parse(str);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
        }
    }

    public static Integer compareDate(Date dt1, Date dt2) {
        try {
            if (dt1.getTime() > dt2.getTime()) {
                return 1;
            }
            if (dt1.getTime() < dt2.getTime()) {
                return -1;
            }
            return 0;
        }
        catch (Exception e) {
            throw new BusinessException("DATE_FORMAT_ERROR", "\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
        }
    }

    public static Date strToDateAsFormat(String str, String format) {
        if (StringUtils.isEmpty((Object)str)) {
            return null;
        }
        if (StringUtils.isEmpty((Object)format)) {
            return null;
        }
        try {
            SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(format);
            DATE_FORMAT.setLenient(false);
            return DATE_FORMAT.parse(str);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
        }
    }

    public static String dateToStrAsFormat(Date date, String format) {
        if (StringUtils.isEmpty((Object)format)) {
            return null;
        }
        if (date == null) {
            return null;
        }
        try {
            SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(format);
            return DATE_FORMAT.format(date);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
        }
    }

    public static Date getCurrentDateStartTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        Date now = null;
        try {
            now = longSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static Date getCurrentDateEndTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        Date now = null;
        try {
            now = longSdf.parse(shortSdf.format(c.getTime()) + " 23:59:59");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static Date getCurrentBeforeDateStartTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, -1);
        Date now = null;
        try {
            now = longSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static Date getCurrentBeforeDateEndTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, -1);
        Date now = null;
        try {
            now = longSdf.parse(shortSdf.format(c.getTime()) + " 23:59:59");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static Date getWeekStartTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int i = c.get(7) - 2;
        c.add(5, -i);
        Date now = null;
        try {
            now = longSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static Date getWeekEndTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int i = 7 - (c.get(7) - 1);
        c.add(5, i);
        Date now = null;
        try {
            now = longSdf.parse(shortSdf.format(c.getTime()) + " 23:59:59");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static int getDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(5);
    }

    public static void main(String[] args) {
        System.out.println(DateUtils.getWeekEndTime(new Date()));
    }
}

