/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.comb.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.bo.SkuPoolSyncESThreadBo;
import com.tydic.commodity.base.bo.UccDealPoolSyncESAtomReqBo;
import com.tydic.commodity.base.bo.UccDealPoolSyncESAtomRspBo;
import com.tydic.commodity.busibase.atom.api.UccDealPoolSyncESAtomService;
import com.tydic.commodity.busibase.busi.impl.SkuPoolSyncESThread;
import com.tydic.commodity.busibase.comb.api.UccDealPoolSyncESCombService;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.UccChannelDealMapper;
import com.tydic.commodity.dao.UccChannelMapper;
import com.tydic.commodity.dao.UccGuideCatalogExtMapper;
import com.tydic.commodity.dao.UccRelChannelPoolMapper;
import com.tydic.commodity.dao.UccRelPoolCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccDealPoolSyncESCombServiceImpl
implements UccDealPoolSyncESCombService {
    private static final Logger log = LoggerFactory.getLogger(UccDealPoolSyncESCombServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccRelPoolCommodityMapper uccRelPoolCommodityMapper;
    @Autowired
    private UccRelChannelPoolMapper uccRelChannelPoolMapper;
    @Autowired
    private UccChannelDealMapper uccChannelDealMapper;
    @Autowired
    private UccChannelMapper uccChannelMapper;
    @Autowired
    private UccGuideCatalogExtMapper uccGuideCatalogExtMapper;
    @Autowired
    private UccDealPoolSyncESAtomService uccDealPoolSyncESAtomService;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private EsConfig esConfig;
    private static final int shard = 20;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UccDealPoolSyncESAtomRspBo dealPoolSyncES(UccDealPoolSyncESAtomReqBo reqBo) {
        UccDealPoolSyncESAtomRspBo rspBo = new UccDealPoolSyncESAtomRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        try {
            this.checkParam(reqBo);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(e.getMessage());
            return rspBo;
        }
        int cpu = Runtime.getRuntime().availableProcessors();
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("thread-call-runner-%d").build();
        ThreadPoolExecutor fixedThreadPool = new ThreadPoolExecutor(cpu, cpu + 10, 2000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
        List<Object> splitList = new ArrayList();
        if (reqBo.getShard() > 1 && reqBo.getSyncType() == 0) {
            splitList = UccDealPoolSyncESCombServiceImpl.splitList(reqBo.getSkuIds(), 200);
        }
        UccDealPoolSyncESCombServiceImpl uccDealPoolSyncESCombServiceImpl = this;
        synchronized (uccDealPoolSyncESCombServiceImpl) {
            int start = 0;
            do {
                SkuPoolSyncESThreadBo skuPoolSyncESThreadBo = new SkuPoolSyncESThreadBo();
                skuPoolSyncESThreadBo.setShard(reqBo.getShard());
                skuPoolSyncESThreadBo.setStart(start);
                skuPoolSyncESThreadBo.setVendorIds(reqBo.getVendorIds());
                skuPoolSyncESThreadBo.setTypeIds(reqBo.getTypeIds());
                skuPoolSyncESThreadBo.setAgrIds(reqBo.getAgrIds());
                skuPoolSyncESThreadBo.setSkuIds(reqBo.getSkuIds());
                if (reqBo.getShard() > 1 && reqBo.getSyncType() == 0) {
                    skuPoolSyncESThreadBo.setSkuIds((List)splitList.get(start));
                }
                skuPoolSyncESThreadBo.setSyncType(reqBo.getSyncType());
                skuPoolSyncESThreadBo.setPoolIds(reqBo.getReqPoolIds());
                skuPoolSyncESThreadBo.setGuideCatalogIds(reqBo.getGuideCatalogIds());
                skuPoolSyncESThreadBo.setSpuIds(reqBo.getSpuIds());
                skuPoolSyncESThreadBo.setSize(reqBo.getSize());
                SkuPoolSyncESThread skuPoolSyncESThread = new SkuPoolSyncESThread();
                skuPoolSyncESThread.setSkuPoolSyncESThreadBo(skuPoolSyncESThreadBo);
                skuPoolSyncESThread.setUccExtSkuMapper(this.uccSkuMapper);
                skuPoolSyncESThread.setUccRelPoolCommodityMapper(this.uccRelPoolCommodityMapper);
                skuPoolSyncESThread.setUccGuideCatalogExtMapper(this.uccGuideCatalogExtMapper);
                skuPoolSyncESThread.setUccDealPoolSyncESAtomService(this.uccDealPoolSyncESAtomService);
                fixedThreadPool.submit(skuPoolSyncESThread);
            } while (++start < reqBo.getShard());
        }
        return rspBo;
    }

    public static <T> List<List<T>> splitList(List<T> list, int pageSize) {
        ArrayList<List<T>> listArray = new ArrayList<List<T>>();
        for (int i = 0; i < list.size(); i += pageSize) {
            int toIndex = Math.min(i + pageSize, list.size());
            listArray.add(list.subList(i, toIndex));
        }
        return listArray;
    }

    private void checkParam(UccDealPoolSyncESAtomReqBo reqBo) {
        if (reqBo.getSyncType() == null) {
            throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5904\u7406\u65b9\u5f0f");
        }
        switch (reqBo.getSyncType()) {
            case 0: {
                if (!CollectionUtils.isEmpty((Collection)reqBo.getSkuIds())) break;
                throw new ZTBusinessException("\u672a\u4f20\u5165\u5355\u54c1ID");
            }
            case 1: {
                if (!CollectionUtils.isEmpty((Collection)reqBo.getVendorIds())) break;
                throw new ZTBusinessException("\u672a\u4f20\u5165\u4f9b\u5e94\u5546ID");
            }
            case 2: {
                if (!CollectionUtils.isEmpty((Collection)reqBo.getTypeIds())) break;
                throw new ZTBusinessException("\u672a\u4f20\u5165\u7c7b\u578bID");
            }
            case 3: {
                if (!CollectionUtils.isEmpty((Collection)reqBo.getAgrIds())) break;
                throw new ZTBusinessException("\u672a\u4f20\u5165\u534f\u8baeID");
            }
            case 4: {
                if (!CollectionUtils.isEmpty((Collection)reqBo.getReqPoolIds())) break;
                throw new ZTBusinessException("\u672a\u4f20\u5165\u5546\u54c1\u6c60ID");
            }
            case 5: {
                if (!CollectionUtils.isEmpty((Collection)reqBo.getGuideCatalogIds())) break;
                throw new ZTBusinessException("\u672a\u4f20\u5165\u5bfc\u8d2d\u7c7b\u76eeID");
            }
            case 6: {
                if (!CollectionUtils.isEmpty((Collection)reqBo.getSpuIds())) break;
                throw new ZTBusinessException("\u672a\u4f20\u5165\u5546\u54c1ID");
            }
            default: {
                throw new ZTBusinessException("\u83b7\u53d6\u7684\u540c\u6b65\u7c7b\u578b\u4e0d\u5b58\u5728");
            }
        }
    }
}

