/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.utils;

import com.tydic.agreement.ability.api.AgrDicDictionaryAbilityService;
import com.tydic.agreement.ability.bo.AgrDicDictionaryBO;
import com.tydic.agreement.ability.bo.AgrQryDicDictionaryListAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryDicDictionaryListAbilityRspBO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PriceUtils {
    @Value(value="${ucc.sku.marketPriceCoefficient}")
    private String marketPriceCoefficient;
    @Autowired
    private AgrDicDictionaryAbilityService agrDicDictionaryAbilityService;

    public long marketPriceInfo(long price) {
        BigDecimal b = new BigDecimal(this.marketPriceCoefficient);
        return new BigDecimal(price).multiply(b).longValue();
    }

    public Map<String, String> getRateMap() {
        Map<String, String> rateMap = null;
        AgrQryDicDictionaryListAbilityReqBO reqBO = new AgrQryDicDictionaryListAbilityReqBO();
        reqBO.setPcodenew("TAX_RATE_PCODE");
        reqBO.setSysCode("AGR");
        AgrQryDicDictionaryListAbilityRspBO rspBO = this.agrDicDictionaryAbilityService.queryDictBOBySysCodeAndPcode(reqBO);
        List agrDicDictionaryBO = rspBO.getAgrDicDictionaryBO();
        if (!CollectionUtils.isEmpty((Collection)agrDicDictionaryBO)) {
            rateMap = agrDicDictionaryBO.stream().collect(Collectors.toMap(AgrDicDictionaryBO::getCode, AgrDicDictionaryBO::getCode));
        }
        return rateMap;
    }
}

