/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.utils;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;

@Component
public class RedisUtils {
    private static final Logger log = LoggerFactory.getLogger(RedisUtils.class);
    @Autowired
    private CacheClient cacheClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mset(Map<String, Param> map) {
        int len;
        if (map != null && (len = map.size()) > 0) {
            String[] keys = map.keySet().toArray(new String[0]);
            String[] strings = new String[len * 2];
            for (int i = 0; i < len; ++i) {
                strings[2 * i] = keys[i];
                strings[2 * i + 1] = JSONObject.toJSONString((Object)map.get(keys[i]));
            }
            try (Jedis jedis = null;){
                jedis = this.cacheClient.getJedisPool().getResource();
                jedis.mset(strings);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> mget(String ... keys) {
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        if (null != keys) {
            List resKeys = null;
            try (Jedis jedis = null;){
                jedis = this.cacheClient.getJedisPool().getResource();
                resKeys = jedis.mget(keys);
            }
            if (null != resKeys) {
                for (String str : resKeys) {
                    if (!StringUtils.isNotBlank((CharSequence)str)) continue;
                    Param params = (Param)JSONObject.parseObject((String)str, Param.class);
                    resMap.put(params.getKey(), params.getObj());
                }
            }
        }
        return resMap;
    }

    public static class Param<T> {
        private String key;
        private T obj;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public T getObj() {
            return this.obj;
        }

        public void setObj(T obj) {
            this.obj = obj;
        }
    }
}

