/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.UccDealPoolSyncESAtomReqBo;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccCommodityPoolSpuImportAbilityService;
import com.tydic.commodity.common.ability.bo.UccCommodityPoolSpuImportAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccCommodityPoolSpuImportAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccCommodityPoolSpuImportBusiService;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.dyc.umc.service.enterprise.UmcFileImpLogService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccCommodityPoolSpuImportAbilityService"})
public class UccCommodityPoolSpuImportAbilityServiceImpl
implements UccCommodityPoolSpuImportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccCommodityPoolSpuImportAbilityServiceImpl.class);
    @Autowired
    private UccCommodityPoolSpuImportBusiService uccCommodityPoolSpuImportBusiService;
    @Autowired
    private UmcFileImpLogService umcFileImpLogService;
    @Resource(name="uccDealPoolSyncToESProvider")
    private ProxyMessageProducer uccDealPoolSyncToESProvider;

    @PostMapping(value={"importSpuRelPool"})
    public UccCommodityPoolSpuImportAbilityRspBO importSpuRelPool(@RequestBody UccCommodityPoolSpuImportAbilityReqBO reqBO) {
        this.validate(reqBO);
        UccCommodityPoolSpuImportAbilityRspBO abilityRspBO = this.uccCommodityPoolSpuImportBusiService.dealSpuRelPool(reqBO);
        if ("0000".equals(abilityRspBO.getRespCode())) {
            try {
                UccDealPoolSyncESAtomReqBo poolSyncESAtomReqBo = new UccDealPoolSyncESAtomReqBo();
                poolSyncESAtomReqBo.setSpuIds(abilityRspBO.getSpuIds());
                poolSyncESAtomReqBo.setSyncType(Integer.valueOf(6));
                poolSyncESAtomReqBo.setShard(1);
                log.info("\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)poolSyncESAtomReqBo));
                this.uccDealPoolSyncToESProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"UCC_SYNC_POOL_ES_TOPIC"), PropertiesUtil.getProperty((String)"UCC_SYNC_POOL_ES_TAG"), JSON.toJSONString((Object)poolSyncESAtomReqBo)));
            }
            catch (Exception e) {
                log.error("\u53d1\u9001es\u540c\u6b65\u5546\u54c1\u6c60\u5546\u54c1\u5931\u8d25\uff01" + e.getMessage());
            }
        }
        return abilityRspBO;
    }

    private void validate(UccCommodityPoolSpuImportAbilityReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getPoolId())) {
            throw new BusinessException("8888", "\u5165\u53c2 poolId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getUrl())) {
            throw new BusinessException("8888", "\u5165\u53c2 url \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

