/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.constant.ExcelUtils;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccInquiryBatchImportByFileService;
import com.tydic.commodity.common.ability.bo.UccImoprtTemplateBO;
import com.tydic.commodity.common.ability.bo.UccInquiryBatchImportGoodsReqBO;
import com.tydic.commodity.common.ability.bo.UccInquiryBatchImportGoodsRspBO;
import com.tydic.commodity.common.ability.bo.UccInquiryImportGoodsInfo;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccInquiryBatchImportByFileService"})
public class UccInquiryBatchImportByFileAbilityServiceImpl
implements UccInquiryBatchImportByFileService {
    private static final Logger log = LoggerFactory.getLogger(UccInquiryBatchImportByFileAbilityServiceImpl.class);
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    @PostMapping(value={"dealInquiryBatchImportByFile"})
    public UccInquiryBatchImportGoodsRspBO dealInquiryBatchImportByFile(@RequestBody UccInquiryBatchImportGoodsReqBO reqBO) {
        UccInquiryBatchImportGoodsRspBO rspBO = new UccInquiryBatchImportGoodsRspBO();
        if (StringUtils.isBlank((CharSequence)reqBO.getUrl())) {
            throw new BusinessException("8888", "\u5165\u53c2 url \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getImpType() == null) {
            throw new BusinessException("8888", "\u5165\u53c2 impType \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        int titleRowIndex = this.getExcelDateByImport(reqBO.getUrl(), data, title);
        if (CollectionUtils.isEmpty(title)) {
            throw new BusinessException("8888", "\u6587\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Integer> dateMapIndex = new HashMap<String, Integer>();
        ArrayList templateBOs = new ArrayList();
        Map<Object, Object> map = new HashMap();
        if (reqBO.getImpType() == 1) {
            map = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_INQUIRY_IMPORT_TEMPLATE");
        } else if (reqBO.getImpType() == 2) {
            map = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_INQUIRY_MGR_IMPORT_TEMPLATE");
        } else {
            throw new BusinessException("8888", "\u67e5\u8be2\u4e0d\u5230\u89e3\u6790\u6a21\u677f\uff01");
        }
        String titleJson = (String)map.get("1");
        if (!StringUtils.isNotBlank((CharSequence)titleJson)) {
            throw new BusinessException("8888", "\u6587\u4ef6\u5bfc\u5165\u89e3\u6790\u6a21\u677f\u83b7\u53d6\u4e3a\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u89e3\u6790\u6a21\u677f\u662f\u5426\u5b58\u5728\uff01");
        }
        List list = JSON.parseArray((String)titleJson, UccImoprtTemplateBO.class);
        templateBOs.addAll(list);
        block2: for (UccImoprtTemplateBO bo : templateBOs) {
            for (int i = 0; i < title.size(); ++i) {
                if (!((String)title.get(i)).equals(bo.getFieldName())) continue;
                dateMapIndex.put(bo.getFieldNameEng(), i);
                continue block2;
            }
        }
        boolean resultLimit = false;
        ArrayList<Integer> quantityIndexList = new ArrayList<Integer>();
        ArrayList<Integer> goodsNameIndexList = new ArrayList<Integer>();
        ArrayList<Integer> brandIndexList = new ArrayList<Integer>();
        ArrayList<Integer> modelIndexList = new ArrayList<Integer>();
        ArrayList<Integer> receivingTimeIndexList = new ArrayList<Integer>();
        int index = titleRowIndex + 1;
        ArrayList importDataMaps = new ArrayList();
        for (List list2 : data) {
            ++index;
            int size = list2.size();
            HashMap<String, Double> dataMap = new HashMap<String, Double>();
            for (UccImoprtTemplateBO bo : templateBOs) {
                String s;
                Integer sheetKey = (Integer)dateMapIndex.get(bo.getFieldNameEng());
                if (sheetKey == null || sheetKey >= size) continue;
                if ("quantity".equalsIgnoreCase(bo.getFieldNameEng()) && StringUtils.isNotBlank((CharSequence)(s = (String)list2.get(sheetKey)))) {
                    try {
                        BigDecimal bigDecimal = BigDecimal.valueOf(Double.valueOf(s.trim())).setScale(2, 4);
                        dataMap.put(bo.getFieldNameEng(), bigDecimal.doubleValue());
                        continue;
                    }
                    catch (Exception e) {
                        resultLimit = true;
                        quantityIndexList.add(index);
                    }
                }
                if ("goodsName".equalsIgnoreCase(bo.getFieldNameEng()) && StringUtils.isNotBlank((CharSequence)(s = (String)list2.get(sheetKey))) && s.length() > 10) {
                    resultLimit = true;
                    goodsNameIndexList.add(index);
                }
                if ("brand".equalsIgnoreCase(bo.getFieldNameEng()) && StringUtils.isNotBlank((CharSequence)(s = (String)list2.get(sheetKey))) && s.length() > 10) {
                    resultLimit = true;
                    brandIndexList.add(index);
                }
                if ("model".equalsIgnoreCase(bo.getFieldNameEng()) && StringUtils.isNotBlank((CharSequence)(s = (String)list2.get(sheetKey))) && s.length() > 10) {
                    resultLimit = true;
                    modelIndexList.add(index);
                }
                if ("receivingTime".equalsIgnoreCase(bo.getFieldNameEng()) && StringUtils.isNotBlank((CharSequence)(s = (String)list2.get(sheetKey))) && !StringUtils.isNumeric((CharSequence)s)) {
                    resultLimit = true;
                    receivingTimeIndexList.add(index);
                }
                dataMap.put(bo.getFieldNameEng(), (Double)list2.get(sheetKey));
            }
            importDataMaps.add(dataMap);
        }
        if (resultLimit) {
            StringBuilder sb = new StringBuilder();
            sb.append("\u5bfc\u5165\u5931\u8d25\uff01").append("</br>");
            if (quantityIndexList.size() > 0) {
                if (quantityIndexList.size() > 3) {
                    sb.append("\u7b2c").append(StringUtils.join(quantityIndexList.subList(0, 3), (String)",")).append(",...\u7b49\u884c,\u9700\u6c42\u6570\u91cf\u5217\u5b58\u5728\u975e\u6570\u5b57\u7c7b\u578b\u6570\u636e\uff1b");
                } else {
                    sb.append("\u7b2c").append(StringUtils.join(quantityIndexList, (String)",")).append("\u884c,\u9700\u6c42\u6570\u91cf\u5217\u5b58\u5728\u975e\u6570\u5b57\u7c7b\u578b\u6570\u636e\uff1b");
                }
                sb.append("</br>");
            }
            if (goodsNameIndexList.size() > 0) {
                if (goodsNameIndexList.size() > 3) {
                    sb.append("\u7b2c").append(StringUtils.join(goodsNameIndexList.subList(0, 3), (String)",")).append(",...\u7b49\u591a\u884c,\u5546\u54c1\u540d\u79f0\u5217\u957f\u5ea6\u8d85\u9650\uff0810\u4e2a\u5b57\u4ee5\u5185\uff09\uff1b");
                } else {
                    sb.append("\u7b2c").append(StringUtils.join(goodsNameIndexList, (String)",")).append("\u884c,\u5546\u54c1\u540d\u79f0\u5217\u957f\u5ea6\u8d85\u9650\uff0810\u4e2a\u5b57\u4ee5\u5185\uff09\uff1b");
                }
                sb.append("</br>");
            }
            if (brandIndexList.size() > 0) {
                if (brandIndexList.size() > 3) {
                    sb.append("\u7b2c").append(StringUtils.join(brandIndexList.subList(0, 3), (String)",")).append(",...\u7b49\u591a\u884c,\u54c1\u724c\u5217\u957f\u5ea6\u8d85\u9650\uff0810\u4e2a\u5b57\u4ee5\u5185\uff09\uff1b");
                } else {
                    sb.append("\u7b2c").append(StringUtils.join(brandIndexList, (String)",")).append("\u884c,\u54c1\u724c\u5217\u957f\u5ea6\u8d85\u9650\uff0810\u4e2a\u5b57\u4ee5\u5185\uff09\uff1b");
                }
                sb.append("</br>");
            }
            if (modelIndexList.size() > 0) {
                if (modelIndexList.size() > 3) {
                    sb.append("\u7b2c").append(StringUtils.join(modelIndexList.subList(0, 3), (String)",")).append(",...\u7b49\u591a\u884c,\u89c4\u683c\u578b\u53f7\u5217\u957f\u5ea6\u8d85\u9650\uff0810\u4e2a\u5b57\u4ee5\u5185\uff09\uff1b");
                } else {
                    sb.append("\u7b2c").append(StringUtils.join(modelIndexList, (String)",")).append("\u884c,\u89c4\u683c\u578b\u53f7\u5217\u957f\u5ea6\u8d85\u9650\uff0810\u4e2a\u5b57\u4ee5\u5185\uff09\uff1b");
                }
                sb.append("</br>");
            }
            if (receivingTimeIndexList.size() > 0) {
                if (receivingTimeIndexList.size() > 3) {
                    sb.append("\u7b2c").append(StringUtils.join(receivingTimeIndexList.subList(0, 3), (String)",")).append(",...\u7b49\u591a\u884c,\u6536\u83b7\u65f6\u95f4\u5217\u5b58\u5728\u975e\u6570\u5b57\u7c7b\u578b\u6570\u636e\uff1b");
                } else {
                    sb.append("\u7b2c").append(StringUtils.join(receivingTimeIndexList, (String)",")).append("\u884c,\u6536\u83b7\u65f6\u95f4\u5217\u5b58\u5728\u975e\u6570\u5b57\u7c7b\u578b\u6570\u636e\uff1b");
                }
            }
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(sb.toString());
            return rspBO;
        }
        String jsonStr = JSON.toJSONString(importDataMaps);
        List list3 = JSONObject.parseArray((String)jsonStr, UccInquiryImportGoodsInfo.class);
        if (list3.size() > 500) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8d85\u51fa500\u884c\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\uff01");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4f60\u5df2\u6210\u529f\u63d0\u4ea4");
        rspBO.setImportDataList(list3);
        return rspBO;
    }

    private int getExcelDateByImport(String path, List<List<String>> data, List<String> title) {
        int titleRowIndex = 0;
        int index = 0;
        try {
            URL url = new URL(path);
            File file = new File(url.getFile());
            ExcelUtils.checkExcelVaild((File)file);
            Workbook workbook = ExcelUtils.getWorkbok((File)file, (InputStream)url.openStream());
            Sheet sheet = workbook.getSheetAt(0);
            for (Row row : sheet) {
                short end = row.getLastCellNum();
                if (end > 1) {
                    Cell cell1 = row.getCell(0);
                    Cell cell2 = row.getCell(1);
                    if (cell1 != null && cell2 != null) {
                        String cValue1 = String.valueOf(ExcelUtils.getValue((Cell)cell1)).trim().replace("*", "");
                        String cValue2 = String.valueOf(ExcelUtils.getValue((Cell)cell2)).trim().replace("*", "");
                        if ("\u5546\u54c1\u540d\u79f0".equalsIgnoreCase(cValue1) && "\u9700\u6c42\u6570\u91cf".equalsIgnoreCase(cValue2)) break;
                    }
                }
                ++titleRowIndex;
            }
            for (Row row : sheet) {
                if (index >= titleRowIndex) {
                    boolean isNotEmptyRow = false;
                    ArrayList<String> c = new ArrayList<String>();
                    int end = row.getLastCellNum();
                    for (int i = 0; i < end; ++i) {
                        Cell cell = row.getCell(i);
                        if (cell == null) {
                            c.add("");
                            continue;
                        }
                        Object obj = ExcelUtils.getValue((Cell)cell);
                        if (index == titleRowIndex) {
                            title.add(String.valueOf(obj).trim());
                            continue;
                        }
                        if (index <= titleRowIndex) continue;
                        String str = String.valueOf(obj).trim();
                        if (obj != null && StringUtils.isNotBlank((CharSequence)str)) {
                            isNotEmptyRow = true;
                        }
                        c.add(str);
                    }
                    if (c.size() > 0 && isNotEmptyRow) {
                        data.add(c);
                    }
                }
                ++index;
            }
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u7b2c" + index + 1 + "\u884c\u6570\u636e\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
        return titleRowIndex;
    }
}

