/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccSkuPriceRecordAbilityService;
import com.tydic.commodity.common.ability.bo.UccItemPriceRecordQueryBO;
import com.tydic.commodity.common.ability.bo.UccSkuPriceRecordAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuPriceRecordAbilityRspBO;
import com.tydic.commodity.dao.ECommercePriceChangeLogMapper;
import com.tydic.commodity.dao.UccGoodsPriceChangeLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.po.ECommercePriceChangeLogPO;
import com.tydic.commodity.po.UccGoodsPriceChangeLogPO;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuPriceRecordAbilityService"})
public class UccSkuPriceRecordAbilityServiceImpl
implements UccSkuPriceRecordAbilityService {
    @Autowired
    private UccGoodsPriceChangeLogMapper uccGoodsPriceChangeLogMapper;
    @Autowired
    private ECommercePriceChangeLogMapper eCommercePriceChangeLogMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;

    @PostMapping(value={"priceRecord"})
    public UccSkuPriceRecordAbilityRspBO priceRecord(@RequestBody UccSkuPriceRecordAbilityReqBO reqBO) {
        this.validate(reqBO);
        UccSkuPriceRecordAbilityRspBO rspBO = new UccSkuPriceRecordAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List<Object> recordQueryList = new ArrayList();
        List<Object> changeRecordList = new ArrayList();
        Integer skuSource = this.uccSkuMapper.qrySkuSource(reqBO.getSkuId());
        if (ObjectUtils.isEmpty((Object)skuSource)) {
            throw new BusinessException("8888", "\u5355\u54c1id\u4e3a\uff1a\u3010" + reqBO.getSkuId() + "\u3011\u4e0d\u5b58\u5728\uff01\u8bf7\u68c0\u67e5\u5165\u53c2\uff01");
        }
        switch (skuSource) {
            case 2: {
                List recordChangeList;
                ECommercePriceChangeLogPO changeLogPO = new ECommercePriceChangeLogPO();
                changeLogPO.setSkuId(reqBO.getSkuId());
                changeLogPO.setUpdateTimeStar(reqBO.getRecordDateBegin());
                changeLogPO.setUpdateTimeEnd(reqBO.getRecordDateEnd());
                List changeLogPOList = this.eCommercePriceChangeLogMapper.qryList(changeLogPO);
                if (!CollectionUtils.isEmpty((Collection)changeLogPOList)) {
                    recordQueryList = changeLogPOList.stream().map(po -> {
                        UccItemPriceRecordQueryBO itemPriceRecordQueryBO = new UccItemPriceRecordQueryBO();
                        itemPriceRecordQueryBO.setPriceRecordId(po.getId());
                        itemPriceRecordQueryBO.setAveragePrice(po.getAveragePrice().divide(new BigDecimal(2), 2, 0));
                        itemPriceRecordQueryBO.setCreateTime(po.getUpdateTime());
                        itemPriceRecordQueryBO.setPrice(po.getOldPrice());
                        if (po.getNewMinPrice().compareTo(po.getMinPrice()) >= 0) {
                            itemPriceRecordQueryBO.setMinPrice(po.getMinPrice());
                        } else {
                            itemPriceRecordQueryBO.setMinPrice(po.getNewMinPrice());
                        }
                        itemPriceRecordQueryBO.setSkuId(reqBO.getSkuId());
                        return itemPriceRecordQueryBO;
                    }).collect(Collectors.toList());
                }
                if (CollectionUtils.isEmpty((Collection)(recordChangeList = this.eCommercePriceChangeLogMapper.getList(changeLogPO)))) break;
                changeRecordList = recordChangeList.stream().map(e -> {
                    UccItemPriceRecordQueryBO changeRecord = new UccItemPriceRecordQueryBO();
                    changeRecord.setOldPrice(e.getOldPrice());
                    changeRecord.setRecordDate(e.getUpdateTime());
                    changeRecord.setCreateTime(e.getUpdateTime());
                    changeRecord.setPrice(e.getCurrentPrice());
                    return changeRecord;
                }).collect(Collectors.toList());
                break;
            }
            case 3: {
                UccGoodsPriceChangeLogPO agrChange = new UccGoodsPriceChangeLogPO();
                agrChange.setSkuId(reqBO.getSkuId());
                agrChange.setChangeTimeStart(reqBO.getRecordDateBegin());
                agrChange.setChangeTimeEnd(reqBO.getRecordDateEnd());
                List agrChanges = this.uccGoodsPriceChangeLogMapper.qryList(agrChange);
                if (CollectionUtils.isEmpty((Collection)agrChanges)) break;
                recordQueryList = agrChanges.stream().map(po -> {
                    UccItemPriceRecordQueryBO itemPriceRecordQueryBO = new UccItemPriceRecordQueryBO();
                    itemPriceRecordQueryBO.setAveragePrice(MoneyUtils.haoToYuan((Long)po.getAveragePrice()).divide(new BigDecimal(2), 2, 0));
                    itemPriceRecordQueryBO.setCreateTime(po.getChangeTime());
                    itemPriceRecordQueryBO.setPrice(MoneyUtils.haoToYuan((Long)po.getCurrentPrice()));
                    if (po.getOldMinPrice().compareTo(po.getMinPrice()) >= 0) {
                        itemPriceRecordQueryBO.setMinPrice(MoneyUtils.haoToYuan((Long)po.getMinPrice()));
                    } else {
                        itemPriceRecordQueryBO.setMinPrice(MoneyUtils.haoToYuan((Long)po.getOldMinPrice()));
                    }
                    itemPriceRecordQueryBO.setPriceRecordId(po.getPriceChangeLogId());
                    itemPriceRecordQueryBO.setSkuId(reqBO.getSkuId());
                    return itemPriceRecordQueryBO;
                }).collect(Collectors.toList());
                List agrChangeRecordList = this.uccGoodsPriceChangeLogMapper.getList(agrChange);
                if (CollectionUtils.isEmpty((Collection)agrChangeRecordList)) break;
                changeRecordList = agrChangeRecordList.stream().map(e -> {
                    UccItemPriceRecordQueryBO changeRecord = new UccItemPriceRecordQueryBO();
                    changeRecord.setOldPrice(MoneyUtils.haoToYuan((Long)e.getOldPrice()));
                    changeRecord.setRecordDate(e.getChangeTime());
                    changeRecord.setCreateTime(e.getChangeTime());
                    changeRecord.setPrice(MoneyUtils.haoToYuan((Long)e.getCurrentPrice()));
                    return changeRecord;
                }).collect(Collectors.toList());
                break;
            }
            default: {
                throw new BusinessException("8888", "\u8be5\u5355\u54c1\u6765\u6e90\u5f02\u5e38\uff01" + skuSource);
            }
        }
        if (CollectionUtils.isEmpty(recordQueryList)) {
            UccSkuPricePo pricePo = new UccSkuPricePo();
            pricePo.setSkuId(reqBO.getSkuId());
            UccSkuPricePo skuPricePo = this.uccSkuPriceMapper.querySkuPrice(pricePo);
            if (!ObjectUtils.isEmpty((Object)skuPricePo)) {
                UccItemPriceRecordQueryBO priceRecordQueryBO = new UccItemPriceRecordQueryBO();
                priceRecordQueryBO.setSkuId(reqBO.getSkuId());
                priceRecordQueryBO.setMinPrice(MoneyUtils.haoToYuan((Long)skuPricePo.getSalePrice()));
                priceRecordQueryBO.setAveragePrice(MoneyUtils.haoToYuan((Long)skuPricePo.getSalePrice()));
                priceRecordQueryBO.setCreateTime(skuPricePo.getCreateTime());
                priceRecordQueryBO.setPrice(MoneyUtils.haoToYuan((Long)skuPricePo.getSalePrice()));
                recordQueryList.add(priceRecordQueryBO);
            }
        }
        rspBO.setRecordQueryList(recordQueryList);
        rspBO.setRecordChangeList(changeRecordList);
        return rspBO;
    }

    private void validate(UccSkuPriceRecordAbilityReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getRecordDateBegin())) {
            throw new BusinessException("8888", "\u53c2\u6570 recordDateBegin \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getRecordDateEnd())) {
            throw new BusinessException("8888", "\u53c2\u6570 recordDateEnd \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getSkuId())) {
            throw new BusinessException("8888", "\u53c2\u6570 skuId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

