/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SelfRunSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccSpuBatchStatsChangeAbilityService;
import com.tydic.commodity.common.ability.api.UccSyncSceneCommodityToEsAbilityService;
import com.tydic.commodity.common.ability.bo.UccSpuBatchStatsChangeAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSpuBatchStatsChangeAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccSpuBatchStatsChangeBusiService;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSpuBatchStatsChangeAbilityService"})
public class UccSpuBatchStatsChangeAbilityServiceImpl
implements UccSpuBatchStatsChangeAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSpuBatchStatsChangeAbilityServiceImpl.class);
    @Autowired
    private UccSpuBatchStatsChangeBusiService uccSpuBatchStatsChangeBusiService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSyncSceneCommodityToEsAbilityService uccSyncSceneCommodityToEsAbilityService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"spuBatchStatusChange"})
    public UccSpuBatchStatsChangeAbilityRspBO spuBatchStatusChange(@RequestBody UccSpuBatchStatsChangeAbilityReqBO reqBO) {
        List skuPos;
        this.validate(reqBO);
        UccSpuBatchStatsChangeAbilityRspBO busiRsp = this.uccSpuBatchStatsChangeBusiService.spuBatchStatusChange(reqBO);
        if ("0000".equals(busiRsp.getRespCode()) && !CollectionUtils.isEmpty((Collection)(skuPos = this.uccSkuMapper.getSKuIdsBySupIds(reqBO.getSupplierIds(), reqBO.getStatus().intValue())))) {
            Map skuMap = skuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId, Collectors.mapping(UccSkuPo::getSkuId, Collectors.toList())));
            for (Long shopId : skuMap.keySet()) {
                SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setSkuIds(skuMap.get(shopId));
                syncSceneCommodityToEsReqBO.setSupplierId(shopId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("==\u5e97\u94fa\u540c\u6b65\u4e0b\u67b6\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff01" + e.getMessage());
                }
            }
        }
        return busiRsp;
    }

    private void validate(UccSpuBatchStatsChangeAbilityReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getStatus())) {
            throw new BusinessException("8888", "\u5165\u53c2 status \u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSupplierIds())) {
            throw new BusinessException("8888", "\u5165\u53c2 supplierIds \u4e3a\u7a7a\uff01");
        }
    }

    @PostMapping(value={"spuBatchStatusShelveChange"})
    public UccSpuBatchStatsChangeAbilityRspBO spuBatchStatusShelveChange(@RequestBody UccSpuBatchStatsChangeAbilityReqBO reqBO) {
        List skuPos;
        this.validate1(reqBO);
        UccSpuBatchStatsChangeAbilityRspBO uccSpuBatchStatsChangeAbilityRspBO = this.uccSpuBatchStatsChangeBusiService.spuBatchStatusShelveChange(reqBO);
        if ("0000".equals(uccSpuBatchStatsChangeAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)(skuPos = this.uccSkuMapper.getSKuIdsBySupIds(reqBO.getSupplierIds(), reqBO.getStatus().intValue())))) {
            Map skuMap = skuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId, Collectors.mapping(UccSkuPo::getSkuId, Collectors.toList())));
            for (Long shopId : skuMap.keySet()) {
                SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setSkuIds(skuMap.get(shopId));
                syncSceneCommodityToEsReqBO.setSupplierId(shopId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("==\u5e97\u94fa\u540c\u6b65\u4e0b\u67b6\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff01" + e.getMessage());
                }
            }
        }
        return uccSpuBatchStatsChangeAbilityRspBO;
    }

    private void validate1(UccSpuBatchStatsChangeAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getSupplierIds())) {
            throw new BusinessException("8888", "\u53c2\u6570 supplierIds \u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getStatus())) {
            throw new BusinessException("8888", "\u53c2\u6570 status \u4e3a\u7a7a\uff01");
        }
    }
}

