/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.common.ability.api.UccSpuCodingexportAbilityService;
import com.tydic.commodity.common.ability.bo.UccEsCommodityBo;
import com.tydic.commodity.common.ability.bo.UccExprotCodeBo;
import com.tydic.commodity.common.ability.bo.UccSpuCodingexportAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSpuCodingexportAbilityRspBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSpuCodingexportAbilityService"})
public class UccSpuCodingexportAbilityServiceImpl
implements UccSpuCodingexportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSpuCodingexportAbilityServiceImpl.class);
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;

    @PostMapping(value={"dealUccSpuCodingexport"})
    public UccSpuCodingexportAbilityRspBO dealUccSpuCodingexport(@RequestBody UccSpuCodingexportAbilityReqBO reqBO) {
        UccSpuCodingexportAbilityRspBO rspBo = new UccSpuCodingexportAbilityRspBO();
        BoolQueryBuilder extBoolQueryBuilder = this.buildEsSql(reqBO);
        String queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder);
        String result = this.searchInfo(queryString);
        if (StringUtils.isEmpty((Object)result)) {
            rspBo.setTotal(0);
            rspBo.setRespCode("0000");
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList());
            return rspBo;
        }
        rspBo = this.dealSearchData(result, reqBO);
        return rspBo;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private BoolQueryBuilder buildEsSql(UccSpuCodingexportAbilityReqBO reqBo) {
        WildcardQueryBuilder wildcardQuery;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBo.getOperType() != null && reqBo.getOperType() == 1) {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"picture_url"));
        }
        if (reqBo.getSkuSource() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)reqBo.getSkuSource()));
        }
        if (reqBo.getSourceAssort() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sourceAssort", (Object)reqBo.getSourceAssort()));
        }
        if (reqBo.getApprovalStatus() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"spu_approval_status", (Object)reqBo.getApprovalStatus()));
        }
        if (reqBo.getCommodityStatus() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_status", (Object)reqBo.getCommodityStatus()));
        }
        if (reqBo.getBrandId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_id", (Object)reqBo.getBrandId()));
        }
        if (reqBo.getVendorId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)reqBo.getVendorId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSupplierOrgId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_org_id", (String)reqBo.getSupplierOrgId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_id", (Object)reqBo.getCommodityId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getL4mgCategoryId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"L4mg_category_id", (String)reqBo.getL4mgCategoryId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"other_source_code", (String)reqBo.getOtherSourceCode()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"create_oper_id", (String)reqBo.getCreateOperId()));
        }
        if (reqBo.getSupplierShopId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_shop_id", (Object)reqBo.getSupplierShopId()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOperIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operIds", (Collection)reqBo.getOperIds()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getBrandName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"brand_name.keyword", (String)(reqBo.getBrandName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_name.keyword", (String)(reqBo.getCommodityName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityExpand1())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_expand1.keyword", (String)(reqBo.getCommodityExpand1() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getVendorName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"vendor_name.keyword", (String)(reqBo.getVendorName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_code.keyword", (String)("*" + reqBo.getCommodityCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"other_source_name.keyword", (String)(reqBo.getOtherSourceName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        return boolQueryBuilder;
    }

    private String excuteEsSql(UccSpuCodingexportAbilityReqBO reqBo, BoolQueryBuilder extBoolQueryBuilder) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("track_total_hits", (Object)true);
        queryJson.put("size", (Object)reqBo.getPageSize());
        queryJson.put("from", (Object)(reqBo.getPageSize() * (reqBo.getPageNo() - 1)));
        ArrayList<String> source = new ArrayList<String>();
        source.add("commodity_code");
        source.add("sku_code");
        source.add("commodity_expand1");
        source.add("commodity_name");
        source.add("other_source_code");
        source.add("vendor_name");
        source.add("vendor_id");
        source.add("sku_source");
        source.add("sku_id");
        source.add("commodity_id");
        source.add("supplier_shop_id");
        queryJson.put("_source", source);
        String queryString = null;
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        return queryJson.toString();
    }

    private UccSpuCodingexportAbilityRspBO dealSearchData(String result, UccSpuCodingexportAbilityReqBO reqBo) {
        UccSpuCodingexportAbilityRspBO rspBo = new UccSpuCodingexportAbilityRspBO();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = 0;
        try {
            total = hitsObj.getInteger("total");
        }
        catch (Exception e) {
            JSONObject totalObj = (JSONObject)hitsObj.get((Object)"total");
            total = totalObj.getInteger("value");
        }
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        }
        ArrayList<UccEsCommodityBo> commodityModels = new ArrayList<UccEsCommodityBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                UccEsCommodityBo commodity = new UccEsCommodityBo();
                try {
                    commodity = (UccEsCommodityBo)JSON.toJavaObject((JSON)data, UccEsCommodityBo.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                    if (!skuIdSet.contains(commodity.getSku_id())) {
                        commodityModels.add(commodity);
                    }
                    skuIdSet.add(commodity.getSku_id());
                }
            }
        }
        rspBo = this.copyData(commodityModels, total, reqBo.getPageNo(), reqBo.getPageSize());
        return rspBo;
    }

    private UccSpuCodingexportAbilityRspBO copyData(List<UccEsCommodityBo> commodityModels, Integer totalNum, int pageNo, int pageSize) {
        UccSpuCodingexportAbilityRspBO rspBo = new UccSpuCodingexportAbilityRspBO();
        ArrayList<UccExprotCodeBo> uccExprotCodeBoList = new ArrayList<UccExprotCodeBo>();
        if (totalNum != null) {
            rspBo.setPageNo(pageNo);
            int size = pageSize;
            int totalPage = 0;
            int add = 0;
            Integer total = 0;
            totalPage = totalNum / size;
            add = totalNum % size == 0 ? 0 : 1;
            total = totalNum;
            rspBo.setTotal(totalPage + add);
            rspBo.setRecordsTotal(total.intValue());
            Object dicDictionaryPo = null;
            if (!CollectionUtils.isEmpty(commodityModels)) {
                for (UccEsCommodityBo uccEsCommodityBo : commodityModels) {
                    UccExprotCodeBo uccExprotCodeBo = new UccExprotCodeBo();
                    uccExprotCodeBo.setCommodityCode(uccEsCommodityBo.getCommodity_code());
                    uccExprotCodeBo.setSkuCode(uccEsCommodityBo.getSku_code());
                    uccExprotCodeBo.setCommodityExpand1(uccEsCommodityBo.getCommodity_expand1());
                    uccExprotCodeBo.setCommodityName(uccEsCommodityBo.getCommodity_name());
                    uccExprotCodeBo.setOtherSourceCode(uccEsCommodityBo.getOther_source_code());
                    uccExprotCodeBo.setVendorId(uccEsCommodityBo.getVendor_id());
                    uccExprotCodeBo.setVendorName(uccEsCommodityBo.getVendor_name());
                    uccExprotCodeBo.setSkuSource(Integer.valueOf(uccEsCommodityBo.getSku_source()));
                    uccExprotCodeBo.setSkuId(Long.valueOf(uccEsCommodityBo.getSku_id()));
                    uccExprotCodeBo.setCommodityId(Long.valueOf(uccEsCommodityBo.getCommodity_id()));
                    uccExprotCodeBo.setSupplierShopId(uccEsCommodityBo.getSupplier_shop_id());
                    uccExprotCodeBoList.add(uccExprotCodeBo);
                }
            }
            rspBo.setRows(uccExprotCodeBoList);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

