/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.atom.impl;

import com.tydic.commodity.common.ability.bo.UccIteminstockModifyBO;
import com.tydic.commodity.common.atom.api.UccIteminstockEditService;
import com.tydic.commodity.common.atom.bo.UccIteminstockEditReqBO;
import com.tydic.commodity.common.atom.bo.UccIteminstockEditRspBO;
import com.tydic.commodity.dao.UccSmcsdkSkuStockInfoMapper;
import com.tydic.commodity.po.UccSmcsdkSkuStockInfoPO;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.smcsdk.api.SmcsdkOperateStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumRspBO;
import com.tydic.smcsdk.api.bo.SmcsdkStockNumInfoBO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccIteminstockEditServiceImpl
implements UccIteminstockEditService {
    private static final Logger log = LoggerFactory.getLogger(UccIteminstockEditServiceImpl.class);
    @Autowired
    private SmcsdkOperateStockNumService smcsdkOperateStockNumService;
    @Autowired
    private UccSmcsdkSkuStockInfoMapper smcsdkSupStockInfoMapper;

    @Override
    public UccIteminstockEditRspBO dealUccIteminstockEdit(UccIteminstockEditReqBO reqBO) {
        Object skus;
        Object boList;
        UccIteminstockEditRspBO rspBO = new UccIteminstockEditRspBO();
        SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO = new SmcsdkOperateStockNumReqBO();
        ArrayList<SmcsdkStockNumInfoBO> smcsdkStockNumInfoBOs = new ArrayList<SmcsdkStockNumInfoBO>();
        if (CollectionUtils.isEmpty(reqBO.getBatchStock())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5e93\u5b58\u64cd\u4f5c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        Map<Integer, List<UccIteminstockModifyBO>> integerListMap = reqBO.getBatchStock().stream().collect(Collectors.groupingBy(UccIteminstockModifyBO::getOperTupe));
        ArrayList<String> failMsgList = new ArrayList<String>();
        ArrayList<UccIteminstockModifyBO> reduceStockList = new ArrayList<UccIteminstockModifyBO>();
        if (integerListMap.containsKey(0)) {
            boList = integerListMap.get(0);
            skus = boList.stream().map(UccIteminstockModifyBO::getSkuId).collect(Collectors.toList());
            List skuStockInfo = this.smcsdkSupStockInfoMapper.getListBySku((List)skus);
            Iterator iterator = boList.iterator();
            while (iterator.hasNext()) {
                UccIteminstockModifyBO change = (UccIteminstockModifyBO)iterator.next();
                boolean hasStock = false;
                for (UccSmcsdkSkuStockInfoPO old : skuStockInfo) {
                    if (!old.getSkuId().equals(change.getSkuId().toString())) continue;
                    hasStock = true;
                    if (old.getTotalNum() - MoneyUtils.yuanToHaoToLongObj((Long)change.getNum()) < old.getSaledNum()) {
                        failMsgList.add("\u5e8f\u53f7" + change.getSerialNum() + "\uff0c\u8c03\u6574\u5e45\u5ea6\u8d85\u8fc7\u53ef\u8c03\u6574\u6700\u5927\u6570\u91cf\uff08\u8c03\u6574\u540e\u5e93\u5b58\u5e94\u5927\u4e8e\u6216\u7b49\u4e8e\u5df2\u552e\u5e93\u5b58\uff09\uff1b");
                        continue;
                    }
                    reduceStockList.add(change);
                }
                if (hasStock) continue;
                failMsgList.add("\u5e8f\u53f7" + change.getSerialNum() + "\uff0c\u64cd\u4f5csku \u65e0\u5e93\u5b58\u6570\u636e\uff1b");
            }
        }
        if (integerListMap.containsKey(1)) {
            Object uccIteminstockEditBO;
            boList = integerListMap.get(1);
            skus = boList.iterator();
            while (skus.hasNext()) {
                uccIteminstockEditBO = (UccIteminstockModifyBO)skus.next();
                SmcsdkStockNumInfoBO smcsdkStockNumInfoBO = new SmcsdkStockNumInfoBO();
                smcsdkStockNumInfoBO.setSkuId(uccIteminstockEditBO.getSkuId().toString());
                smcsdkStockNumInfoBO.setOperateNum(MoneyUtils.yuanToHaoToLongObj((Long)uccIteminstockEditBO.getNum()));
                smcsdkStockNumInfoBOs.add(smcsdkStockNumInfoBO);
            }
            smcsdkOperateStockNumReqBO.setOperateType("10");
            smcsdkOperateStockNumReqBO.setObjectId("111111");
            smcsdkOperateStockNumReqBO.setOperateNo(reqBO.getUsername());
            smcsdkOperateStockNumReqBO.setObjectType("20");
            smcsdkOperateStockNumReqBO.setSmcsdkStockNumInfoBOs(smcsdkStockNumInfoBOs);
            SmcsdkOperateStockNumRspBO smcsdkOperateStockNumRspBO = this.smcsdkOperateStockNumService.operateStockNum(smcsdkOperateStockNumReqBO);
            if (!"0000".equals(smcsdkOperateStockNumRspBO.getRespCode())) {
                log.info("[UccIteminstockEditServiceImpl]\u589e\u52a0\u5e93\u5b58\u64cd\u4f5c\u5931\u8d25,respCode:{},respDesc:{}", (Object)smcsdkOperateStockNumRspBO.getRespCode(), (Object)smcsdkOperateStockNumRspBO.getRespDesc());
                uccIteminstockEditBO = boList.iterator();
                while (uccIteminstockEditBO.hasNext()) {
                    UccIteminstockModifyBO bo = (UccIteminstockModifyBO)uccIteminstockEditBO.next();
                    failMsgList.add("\u5e8f\u53f7" + bo.getSerialNum() + "\uff0c" + smcsdkOperateStockNumRspBO.getRespDesc() + "\uff1b");
                }
            }
        }
        if (reduceStockList.size() > 0) {
            for (UccIteminstockModifyBO uccIteminstockEditBO : reduceStockList) {
                SmcsdkStockNumInfoBO smcsdkStockNumInfoBO = new SmcsdkStockNumInfoBO();
                smcsdkStockNumInfoBO.setSkuId(uccIteminstockEditBO.getSkuId().toString());
                smcsdkStockNumInfoBO.setOperateNum(Long.valueOf(-1L * MoneyUtils.yuanToHaoToLongObj((Long)uccIteminstockEditBO.getNum())));
                smcsdkStockNumInfoBOs.add(smcsdkStockNumInfoBO);
            }
            smcsdkOperateStockNumReqBO.setOperateType("10");
            smcsdkOperateStockNumReqBO.setObjectId("111111");
            smcsdkOperateStockNumReqBO.setOperateNo(reqBO.getUsername());
            smcsdkOperateStockNumReqBO.setObjectType("10");
            smcsdkOperateStockNumReqBO.setSmcsdkStockNumInfoBOs(smcsdkStockNumInfoBOs);
            SmcsdkOperateStockNumRspBO smcsdkOperateStockNumRspBO = this.smcsdkOperateStockNumService.operateStockNum(smcsdkOperateStockNumReqBO);
            if (!"0000".equals(smcsdkOperateStockNumRspBO.getRespCode())) {
                log.info("[UccIteminstockEditServiceImpl]\u51cf\u5c11\u5e93\u5b58\u64cd\u4f5c\u5931\u8d25,respCode:{},respDesc:{}", (Object)smcsdkOperateStockNumRspBO.getRespCode(), (Object)smcsdkOperateStockNumRspBO.getRespDesc());
                for (UccIteminstockModifyBO bo : reduceStockList) {
                    failMsgList.add("\u5e8f\u53f7" + bo.getSerialNum() + "\uff0c" + smcsdkOperateStockNumRspBO.getRespDesc() + "\uff1b");
                }
            }
        }
        int total = reqBO.getBatchStock().size();
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        rspBO.setFailNum(failMsgList.size());
        rspBO.setFailMsgList(failMsgList);
        rspBO.setSuccessNum(total - failMsgList.size());
        rspBO.setTotalNum(total);
        return rspBO;
    }
}

