/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.tydic.commodity.base.bo.UccCommodityPicBO;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccExcelImportImgSpuBO;
import com.tydic.commodity.common.busi.api.UccBatchImageImportChangeBusiService;
import com.tydic.commodity.common.busi.bo.UccBatchImageImportChangeBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccBatchImageImportChangeBusiRspBO;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.po.UccCommodityPicPo;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuPicPo;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccBatchImageImportChangeBusiServiceImpl
implements UccBatchImageImportChangeBusiService {
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;

    @Override
    public UccBatchImageImportChangeBusiRspBO dealBatchImageImport(UccBatchImageImportChangeBusiReqBO reqBO) {
        List<UccCommodityPicBO> pics = reqBO.getPics();
        Map<Integer, List<UccCommodityPicBO>> picMap = pics.stream().collect(Collectors.groupingBy(UccCommodityPicBO::getCommodityPicType));
        List<Long> commodityIds = reqBO.getSpuBOS().stream().map(UccExcelImportImgSpuBO::getCommodityId).collect(Collectors.toList());
        List skuIds = this.uccSkuMapper.getSKuIdsByComms(commodityIds);
        this.dealUpdatePics(reqBO, pics, picMap, commodityIds, skuIds);
        List uccCommodityPos = this.uccCommodityMapper.getIdAndShop(commodityIds);
        Map<Long, List<Long>> commoditysMap = uccCommodityPos.stream().collect(Collectors.groupingBy(UccCommodityPo::getSupplierShopId, Collectors.mapping(UccCommodityPo::getCommodityId, Collectors.toList())));
        UccBatchImageImportChangeBusiRspBO busiRspBO = new UccBatchImageImportChangeBusiRspBO();
        busiRspBO.setSysMap(commoditysMap);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }

    private void dealUpdatePics(UccBatchImageImportChangeBusiReqBO reqBO, List<UccCommodityPicBO> pics, Map<Integer, List<UccCommodityPicBO>> picMap, List<Long> commodityIds, List<Long> skuIds) {
        this.uccCommodityPicMapper.updateSkuPicBySpus(commodityIds, picMap.get(1).get(0).getCommodityPicUrl());
        this.uccSkuPicMapper.updateSkuPicBySkus(skuIds, picMap.get(1).get(0).getCommodityPicUrl());
        boolean detailFlag = false;
        List<UccCommodityPicBO> detailPics = picMap.get(2);
        for (UccCommodityPicBO detailPic : detailPics) {
            if (StringUtils.isEmpty((Object)detailPic.getCommodityPicUrl())) continue;
            detailFlag = true;
            break;
        }
        if (detailFlag) {
            List commodityPicPos = this.uccCommodityPicMapper.getListBySpuIds(commodityIds);
            List skuPicPos = this.uccSkuPicMapper.getListBySkuIds(skuIds);
            if (CollectionUtils.isEmpty((Collection)commodityPicPos) || CollectionUtils.isEmpty((Collection)skuPicPos)) {
                throw new BusinessException("8888", "\u5546\u54c1\u6216\u8005\u5355\u54c1\u67e5\u8be2\u8be6\u60c5\u56fe\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            Map<Long, List<UccCommodityPicPo>> commPicMap = commodityPicPos.stream().collect(Collectors.groupingBy(UccCommodityPicPo::getCommodityId));
            for (Long commodityId : commPicMap.keySet()) {
                int count = 0;
                for (UccCommodityPicPo commodityPicPo : commPicMap.get(commodityId)) {
                    if (count == 0) {
                        commodityPicPo.setCommodityPicUrl(detailPics.get(0).getCommodityPicUrl());
                    }
                    if (count == 1) {
                        commodityPicPo.setCommodityPicUrl(detailPics.get(1).getCommodityPicUrl());
                    }
                    if (count == 2) {
                        commodityPicPo.setCommodityPicUrl(detailPics.get(2).getCommodityPicUrl());
                    }
                    if (count == 3) {
                        commodityPicPo.setCommodityPicUrl(detailPics.get(3).getCommodityPicUrl());
                    }
                    ++count;
                }
                try {
                    this.uccCommodityPicMapper.updateBatchCommodityPicById(commPicMap.get(commodityId), commodityId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BusinessException("8888", "\u6279\u91cf\u66f4\u65b0\u5546\u54c1\u56fe\u7247\u5931\u8d25\uff01" + e.getMessage());
                }
            }
            Map<Long, List<UccSkuPicPo>> skuPicMap = skuPicPos.stream().collect(Collectors.groupingBy(UccSkuPicPo::getSkuId));
            for (Long skuId : skuPicMap.keySet()) {
                int count = 0;
                for (UccSkuPicPo skuPicPo : skuPicMap.get(skuId)) {
                    if (count == 0) {
                        skuPicPo.setSkuPicUrl(detailPics.get(0).getCommodityPicUrl());
                    }
                    if (count == 1) {
                        skuPicPo.setSkuPicUrl(detailPics.get(1).getCommodityPicUrl());
                    }
                    if (count == 2) {
                        skuPicPo.setSkuPicUrl(detailPics.get(2).getCommodityPicUrl());
                    }
                    if (count == 3) {
                        skuPicPo.setSkuPicUrl(detailPics.get(3).getCommodityPicUrl());
                    }
                    ++count;
                }
                try {
                    this.uccSkuPicMapper.updateBatchskuPicById(skuPicMap.get(skuId), skuId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BusinessException("8888", "\u6279\u91cf\u66f4\u65b0\u5355\u54c1\u56fe\u7247\u5931\u8d25\uff01" + e.getMessage());
                }
            }
        }
    }

    public static void main(String[] args) {
        System.err.println(new BigDecimal("-1.2").longValue());
    }
}

