/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.CatalogRelManagerBO;
import com.tydic.commodity.common.busi.api.UccGuideManagerImportBusiService;
import com.tydic.commodity.common.busi.bo.UccGuideManagerImportBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccGuideManagerImportBusiRspBO;
import com.tydic.commodity.dao.UccGuideCatalogExtMapper;
import com.tydic.commodity.dao.UccManagerRelGuideCatalogMapper;
import com.tydic.commodity.po.UccGuideManagerPO;
import com.tydic.commodity.po.UccManagerRelGuideCatalogPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccGuideManagerImportBusiServiceImpl
implements UccGuideManagerImportBusiService {
    @Autowired
    private UccGuideCatalogExtMapper uccGuideCatalogExtMapper;
    @Autowired
    private UccManagerRelGuideCatalogMapper uccManagerRelGuideCatalogMapper;
    private static final Sequence SEQUENCE = Sequence.getInstance();

    @Override
    public UccGuideManagerImportBusiRspBO dealImport(UccGuideManagerImportBusiReqBO reqBO) {
        Map<Integer, List<CatalogRelManagerBO>> catalogRelManagerMap = reqBO.getCatalogRelManagerMap();
        Iterator<Integer> iterator = reqBO.getCatalogRelManagerMap().keySet().iterator();
        ArrayList endCatalogIds1 = new ArrayList();
        ArrayList endCatalogIds2 = new ArrayList();
        List<Long> endCatalogIds3 = new ArrayList<Long>();
        List<UccGuideManagerPO> uccGuideManagerRelPOS1 = new ArrayList<UccGuideManagerPO>();
        List<UccGuideManagerPO> uccGuideManagerRelPOS2 = new ArrayList<UccGuideManagerPO>();
        ArrayList uccGuideManagerRelPOS3 = new ArrayList();
        block7: while (iterator.hasNext()) {
            Integer level = iterator.next();
            List<CatalogRelManagerBO> managerBOS = catalogRelManagerMap.get(level);
            if (CollectionUtils.isEmpty(managerBOS)) continue;
            switch (level) {
                case 1: {
                    for (CatalogRelManagerBO managerBO : managerBOS) {
                        uccGuideManagerRelPOS1 = this.getEndCatalogIds(level, Collections.singletonList(managerBO.getCatalogId()), managerBO.getManagerName(), managerBO.getManagerId());
                    }
                    continue block7;
                }
                case 2: {
                    for (CatalogRelManagerBO managerBO : managerBOS) {
                        uccGuideManagerRelPOS2 = this.getEndCatalogIds(level, Collections.singletonList(managerBO.getCatalogId()), managerBO.getManagerName(), managerBO.getManagerId());
                    }
                    continue block7;
                }
                case 3: {
                    endCatalogIds3 = managerBOS.stream().map(CatalogRelManagerBO::getCatalogId).collect(Collectors.toList());
                    break;
                }
                default: {
                    throw new BusinessException("8888", "\u5904\u7406\u7c7b\u76ee\u5173\u8054\u5931\u8d25\uff01");
                }
            }
        }
        this.dealCatalogId(uccGuideManagerRelPOS1, uccGuideManagerRelPOS2, endCatalogIds3);
        List<UccManagerRelGuideCatalogPO> guideCatalogPOS = this.dealCollectCatalogManager(uccGuideManagerRelPOS1, uccGuideManagerRelPOS2, endCatalogIds3, catalogRelManagerMap, reqBO);
        List listIds = guideCatalogPOS.stream().map(UccManagerRelGuideCatalogPO::getLastCatalogId).collect(Collectors.toList());
        try {
            this.uccManagerRelGuideCatalogMapper.deleteByLastIds(listIds);
            this.uccManagerRelGuideCatalogMapper.insertBatch(guideCatalogPOS);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u6279\u91cf\u65b0\u589e\u5f00\u53d1\u7ecf\u7406-\u7c7b\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425\u4eba\u5458");
        }
        UccGuideManagerImportBusiRspBO rspBO = new UccGuideManagerImportBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<UccManagerRelGuideCatalogPO> dealCollectCatalogManager(List<UccGuideManagerPO> endCatalogIds1, List<UccGuideManagerPO> endCatalogIds2, List<Long> endCatalogIds3, Map<Integer, List<CatalogRelManagerBO>> map, UccGuideManagerImportBusiReqBO reqBO) {
        Date time = new Date();
        ArrayList<UccManagerRelGuideCatalogPO> uccManagerRelGuideCatalogPOS = new ArrayList<UccManagerRelGuideCatalogPO>();
        if (!CollectionUtils.isEmpty(endCatalogIds1)) {
            List collect1 = endCatalogIds1.stream().map(id -> {
                UccManagerRelGuideCatalogPO relGuideCatalogPO = new UccManagerRelGuideCatalogPO();
                relGuideCatalogPO.setManagerId(id.getManagerId());
                relGuideCatalogPO.setManagerName(id.getManagerName());
                relGuideCatalogPO.setLevel(Integer.valueOf(1));
                relGuideCatalogPO.setId(Long.valueOf(SEQUENCE.nextId()));
                relGuideCatalogPO.setCreateTime(time);
                relGuideCatalogPO.setLastCatalogId(id.getGuideCatalogId());
                relGuideCatalogPO.setOperId(reqBO.getUserId());
                relGuideCatalogPO.setOperName(reqBO.getName());
                return relGuideCatalogPO;
            }).collect(Collectors.toList());
            uccManagerRelGuideCatalogPOS.addAll(collect1);
        }
        if (!CollectionUtils.isEmpty(endCatalogIds2)) {
            List collect2 = endCatalogIds2.stream().map(id -> {
                UccManagerRelGuideCatalogPO relGuideCatalogPO = new UccManagerRelGuideCatalogPO();
                relGuideCatalogPO.setManagerId(id.getManagerId());
                relGuideCatalogPO.setManagerName(id.getManagerName());
                relGuideCatalogPO.setLevel(Integer.valueOf(2));
                relGuideCatalogPO.setId(Long.valueOf(SEQUENCE.nextId()));
                relGuideCatalogPO.setCreateTime(time);
                relGuideCatalogPO.setLastCatalogId(id.getGuideCatalogId());
                relGuideCatalogPO.setOperId(reqBO.getUserId());
                relGuideCatalogPO.setOperName(reqBO.getName());
                return relGuideCatalogPO;
            }).collect(Collectors.toList());
            uccManagerRelGuideCatalogPOS.addAll(collect2);
        }
        if (!CollectionUtils.isEmpty(endCatalogIds3)) {
            List<CatalogRelManagerBO> relManagerBOS3 = map.get(3);
            Map<Long, List<CatalogRelManagerBO>> map3 = relManagerBOS3.stream().collect(Collectors.groupingBy(CatalogRelManagerBO::getCatalogId));
            List collect3 = endCatalogIds3.stream().map(id -> {
                UccManagerRelGuideCatalogPO relGuideCatalogPO = new UccManagerRelGuideCatalogPO();
                relGuideCatalogPO.setManagerId(((CatalogRelManagerBO)((List)map3.get(id)).get(0)).getManagerId());
                relGuideCatalogPO.setManagerName(((CatalogRelManagerBO)((List)map3.get(id)).get(0)).getManagerName());
                relGuideCatalogPO.setLevel(Integer.valueOf(3));
                relGuideCatalogPO.setId(Long.valueOf(SEQUENCE.nextId()));
                relGuideCatalogPO.setCreateTime(time);
                relGuideCatalogPO.setLastCatalogId(id);
                relGuideCatalogPO.setOperId(reqBO.getUserId());
                relGuideCatalogPO.setOperName(reqBO.getName());
                return relGuideCatalogPO;
            }).collect(Collectors.toList());
            uccManagerRelGuideCatalogPOS.addAll(collect3);
        }
        return uccManagerRelGuideCatalogPOS;
    }

    private void dealCatalogId(List<UccGuideManagerPO> endCatalogIds1, List<UccGuideManagerPO> endCatalogIds2, List<Long> endCatalogIds3) {
        if (!CollectionUtils.isEmpty(endCatalogIds1)) {
            Iterator<UccGuideManagerPO> iterator1 = endCatalogIds1.iterator();
            while (iterator1.hasNext()) {
                List id2s;
                Long catalogId = iterator1.next().getGuideCatalogId();
                if (!CollectionUtils.isEmpty(endCatalogIds2) && (id2s = endCatalogIds2.stream().map(UccGuideManagerPO::getGuideCatalogId).collect(Collectors.toList())).contains(catalogId)) {
                    iterator1.remove();
                    continue;
                }
                if (CollectionUtils.isEmpty(endCatalogIds3) || !endCatalogIds3.contains(catalogId)) continue;
                iterator1.remove();
            }
            if (!CollectionUtils.isEmpty(endCatalogIds2)) {
                Iterator<UccGuideManagerPO> iterator2 = endCatalogIds2.iterator();
                if (!CollectionUtils.isEmpty(endCatalogIds3)) {
                    while (iterator2.hasNext()) {
                        Long guideCatalogId = iterator2.next().getGuideCatalogId();
                        if (!endCatalogIds3.contains(guideCatalogId)) continue;
                        iterator2.remove();
                    }
                }
            }
        }
    }

    private List<UccGuideManagerPO> getEndCatalogIds(Integer level, List<Long> guideCatalogIds, String managerName, Long managerId) {
        List catalogPOS = null;
        switch (level) {
            case 1: {
                catalogPOS = this.uccGuideCatalogExtMapper.getEndLevelByCatalog1(level, guideCatalogIds);
                break;
            }
            case 2: {
                catalogPOS = this.uccGuideCatalogExtMapper.getEndLevelByCatalog2(level, guideCatalogIds);
                break;
            }
            case 3: {
                catalogPOS = this.uccGuideCatalogExtMapper.getCatalogInfo(level, guideCatalogIds);
                break;
            }
            default: {
                throw new BusinessException("8888", "level \u4e0d\u5408\u6cd5\uff01");
            }
        }
        if (CollectionUtils.isEmpty((Collection)catalogPOS)) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u4e09\u7ea7\u7c7b\u76ee\u4fe1\u606f\uff01");
        }
        List<UccGuideManagerPO> managerPOS = catalogPOS.stream().map(e -> {
            UccGuideManagerPO rel = new UccGuideManagerPO();
            rel.setCatalogName(e.getCatalogName());
            rel.setGuideCatalogId(e.getCatalogId());
            rel.setManagerId(managerId);
            rel.setManagerName(managerName);
            return rel;
        }).collect(Collectors.toList());
        return managerPOS;
    }
}

