/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.busi.api.UccInquirySheetInfosQryBusiService;
import com.tydic.commodity.common.busi.bo.UccInquiryMyQuotationDetailBO;
import com.tydic.commodity.common.busi.bo.UccInquirySheetInfosQryBO;
import com.tydic.commodity.common.busi.bo.UccInquirySheetInfosQryBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccInquirySheetInfosQryBusiRspBO;
import com.tydic.commodity.dao.UccInquirySheetDetailMapper;
import com.tydic.commodity.po.UccInquirySheetInfoPO;
import com.tydic.commodity.po.UccInquirySheetInfoQryPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccInquirySheetInfosQryBusiServiceImpl
implements UccInquirySheetInfosQryBusiService {
    @Autowired
    private UccInquirySheetDetailMapper uccInquirySheetDetailMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    @Override
    public UccInquirySheetInfosQryBusiRspBO inquirySheetInfosQry(UccInquirySheetInfosQryBusiReqBO reqBO) {
        UccInquirySheetInfosQryBusiRspBO rspBO = new UccInquirySheetInfosQryBusiRspBO();
        UccInquirySheetInfoQryPO qryPO = (UccInquirySheetInfoQryPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), UccInquirySheetInfoQryPO.class);
        List uccInquirySheetInfoPOList = this.uccInquirySheetDetailMapper.queryInquirySheetInfoListAll(qryPO);
        ArrayList<UccInquirySheetInfosQryBO> dataList = new ArrayList<UccInquirySheetInfosQryBO>();
        if (uccInquirySheetInfoPOList != null && uccInquirySheetInfoPOList.size() > 0) {
            Map<Long, List<UccInquirySheetInfoPO>> listMap = uccInquirySheetInfoPOList.stream().collect(Collectors.groupingBy(UccInquirySheetInfoPO::getInquirySheetDetailId));
            if (reqBO.getInquirySheetDetailIdForSort() != null) {
                List<UccInquirySheetInfoPO> inquirySheetInfoPOList = listMap.get(reqBO.getInquirySheetDetailIdForSort());
                this.buildUccInquirySheetInfosQryBO(dataList, inquirySheetInfoPOList);
                listMap.remove(reqBO.getInquirySheetDetailIdForSort());
            }
            for (Long inquirySheetDetailId : listMap.keySet()) {
                this.buildUccInquirySheetInfosQryBO(dataList, listMap.get(inquirySheetDetailId));
            }
        }
        this.translateDataToStr(dataList);
        rspBO.setInquirySheetDetailList(dataList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public void buildUccInquirySheetInfosQryBO(List<UccInquirySheetInfosQryBO> dataList, List<UccInquirySheetInfoPO> inquirySheetInfoPOList) {
        if (!CollectionUtils.isEmpty(inquirySheetInfoPOList)) {
            UccInquirySheetInfoPO sheetInfoPO = inquirySheetInfoPOList.get(0);
            UccInquirySheetInfosQryBO infosQryBO = new UccInquirySheetInfosQryBO();
            BeanUtils.copyProperties((Object)sheetInfoPO, (Object)infosQryBO);
            ArrayList<UccInquiryMyQuotationDetailBO> quotationList = new ArrayList<UccInquiryMyQuotationDetailBO>();
            for (UccInquirySheetInfoPO infoPO : inquirySheetInfoPOList) {
                UccInquiryMyQuotationDetailBO quotationDetailBO = new UccInquiryMyQuotationDetailBO();
                BeanUtils.copyProperties((Object)infoPO, (Object)quotationDetailBO);
                quotationDetailBO.setRemark(infoPO.getQuotationRemark());
                if (infoPO.getSalesPrice() != null && infoPO.getQuotationQuantity() != null) {
                    quotationDetailBO.setSalesPriceTotal(infoPO.getSalesPrice().multiply(new BigDecimal(infoPO.getQuotationQuantity())));
                }
                if (infoPO.getQuotationTime() != null) {
                    quotationDetailBO.setQuotedDays(Integer.parseInt(DateUtil.betweenDay((Date)new Date(), (Date)infoPO.getQuotationTime(), (boolean)true) + ""));
                }
                quotationList.add(quotationDetailBO);
                if (quotationDetailBO.getSalesPrice() != null) {
                    quotationDetailBO.setSalesPrice(quotationDetailBO.getSalesPrice().divide(new BigDecimal("10000")));
                }
                if (quotationDetailBO.getPurchasePrice() != null) {
                    quotationDetailBO.setPurchasePrice(quotationDetailBO.getPurchasePrice().divide(new BigDecimal("10000")));
                }
                if (quotationDetailBO.getSalesPriceTotal() == null) continue;
                quotationDetailBO.setSalesPriceTotal(quotationDetailBO.getSalesPriceTotal().divide(new BigDecimal("10000")).setScale(2, 4));
            }
            infosQryBO.setInquiryQuotationList(quotationList);
            dataList.add(infosQryBO);
        }
    }

    public void translateDataToStr(List<UccInquirySheetInfosQryBO> dataList) {
        if (!CollectionUtils.isEmpty(dataList)) {
            Map<String, String> quotationStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap("QUOTATION_STATUS_MANGER");
            for (UccInquirySheetInfosQryBO qryBO : dataList) {
                List<UccInquiryMyQuotationDetailBO> inquiryQuotationList = qryBO.getInquiryQuotationList();
                if (CollectionUtils.isEmpty(inquiryQuotationList)) continue;
                for (UccInquiryMyQuotationDetailBO quotationDetailBO : inquiryQuotationList) {
                    if (quotationDetailBO.getQuotationStatus() == null) continue;
                    quotationDetailBO.setQuotationStatusStr(quotationStatusMap.get(quotationDetailBO.getQuotationStatus().toString()));
                }
            }
        }
    }
}

