/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import cn.hutool.core.date.DateUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.busi.api.UccInquirySheetMangerQryListBusiService;
import com.tydic.commodity.common.busi.bo.UccInquirySheetMangerQryListBO;
import com.tydic.commodity.common.busi.bo.UccInquirySheetMangerQryListBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccInquirySheetMangerQryListBusiRspBO;
import com.tydic.commodity.dao.UccInquirySheetMapper;
import com.tydic.commodity.po.UccInquirySheetMangerDetailPO;
import com.tydic.commodity.po.UccInquirySheetMangerQryPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccInquirySheetMangerQryListBusiServiceImpl
implements UccInquirySheetMangerQryListBusiService {
    @Autowired
    private UccInquirySheetMapper uccInquirySheetMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    @Override
    public UccInquirySheetMangerQryListBusiRspBO InquirySheetMangerQryList(UccInquirySheetMangerQryListBusiReqBO reqBO) {
        UccInquirySheetMangerQryListBusiRspBO rspBO = new UccInquirySheetMangerQryListBusiRspBO();
        UccInquirySheetMangerQryPO uccInquirySheetMangerQryPO = new UccInquirySheetMangerQryPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)uccInquirySheetMangerQryPO);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List detailPOList = new ArrayList();
        detailPOList = reqBO.getPageQueryFlag() != false ? this.uccInquirySheetMapper.queryInquiryMangerList(uccInquirySheetMangerQryPO, page) : this.uccInquirySheetMapper.queryInquiryMangerList(uccInquirySheetMangerQryPO);
        ArrayList<UccInquirySheetMangerQryListBO> rows = new ArrayList<UccInquirySheetMangerQryListBO>();
        if (detailPOList != null) {
            for (UccInquirySheetMangerDetailPO uccInquirySheetMangerDetailPO : detailPOList) {
                UccInquirySheetMangerQryListBO uccInquirySheetMangerQryListBO = new UccInquirySheetMangerQryListBO();
                BeanUtils.copyProperties((Object)uccInquirySheetMangerDetailPO, (Object)uccInquirySheetMangerQryListBO);
                if (uccInquirySheetMangerDetailPO.getSalesPrice() != null && uccInquirySheetMangerDetailPO.getQuotationQuantity() != null) {
                    uccInquirySheetMangerQryListBO.setSalesPriceTotal(uccInquirySheetMangerDetailPO.getSalesPrice().multiply(new BigDecimal(uccInquirySheetMangerDetailPO.getQuotationQuantity())));
                }
                if (uccInquirySheetMangerDetailPO.getQuotationTime() != null) {
                    uccInquirySheetMangerQryListBO.setQuotedDays(Integer.parseInt(DateUtil.betweenDay((Date)new Date(), (Date)uccInquirySheetMangerDetailPO.getQuotationTime(), (boolean)true) + ""));
                }
                rows.add(uccInquirySheetMangerQryListBO);
                if (uccInquirySheetMangerQryListBO.getSalesPrice() != null) {
                    uccInquirySheetMangerQryListBO.setSalesPrice(uccInquirySheetMangerQryListBO.getSalesPrice().divide(new BigDecimal("10000")));
                }
                if (uccInquirySheetMangerQryListBO.getPurchasePrice() != null) {
                    uccInquirySheetMangerQryListBO.setPurchasePrice(uccInquirySheetMangerQryListBO.getPurchasePrice().divide(new BigDecimal("10000")));
                }
                if (uccInquirySheetMangerQryListBO.getSalesPriceTotal() == null) continue;
                uccInquirySheetMangerQryListBO.setSalesPriceTotal(uccInquirySheetMangerQryListBO.getSalesPriceTotal().divide(new BigDecimal("10000")).setScale(2, 4));
            }
        }
        this.translateDataToStr(rows);
        rspBO.setRows(rows);
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public void translateDataToStr(List<UccInquirySheetMangerQryListBO> rows) {
        if (!CollectionUtils.isEmpty(rows)) {
            Map<String, String> inquiryStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap("INQUIRY_STATUS_MANGER");
            Map<String, String> quotationStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap("QUOTATION_STATUS_MANGER");
            Map<String, String> inquirySourceMap = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_INQUIRY_SOURCE");
            Map<String, String> enterpriseTypeMap = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_INQUIRY_ENTERPRISE_TYPE");
            Map<String, String> industryTypeMap = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_INQUIRY_INDUSTRY_TYPE");
            for (UccInquirySheetMangerQryListBO row : rows) {
                if (row.getInquiryStatus() != null) {
                    row.setInquiryStatusStr(inquiryStatusMap.get(row.getInquiryStatus().toString()));
                }
                if (row.getQuotationStatus() != null) {
                    row.setQuotationStatusStr(quotationStatusMap.get(row.getQuotationStatus().toString()));
                }
                if (row.getInquirySource() != null) {
                    row.setInquirySourceStr(inquirySourceMap.get(row.getInquirySource().toString()));
                }
                if (row.getEnterpriseType() != null) {
                    row.setEnterpriseTypeStr(enterpriseTypeMap.get(row.getEnterpriseType().toString()));
                }
                if (row.getIndustryType() == null) continue;
                row.setIndustryTypeStr(industryTypeMap.get(row.getIndustryType().toString()));
            }
        }
    }
}

