/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccInquiryMatchGoodsUpdateBO;
import com.tydic.commodity.common.ability.bo.UccInquiryQuotationDetailBO;
import com.tydic.commodity.common.busi.api.UccInquirySheetUpdateBusiService;
import com.tydic.commodity.common.busi.bo.UccInquirySheetUpdateBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccInquirySheetUpdateBusiRspBO;
import com.tydic.commodity.dao.UccInquiryQuotationDetailMapper;
import com.tydic.commodity.dao.UccInquirySheetDetailMapper;
import com.tydic.commodity.dao.UccInquirySheetMapper;
import com.tydic.commodity.po.UccInquiryQuotationDetailPO;
import com.tydic.commodity.po.UccInquiryQuotationDetailQryPO;
import com.tydic.commodity.po.UccInquirySheetDetailPO;
import com.tydic.commodity.po.UccInquirySheetPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccInquirySheetUpdateBusiServiceImpl
implements UccInquirySheetUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccInquirySheetUpdateBusiServiceImpl.class);
    @Autowired
    private UccInquirySheetMapper uccInquirySheetMapper;
    @Autowired
    private UccInquirySheetDetailMapper uccInquirySheetDetailMapper;
    @Autowired
    private UccInquiryQuotationDetailMapper uccInquiryQuotationDetailMapper;
    private static final Sequence SEQUENCE = Sequence.getInstance();

    @Override
    public UccInquirySheetUpdateBusiRspBO updateInquirySheet(UccInquirySheetUpdateBusiReqBO uccInquirySheetBusiReqBO) {
        UccInquirySheetUpdateBusiRspBO rspBO = new UccInquirySheetUpdateBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Long inquirySheetId = uccInquirySheetBusiReqBO.getInquirySheetId();
        if (null == inquirySheetId) {
            throw new BusinessException("8888", "\u8be2\u76d8\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        UccInquirySheetPO uccInquirySheetPO = this.uccInquirySheetMapper.queryById(inquirySheetId);
        if (Objects.isNull(uccInquirySheetPO)) {
            throw new BusinessException("8888", "\u8be2\u76d8\u5355\u67e5\u8be2\u5931\u8d25\u3002");
        }
        this.checkStatus(uccInquirySheetPO);
        Integer editType = uccInquirySheetBusiReqBO.getEditType();
        switch (editType) {
            case 1: {
                this.save(uccInquirySheetPO, uccInquirySheetBusiReqBO);
                break;
            }
            case 2: {
                this.reject(uccInquirySheetPO);
                break;
            }
            case 3: {
                this.submit(uccInquirySheetPO, uccInquirySheetBusiReqBO);
                break;
            }
            case 4: {
                this.lostOrder(uccInquirySheetPO, uccInquirySheetBusiReqBO);
                break;
            }
            case 5: {
                this.change(uccInquirySheetPO, uccInquirySheetBusiReqBO);
                break;
            }
        }
        return rspBO;
    }

    private void change(UccInquirySheetPO uccInquirySheetPO, UccInquirySheetUpdateBusiReqBO uccInquirySheetBusiReqBO) {
        Integer inquirySource = uccInquirySheetPO.getInquirySource();
        if (inquirySource == 1) {
            throw new BusinessException("8888", "\u5f53\u524d\u8be2\u76d8\u5355\u7c7b\u578b\u65e0\u6cd5\u64cd\u4f5c\uff01");
        }
        if (uccInquirySheetPO.getInquiryStatus() != 1) {
            throw new BusinessException("8888", "\u5df2\u62a5\u4ef7\u8be2\u76d8\u5355\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c\uff01");
        }
        uccInquirySheetPO.setUpdatedName(uccInquirySheetBusiReqBO.getUserName());
        uccInquirySheetPO.setUpdatedTime(new Date());
        uccInquirySheetPO.setUpdatedId(uccInquirySheetBusiReqBO.getUserId());
        uccInquirySheetPO.setInquiryName(uccInquirySheetBusiReqBO.getInquiryName());
        uccInquirySheetPO.setInquiryPhone(uccInquirySheetBusiReqBO.getInquiryPhone());
        uccInquirySheetPO.setCustomerId(uccInquirySheetBusiReqBO.getCustomerId());
        uccInquirySheetPO.setCustomerName(uccInquirySheetBusiReqBO.getCustomerName());
        uccInquirySheetPO.setIndustryType(uccInquirySheetBusiReqBO.getIndustryType());
        uccInquirySheetPO.setParkName(uccInquirySheetBusiReqBO.getParkName());
        uccInquirySheetPO.setParkId(uccInquirySheetBusiReqBO.getParkId());
        uccInquirySheetPO.setRemark(uccInquirySheetBusiReqBO.getRemark());
        uccInquirySheetPO.setEnterpriseType(uccInquirySheetBusiReqBO.getEnterpriseBelong());
        uccInquirySheetPO.setInquiryStatus(Integer.valueOf(0));
        this.uccInquirySheetMapper.update(uccInquirySheetPO);
        List<UccInquiryMatchGoodsUpdateBO> quotationGoods = uccInquirySheetBusiReqBO.getQuotationGoods();
        log.debug("\u9700\u6c42\u53d8\u66f4\u8be2\u4ef7\u660e\u7ec6:{}", (Object)JSON.toJSONString(quotationGoods));
        List<UccInquirySheetDetailPO> collect = quotationGoods.stream().map(goods -> {
            if (Objects.isNull(goods.getInquirySheetDetailId())) {
                throw new BusinessException("8888", "\u8be2\u4ef7\u5355\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            UccInquirySheetDetailPO detailPO = new UccInquirySheetDetailPO();
            BeanUtils.copyProperties((Object)goods, (Object)detailPO);
            return detailPO;
        }).collect(Collectors.toList());
        log.debug("\u9700\u6c42\u53d8\u66f4\u8be2\u4ef7\u660e\u7ec6\u5b9e\u4f53:{}", (Object)JSON.toJSONString(collect));
        collect.forEach(detail -> {
            this.uccInquirySheetDetailMapper.update(detail);
            UccInquiryQuotationDetailPO uccInquiryQuotationDetailPO = new UccInquiryQuotationDetailPO();
            uccInquiryQuotationDetailPO.setInquirySheetDetailId(detail.getInquirySheetDetailId());
            uccInquiryQuotationDetailPO.setQuotationStatus(Integer.valueOf(0));
            this.uccInquiryQuotationDetailMapper.updateStatusByInquiryQuotationDetailId(uccInquiryQuotationDetailPO);
        });
    }

    private void lostOrder(UccInquirySheetPO uccInquirySheetPO, UccInquirySheetUpdateBusiReqBO uccInquirySheetBusiReqBO) {
        Integer inquirySource = uccInquirySheetPO.getInquirySource();
        if (inquirySource == 1) {
            throw new BusinessException("8888", "\u5f53\u524d\u8be2\u76d8\u5355\u7c7b\u578b\u65e0\u6cd5\u64cd\u4f5c\uff01");
        }
        if (uccInquirySheetPO.getInquiryStatus() != 1) {
            throw new BusinessException("8888", "\u5df2\u62a5\u4ef7\u8be2\u76d8\u5355\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c\uff01");
        }
        if (StringUtils.isBlank((CharSequence)uccInquirySheetBusiReqBO.getFailureCause())) {
            throw new BusinessException("8888", "\u4e22\u5355\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        uccInquirySheetPO.setInquiryStatus(Integer.valueOf(3));
        uccInquirySheetPO.setFailureCause(uccInquirySheetBusiReqBO.getFailureCause());
        this.uccInquirySheetMapper.update(uccInquirySheetPO);
    }

    private void reject(UccInquirySheetPO uccInquirySheetPO) {
        if (uccInquirySheetPO.getInquiryStatus() != 0) {
            throw new BusinessException("8888", "\u5f53\u524d\u8be2\u76d8\u5355\u72b6\u6001\u65e0\u6cd5\u9a73\u56de\uff01");
        }
        uccInquirySheetPO.setInquiryStatus(Integer.valueOf(3));
        uccInquirySheetPO.setFailureCause("\u9a73\u56de");
        uccInquirySheetPO.setQuotationTime(new Date());
        this.uccInquirySheetMapper.update(uccInquirySheetPO);
        UccInquiryQuotationDetailPO uccInquiryQuotationDetailPO = new UccInquiryQuotationDetailPO();
        uccInquiryQuotationDetailPO.setInquirySheetId(uccInquirySheetPO.getInquirySheetId());
        uccInquiryQuotationDetailPO.setQuotationStatus(Integer.valueOf(2));
        uccInquiryQuotationDetailPO.setExpirationDate(new Date());
        this.uccInquiryQuotationDetailMapper.updateStatusByInquirySheetId(uccInquiryQuotationDetailPO);
    }

    private void submit(UccInquirySheetPO uccInquirySheetPO, UccInquirySheetUpdateBusiReqBO uccInquirySheetBusiReqBO) {
        Integer inquiryStatus = uccInquirySheetPO.getInquiryStatus();
        if (inquiryStatus != 0) {
            throw new BusinessException("8888", "\u5f53\u524d\u8be2\u76d8\u5355\u5df2\u7ecf\u63d0\u4ea4\uff01");
        }
        List<UccInquiryMatchGoodsUpdateBO> quotationGoods = uccInquirySheetBusiReqBO.getQuotationGoods();
        quotationGoods.forEach(goods -> {
            List inquiryQuotationDetailList = goods.getInquiryQuotationDetailList();
            if (inquiryQuotationDetailList.size() < 1) {
                throw new BusinessException("8888", "\u62a5\u4ef7\u6807\u8bb0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (inquiryQuotationDetailList.size() > 3) {
                throw new BusinessException("8888", "\u6bcf\u79cd\u8be2\u4ef7\u5546\u54c1\u62a5\u4ef7\u6570\u91cf\u6700\u591a\u4e09\u6761\u3002");
            }
            long count1 = inquiryQuotationDetailList.stream().filter(detail -> Objects.isNull(detail.getQuotationStatus()) || detail.getQuotationStatus() == 0).count();
            if (count1 > 0L) {
                throw new BusinessException("8888", "\u62a5\u4ef7\u6807\u8bb0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            long count = inquiryQuotationDetailList.stream().filter(detail -> StringUtils.isBlank((CharSequence)detail.getQuotationGoodsName()) && detail.getQuotationStatus() == 1).count();
            if (count > 0L) {
                throw new BusinessException("8888", "\u5df2\u62a5\u4ef7\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            long count2 = inquiryQuotationDetailList.stream().filter(detail -> (Objects.isNull(detail.getSalesPrice()) || Objects.isNull(detail.getPurchasePrice())) && detail.getQuotationStatus() == 1).count();
            if (count2 > 0L) {
                throw new BusinessException("8888", "\u5df2\u62a5\u4ef7\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            long count3 = inquiryQuotationDetailList.stream().filter(detail -> StringUtils.isBlank((CharSequence)detail.getQuotationUnit()) && detail.getQuotationStatus() == 1).count();
            if (count3 > 0L) {
                throw new BusinessException("8888", "\u5df2\u62a5\u4ef7\u5546\u54c1\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            long count4 = inquiryQuotationDetailList.stream().filter(detail -> Objects.isNull(detail.getTaxRate()) && detail.getQuotationStatus() == 1).count();
            if (count4 > 0L) {
                throw new BusinessException("8888", "\u5df2\u62a5\u4ef7\u5546\u54c1\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            long count5 = inquiryQuotationDetailList.stream().filter(detail -> Objects.isNull(detail.getQuotationQuantity()) && detail.getQuotationStatus() == 1).count();
            if (count5 > 0L) {
                throw new BusinessException("8888", "\u5df2\u62a5\u4ef7\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            long count6 = inquiryQuotationDetailList.stream().filter(detail -> Objects.isNull(detail.getSalesPrice()) && detail.getQuotationStatus() == 1).count();
            if (count6 > 0L) {
                throw new BusinessException("8888", "\u5df2\u62a5\u4ef7\u5546\u54c1\u9500\u552e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            long count7 = inquiryQuotationDetailList.stream().filter(detail -> Objects.isNull(detail.getPurchasePrice()) && detail.getQuotationStatus() == 1).count();
            if (count7 > 0L) {
                throw new BusinessException("8888", "\u5df2\u62a5\u4ef7\u5546\u54c1\u6210\u672c\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            long count8 = inquiryQuotationDetailList.stream().filter(detail -> Objects.isNull(detail.getExpirationDay()) && detail.getQuotationStatus() == 1).count();
            if (count8 > 0L) {
                throw new BusinessException("8888", "\u5df2\u62a5\u4ef7\u5546\u54c1\u6709\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            long count9 = inquiryQuotationDetailList.stream().filter(detail -> Objects.isNull(detail.getDeliveryCycle()) && detail.getQuotationStatus() == 1).count();
            if (count9 > 0L) {
                throw new BusinessException("8888", "\u5df2\u62a5\u4ef7\u5546\u54c1\u5230\u8d27\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
        });
        this.save(uccInquirySheetPO, uccInquirySheetBusiReqBO);
        UccInquirySheetDetailPO detailQuery = new UccInquirySheetDetailPO();
        detailQuery.setInquirySheetId(uccInquirySheetPO.getInquirySheetId());
        List uccInquirySheetDetailPOS = this.uccInquirySheetDetailMapper.queryAll(detailQuery);
        List detailIds = uccInquirySheetDetailPOS.stream().map(UccInquirySheetDetailPO::getInquirySheetDetailId).collect(Collectors.toList());
        UccInquiryQuotationDetailQryPO query = new UccInquiryQuotationDetailQryPO();
        query.setInquirySheetId(uccInquirySheetPO.getInquirySheetId());
        List uccInquiryQuotationDetailPOS = this.uccInquiryQuotationDetailMapper.queryAll(query);
        Map<Long, List<UccInquiryQuotationDetailPO>> detailMap = uccInquiryQuotationDetailPOS.stream().collect(Collectors.groupingBy(UccInquiryQuotationDetailPO::getInquirySheetDetailId));
        if (detailMap.keySet().size() != detailIds.size()) {
            throw new BusinessException("8888", "\u62a5\u4ef7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        detailMap.keySet().forEach(k -> {
            List uccInquiryQuotationDetailPOS1 = (List)detailMap.get(k);
            if (uccInquiryQuotationDetailPOS1.size() > 3) {
                throw new BusinessException("8888", "\u62a5\u4ef7\u5546\u54c1\u6570\u91cf\u6700\u591a\u4e09\u6761\u3002");
            }
        });
        long count = uccInquiryQuotationDetailPOS.stream().filter(detail -> Objects.isNull(detail.getQuotationStatus()) || detail.getQuotationStatus() == 0).count();
        if (count > 0L) {
            throw new BusinessException("8888", "\u62a5\u4ef7\u6807\u8bb0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        uccInquirySheetPO = new UccInquirySheetPO();
        uccInquirySheetPO.setInquirySheetId(uccInquirySheetBusiReqBO.getInquirySheetId());
        uccInquirySheetPO.setInquiryStatus(Integer.valueOf(1));
        uccInquirySheetPO.setCustomerId(uccInquirySheetBusiReqBO.getCustomerId());
        uccInquirySheetPO.setQuotationTime(new Date());
        this.uccInquirySheetMapper.update(uccInquirySheetPO);
    }

    private void save(UccInquirySheetPO uccInquirySheetPO, UccInquirySheetUpdateBusiReqBO uccInquirySheetBusiReqBO) {
        Date now = new Date();
        uccInquirySheetPO.setUpdatedName(uccInquirySheetBusiReqBO.getUserName());
        uccInquirySheetPO.setUpdatedTime(now);
        uccInquirySheetPO.setUpdatedId(uccInquirySheetBusiReqBO.getUserId());
        if (uccInquirySheetPO.getInquiryStatus() == 3 || uccInquirySheetPO.getInquiryStatus() == 1) {
            if (StringUtils.isNotBlank((CharSequence)uccInquirySheetBusiReqBO.getRemark())) {
                uccInquirySheetPO = new UccInquirySheetPO();
                uccInquirySheetPO.setInquirySheetId(uccInquirySheetBusiReqBO.getInquirySheetId());
                uccInquirySheetPO.setRemark(uccInquirySheetBusiReqBO.getRemark());
                this.uccInquirySheetMapper.update(uccInquirySheetPO);
            }
        } else {
            ArrayList add = new ArrayList();
            ArrayList update = new ArrayList();
            List<UccInquiryMatchGoodsUpdateBO> quotationGoods = uccInquirySheetBusiReqBO.getQuotationGoods();
            quotationGoods.stream().flatMap(goods -> goods.getDelDetailIdList().stream()).forEach(id -> this.uccInquiryQuotationDetailMapper.deleteById(id));
            UccInquiryQuotationDetailQryPO query = new UccInquiryQuotationDetailQryPO();
            query.setInquirySheetId(uccInquirySheetPO.getInquirySheetId());
            List uccInquiryQuotationDetailPOS = this.uccInquiryQuotationDetailMapper.queryAll(query);
            Map<Long, List<UccInquiryQuotationDetailPO>> detailMap = uccInquiryQuotationDetailPOS.stream().collect(Collectors.groupingBy(UccInquiryQuotationDetailPO::getInquirySheetDetailId));
            quotationGoods.forEach(goods -> {
                Long inquirySheetDetailId = goods.getInquirySheetDetailId();
                ArrayList oldList = (ArrayList)detailMap.get(inquirySheetDetailId);
                List newList = goods.getInquiryQuotationDetailList();
                long count = newList.stream().filter(d -> Objects.isNull(d.getInquiryQuotationDetailId())).count();
                if (null == oldList) {
                    oldList = new ArrayList();
                }
                if ((long)oldList.size() + count > 3L || count > 3L || oldList.size() > 3 || newList.size() > 3) {
                    throw new BusinessException("8888", "\u62a5\u4ef7\u5546\u54c1\u6570\u91cf\u6700\u591a\u4e09\u6761\u3002");
                }
                List<Long> newIds = newList.stream().map(UccInquiryQuotationDetailBO::getInquiryQuotationDetailId).filter(inquiryQuotationDetailId -> !Objects.isNull(inquiryQuotationDetailId)).collect(Collectors.toList());
                List oldIds = oldList.stream().map(UccInquiryQuotationDetailPO::getInquiryQuotationDetailId).collect(Collectors.toList());
                newIds.forEach(id -> {
                    if (!oldIds.contains(id)) {
                        oldIds.add(id);
                    }
                });
                if (oldIds.size() > 3) {
                    throw new BusinessException("8888", "\u62a5\u4ef7\u5546\u54c1\u6570\u91cf\u6700\u591a\u4e09\u6761\u3002");
                }
            });
            uccInquirySheetPO.setInquiryName(uccInquirySheetBusiReqBO.getInquiryName());
            uccInquirySheetPO.setInquiryPhone(uccInquirySheetBusiReqBO.getInquiryPhone());
            uccInquirySheetPO.setCustomerId(uccInquirySheetBusiReqBO.getCustomerId());
            uccInquirySheetPO.setCustomerName(uccInquirySheetBusiReqBO.getCustomerName());
            uccInquirySheetPO.setIndustryType(uccInquirySheetBusiReqBO.getIndustryType());
            uccInquirySheetPO.setParkName(uccInquirySheetBusiReqBO.getParkName());
            uccInquirySheetPO.setParkId(uccInquirySheetBusiReqBO.getParkId());
            uccInquirySheetPO.setRemark(uccInquirySheetBusiReqBO.getRemark());
            uccInquirySheetPO.setEnterpriseType(uccInquirySheetBusiReqBO.getEnterpriseBelong());
            List<UccInquirySheetDetailPO> detailList = quotationGoods.stream().filter(goods -> StringUtils.isNotBlank((CharSequence)goods.getAttachmentUrl())).map(goods -> {
                UccInquirySheetDetailPO detailPO = new UccInquirySheetDetailPO();
                detailPO.setInquirySheetDetailId(goods.getInquirySheetDetailId());
                detailPO.setAttachmentUrl(goods.getAttachmentUrl());
                return detailPO;
            }).collect(Collectors.toList());
            quotationGoods.stream().flatMap(goods -> goods.getInquiryQuotationDetailList().stream()).forEach(q -> {
                UccInquiryQuotationDetailPO detailPO = new UccInquiryQuotationDetailPO();
                BeanUtils.copyProperties((Object)q, (Object)detailPO);
                Integer skuType = StringUtils.isNotBlank((CharSequence)detailPO.getQuotationGoodsName()) && StringUtils.isBlank((CharSequence)detailPO.getQuotationSku()) ? 1 : 0;
                if (q.getSalesPrice() != null) {
                    detailPO.setSalesPrice(q.getSalesPrice().multiply(new BigDecimal("10000")));
                }
                if (q.getPurchasePrice() != null) {
                    detailPO.setPurchasePrice(q.getPurchasePrice().multiply(new BigDecimal("10000")));
                }
                detailPO.setSkuType(skuType);
                detailPO.setCreatedTime(now);
                detailPO.setQuotationName(q.getQuotationName());
                detailPO.setQuotationId(q.getQuotationId());
                if (Objects.isNull(detailPO.getInquirySheetDetailId())) {
                    throw new BusinessException("8888", "\u8be2\u4ef7\u5546\u54c1\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                }
                Integer expirationDay = Objects.isNull(detailPO.getExpirationDay()) ? 1 : detailPO.getExpirationDay();
                detailPO.setExpirationDate(this.getExpirationDate(now, expirationDay));
                if (Objects.isNull(detailPO.getInquiryQuotationDetailId())) {
                    detailPO.setInquiryQuotationDetailId(Long.valueOf(SEQUENCE.nextId()));
                    add.add(detailPO);
                } else {
                    update.add(detailPO);
                }
            });
            this.uccInquirySheetMapper.update(uccInquirySheetPO);
            detailList.forEach(detail -> this.uccInquirySheetDetailMapper.update(detail));
            if (add.size() > 0) {
                this.uccInquiryQuotationDetailMapper.insertBatch(add);
            }
            update.forEach(u -> this.uccInquiryQuotationDetailMapper.update(u));
        }
    }

    private Date getExpirationDate(Date date, Integer expirationDay) {
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        calendar1.set(calendar2.get(1), calendar2.get(2), calendar2.get(5), 23, 59, 59);
        calendar1.add(5, expirationDay);
        return calendar1.getTime();
    }

    private void checkStatus(UccInquirySheetPO uccInquirySheetPO) {
        Integer inquiryStatus = uccInquirySheetPO.getInquiryStatus();
        if (inquiryStatus == 4) {
            throw new BusinessException("8888", "\u5f53\u524d\u8be2\u76d8\u5355\u5df2\u8fc7\u671f\uff01");
        }
        if (inquiryStatus == 2) {
            throw new BusinessException("8888", "\u5f53\u524d\u8be2\u76d8\u5355\u5df2\u6210\u5355\uff01");
        }
    }
}

