/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.bo.RspUccBo;
import com.tydic.commodity.busibase.busi.api.UccSendMessageAndNoteAtomService;
import com.tydic.commodity.common.ability.bo.UccPricePreventByDataBO;
import com.tydic.commodity.common.busi.api.UccRiskPricePreventSendMsgBusiService;
import com.tydic.commodity.common.busi.bo.UccRiskPricePreventSendMsgBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccRiskPricePreventSendMsgBusiRspBO;
import com.tydic.commodity.utils.HSHttpHelper;
import com.tydic.commodity.utils.HSNHttpHeader;
import com.tydic.commodity.utils.HttpRetBean;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccRiskPricePreventSendMsgBusiServiceImpl
implements UccRiskPricePreventSendMsgBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccRiskPricePreventSendMsgBusiServiceImpl.class);
    @Autowired
    private UccSendMessageAndNoteAtomService uccSendMessageAndNoteAtomService;
    @Value(value="${UCC_SEND_MESSAGE_AND_NOTE_URL}")
    private String UCC_SEND_MESSAGE_AND_NOTE_URL;

    @Override
    public UccRiskPricePreventSendMsgBusiRspBO preventTaskSendMsg(UccRiskPricePreventSendMsgBusiReqBO reqBO) {
        if (!MapUtils.isEmpty(reqBO.getAdjustPriceMap())) {
            Map<Long, List<UccPricePreventByDataBO>> adjustPriceMap = reqBO.getAdjustPriceMap();
            for (Long managerId : adjustPriceMap.keySet()) {
                this.sendMsg(adjustPriceMap.get(managerId), 1);
            }
        }
        if (!MapUtils.isEmpty(reqBO.getOffPriceMap())) {
            Map<Long, List<UccPricePreventByDataBO>> offPriceMap = reqBO.getOffPriceMap();
            for (Long managerId : offPriceMap.keySet()) {
                this.sendMsg(offPriceMap.get(managerId), 2);
            }
        }
        UccRiskPricePreventSendMsgBusiRspBO busiRspBO = new UccRiskPricePreventSendMsgBusiRspBO();
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }

    private void sendMsg(List<UccPricePreventByDataBO> preventByDataBOList, Integer type) {
        if (!CollectionUtils.isEmpty(preventByDataBOList)) {
            String reqStr = this.initReqStr(preventByDataBOList, type);
            log.info("\u901a\u77e5\u4e2d\u5fc3\u901a\u77e5\u53d1\u9001\u5165\u53c2{}->" + reqStr);
            HttpRetBean httpRetBean = null;
            try {
                httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.UCC_SEND_MESSAGE_AND_NOTE_URL), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            }
            catch (Exception e) {
                log.error("\u901a\u77e5\u4e2d\u5fc3\u901a\u77e5\u53d1\u9001\u63a5\u53e3\u51fa\u9519\uff1a" + e.getMessage());
                throw new ZTBusinessException("\u901a\u77e5\u4e2d\u5fc3\u901a\u77e5\u53d1\u9001\u63a5\u53e3\u51fa\u9519");
            }
            if (httpRetBean.getStatus() != 200) {
                log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.UCC_SEND_MESSAGE_AND_NOTE_URL + "]");
                throw new ZTBusinessException("\u901a\u77e5\u4e2d\u5fc3\u901a\u77e5\u53d1\u9001\u63a5\u53e3\u51fa\u9519\uff0chttp_status = " + httpRetBean.getStatus());
            }
            log.info("\u901a\u77e5\u4e2d\u5fc3\u901a\u77e5\u53d1\u9001\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                log.error("\u901a\u77e5\u4e2d\u5fc3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                throw new ZTBusinessException("\u901a\u77e5\u4e2d\u5fc3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            RspUccBo rspUccBo = this.resolveRsp(returnString);
            log.info("\u901a\u77e5\u4e2d\u5fc3\u54cd\u5e94\u6570\u636e\uff1a" + JSON.toJSONString((Object)rspUccBo.toString()));
        }
    }

    private String initReqStr(List<UccPricePreventByDataBO> preventByDataBOList, Integer type) {
        JSONObject reqJson = new JSONObject();
        if (type == 1) {
            reqJson.put("taskCode", (Object)"ucc_risk_price_warning_note");
        }
        if (type == 2) {
            reqJson.put("taskCode", (Object)"ucc_risk_price_off_sku_note");
        }
        JSONObject data = new JSONObject();
        data.put("skuNum", (Object)preventByDataBOList.size());
        data.put("percentagePrice", (Object)"30%");
        reqJson.put("data", (Object)data.toJSONString());
        reqJson.put("sendId", (Object)1);
        reqJson.put("sendName", (Object)"\u7cfb\u7edf");
        JSONArray receivers = new JSONArray();
        JSONObject receiver = new JSONObject();
        receiver.put("receiverId", (Object)preventByDataBOList.get(0).getManagerId());
        receiver.put("receiverName", (Object)preventByDataBOList.get(0).getManagerName());
        receivers.add((Object)receiver);
        reqJson.put("receivers", (Object)receivers);
        return reqJson.toString();
    }

    private RspUccBo resolveRsp(String returnString) {
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            return (RspUccBo)JSON.toJavaObject((JSON)rspJsonObject, RspUccBo.class);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u901a\u77e5\u4e2d\u5fc3\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
            throw new RuntimeException("\u8f6c\u6362\u901a\u77e5\u4e2d\u5fc3\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
        }
    }
}

