/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccSpuBatchStatsChangeAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSpuBatchStatsChangeAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccSpuBatchStatsChangeBusiService;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccShopFreezeSpuRecordMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccShopFreezeSpuRecordPO;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class UccSpuBatchStatsChangeBusiServiceImpl
implements UccSpuBatchStatsChangeBusiService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccShopFreezeSpuRecordMapper uccShopFreezeSpuRecordMapper;
    private static final Sequence SEQUENCE = Sequence.getInstance();

    @Override
    public UccSpuBatchStatsChangeAbilityRspBO spuBatchStatusChange(UccSpuBatchStatsChangeAbilityReqBO reqBO) {
        try {
            List skuIds = this.uccSkuMapper.getSkuIdBySupAndStatus(reqBO.getSupplierIds(), 3);
            List spuIds = this.uccCommodityMapper.getSpuIdBySupAndStatus(reqBO.getSupplierIds(), 3);
            this.dealAddMmcFreezeSpuRecord(skuIds, spuIds);
            this.uccSkuMapper.updateSkuStatusBySupIds(reqBO.getSupplierIds(), reqBO.getStatus());
            this.uccCommodityMapper.updateSpuStatusBySupIds(reqBO.getSupplierIds(), reqBO.getStatus());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u5546\u54c1\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff01");
        }
        UccSpuBatchStatsChangeAbilityRspBO rspBO = new UccSpuBatchStatsChangeAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealAddMmcFreezeSpuRecord(List<UccSkuPo> skuIds, List<UccSkuPo> spuIds) {
        List uccShopFreezeSpuRecordPOS1;
        Date date = new Date();
        ArrayList uccShopFreezeSpuRecordPOS = new ArrayList();
        if (!CollectionUtils.isEmpty(skuIds)) {
            uccShopFreezeSpuRecordPOS1 = skuIds.stream().map(e -> {
                UccShopFreezeSpuRecordPO uccShopFreezeSpuRecordPO = new UccShopFreezeSpuRecordPO();
                uccShopFreezeSpuRecordPO.setId(Long.valueOf(SEQUENCE.nextId()));
                uccShopFreezeSpuRecordPO.setSupplierShopId(e.getSupplierShopId());
                uccShopFreezeSpuRecordPO.setSkuId(e.getSkuId());
                uccShopFreezeSpuRecordPO.setRemark("\u5e97\u94fa\u51bb\u7ed3");
                uccShopFreezeSpuRecordPO.setTime(date);
                return uccShopFreezeSpuRecordPO;
            }).collect(Collectors.toList());
            uccShopFreezeSpuRecordPOS.addAll(uccShopFreezeSpuRecordPOS1);
        }
        if (!CollectionUtils.isEmpty(spuIds)) {
            uccShopFreezeSpuRecordPOS1 = spuIds.stream().map(e -> {
                UccShopFreezeSpuRecordPO uccShopFreezeSpuRecordPO = new UccShopFreezeSpuRecordPO();
                uccShopFreezeSpuRecordPO.setId(Long.valueOf(SEQUENCE.nextId()));
                uccShopFreezeSpuRecordPO.setSupplierShopId(e.getSupplierShopId());
                uccShopFreezeSpuRecordPO.setCommodityId(e.getCommodityId());
                uccShopFreezeSpuRecordPO.setRemark("\u5e97\u94fa\u51bb\u7ed3");
                uccShopFreezeSpuRecordPO.setTime(date);
                return uccShopFreezeSpuRecordPO;
            }).collect(Collectors.toList());
            uccShopFreezeSpuRecordPOS.addAll(uccShopFreezeSpuRecordPOS1);
        }
        if (!CollectionUtils.isEmpty(uccShopFreezeSpuRecordPOS)) {
            try {
                this.uccShopFreezeSpuRecordMapper.insertBatch(uccShopFreezeSpuRecordPOS);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new BusinessException("8888", "\u65b0\u589e\u5e97\u94fa\u51bb\u7ed3\u4e0b\u67b6\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff01" + e2.getMessage());
            }
        }
    }

    @Override
    public UccSpuBatchStatsChangeAbilityRspBO spuBatchStatusShelveChange(UccSpuBatchStatsChangeAbilityReqBO reqBO) {
        for (Long supplierId : reqBO.getSupplierIds()) {
            UccShopFreezeSpuRecordPO select = new UccShopFreezeSpuRecordPO();
            select.setSupplierShopId(supplierId);
            List uccShopFreezeSpuRecordPOS = this.uccShopFreezeSpuRecordMapper.getList(select);
            if (!CollectionUtils.isEmpty((Collection)uccShopFreezeSpuRecordPOS)) {
                List skuList = uccShopFreezeSpuRecordPOS.stream().filter(e -> e.getCommodityId() == null).map(UccShopFreezeSpuRecordPO::getSkuId).collect(Collectors.toList());
                List spuList = uccShopFreezeSpuRecordPOS.stream().filter(e -> e.getSkuId() == null).map(UccShopFreezeSpuRecordPO::getCommodityId).collect(Collectors.toList());
                try {
                    if (!CollectionUtils.isEmpty(skuList)) {
                        this.uccSkuMapper.updateStatusBySkuIdsNew(skuList, ModelRuleConstant.SKU_STATUS_ON_SHELF);
                    }
                    if (!CollectionUtils.isEmpty(spuList)) {
                        this.uccCommodityMapper.updateStatusBySpuIdsNew(spuList, ModelRuleConstant.SKU_STATUS_ON_SHELF);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    throw new BusinessException("8888", "\u66f4\u65b0\u72b6\u6001\u5931\u8d25\uff01" + e2.getMessage());
                }
            }
            UccShopFreezeSpuRecordPO spuRecordPO = new UccShopFreezeSpuRecordPO();
            spuRecordPO.setSupplierShopId(supplierId);
            if (ObjectUtils.isEmpty((Object)spuRecordPO.getSupplierShopId())) continue;
            this.uccShopFreezeSpuRecordMapper.deleteBy(spuRecordPO);
        }
        UccSpuBatchStatsChangeAbilityRspBO rspBO = new UccSpuBatchStatsChangeAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

